/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin.configassembly;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.build.plugin.configassembly.AttributeValue;
import org.wildfly.build.plugin.configassembly.ElementNode;
import org.wildfly.build.plugin.configassembly.FormattingXMLStreamWriter;
import org.wildfly.build.plugin.configassembly.ModuleParser;
import org.wildfly.build.plugin.configassembly.SubsystemConfig;
import org.wildfly.build.plugin.configassembly.SubsystemParser;
import org.wildfly.build.plugin.configassembly.SubsystemsParser;

public class GenerateModulesDefinition {
    static Logger log = Logger.getLogger(GenerateModulesDefinition.class);
    static final String SPLIT_PATTERN = ",(\\s*)";
    static final String SKIP_SUBSYSTEMS = "skip-subsystems";
    static final String NO_MODULE_DEPENENCIES = "no-module-dependencies";
    private final File inputFile;
    private final String profile;
    private final File resourcesDir;
    private final File modulesDir;
    private final String[] staticModules;
    private final File outputFile;

    public static void main(String[] args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException("Null args");
        }
        if (args.length < 6) {
            throw new IllegalArgumentException("Invalid args: " + Arrays.asList(args));
        }
        int index = 0;
        if (args[index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No input file");
        }
        File inputFile = new File(args[index++]);
        if (args[index] == null) {
            throw new IllegalArgumentException("No profile");
        }
        String profile = args[index++];
        if (args[index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No resources dir");
        }
        File resourcesDir = new File(args[index++]);
        if (args[index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No modules dir");
        }
        File modulesDir = new File(args[index++]);
        String[] staticModules = new String[]{};
        if (args[index] != null && !args[index].isEmpty()) {
            staticModules = args[index].trim().split(SPLIT_PATTERN);
        }
        if (args[++index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No output file");
        }
        File outputFile = new File(args[index]);
        new GenerateModulesDefinition(inputFile, profile, resourcesDir, modulesDir, staticModules, outputFile).process();
    }

    private GenerateModulesDefinition(File inputFile, String profile, File resourcesDir, File modulesDir, String[] staticModules, File outputFile) {
        this.inputFile = inputFile;
        this.profile = profile;
        this.resourcesDir = resourcesDir;
        this.modulesDir = modulesDir;
        this.staticModules = staticModules;
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws XMLStreamException, IOException {
        ElementNode modulesNode = new ElementNode(null, "modules", "urn:modules:1.0");
        ArrayList<ModuleIdentifier> dependencies = new ArrayList<ModuleIdentifier>();
        if (!this.inputFile.getName().equals(SKIP_SUBSYSTEMS)) {
            SubsystemsParser parser = new SubsystemsParser(this.inputFile);
            parser.parse();
            for (SubsystemConfig config : parser.getSubsystemConfigs().get(this.profile)) {
                File configFile = new File(this.resourcesDir + File.separator + config.getSubsystem());
                SubsystemParser configParser = new SubsystemParser(null, config.getSupplement(), configFile);
                configParser.parse();
                ModuleIdentifier moduleId = ModuleIdentifier.create((String)configParser.getExtensionModule());
                this.processModuleDependency(dependencies, modulesNode, new ModuleParser.ModuleDependency(moduleId, false));
            }
        }
        for (String staticId : this.staticModules) {
            if (staticId.isEmpty()) continue;
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)staticId);
            this.processModuleDependency(dependencies, modulesNode, new ModuleParser.ModuleDependency(moduleId, false));
        }
        Comparator<ModuleIdentifier> comp = new Comparator<ModuleIdentifier>(){

            @Override
            public int compare(ModuleIdentifier o1, ModuleIdentifier o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        Collections.sort(dependencies, comp);
        try (PrintWriter pw = new PrintWriter(new FileWriter(this.outputFile));){
            if (!dependencies.isEmpty()) {
                for (ModuleIdentifier moduleId : dependencies) {
                    String path = moduleId.getName().replace('.', '/') + '/' + moduleId.getSlot();
                    pw.println(path + '/' + "**");
                }
            } else {
                pw.println(NO_MODULE_DEPENENCIES);
            }
        }
        String xmloutput = this.outputFile.getPath();
        try (FileWriter writer = new FileWriter(xmloutput.substring(0, xmloutput.lastIndexOf(".")) + ".xml");){
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            FormattingXMLStreamWriter xmlwriter = new FormattingXMLStreamWriter(factory.createXMLStreamWriter(writer));
            modulesNode.marshall(xmlwriter);
        }
    }

    private void processModuleDependency(List<ModuleIdentifier> dependencies, ElementNode parentNode, ModuleParser.ModuleDependency dep) throws IOException, XMLStreamException {
        ModuleIdentifier moduleId = dep.getModuleId();
        if (dependencies.contains(moduleId)) {
            log.debugf("Already defined: %s", (Object)moduleId);
            return;
        }
        ElementNode moduleNode = new ElementNode(parentNode, "module");
        moduleNode.addAttribute("name", new AttributeValue(moduleId.toString()));
        parentNode.addChild(moduleNode);
        if (!dep.isOptional()) {
            dependencies.add(moduleId);
            String path = moduleId.getName().replace('.', '/') + '/' + moduleId.getSlot();
            String modulespath = "system" + File.separator + "layers" + File.separator + "base";
            File moduleFile = new File(this.modulesDir + File.separator + modulespath + File.separator + path + File.separator + "module.xml");
            ModuleParser moduleParser = new ModuleParser(moduleFile);
            moduleParser.parse();
            List<ModuleParser.ModuleDependency> moduledeps = moduleParser.getDependencies();
            for (ModuleParser.ModuleDependency aux : moduledeps) {
                this.processModuleDependency(dependencies, moduleNode, aux);
            }
        } else {
            moduleNode.addAttribute("optional", new AttributeValue("true"));
        }
    }
}

