/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.ModuleIdentifier;

public class ModuleParseResult {
    final Path moduleRoot;
    final Path moduleXmlFile;
    final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    final List<String> resourceRoots = new ArrayList<String>();
    final List<String> artifacts = new ArrayList<String>();
    ModuleIdentifier identifier;

    public ModuleParseResult(Path moduleRoot, Path moduleXmlFile) {
        this.moduleRoot = moduleRoot;
        this.moduleXmlFile = moduleXmlFile;
    }

    public Path getModuleXmlFile() {
        return this.moduleXmlFile;
    }

    public Path getModuleRoot() {
        return this.moduleRoot;
    }

    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getResourceRoots() {
        return this.resourceRoots;
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

