/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin.configassembly;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.plugin.configassembly.AttributeValue;
import org.wildfly.build.plugin.configassembly.ElementNode;
import org.wildfly.build.plugin.configassembly.Node;
import org.wildfly.build.plugin.configassembly.NodeParser;
import org.wildfly.build.plugin.configassembly.ParsingUtils;
import org.wildfly.build.plugin.configassembly.ProcessingInstructionNode;

class SubsystemParser
extends NodeParser {
    private final String socketBindingNamespace;
    private final File inputFile;
    private final String supplementName;
    private String extensionModule;
    private Node subsystem;
    private final Map<String, ElementNode> socketBindings = new HashMap<String, ElementNode>();
    private final Map<String, ElementNode> outboundSocketBindings = new HashMap<String, ElementNode>();
    private final Map<String, ProcessingInstructionNode> supplementPlaceholders = new HashMap<String, ProcessingInstructionNode>();
    private final Map<String, Supplement> supplementReplacements = new HashMap<String, Supplement>();
    private final Map<String, List<AttributeValue>> attributesForReplacement = new HashMap<String, List<AttributeValue>>();

    SubsystemParser(String socketBindingNamespace, String supplementName, File inputFile) {
        this.socketBindingNamespace = socketBindingNamespace;
        this.supplementName = supplementName;
        this.inputFile = inputFile;
    }

    String getExtensionModule() {
        return this.extensionModule;
    }

    Node getSubsystem() {
        return this.subsystem;
    }

    Map<String, ElementNode> getSocketBindings() {
        return this.socketBindings;
    }

    Map<String, ElementNode> getOutboundSocketBindings() {
        return this.outboundSocketBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse() throws IOException, XMLStreamException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.inputFile));
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            reader.require(7, null, null);
            HashMap<String, String> configAttributes = new HashMap<String, String>();
            configAttributes.put("default-supplement", null);
            ParsingUtils.getNextElement(reader, "config", configAttributes, false);
            this.extensionModule = ParsingUtils.getNextElement(reader, "extension-module", null, true);
            ParsingUtils.getNextElement(reader, "subsystem", null, false);
            this.subsystem = super.parseNode(reader, "subsystem");
            while (reader.hasNext()) {
                ElementNode socketBinding;
                if (reader.next() != 1) continue;
                if (reader.getLocalName().equals("subsystem")) {
                    throw new XMLStreamException("Only one subsystem element is allowed", reader.getLocation());
                }
                if (reader.getLocalName().equals("supplement")) {
                    this.parseSupplement(reader, ((ElementNode)this.subsystem).getNamespace());
                    continue;
                }
                if (reader.getLocalName().equals("socket-binding")) {
                    socketBinding = new NodeParser(this.socketBindingNamespace).parseNode(reader, "socket-binding");
                    this.socketBindings.put(socketBinding.getAttributeValue("name"), socketBinding);
                    continue;
                }
                if (!reader.getLocalName().equals("outbound-socket-binding")) continue;
                socketBinding = new NodeParser(this.socketBindingNamespace).parseNode(reader, "outbound-socket-binding");
                this.outboundSocketBindings.put(socketBinding.getAttributeValue("name"), socketBinding);
            }
            String supplementName = this.supplementName;
            if (supplementName == null) {
                supplementName = (String)configAttributes.get("default-supplement");
            }
            if (supplementName != null) {
                Supplement supplement = this.supplementReplacements.get(supplementName);
                if (supplement == null) {
                    throw new IllegalStateException("No supplement called '" + supplementName + "' could be found to augment the subsystem configuration");
                }
                Map<String, ElementNode> nodeReplacements = supplement.getAllNodeReplacements();
                for (Map.Entry<String, ProcessingInstructionNode> entry : this.supplementPlaceholders.entrySet()) {
                    ElementNode replacement = nodeReplacements.get(entry.getKey());
                    if (replacement == null) continue;
                    Iterator<Node> it = replacement.iterateChildren();
                    while (it.hasNext()) {
                        entry.getValue().addDelegate(it.next());
                    }
                }
                Map<String, String> attributeReplacements = supplement.getAllAttributeReplacements();
                for (Map.Entry<String, List<AttributeValue>> entry : this.attributesForReplacement.entrySet()) {
                    String replacement = attributeReplacements.get(entry.getKey());
                    if (replacement == null) {
                        throw new IllegalStateException("No replacement found for " + entry.getKey() + " in supplement " + supplementName);
                    }
                    for (AttributeValue attrValue : entry.getValue()) {
                        attrValue.setValue(replacement);
                    }
                }
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    protected void parseSupplement(XMLStreamReader reader, String subsystemNs) throws XMLStreamException {
        String name = null;
        String[] includes = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            if (attr.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (attr.equals("includes")) {
                String tmp = reader.getAttributeValue(i);
                includes = tmp.split(" ");
                continue;
            }
            throw new XMLStreamException("Invalid attribute " + attr, reader.getLocation());
        }
        if (name == null) {
            throw new XMLStreamException("Missing required attribute 'name'", reader.getLocation());
        }
        if (name.length() == 0) {
            throw new XMLStreamException("Empty name attribute for <supplement>", reader.getLocation());
        }
        Supplement supplement = new Supplement(includes);
        if (this.supplementReplacements.put(name, supplement) != null) {
            throw new XMLStreamException("Already have a supplement called " + name, reader.getLocation());
        }
        while (reader.hasNext()) {
            reader.next();
            int type = reader.getEventType();
            switch (type) {
                case 1: {
                    if (reader.getLocalName().equals("replacement")) {
                        this.parseSupplementReplacement(reader, subsystemNs, supplement);
                        break;
                    }
                    throw new XMLStreamException("Unknown element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (reader.getLocalName().equals("supplement")) {
                        return;
                    }
                    throw new XMLStreamException("Unknown element " + reader.getLocalName(), reader.getLocation());
                }
            }
        }
    }

    protected void parseSupplementReplacement(XMLStreamReader reader, String subsystemNs, Supplement supplement) throws XMLStreamException {
        String placeholder = null;
        String attributeValue = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            if (attr.equals("placeholder")) {
                placeholder = reader.getAttributeValue(i);
                continue;
            }
            if (attr.equals("attributeValue")) {
                attributeValue = reader.getAttributeValue(i);
                continue;
            }
            throw new XMLStreamException("Invalid attribute " + attr, reader.getLocation());
        }
        if (placeholder == null) {
            throw new XMLStreamException("Missing required attribute 'placeholder'", reader.getLocation());
        }
        if (placeholder.length() == 0) {
            throw new XMLStreamException("Empty placeholder attribute for <replacement>", reader.getLocation());
        }
        if (attributeValue != null) {
            supplement.addAttributeReplacement(placeholder, attributeValue);
        }
        while (reader.hasNext()) {
            int type = reader.getEventType();
            switch (type) {
                case 1: {
                    ElementNode node = new NodeParser(subsystemNs).parseNode(reader, reader.getLocalName());
                    if (attributeValue != null && node.iterateChildren().hasNext()) {
                        throw new XMLStreamException("Can not have nested content when attributeValue is used", reader.getLocation());
                    }
                    if (supplement.addNodeReplacement(placeholder, node) == null) break;
                    throw new XMLStreamException("Already have a replacement called " + placeholder + " in supplement", reader.getLocation());
                }
                case 2: {
                    if (reader.getLocalName().equals("replacement")) {
                        return;
                    }
                    throw new XMLStreamException("Unknown element " + reader.getLocalName(), reader.getLocation());
                }
            }
        }
    }

    @Override
    protected ProcessingInstructionNode parseProcessingInstruction(XMLStreamReader reader, ElementNode parent) throws XMLStreamException {
        ProcessingInstructionNode placeholder;
        String name = reader.getPITarget();
        if (this.supplementPlaceholders.put(name, placeholder = new ProcessingInstructionNode(name, this.parseProcessingInstructionData(reader.getPIData()))) != null) {
            throw new IllegalStateException("Already have a processing instruction called <?" + name + "?>");
        }
        return placeholder;
    }

    @Override
    protected AttributeValue createAttributeValue(String attributeValue) {
        AttributeValue value = super.createAttributeValue(attributeValue);
        if (attributeValue.startsWith("@@")) {
            List<AttributeValue> attributeValues = this.attributesForReplacement.get(attributeValue);
            if (attributeValues == null) {
                attributeValues = new ArrayList<AttributeValue>();
                this.attributesForReplacement.put(attributeValue, attributeValues);
            }
            attributeValues.add(value);
        }
        return value;
    }

    private class Supplement {
        final String[] includes;
        final Map<String, ElementNode> nodeReplacements = new HashMap<String, ElementNode>();
        final Map<String, String> attributeReplacements = new HashMap<String, String>();

        Supplement(String[] includes) {
            this.includes = includes;
        }

        ElementNode addNodeReplacement(String placeholder, ElementNode replacement) {
            return this.nodeReplacements.put(placeholder, replacement);
        }

        String addAttributeReplacement(String placeholder, String replacement) {
            return this.attributeReplacements.put(placeholder, replacement);
        }

        Map<String, ElementNode> getAllNodeReplacements() {
            HashMap<String, ElementNode> result = new HashMap<String, ElementNode>();
            this.getAllNodeReplacements(result);
            return result;
        }

        void getAllNodeReplacements(Map<String, ElementNode> result) {
            if (this.includes != null && this.includes.length > 0) {
                for (String include : this.includes) {
                    Supplement parent = (Supplement)SubsystemParser.this.supplementReplacements.get(include);
                    if (parent == null) {
                        throw new IllegalStateException("Can't find included supplement '" + include + "'");
                    }
                    parent.getAllNodeReplacements(result);
                }
            }
            result.putAll(this.nodeReplacements);
        }

        Map<String, String> getAllAttributeReplacements() {
            HashMap<String, String> result = new HashMap<String, String>();
            this.getAllAttributeReplacements(result);
            return result;
        }

        void getAllAttributeReplacements(Map<String, String> result) {
            if (this.includes != null && this.includes.length > 0) {
                for (String include : this.includes) {
                    Supplement parent = (Supplement)SubsystemParser.this.supplementReplacements.get(include);
                    if (parent == null) {
                        throw new IllegalStateException("Can't find included supplement '" + include + "'");
                    }
                    parent.getAllAttributeReplacements(result);
                }
            }
            result.putAll(this.attributeReplacements);
        }
    }
}

