/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.build.plugin.BuildPropertyReplacer;
import org.wildfly.build.plugin.ModuleParseResult;
import org.wildfly.build.plugin.ModuleParser;
import org.wildfly.build.plugin.ModuleUtils;
import org.wildfly.build.plugin.configassembly.ConfigurationAssembler;
import org.wildfly.build.plugin.model.Build;
import org.wildfly.build.plugin.model.BuildModelParser;
import org.wildfly.build.plugin.model.ConfigFile;
import org.wildfly.build.plugin.model.CopyArtifact;
import org.wildfly.build.plugin.model.FilePermission;
import org.wildfly.build.plugin.model.Server;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractMojo {
    private static final boolean OS_WINDOWS = System.getProperty("os.name").contains("indows");
    int folderCount = 0;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="config-file", required=true)
    private String configFile;
    @Parameter(defaultValue="${basedir}", alias="config-dir")
    private File configDir;
    @Parameter(defaultValue="${project.build.finalName}", alias="server-name")
    private String serverName;
    @Parameter(defaultValue="${project.build.directory}")
    private String buildName;
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();
    private final Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();
    private Path templateTmpDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.buildArtifactMap();
        FileInputStream configStream = null;
        try {
            this.templateTmpDir = Files.createTempDirectory("wildfly-templates", new FileAttribute[0]);
            this.cleanupTasks.add(new FileDeleteTask(this.templateTmpDir.toFile()));
            configStream = new FileInputStream(new File(this.configDir, this.configFile));
            Build build = new BuildModelParser(this.project.getProperties()).parse(configStream);
            for (Server server : build.getServers()) {
                this.extractServer(server);
            }
            this.copyServers(build);
            this.copyModules(build);
            this.makeDirectories(build);
            this.copyArtifacts(build);
            this.postProcessModuleDirectory(build.isExtractSchema(), build.isCopyModuleArtifacts());
            this.generateConfigFiles(build);
            this.postProcessBuild(build);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(configStream);
                for (Runnable task : this.cleanupTasks) {
                    try {
                        task.run();
                    }
                    catch (Exception e2) {
                        this.getLog().error((CharSequence)"Failed to cleanup", (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
        this.safeClose(configStream);
        for (Runnable task : this.cleanupTasks) {
            try {
                task.run();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Failed to cleanup", (Throwable)e);
            }
        }
    }

    private void postProcessBuild(final Build build) throws IOException {
        final Path baseDir = Paths.get(new File(this.buildName, this.serverName).getAbsolutePath(), new String[0]);
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(dir).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : build.getFilePermissions()) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(dir, perm.getPermission());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(file).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : build.getFilePermissions()) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(file, perm.getPermission());
                    }
                }
                if (build.getUnix().includeFile(relative)) {
                    BuildMojo.this.toUnixLineEndings(file);
                }
                if (build.getWindows().includeFile(relative)) {
                    BuildMojo.this.toWindowsLineEndings(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void toUnixLineEndings(Path file) throws IOException {
        Pattern pattern = Pattern.compile("\\r\\n", 8);
        String content = BuildMojo.readFile(file.toFile());
        Matcher matcher = pattern.matcher(content);
        content = matcher.replaceAll("\n");
        this.copyFile(new ByteArrayInputStream(content.getBytes("UTF-8")), file.toFile());
    }

    private void toWindowsLineEndings(Path file) throws IOException {
        Pattern pattern = Pattern.compile("(?<!\\r)\\n", 8);
        String content = BuildMojo.readFile(file.toFile());
        Matcher matcher = pattern.matcher(content);
        content = matcher.replaceAll("\r\n");
        this.copyFile(new ByteArrayInputStream(content.getBytes("UTF-8")), file.toFile());
    }

    private void generateConfigFiles(Build build) throws IOException, XMLStreamException {
        File baseDir = new File(this.buildName, this.serverName);
        File configBaseDir = new File(this.configDir, "src" + File.separator + "main" + File.separator + "resources");
        for (ConfigFile standalone : build.getStandaloneConfigs()) {
            new ConfigurationAssembler(this.templateTmpDir.toFile(), new File(configBaseDir, standalone.getTemplateFile()), "server", new File(configBaseDir, standalone.getSubsystemFile()), new File(baseDir, standalone.getOutputFile()), standalone.getProperties()).assemble();
        }
        for (ConfigFile domain : build.getDomainConfigs()) {
            new ConfigurationAssembler(this.templateTmpDir.toFile(), new File(configBaseDir, domain.getTemplateFile()), "domain", new File(configBaseDir, domain.getSubsystemFile()), new File(baseDir, domain.getOutputFile()), domain.getProperties()).assemble();
        }
    }

    private void makeDirectories(Build build) throws IOException, XMLStreamException {
        File baseDir = new File(this.buildName, this.serverName);
        for (String dir : build.getMkDirs()) {
            File file = new File(baseDir, dir);
            if (file.isDirectory() || file.mkdirs()) continue;
            throw new RuntimeException("Could not create directory " + file);
        }
    }

    private void postProcessModuleDirectory(final boolean extractSchema, final boolean copyModuleArtifacts) throws IOException {
        File baseDir = new File(this.buildName, this.serverName);
        final File schemaTarget = new File(baseDir, "docs" + File.separator + "schema");
        if (!schemaTarget.isDirectory() && !schemaTarget.mkdirs()) {
            throw new RuntimeException("Could not create schema directory");
        }
        final Path modulesDir = Paths.get(new File(baseDir, "modules").getAbsolutePath(), new String[0]);
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!file.getFileName().toString().equals("module.xml")) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    ZipFile zip;
                    String moduleXmlContents = null;
                    if (copyModuleArtifacts) {
                        moduleXmlContents = BuildMojo.readFile(file.toFile());
                    }
                    ModuleParseResult result = ModuleParser.parse(modulesDir, file);
                    for (String artifactName : result.getArtifacts()) {
                        Artifact artifact = (Artifact)BuildMojo.this.artifactMap.get(artifactName);
                        if (artifact == null) {
                            throw new RuntimeException("Could not extract resources from artifact " + artifactName + " contents " + BuildMojo.this.artifactMap);
                        }
                        try {
                            zip = new ZipFile(artifact.getFile());
                            try {
                                if (extractSchema) {
                                    BuildMojo.this.extractSchemaFromZip(zip, schemaTarget);
                                }
                                BuildMojo.this.extractTemplatesFromZip(zip);
                            }
                            catch (Throwable throwable) {
                                BuildMojo.this.safeClose(new Closeable[]{zip});
                                throw throwable;
                            }
                            BuildMojo.this.safeClose(new Closeable[]{zip});
                        }
                        catch (Throwable t) {
                            throw new RuntimeException("Could not extract resources from " + artifactName, t);
                        }
                        if (!copyModuleArtifacts) continue;
                        String artifactFileName = artifact.getFile().getName();
                        BuildMojo.this.copyFile(artifact.getFile(), new File(file.getParent().toFile(), artifactFileName));
                        moduleXmlContents = moduleXmlContents.replaceAll("<artifact\\s+name=\"" + artifactName + "\"\\s*/>", "<resource-root path=\"" + artifactFileName + "\"/>");
                    }
                    if (copyModuleArtifacts) {
                        BuildMojo.this.copyFile(new ByteArrayInputStream(moduleXmlContents.getBytes("UTF-8")), file.toFile());
                    }
                    for (String rootName : result.getResourceRoots()) {
                        Path resourcePath = file.getParent().resolve(rootName);
                        if (!Files.exists(resourcePath, new LinkOption[0])) {
                            BuildMojo.this.getLog().warn((CharSequence)("Could not find resource root " + resourcePath));
                            continue;
                        }
                        if (!Files.isRegularFile(resourcePath, new LinkOption[0])) continue;
                        zip = new ZipFile(resourcePath.toFile());
                        try {
                            if (extractSchema) {
                                BuildMojo.this.extractSchemaFromZip(zip, schemaTarget);
                            }
                            BuildMojo.this.extractTemplatesFromZip(zip);
                        }
                        catch (Throwable throwable) {
                            BuildMojo.this.safeClose(new Closeable[]{zip});
                            throw throwable;
                            return FileVisitResult.CONTINUE;
                        }
                        BuildMojo.this.safeClose(new Closeable[]{zip});
                    }
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractTemplatesFromZip(ZipFile zip) throws IOException {
        if (zip.getEntry("subsystem-templates") == null) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("subsystem-templates/") || entry.isDirectory()) continue;
            InputStream in = null;
            try {
                in = zip.getInputStream(entry);
                this.copyFile(in, new File(this.templateTmpDir.toFile(), entry.getName().substring("subsystem-templates/".length())));
            }
            catch (Throwable throwable) {
                this.safeClose(in);
                throw throwable;
            }
            this.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSchemaFromZip(ZipFile zip, File schemaTarget) throws IOException {
        if (zip.getEntry("schema") == null) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("schema/") || entry.isDirectory()) continue;
            InputStream in = null;
            try {
                in = zip.getInputStream(entry);
                this.copyFile(in, new File(schemaTarget, entry.getName().substring("schema/".length())));
            }
            catch (Throwable throwable) {
                this.safeClose(in);
                throw throwable;
            }
            this.safeClose(in);
        }
    }

    private void copyModules(Build build) throws IOException {
        ArrayList<Map<ModuleIdentifier, ModuleParseResult>> allModules = new ArrayList<Map<ModuleIdentifier, ModuleParseResult>>();
        for (Server server : build.getServers()) {
            allModules.add(ModuleUtils.enumerateModuleDirectory(this.getLog(), Paths.get(server.getPath(), new String[0])));
        }
        ArrayDeque<Object> transitiveIncludes = new ArrayDeque<Object>();
        HashMap finalModuleSet = new HashMap();
        for (int i = 0; i < allModules.size(); ++i) {
            Server server = build.getServers().get(i);
            Map modules = (Map)allModules.get(i);
            for (Map.Entry entry : modules.entrySet()) {
                Server.ModuleIncludeType includeType = server.includeModule(((ModuleIdentifier)entry.getKey()).toString());
                if (includeType != Server.ModuleIncludeType.MODULE_ONLY && includeType != Server.ModuleIncludeType.TRANSITIVE) continue;
                if (finalModuleSet.containsKey(entry.getKey())) {
                    throw new RuntimeException("Same module is present in two servers, one of them must be excluded " + ((ModuleParseResult)finalModuleSet.get(entry.getKey())).moduleXmlFile + " and " + ((ModuleParseResult)entry.getValue()).moduleXmlFile);
                }
                finalModuleSet.put(entry.getKey(), entry.getValue());
                if (includeType != Server.ModuleIncludeType.TRANSITIVE) continue;
                transitiveIncludes.add(entry.getValue());
            }
        }
        HashSet<String> notFound = new HashSet<String>();
        while (!transitiveIncludes.isEmpty()) {
            ModuleParseResult transitive = (ModuleParseResult)transitiveIncludes.pop();
            for (ModuleParseResult.ModuleDependency moduleDependency : transitive.getDependencies()) {
                if (finalModuleSet.containsKey(moduleDependency.getModuleId())) continue;
                ModuleParseResult found = null;
                for (Map map : allModules) {
                    if (!map.containsKey(moduleDependency.getModuleId())) continue;
                    if (found == null) {
                        found = (ModuleParseResult)map.get(moduleDependency.getModuleId());
                        continue;
                    }
                    throw new RuntimeException("Same module is present in two servers, one of them must be excluded " + map.get(moduleDependency.getModuleId()) + " and " + found.moduleXmlFile);
                }
                if (found == null && !moduleDependency.isOptional()) {
                    notFound.add("Could not find module " + moduleDependency.getModuleId() + " referenced from module " + transitive.getIdentifier() + " at " + transitive.getModuleXmlFile());
                    continue;
                }
                if (found != null) {
                    finalModuleSet.put(found.getIdentifier(), found);
                    transitiveIncludes.add(found);
                    continue;
                }
                this.getLog().warn((CharSequence)("Could not find optional dependency " + moduleDependency.getModuleId()));
            }
        }
        if (!notFound.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : notFound) {
                sb.append(string);
                sb.append('\n');
            }
            throw new RuntimeException(sb.toString());
        }
        Properties artifactPropertyMap = new Properties();
        for (Map.Entry entry : this.artifactMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(((Artifact)entry.getValue()).getGroupId());
            sb.append(":");
            sb.append(((Artifact)entry.getValue()).getArtifactId());
            sb.append(":");
            sb.append(((Artifact)entry.getValue()).getVersion());
            if (((Artifact)entry.getValue()).getClassifier() != null) {
                sb.append(':');
                sb.append(((Artifact)entry.getValue()).getClassifier());
            }
            artifactPropertyMap.put(entry.getKey(), sb.toString());
        }
        final HashSet errors = new HashSet();
        final BuildPropertyReplacer buildPropertyReplacer = new BuildPropertyReplacer(artifactPropertyMap);
        File baseDir = new File(this.buildName, this.serverName);
        Path modulesDir = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        for (Map.Entry entry : finalModuleSet.entrySet()) {
            Path module;
            Path moduleParent;
            Path moduleRoot = ((ModuleParseResult)entry.getValue()).getModuleRoot();
            Path relativeParent = moduleRoot.relativize(moduleParent = (module = ((ModuleParseResult)entry.getValue()).getModuleXmlFile()).getParent());
            final Path targetDir = modulesDir.resolve(relativeParent);
            if (!Files.isDirectory(targetDir, new LinkOption[0])) {
                targetDir.toFile().mkdirs();
            }
            Files.walkFileTree(moduleParent, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relative = moduleParent.relativize(dir).toString();
                    Path rel = targetDir.resolve(relative);
                    if (!Files.isDirectory(rel, new LinkOption[0]) && !rel.toFile().mkdirs()) {
                        throw new IOException("Could not create directory " + rel.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        String relative = moduleParent.relativize(file).toString();
                        Path targetFile = targetDir.resolve(relative);
                        if (relative.equals("module.xml")) {
                            String data = BuildMojo.readFile(file.toFile());
                            data = buildPropertyReplacer.replaceProperties(data);
                            BuildMojo.this.copyFile(new ByteArrayInputStream(data.getBytes("UTF-8")), targetFile.toFile());
                        } else {
                            BuildMojo.this.copyFile(file.toFile(), targetFile.toFile());
                            if (!OS_WINDOWS) {
                                Files.setPosixFilePermissions(targetFile, Files.getPosixFilePermissions(file, new LinkOption[0]));
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    catch (Exception e) {
                        errors.add(e.getMessage());
                        return FileVisitResult.CONTINUE;
                    }
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        if (!errors.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String problem : errors) {
                stringBuilder.append(problem);
                stringBuilder.append('\n');
            }
            throw new RuntimeException(stringBuilder.toString());
        }
    }

    private void buildArtifactMap() {
        for (Artifact artifact : this.project.getArtifacts()) {
            StringBuilder sb = new StringBuilder();
            sb.append(artifact.getGroupId());
            sb.append(':');
            sb.append(artifact.getArtifactId());
            if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
                this.artifactMap.put(sb.toString() + "::" + artifact.getClassifier(), artifact);
                this.artifactMap.put(sb.toString() + ":" + artifact.getVersion() + ":" + artifact.getClassifier(), artifact);
                continue;
            }
            this.artifactMap.put(sb.toString(), artifact);
            sb.append(':');
            sb.append(artifact.getVersion());
            this.artifactMap.put(sb.toString(), artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractServer(Server server) {
        if (server.getPath() != null) {
            return;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        String name = "wf-server-build" + this.folderCount++;
        File destDir = new File(tempDir, name);
        this.deleteRecursive(destDir);
        this.cleanupTasks.add(new FileDeleteTask(destDir));
        destDir.mkdirs();
        Artifact artifact = this.artifactMap.get(server.getArtifact());
        if (artifact == null) {
            throw new RuntimeException("Could not find server artifact " + server.getArtifact() + " make sure it is present as a dependency of the project");
        }
        this.getLog().info((CharSequence)("Extracting server " + artifact.getFile()));
        JarFile jar = null;
        try {
            jar = new JarFile(artifact.getFile());
            Enumeration<JarEntry> entries = jar.entries();
            byte[] data = new byte[1024];
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                File f = new File(destDir + File.separator + jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                InputStream is = jar.getInputStream(jarEntry);
                FileOutputStream fos = new FileOutputStream(f);
                try {
                    int read;
                    while ((read = is.read(data)) > 0) {
                        fos.write(data, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(is, fos);
                    throw throwable;
                }
                this.safeClose(is, fos);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to extract " + artifact.getFile(), e);
            }
            catch (Throwable throwable) {
                this.safeClose(jar);
                throw throwable;
            }
        }
        this.safeClose(jar);
        String[] files = destDir.list();
        server.setPath(new File(destDir, files[0]).getAbsolutePath());
    }

    private void copyArtifacts(Build build) throws IOException {
        File baseDir = new File(this.buildName, this.serverName);
        for (CopyArtifact copy : build.getCopyArtifacts()) {
            File target = new File(baseDir, copy.getToLocation());
            if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory " + target.getParentFile());
            }
            Artifact artifact = this.artifactMap.get(copy.getArtifact());
            if (artifact == null) {
                throw new RuntimeException("Could not find artifact " + copy.getArtifact() + " make sure it is a dependency of the project");
            }
            if (copy.isExtract()) {
                this.extractArtifact(artifact.getFile(), target, copy);
                continue;
            }
            this.copyFile(artifact.getFile(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractArtifact(File file, File target, CopyArtifact copy) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!copy.includeFile(entry.getName())) continue;
                if (entry.isDirectory()) {
                    new File(target, entry.getName()).mkdirs();
                    continue;
                }
                InputStream in = null;
                try {
                    in = zip.getInputStream(entry);
                    this.copyFile(in, new File(target, entry.getName()));
                }
                catch (Throwable throwable) {
                    this.safeClose(in);
                    throw throwable;
                }
                this.safeClose(in);
            }
        }
        catch (Throwable throwable) {
            this.safeClose(zip);
            throw throwable;
        }
        this.safeClose(zip);
    }

    public void copyServers(Build build) throws IOException {
        File baseDir = new File(this.buildName, this.serverName);
        this.deleteRecursive(baseDir);
        final Path path = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        for (final Server server : build.getServers()) {
            final Path base = Paths.get(server.getPath(), new String[0]);
            Files.walkFileTree(base, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relative = base.relativize(dir).toString();
                    boolean include = server.includeFile(relative);
                    if (include) {
                        Path rel = path.resolve(relative);
                        if (!Files.isDirectory(rel, new LinkOption[0]) && !rel.toFile().mkdirs()) {
                            throw new IOException("Could not create directory " + rel.toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relative = base.relativize(file).toString();
                    if (!server.includeFile(relative)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = path.resolve(relative);
                    BuildMojo.this.copyFile(file.toFile(), targetFile.toFile());
                    if (!OS_WINDOWS) {
                        Files.setPosixFilePermissions(targetFile, Files.getPosixFilePermissions(file, new LinkOption[0]));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void safeClose(Closeable ... closeable) {
        for (Closeable c : closeable) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Failed to close resource", (Throwable)e);
            }
        }
    }

    public void deleteRecursive(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.deleteRecursive(f);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File src, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        try {
            this.copyFile(in, dest);
        }
        catch (Throwable throwable) {
            this.safeClose(in);
            throw throwable;
        }
        this.safeClose(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        byte[] data = new byte[10000];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            int read;
            while ((read = in.read(data)) > 0) {
                ((OutputStream)out).write(data, 0, read);
            }
        }
        catch (Throwable throwable) {
            this.safeClose(out);
            throw throwable;
        }
        this.safeClose(out);
    }

    public static String readFile(File file) {
        try {
            return BuildMojo.readFile(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFile(InputStream file) {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file);
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class FileDeleteTask
    implements Runnable {
        final File file;

        private FileDeleteTask(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            BuildMojo.this.deleteRecursive(this.file);
        }
    }
}

