/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.build.plugin.ModuleParseResult;
import org.wildfly.build.plugin.ModuleParser;

public class ModuleUtils {
    private ModuleUtils() {
    }

    public static Map<ModuleIdentifier, ModuleParseResult> enumerateModuleDirectory(Log log, Path moduleDirectory) throws IOException {
        ModuleVisitor visitor = new ModuleVisitor(moduleDirectory, log);
        Files.walkFileTree(moduleDirectory, visitor);
        return visitor.getParseResults();
    }

    private static final class ModuleVisitor
    implements FileVisitor<Path> {
        private final Path moduleRoot;
        final Log log;
        private final Map<ModuleIdentifier, ModuleParseResult> parseResults = new HashMap<ModuleIdentifier, ModuleParseResult>();

        private ModuleVisitor(Path moduleRoot, Log log) {
            this.moduleRoot = moduleRoot;
            this.log = log;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!file.getName(file.getNameCount() - 1).toString().equals("module.xml")) {
                return FileVisitResult.CONTINUE;
            }
            try {
                ModuleParseResult result = ModuleParser.parse(this.moduleRoot, file);
                this.parseResults.put(result.getIdentifier(), result);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.TERMINATE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        private Map<ModuleIdentifier, ModuleParseResult> getParseResults() {
            return this.parseResults;
        }
    }
}

