/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.plugin.BuildPropertyReplacer;
import org.wildfly.build.plugin.model.Build;
import org.wildfly.build.plugin.model.ConfigFile;
import org.wildfly.build.plugin.model.CopyArtifact;
import org.wildfly.build.plugin.model.FileFilter;
import org.wildfly.build.plugin.model.FilePermission;
import org.wildfly.build.plugin.model.LineEndings;
import org.wildfly.build.plugin.model.ModuleFilter;
import org.wildfly.build.plugin.model.Server;

class BuildModelParser10
implements XMLElementReader<Build> {
    private final BuildPropertyReplacer propertyReplacer;
    public static final String NAMESPACE_1_0 = "urn:wildfly:build:1.0";

    BuildModelParser10(Properties properties) {
        this.propertyReplacer = new BuildPropertyReplacer(properties);
    }

    public void readElement(XMLExtendedStreamReader reader, Build result) throws XMLStreamException {
        boolean extractSchema = true;
        boolean copyModuleArtifacts = true;
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case EXTRACT_SCHEMA: {
                    extractSchema = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block16;
                }
                case COPY_MODULE_ARTIFACTS: {
                    copyModuleArtifacts = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block16;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        result.setExtractSchema(extractSchema);
        result.setCopyModuleArtifacts(copyModuleArtifacts);
        block17: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case SERVERS: {
                            this.parseServers((XMLStreamReader)reader, result);
                            continue block17;
                        }
                        case ARTIFACTS: {
                            this.parseArtifacts((XMLStreamReader)reader, result);
                            continue block17;
                        }
                        case CONFIG: {
                            this.parseConfig((XMLStreamReader)reader, result);
                            continue block17;
                        }
                        case FILE_PERMISSIONS: {
                            this.parseFilePermissions((XMLStreamReader)reader, result);
                            continue block17;
                        }
                        case MKDIRS: {
                            this.parseMkdirs((XMLStreamReader)reader, result);
                            continue block17;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings((XMLStreamReader)reader, result);
                            continue block17;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw BuildModelParser10.unexpectedContent((XMLStreamReader)reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, Build result) throws XMLStreamException {
        String artifact = null;
        String location = null;
        boolean extract = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    artifact = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case TO_LOCATION: {
                    location = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block12;
                }
                case EXTRACT: {
                    extract = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        CopyArtifact copyArtifact = new CopyArtifact(artifact, location, extract);
        result.getCopyArtifacts().add(copyArtifact);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, copyArtifact.getFilters());
                            continue block13;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseLineEnding(XMLStreamReader reader, LineEndings result) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw BuildModelParser10.unexpectedContent(reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, result.getFilters());
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parsePermission(XMLStreamReader reader, Build result) throws XMLStreamException {
        String permission = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permission = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        FilePermission filePermission = new FilePermission(permission);
        result.getFilePermissions().add(filePermission);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, filePermission.getFilters());
                            continue block11;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseServers(XMLStreamReader reader, Build result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case SERVER: {
                            Server server = new Server();
                            result.getServers().add(server);
                            this.parseServer(reader, server);
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseArtifacts(XMLStreamReader reader, Build result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            this.parseCopyArtifact(reader, result);
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseLineEndings(XMLStreamReader reader, Build result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            this.parseLineEnding(reader, result.getWindows());
                            continue block8;
                        }
                        case UNIX: {
                            this.parseLineEnding(reader, result.getUnix());
                            continue block8;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseServer(XMLStreamReader reader, Server result) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        boolean locationSpecified = false;
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw BuildModelParser10.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case PATH: {
                            if (locationSpecified) {
                                throw new XMLStreamException("<server> can only have a single <path> or <artifact> element");
                            }
                            locationSpecified = true;
                            result.setPath(this.parseName(reader));
                            continue block10;
                        }
                        case ARTIFACT: {
                            if (locationSpecified) {
                                throw new XMLStreamException("<server> can only have a single <path> or <artifact> element");
                            }
                            locationSpecified = true;
                            result.setArtifact(this.parseName(reader));
                            continue block10;
                        }
                        case FILES: {
                            this.parseFiles(reader, result);
                            continue block10;
                        }
                        case MODULES: {
                            this.parseModules(reader, result);
                            continue block10;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        BuildModelParser10.parseNoContent(reader);
        return this.propertyReplacer.replaceProperties(name);
    }

    private void parseFiles(XMLStreamReader reader, Server result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseFilter(reader, result.getFilters());
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseFilter(XMLStreamReader reader, List<FileFilter> filters) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        BuildModelParser10.parseNoContent(reader);
        filters.add(new FileFilter(BuildModelParser10.wildcardToJavaRegexp(pattern), include));
    }

    private void parseModules(XMLStreamReader reader, Server result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            this.parseModulesFilter(reader, result);
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseModulesFilter(XMLStreamReader reader, Server result) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        boolean transitive = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block5;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block5;
                }
                case TRANSITIVE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block5;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        BuildModelParser10.parseNoContent(reader);
        result.getModules().add(new ModuleFilter(BuildModelParser10.wildcardToJavaRegexp(pattern), include, transitive));
    }

    private void parseConfig(XMLStreamReader reader, Build result) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            this.parseConfigFile(reader, result, false);
                            continue block8;
                        }
                        case DOMAIN: {
                            this.parseConfigFile(reader, result, true);
                            continue block8;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseConfigFile(XMLStreamReader reader, Build result, boolean domain) throws XMLStreamException {
        String template = null;
        String subsystems = null;
        String outputFile = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.TEMPLATE, Attribute.SUBSYSTEMS, Attribute.OUTPUT_FILE);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case TEMPLATE: {
                    template = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block5;
                }
                case SUBSYSTEMS: {
                    subsystems = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block5;
                }
                case OUTPUT_FILE: {
                    outputFile = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block5;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        ConfigFile file = new ConfigFile(template, subsystems, outputFile);
        this.parseProperties(reader, file.getProperties());
        if (domain) {
            result.getDomainConfigs().add(file);
        } else {
            result.getStandaloneConfigs().add(file);
        }
    }

    private void parseMkdirs(XMLStreamReader reader, Build result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DIR: {
                            result.getMkDirs().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseProperties(XMLStreamReader reader, Properties properties) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, properties);
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private void parseProperty(XMLStreamReader reader, Properties result) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case VALUE: {
                    value = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw BuildModelParser10.missingAttributes(reader.getLocation(), required);
        }
        BuildModelParser10.parseNoContent(reader);
        result.put(name, value);
    }

    private void parseFilePermissions(XMLStreamReader reader, Build result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            this.parsePermission(reader, result);
                            continue block7;
                        }
                    }
                    throw BuildModelParser10.unexpectedContent(reader);
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
        throw BuildModelParser10.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw BuildModelParser10.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw BuildModelParser10.unexpectedContent(reader);
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        return new XMLStreamException("unexpected content: " + kind + (reader.hasName() ? reader.getName() : null) + (reader.hasText() ? reader.getText() : null), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document ", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder();
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException("Missing required attributes " + b.toString(), location);
    }

    private static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    static enum Attribute {
        NAME,
        PATTERN,
        INCLUDE,
        TRANSITIVE,
        ARTIFACT,
        TO_LOCATION,
        EXTRACT,
        EXTRACT_SCHEMA,
        TEMPLATE,
        SUBSYSTEMS,
        OUTPUT_FILE,
        COPY_MODULE_ARTIFACTS,
        VALUE,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("pattern"), PATTERN);
            attributesMap.put(new QName("include"), INCLUDE);
            attributesMap.put(new QName("transitive"), TRANSITIVE);
            attributesMap.put(new QName("artifact"), ARTIFACT);
            attributesMap.put(new QName("to-location"), TO_LOCATION);
            attributesMap.put(new QName("extract-schema"), EXTRACT_SCHEMA);
            attributesMap.put(new QName("extract"), EXTRACT);
            attributesMap.put(new QName("template"), TEMPLATE);
            attributesMap.put(new QName("subsystems"), SUBSYSTEMS);
            attributesMap.put(new QName("output-file"), OUTPUT_FILE);
            attributesMap.put(new QName("copy-module-artifacts"), COPY_MODULE_ARTIFACTS);
            attributesMap.put(new QName("value"), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD,
        SERVER,
        SERVERS,
        ARTIFACT,
        PATH,
        FILES,
        FILTER,
        MODULES,
        CONFIG,
        STANDALONE,
        DOMAIN,
        COPY_ARTIFACT,
        ARTIFACTS,
        FILE_PERMISSIONS,
        PERMISSION,
        PROPERTY,
        MKDIRS,
        DIR,
        LINE_ENDINGS,
        WINDOWS,
        UNIX,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(BuildModelParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "build"), BUILD);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "server"), SERVER);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "servers"), SERVERS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "artifact"), ARTIFACT);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "path"), PATH);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "files"), FILES);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "filter"), FILTER);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "modules"), MODULES);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "config"), CONFIG);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "copy-artifact"), COPY_ARTIFACT);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "standalone"), STANDALONE);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "domain"), DOMAIN);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "artifacts"), ARTIFACTS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "file-permissions"), FILE_PERMISSIONS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "permission"), PERMISSION);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "property"), PROPERTY);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "mkdirs"), MKDIRS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "dir"), DIR);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "line-endings"), LINE_ENDINGS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "windows"), WINDOWS);
            elementsMap.put(new QName(BuildModelParser10.NAMESPACE_1_0, "unix"), UNIX);
            elements = elementsMap;
        }
    }
}

