/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin.model;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.build.plugin.model.FileFilter;
import org.wildfly.build.plugin.model.ModuleFilter;

public class Server {
    private String path;
    private String artifact;
    private final List<FileFilter> filters = new ArrayList<FileFilter>();
    private final List<ModuleFilter> modules = new ArrayList<ModuleFilter>();

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public List<ModuleFilter> getModules() {
        return this.modules;
    }

    public boolean includeFile(String path) {
        if (path.startsWith("modules/") || path.startsWith("configuration")) {
            return false;
        }
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return true;
    }

    public ModuleIncludeType includeModule(String path) {
        for (ModuleFilter filter : this.modules) {
            if (!filter.matches(path)) continue;
            if (filter.isInclude()) {
                return filter.isTransitive() ? ModuleIncludeType.TRANSITIVE : ModuleIncludeType.MODULE_ONLY;
            }
            return ModuleIncludeType.NONE;
        }
        return ModuleIncludeType.TRANSITIVE;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public static enum ModuleIncludeType {
        NONE,
        MODULE_ONLY,
        TRANSITIVE;

    }
}

