/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformersLogger;
import org.jboss.dmr.ModelNode;

abstract class TransformationRule {
    TransformationRule() {
    }

    abstract void transformOperation(ModelNode var1, PathAddress var2, ChainedOperationContext var3) throws OperationFailedException;

    abstract void transformResource(Resource var1, PathAddress var2, ChainedResourceContext var3) throws OperationFailedException;

    static ModelNode cloneAndProtect(ModelNode modelNode) {
        ModelNode clone = modelNode.clone();
        clone.protect();
        return clone;
    }

    private static class ProtectedModelResourceEntry
    extends ProtectedModelResource<Resource.ResourceEntry>
    implements Resource.ResourceEntry {
        ProtectedModelResourceEntry(Resource.ResourceEntry delegate) {
            super(delegate);
        }

        @Override
        public String getName() {
            return ((Resource.ResourceEntry)this.delegate).getName();
        }

        @Override
        public PathElement getPathElement() {
            return ((Resource.ResourceEntry)this.delegate).getPathElement();
        }
    }

    private static class ProtectedModelResource<T extends Resource>
    implements Resource {
        protected T delegate;

        ProtectedModelResource(T delegate) {
            this.delegate = delegate;
        }

        @Override
        public ModelNode getModel() {
            return TransformationRule.cloneAndProtect(this.delegate.getModel());
        }

        @Override
        public void writeModel(ModelNode newModel) {
            throw ControllerLogger.ROOT_LOGGER.immutableResource();
        }

        @Override
        public boolean isModelDefined() {
            return this.delegate.isModelDefined();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.delegate.hasChild(element);
        }

        @Override
        public Resource getChild(PathElement element) {
            Resource resource = this.delegate.getChild(element);
            if (resource != null) {
                return new ProtectedModelResource<Resource>(resource);
            }
            return null;
        }

        @Override
        public Resource requireChild(PathElement element) {
            Resource resource = this.delegate.requireChild(element);
            if (resource != null) {
                return new ProtectedModelResource<Resource>(resource);
            }
            return null;
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.delegate.hasChildren(childType);
        }

        @Override
        public Resource navigate(PathAddress address) {
            Resource resource = this.delegate.navigate(address);
            if (resource != null) {
                return new ProtectedModelResource<Resource>(resource);
            }
            return null;
        }

        @Override
        public Set<String> getChildTypes() {
            return this.delegate.getChildTypes();
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.delegate.getChildrenNames(childType);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            Set<Resource.ResourceEntry> children = this.delegate.getChildren(childType);
            if (children != null) {
                LinkedHashSet<Resource.ResourceEntry> protectedChildren = new LinkedHashSet<Resource.ResourceEntry>();
                for (Resource.ResourceEntry entry : children) {
                    protectedChildren.add(new ProtectedModelResourceEntry(entry));
                }
                return protectedChildren;
            }
            return null;
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            throw ControllerLogger.ROOT_LOGGER.immutableResource();
        }

        @Override
        public Resource removeChild(PathElement address) {
            throw ControllerLogger.ROOT_LOGGER.immutableResource();
        }

        @Override
        public boolean isRuntime() {
            return this.delegate.isRuntime();
        }

        @Override
        public boolean isProxy() {
            return this.delegate.isProxy();
        }

        @Override
        public Resource clone() {
            return new ProtectedModelResource<Resource>(this.delegate.clone());
        }
    }

    private static class ChainedTransformedOperation
    extends OperationTransformer.TransformedOperation {
        private final List<OperationTransformer.TransformedOperation> delegates;
        private volatile String failure;
        private volatile boolean initialized;

        public ChainedTransformedOperation(ModelNode transformedOperation, List<OperationTransformer.TransformedOperation> delegates) {
            super(transformedOperation, null);
            this.delegates = delegates;
        }

        @Override
        public ModelNode getTransformedOperation() {
            return super.getTransformedOperation();
        }

        @Override
        public OperationResultTransformer getResultTransformer() {
            return this;
        }

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            for (OperationTransformer.TransformedOperation delegate : this.delegates) {
                if (!delegate.rejectOperation(preparedResult)) continue;
                this.failure = delegate.getFailureDescription();
                this.initialized = true;
                return true;
            }
            return false;
        }

        @Override
        public String getFailureDescription() {
            if (!this.initialized) {
                for (OperationTransformer.TransformedOperation delegate : this.delegates) {
                    String failure = delegate.getFailureDescription();
                    if (failure == null) continue;
                    return failure;
                }
            }
            return this.failure;
        }

        @Override
        public ModelNode transformResult(ModelNode result) {
            ModelNode currentResult = result;
            int size = this.delegates.size();
            for (int i = size - 1; i >= 0; --i) {
                currentResult = this.delegates.get(i).transformResult(currentResult);
            }
            return currentResult;
        }
    }

    private static class TransformationContextWrapper
    implements TransformationContext {
        private final TransformationContext delegate;
        private volatile boolean immutable;

        private TransformationContextWrapper(TransformationContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public TransformationTarget getTarget() {
            return this.delegate.getTarget();
        }

        @Override
        public ProcessType getProcessType() {
            return this.delegate.getProcessType();
        }

        @Override
        public RunningMode getRunningMode() {
            return this.delegate.getRunningMode();
        }

        @Override
        public ImmutableManagementResourceRegistration getResourceRegistration(PathAddress address) {
            return this.delegate.getResourceRegistration(address);
        }

        @Override
        public ImmutableManagementResourceRegistration getResourceRegistrationFromRoot(PathAddress address) {
            return this.delegate.getResourceRegistrationFromRoot(address);
        }

        @Override
        public Resource readResource(PathAddress address) {
            Resource resource = this.delegate.readResource(address);
            if (resource != null) {
                return this.immutable ? new ProtectedModelResource<Resource>(resource) : resource;
            }
            return null;
        }

        @Override
        public Resource readResourceFromRoot(PathAddress address) {
            Resource resource = this.delegate.readResourceFromRoot(address);
            if (resource != null) {
                return this.immutable ? new ProtectedModelResource<Resource>(resource) : resource;
            }
            return null;
        }

        @Override
        @Deprecated
        public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
            return this.delegate.resolveExpressions(node);
        }

        @Override
        public TransformersLogger getLogger() {
            return this.delegate.getLogger();
        }

        void setImmutableResource(boolean immutable) {
            this.immutable = immutable;
        }

        @Override
        public boolean isSkipRuntimeIgnoreCheck() {
            return this.delegate.isSkipRuntimeIgnoreCheck();
        }
    }

    static abstract class ChainedResourceContext
    extends AbstractChainedContext {
        protected ChainedResourceContext(ResourceTransformationContext context) {
            super(context);
        }

        abstract void invokeNext(Resource var1) throws OperationFailedException;
    }

    static abstract class ChainedOperationContext
    extends AbstractChainedContext {
        private final List<OperationTransformer.TransformedOperation> transformed = new ArrayList<OperationTransformer.TransformedOperation>();
        private ModelNode lastOperation;

        protected ChainedOperationContext(TransformationContext context) {
            super(context);
        }

        protected void recordTransformedOperation(OperationTransformer.TransformedOperation operation) {
            this.lastOperation = operation.getTransformedOperation();
            this.transformed.add(operation);
        }

        void invokeNext(ModelNode operation) throws OperationFailedException {
            this.invokeNext(new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT));
        }

        abstract void invokeNext(OperationTransformer.TransformedOperation var1) throws OperationFailedException;

        protected OperationTransformer.TransformedOperation createOp() {
            if (this.transformed.size() == 1) {
                return this.transformed.get(0);
            }
            return new ChainedTransformedOperation(this.lastOperation, this.transformed);
        }
    }

    static abstract class AbstractChainedContext {
        private final TransformationContextWrapper context;

        protected AbstractChainedContext(TransformationContext context) {
            this.context = new TransformationContextWrapper(context);
        }

        protected TransformationContext getContext() {
            return this.context;
        }

        void setImmutableResource(boolean immutable) {
            this.context.setImmutableResource(immutable);
        }
    }
}

