/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;

public abstract class AttributeMarshaller {
    public static final AttributeMarshaller SIMPLE = new DefaultAttributeMarshaller();
    public static final AttributeMarshaller STRING_LIST = new ListMarshaller(' ');
    public static final AttributeMarshaller COMMA_STRING_LIST = new ListMarshaller(',');

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
        return this.isMarshallable(attribute, resourceModel, true);
    }

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
        return resourceModel.hasDefined(attribute.getName()) && (marshallDefault || !resourceModel.get(attribute.getName()).equals(attribute.getDefaultValue()));
    }

    public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsAttribute(attribute.getName());
    }

    public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsElement(attribute.getName());
    }

    public boolean isMarshallableAsElement() {
        return false;
    }

    private static class ListMarshaller
    extends DefaultAttributeMarshaller {
        private final char delimiter;

        private ListMarshaller(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            StringBuilder builder = new StringBuilder();
            if (resourceModel.hasDefined(attribute.getName())) {
                for (ModelNode p : resourceModel.get(attribute.getName()).asList()) {
                    builder.append(p.asString()).append(this.delimiter);
                }
            }
            if (builder.length() > 2) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() > 0) {
                writer.writeAttribute(attribute.getXmlName(), builder.toString());
            }
        }
    }
}

