/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.HostServerGroupTracker;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.DelegatingImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.DelegatingManagementResourceRegistration;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class OperationContextImpl
extends AbstractOperationContext {
    private static final Object NULL = new Object();
    private static final Set<Action.ActionEffect> ADDRESS = EnumSet.of(Action.ActionEffect.ADDRESS);
    private static final Set<Action.ActionEffect> READ_CONFIG = EnumSet.of(Action.ActionEffect.READ_CONFIG);
    private static final Set<Action.ActionEffect> READ_RUNTIME = EnumSet.of(Action.ActionEffect.READ_RUNTIME);
    private static final Set<Action.ActionEffect> READ_WRITE_CONFIG = EnumSet.of(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.WRITE_CONFIG);
    private static final Set<Action.ActionEffect> READ_WRITE_RUNTIME = EnumSet.of(Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_RUNTIME);
    private static final Set<Action.ActionEffect> WRITE_CONFIG = EnumSet.of(Action.ActionEffect.WRITE_CONFIG);
    private static final Set<Action.ActionEffect> WRITE_RUNTIME = EnumSet.of(Action.ActionEffect.WRITE_RUNTIME);
    private static final Set<Action.ActionEffect> ALL_READ_WRITE = EnumSet.of(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_CONFIG, Action.ActionEffect.WRITE_RUNTIME);
    private final ModelControllerImpl modelController;
    private final EnumSet<AbstractOperationContext.ContextFlag> contextFlags;
    private final OperationMessageHandler messageHandler;
    private final ServiceTarget serviceTarget;
    private final Map<ServiceName, ServiceController<?>> realRemovingControllers = new HashMap();
    private final Map<ServiceName, AbstractOperationContext.Step> removalSteps = new HashMap<ServiceName, AbstractOperationContext.Step>();
    private final OperationAttachments attachments;
    private final Map<PathAddress, Object> affectsModel;
    private Map<PathAddress, Object> restartedResources = Collections.emptyMap();
    private final ConcurrentMap<OperationContext.AttachmentKey<?>, Object> valueAttachments = new ConcurrentHashMap();
    private final Map<AbstractOperationContext.OperationId, AuthorizationResponseImpl> authorizations = new ConcurrentHashMap<AbstractOperationContext.OperationId, AuthorizationResponseImpl>();
    private final ModelNode blockingTimeoutConfig;
    private volatile BlockingTimeout blockingTimeout;
    private final long startTime = System.nanoTime();
    private volatile long exclusiveStartTime = -1L;
    private volatile boolean affectsResourceRegistration;
    private volatile Resource model;
    private volatile Resource originalModel;
    private volatile HostServerGroupTracker hostServerGroupTracker;
    private volatile boolean affectsRuntime;
    private AbstractOperationContext.Step lockStep;
    private AbstractOperationContext.Step containerMonitorStep;
    private volatile Boolean requiresModelUpdateAuthorization;
    private volatile boolean readOnly = true;
    private final Map<PathAddress, ModelNode> resourceDescriptions = Collections.synchronizedMap(new HashMap());
    private final Integer operationId;
    private final String operationName;
    private final ModelNode operationAddress;
    private final AccessMechanism accessMechanism;
    private final ActiveOperationResource activeOperationResource;
    private final BooleanHolder done = new BooleanHolder();
    private volatile OperationContext.ExecutionStatus executionStatus = OperationContext.ExecutionStatus.EXECUTING;

    OperationContextImpl(Integer operationId, String operationName, ModelNode operationAddress, ModelControllerImpl modelController, ProcessType processType, RunningMode runningMode, EnumSet<AbstractOperationContext.ContextFlag> contextFlags, OperationMessageHandler messageHandler, OperationAttachments attachments, Resource model, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, AuditLogger auditLogger, boolean booting, HostServerGroupTracker hostServerGroupTracker, ModelNode blockingTimeoutConfig, AccessMechanism accessMechanism) {
        super(processType, runningMode, transactionControl, processState, booting, auditLogger);
        this.operationId = operationId;
        this.operationName = operationName;
        this.operationAddress = operationAddress.isDefined() ? operationAddress : ModelControllerImpl.EMPTY_ADDRESS;
        this.model = model;
        this.originalModel = model;
        this.modelController = modelController;
        this.messageHandler = messageHandler;
        this.attachments = attachments;
        this.affectsModel = booting ? new ConcurrentHashMap(256) : new HashMap(1);
        this.contextFlags = contextFlags;
        this.serviceTarget = new ContextServiceTarget(modelController);
        this.hostServerGroupTracker = hostServerGroupTracker;
        this.blockingTimeoutConfig = blockingTimeoutConfig != null && blockingTimeoutConfig.isDefined() ? blockingTimeoutConfig : null;
        this.activeOperationResource = new ActiveOperationResource();
        this.accessMechanism = accessMechanism;
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        if (this.attachments == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (InputStream)this.attachments.getInputStreams().get(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.attachments == null ? 0 : this.attachments.getInputStreams().size();
    }

    @Override
    void awaitServiceContainerStability() throws InterruptedException, TimeoutException {
        if (this.affectsRuntime) {
            ControllerLogger.MGMT_OP_LOGGER.debugf("Entered VERIFY stage; waiting for service container to settle", new Object[0]);
            long timeout = this.getBlockingTimeout().getBlockingTimeout();
            OperationContext.ExecutionStatus originalExecutionStatus = this.executionStatus;
            try {
                this.executionStatus = OperationContext.ExecutionStatus.AWAITING_STABILITY;
                this.waitForRemovals();
                ContainerStateMonitor.ContainerStateChangeReport changeReport = this.modelController.awaitContainerStateChangeReport(timeout, TimeUnit.MILLISECONDS);
                if (changeReport != null && !changeReport.getMissingServices().isEmpty()) {
                    ServiceRemovalVerificationHandler removalVerificationHandler = new ServiceRemovalVerificationHandler(changeReport);
                    this.addStep(new ModelNode(), new ModelNode(), PathAddress.EMPTY_ADDRESS, removalVerificationHandler, OperationContext.Stage.VERIFY);
                }
            }
            catch (TimeoutException te) {
                this.getBlockingTimeout().timeoutDetected();
                ControllerLogger.MGMT_OP_LOGGER.timeoutExecutingOperation(timeout / 1000L, this.containerMonitorStep.operationId.name, this.containerMonitorStep.address);
                throw te;
            }
            finally {
                this.executionStatus = originalExecutionStatus;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitForRemovals() throws InterruptedException, TimeoutException {
        if (this.affectsRuntime && !this.cancelled) {
            Map<ServiceName, ServiceController<?>> map = this.realRemovingControllers;
            synchronized (map) {
                boolean wait;
                long waitTime = this.getBlockingTimeout().getBlockingTimeout();
                long end = System.currentTimeMillis() + waitTime;
                boolean bl = wait = !this.realRemovingControllers.isEmpty() && !this.cancelled;
                while (wait && waitTime > 0L) {
                    this.realRemovingControllers.wait(waitTime);
                    wait = !this.realRemovingControllers.isEmpty() && !this.cancelled;
                    waitTime = end - System.currentTimeMillis();
                }
                if (wait) {
                    this.getBlockingTimeout().timeoutDetected();
                    throw new TimeoutException();
                }
            }
        }
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return this.modelController.writeModel(this.model, this.affectsModel.keySet());
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return this.contextFlags.contains((Object)AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL);
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return this.contextFlags.contains((Object)AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        assert (this.isControllingThread());
        this.readOnly = false;
        PathAddress address = this.activeStep.address;
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        this.authorize(false, READ_WRITE_CONFIG);
        if (!this.affectsResourceRegistration) {
            this.takeWriteLock();
            this.affectsResourceRegistration = true;
        }
        ManagementResourceRegistration delegate = this.modelController.getRootRegistration().getSubModel(address);
        return new DescriptionCachingResourceRegistration(delegate, address);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        PathAddress address = this.activeStep.address;
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null || currentStage == OperationContext.Stage.DONE) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        this.authorize(false, Collections.emptySet());
        ManagementResourceRegistration delegate = this.modelController.getRootRegistration().getSubModel(address);
        return delegate == null ? null : new DescriptionCachingImmutableResourceRegistration(delegate, address);
    }

    @Override
    public ImmutableManagementResourceRegistration getRootResourceRegistration() {
        ManagementResourceRegistration delegate = this.modelController.getRootRegistration();
        return delegate == null ? null : new DescriptionCachingImmutableResourceRegistration(delegate, PathAddress.EMPTY_ADDRESS);
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        OperationContext.Stage currentStage;
        assert (this.isControllingThread());
        if (modify) {
            this.readOnly = false;
        }
        if ((currentStage = this.currentStage) == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (modify && currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.MODEL && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerLogger.ROOT_LOGGER.serviceRegistryRuntimeOperationsOnly();
        }
        this.authorize(false, modify ? READ_WRITE_RUNTIME : READ_RUNTIME);
        if (modify) {
            this.ensureWriteLockForRuntime();
        }
        return new OperationContextServiceRegistry(this.modelController.getServiceRegistry());
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        assert (this.isControllingThread());
        this.readOnly = false;
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerLogger.ROOT_LOGGER.serviceRemovalRuntimeOperationsOnly();
        }
        this.authorize(false, WRITE_RUNTIME);
        this.ensureWriteLockForRuntime();
        ServiceController controller = this.modelController.getServiceRegistry().getService(name);
        if (controller != null) {
            this.doRemove(controller);
        }
        return controller;
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.containsKey(resource)) {
            return false;
        }
        if (this.restartedResources == Collections.EMPTY_MAP) {
            this.restartedResources = new HashMap<PathAddress, Object>();
        }
        this.restartedResources.put(resource, owner);
        return true;
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.get(resource) == owner) {
            this.restartedResources.remove(resource);
            return true;
        }
        return false;
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        assert (this.isControllingThread());
        this.readOnly = false;
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerLogger.ROOT_LOGGER.serviceRemovalRuntimeOperationsOnly();
        }
        this.authorize(false, WRITE_RUNTIME);
        this.ensureWriteLockForRuntime();
        if (controller != null) {
            this.doRemove(controller);
        }
    }

    private void doRemove(ServiceController<?> controller) {
        final AbstractOperationContext.Step removalStep = this.activeStep;
        removalStep.hasRemovals = true;
        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void listenerAdded(ServiceController<?> controller) {
                Map map = OperationContextImpl.this.realRemovingControllers;
                synchronized (map) {
                    OperationContextImpl.this.realRemovingControllers.put(controller.getName(), controller);
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case REMOVING_to_REMOVED: 
                    case REMOVING_to_DOWN: {
                        Map map = OperationContextImpl.this.realRemovingControllers;
                        synchronized (map) {
                            ServiceName name = controller.getName();
                            if (OperationContextImpl.this.realRemovingControllers.get(name) == controller) {
                                OperationContextImpl.this.realRemovingControllers.remove(name);
                                OperationContextImpl.this.removalSteps.put(name, removalStep);
                                OperationContextImpl.this.realRemovingControllers.notifyAll();
                            }
                            break;
                        }
                    }
                }
            }
        });
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        assert (this.isControllingThread());
        this.readOnly = false;
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerLogger.ROOT_LOGGER.serviceTargetRuntimeOperationsOnly();
        }
        this.ensureWriteLockForRuntime();
        return this.serviceTarget;
    }

    Resource.ResourceEntry getActiveOperationResource() {
        return this.activeOperationResource;
    }

    private void takeWriteLock() {
        if (this.lockStep == null) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw ControllerLogger.ROOT_LOGGER.invalidModificationAfterCompletedStep();
            }
            OperationContext.ExecutionStatus originalStatus = this.executionStatus;
            try {
                this.executionStatus = OperationContext.ExecutionStatus.AWAITING_OTHER_OPERATION;
                this.modelController.acquireLock(this.operationId, this.respectInterruption);
                this.exclusiveStartTime = System.nanoTime();
                this.lockStep = this.activeStep;
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                Thread.currentThread().interrupt();
                throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
            }
            finally {
                this.executionStatus = originalStatus;
            }
        }
    }

    private void ensureWriteLockForRuntime() {
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            if (this.containerMonitorStep == null) {
                if (this.currentStage == OperationContext.Stage.DONE) {
                    throw ControllerLogger.ROOT_LOGGER.invalidModificationAfterCompletedStep();
                }
                this.containerMonitorStep = this.activeStep;
                int timeout = this.getBlockingTimeout().getBlockingTimeout();
                OperationContext.ExecutionStatus origStatus = this.executionStatus;
                try {
                    this.executionStatus = OperationContext.ExecutionStatus.AWAITING_STABILITY;
                    this.modelController.awaitContainerStability(timeout, TimeUnit.MILLISECONDS, this.respectInterruption);
                }
                catch (InterruptedException e) {
                    if (this.resultAction != OperationContext.ResultAction.ROLLBACK) {
                        this.cancelled = true;
                    }
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
                }
                catch (TimeoutException te) {
                    this.getBlockingTimeout().timeoutDetected();
                    this.processState.setRestartRequired();
                    ControllerLogger.MGMT_OP_LOGGER.timeoutAwaitingInitialStability(timeout / 1000, this.activeStep.operationId.name, this.activeStep.operationId.address);
                    this.setRollbackOnly();
                    throw new OperationFailedRuntimeException(ControllerLogger.ROOT_LOGGER.timeoutAwaitingInitialStability());
                }
                finally {
                    this.executionStatus = origStatus;
                }
            }
        }
    }

    @Override
    public Resource readResource(PathAddress requestAddress) {
        return this.readResource(requestAddress, true);
    }

    @Override
    public Resource readResource(PathAddress requestAddress, boolean recursive) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        return this.readResourceFromRoot(address, recursive);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.readResourceFromRoot(address, true);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        ModelNode operation = this.activeStep.operation.clone();
        operation.get("operation").set(ReadResourceHandler.DEFINITION.getName());
        operation.get("address").set(address.toModelNode());
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult authResult = this.authorize(opId, operation, false, READ_CONFIG);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            AuthorizationResult addressResult = this.authorize(opId, operation, false, ADDRESS);
            if (addressResult.getDecision() == AuthorizationResult.Decision.DENY) {
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(this.activeStep.address);
            }
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
        }
        Resource model = this.model;
        Iterator iterator = address.iterator();
        while (iterator.hasNext()) {
            PathElement element = (PathElement)iterator.next();
            if (element.isWildcard() && !iterator.hasNext()) {
                Set<Resource.ResourceEntry> children = model.getChildren(element.getKey());
                if (children.isEmpty()) {
                    PathAddress parent = address.subAddress(0, address.size() - 1);
                    Set<String> childrenTypes = this.modelController.getRootRegistration().getChildNames(parent);
                    if (!childrenTypes.contains(element.getKey())) {
                        throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
                    }
                    return Resource.Factory.create();
                }
                model = Resource.Factory.create();
                for (Resource.ResourceEntry entry : children) {
                    model.registerChild(entry.getPathElement(), entry);
                }
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        if (recursive) {
            return model.clone();
        }
        Resource copy = Resource.Factory.create();
        copy.writeModel(model.getModel());
        for (String childType : model.getChildTypes()) {
            for (Resource.ResourceEntry child : model.getChildren(childType)) {
                copy.registerChild(child.getPathElement(), PlaceholderResource.INSTANCE);
            }
        }
        return copy;
    }

    @Override
    public Resource readResourceForUpdate(PathAddress requestAddress) {
        boolean runtimeOnly;
        assert (this.isControllingThread());
        this.readOnly = false;
        PathAddress address = this.activeStep.address.append(requestAddress);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        boolean bl = runtimeOnly = !this.isBooting() && this.isResourceRuntimeOnly(address);
        if (!runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(address);
        this.authorize(false, runtimeOnly ? READ_WRITE_RUNTIME : READ_WRITE_CONFIG);
        if (!runtimeOnly && !this.isModelAffected() || runtimeOnly && !this.affectsRuntime) {
            this.takeWriteLock();
            this.model = this.model.clone();
            if (runtimeOnly) {
                this.affectsRuntime = true;
            }
        }
        this.affectsModel.put(address, NULL);
        Resource resource = this.model;
        for (PathElement element : address) {
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotWriteTo("*");
            }
            resource = OperationContextImpl.requireChild(resource, element, address);
        }
        return resource;
    }

    private boolean isResourceRuntimeOnly(PathAddress fullAddress) {
        Resource resource = this.model;
        Iterator it = fullAddress.iterator();
        while (it.hasNext() && resource != null) {
            PathElement element = (PathElement)it.next();
            if (element.isMultiTarget()) {
                resource = null;
                continue;
            }
            resource = resource.getChild(element);
        }
        if (resource != null) {
            return resource.isRuntime();
        }
        ManagementResourceRegistration mrr = this.modelController.getRootRegistration().getSubModel(fullAddress);
        return mrr != null && mrr.isRuntimeOnly();
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.originalModel.clone();
    }

    @Override
    public Resource createResource(PathAddress relativeAddress) {
        Resource toAdd = Resource.Factory.create();
        this.addResource(relativeAddress, toAdd);
        return toAdd;
    }

    @Override
    public void addResource(PathAddress relativeAddress, Resource toAdd) {
        assert (this.isControllingThread());
        this.readOnly = false;
        PathAddress absoluteAddress = this.activeStep.address.append(relativeAddress);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        if (absoluteAddress.size() == 0) {
            throw ControllerLogger.ROOT_LOGGER.duplicateResourceAddress(absoluteAddress);
        }
        boolean runtimeOnly = toAdd.isRuntime();
        if (!runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(absoluteAddress);
        this.authorizeAdd(runtimeOnly);
        if (!runtimeOnly && !this.isModelAffected() || runtimeOnly && !this.affectsRuntime) {
            this.takeWriteLock();
            this.model = this.model.clone();
            if (runtimeOnly) {
                this.affectsRuntime = true;
            }
        }
        this.affectsModel.put(absoluteAddress, NULL);
        Resource model = this.model;
        Iterator i = absoluteAddress.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotWriteTo("*");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (model.hasChild(element)) {
                    throw ControllerLogger.ROOT_LOGGER.duplicateResourceAddress(absoluteAddress);
                }
                PathAddress parent = absoluteAddress.subAddress(0, absoluteAddress.size() - 1);
                Set<String> childrenNames = this.modelController.getRootRegistration().getChildNames(parent);
                if (!childrenNames.contains(key)) {
                    throw ControllerLogger.ROOT_LOGGER.noChildType(key);
                }
                model.registerChild(element, toAdd);
                model = toAdd;
                continue;
            }
            if ((model = model.getChild(element)) != null) continue;
            PathAddress ancestor = PathAddress.EMPTY_ADDRESS;
            for (PathElement pe : absoluteAddress) {
                ancestor = ancestor.append(pe);
                if (!element.equals(pe)) continue;
                break;
            }
            throw ControllerLogger.ROOT_LOGGER.resourceNotFound(ancestor, absoluteAddress);
        }
    }

    @Override
    public Resource removeResource(PathAddress requestAddress) {
        assert (this.isControllingThread());
        this.readOnly = false;
        PathAddress address = this.activeStep.address.append(requestAddress);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        boolean runtimeOnly = this.isResourceRuntimeOnly(address);
        if (runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(address);
        this.authorize(false, runtimeOnly ? READ_WRITE_RUNTIME : READ_WRITE_CONFIG);
        if (!runtimeOnly && !this.isModelAffected() || runtimeOnly && !this.affectsRuntime) {
            this.takeWriteLock();
            this.model = this.model.clone();
            if (runtimeOnly) {
                this.affectsRuntime = true;
            }
        }
        this.affectsModel.put(address, NULL);
        Resource model = this.model;
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotRemove("*");
            }
            if (!i.hasNext()) {
                model = model.removeChild(element);
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        return model;
    }

    @Override
    public void acquireControllerLock() {
        this.takeWriteLock();
    }

    @Override
    public boolean isModelAffected() {
        return this.affectsModel.size() > 0;
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.affectsRuntime;
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.affectsResourceRegistration;
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        try {
            if (this.messageHandler != null) {
                this.messageHandler.handleReport(severity, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseStepLocks(AbstractOperationContext.Step step) {
        boolean interrupted = false;
        try {
            if (this.containerMonitorStep == step) {
                long timeout = this.getBlockingTimeout().getBlockingTimeout();
                try {
                    this.modelController.awaitContainerStability(timeout, TimeUnit.MILLISECONDS, true);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    ControllerLogger.MGMT_OP_LOGGER.interruptedWaitingStability();
                }
                catch (TimeoutException te) {
                    this.processState.setRestartRequired();
                    ControllerLogger.MGMT_OP_LOGGER.timeoutCompletingOperation(timeout, this.activeStep.operationId.name, this.activeStep.operationId.address);
                }
            }
            if (this.lockStep == step) {
                this.modelController.releaseLock(this.operationId);
                this.exclusiveStartTime = -1L;
                this.lockStep = null;
            }
        }
        finally {
            try {
                if (this.containerMonitorStep == step) {
                    this.modelController.logContainerStateChangesAndReset();
                    this.containerMonitorStep = null;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    boolean isReadOnly() {
        return this.readOnly;
    }

    private static Resource requireChild(Resource resource, PathElement childPath, PathAddress fullAddress) {
        if (resource.hasChild(childPath)) {
            return resource.requireChild(childPath);
        }
        PathAddress missing = PathAddress.EMPTY_ADDRESS;
        for (PathElement search : fullAddress) {
            missing = missing.append(search);
            if (!search.equals(childPath)) continue;
            break;
        }
        throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(missing);
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.modelController.resolveExpressions(node);
    }

    public <V> V getAttachment(OperationContext.AttachmentKey<V> key) {
        if (key == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("key");
        }
        return key.cast(this.valueAttachments.get(key));
    }

    @Override
    void logAuditRecord() {
        super.logAuditRecord();
    }

    public <V> V attach(OperationContext.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("key");
        }
        return key.cast(this.valueAttachments.put(key, value));
    }

    public <V> V attachIfAbsent(OperationContext.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("key");
        }
        return key.cast(this.valueAttachments.putIfAbsent(key, value));
    }

    public <V> V detach(OperationContext.AttachmentKey<V> key) {
        if (key == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("key");
        }
        return key.cast(this.valueAttachments.remove(key));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation) {
        return this.authorize(operation, EnumSet.noneOf(Action.ActionEffect.class));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, Set<Action.ActionEffect> effects) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        return this.authorize(opId, operation, false, effects);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue) {
        return this.authorize(operation, attribute, currentValue, EnumSet.noneOf(Action.ActionEffect.class));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue, Set<Action.ActionEffect> effects) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult resourceResult = this.authorize(opId, operation, false, effects);
        if (resourceResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return resourceResult;
        }
        return this.authorize(opId, attribute, currentValue, effects);
    }

    @Override
    public AuthorizationResponseImpl authorizeResource(boolean attributes, boolean isDefaultResponse) {
        AbstractOperationContext.OperationId opId;
        AuthorizationResponseImpl authResp;
        ModelNode op = new ModelNode();
        op.get("operation").set(isDefaultResponse ? "check-default-resource-access" : "check-resource-access");
        op.get("address").set(this.activeStep.operation.get("address"));
        if (this.activeStep.operation.hasDefined("operation-headers")) {
            op.get("operation-headers").set(this.activeStep.operation.get("operation-headers"));
        }
        if ((authResp = this.authorizations.get(opId = new AbstractOperationContext.OperationId(op))) == null) {
            authResp = this.getBasicAuthorizationResponse(opId, op);
        }
        if (authResp == null) {
            return null;
        }
        Environment callEnvironment = this.getCallEnvironment();
        if (authResp.getResourceResult(Action.ActionEffect.ADDRESS) == null) {
            Action action = authResp.standardAction.limitAction(Action.ActionEffect.ADDRESS);
            authResp.addResourceResult(Action.ActionEffect.ADDRESS, this.modelController.getAuthorizer().authorize(this.getCaller(), callEnvironment, action, authResp.targetResource));
        }
        if (authResp.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() == AuthorizationResult.Decision.PERMIT) {
            for (Action.ActionEffect requiredEffect : ALL_READ_WRITE) {
                AuthorizationResult effectResult = authResp.getResourceResult(requiredEffect);
                if (effectResult != null) continue;
                Action action = authResp.standardAction.limitAction(requiredEffect);
                effectResult = this.modelController.getAuthorizer().authorize(this.getCaller(), callEnvironment, action, authResp.targetResource);
                authResp.addResourceResult(requiredEffect, effectResult);
            }
        }
        if (attributes) {
            ImmutableManagementResourceRegistration mrr = authResp.targetResource.getResourceRegistration();
            if (!authResp.attributesComplete) {
                for (String attr : mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
                    TargetAttribute targetAttribute = null;
                    if (authResp.getAttributeResult(attr, Action.ActionEffect.ADDRESS) == null) {
                        authResp.addAttributeResult(attr, Action.ActionEffect.ADDRESS, AuthorizationResult.PERMITTED);
                    }
                    for (Action.ActionEffect actionEffect : ALL_READ_WRITE) {
                        AuthorizationResult authResult = authResp.getAttributeResult(attr, actionEffect);
                        if (authResult != null) continue;
                        Action action = authResp.standardAction.limitAction(actionEffect);
                        if (targetAttribute == null) {
                            targetAttribute = this.createTargetAttribute(authResp, attr, isDefaultResponse);
                        }
                        authResult = this.modelController.getAuthorizer().authorize(this.getCaller(), callEnvironment, action, targetAttribute);
                        authResp.addAttributeResult(attr, actionEffect, authResult);
                    }
                }
                authResp.attributesComplete = true;
            }
        }
        return authResp;
    }

    @Override
    Resource getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OperationContext.ResultAction executeOperation() {
        try {
            OperationContext.ResultAction resultAction = super.executeOperation();
            return resultAction;
        }
        finally {
            BooleanHolder booleanHolder = this.done;
            synchronized (booleanHolder) {
                if (this.done.done) {
                    Thread.interrupted();
                } else {
                    this.done.done = true;
                }
            }
        }
    }

    private TargetAttribute createTargetAttribute(AuthorizationResponseImpl authResp, String attributeName, boolean isDefaultResponse) {
        ModelNode model = authResp.targetResource.getResource().getModel();
        ModelNode currentValue = isDefaultResponse ? new ModelNode() : (model.has(attributeName) ? model.get(attributeName) : new ModelNode());
        AttributeAccess attributeAccess = authResp.targetResource.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        return new TargetAttribute(attributeName, attributeAccess, currentValue, authResp.targetResource);
    }

    @Override
    public AuthorizationResult authorizeOperation(ModelNode operation) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult resourceResult = this.authorize(opId, operation, false, EnumSet.of(Action.ActionEffect.ADDRESS));
        if (resourceResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return resourceResult;
        }
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        String operationName = operation.require("operation").asString();
        AuthorizationResponseImpl authResp = this.authorizations.get(opId);
        assert (authResp != null) : "perform resource authorization before operation authorization";
        AuthorizationResult authResult = authResp.getOperationResult(operationName);
        if (authResult == null) {
            OperationEntry operationEntry = authResp.targetResource.getResourceRegistration().getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            operation.get("operation-headers").set(this.activeStep.operation.get("operation-headers"));
            Action targetAction = new Action(operation, operationEntry);
            authResult = this.modelController.getAuthorizer().authorize(this.getCaller(), this.getCallEnvironment(), targetAction, authResp.targetResource);
            authResp.addOperationResult(operationName, authResult);
            if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT && operationName.equals("add")) {
                if (!authResp.attributesComplete) {
                    authResp = this.authorizeResource(true, false);
                    authResp.addOperationResult(operationName, authResult);
                }
                authResult = authResp.validateAddAttributeEffects("add", targetAction.getActionEffects());
            }
        }
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return authResult;
        }
        return AuthorizationResult.PERMITTED;
    }

    private void rejectUserDomainServerUpdates() {
        ModelNode op;
        if (this.isModelUpdateRejectionRequired() && (op = this.activeStep.operation).hasDefined("operation-headers") && op.get("operation-headers").hasDefined("caller-type") && "user".equals(op.get(new String[]{"operation-headers", "caller-type"}).asString())) {
            throw ControllerLogger.ROOT_LOGGER.modelUpdateNotAuthorized(op.require("operation").asString(), PathAddress.pathAddress(op.get("address")));
        }
    }

    private boolean isModelUpdateRejectionRequired() {
        if (this.requiresModelUpdateAuthorization == null) {
            this.requiresModelUpdateAuthorization = !this.isBooting() && this.getProcessType() == ProcessType.DOMAIN_SERVER;
        }
        return this.requiresModelUpdateAuthorization;
    }

    private void authorize(boolean allAttributes, Set<Action.ActionEffect> actionEffects) {
        AuthorizationResult accessResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, false, ADDRESS);
        if (accessResult.getDecision() == AuthorizationResult.Decision.DENY) {
            if (this.activeStep.address.size() > 0) {
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(this.activeStep.address);
            }
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, accessResult.getExplanation());
        }
        AuthorizationResult authResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, allAttributes, actionEffects);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
        }
    }

    private void authorizeAdd(boolean runtimeOnly) {
        AuthorizationResult accessResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, false, ADDRESS);
        if (accessResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(this.activeStep.address);
        }
        Set<Action.ActionEffect> writeEffect = runtimeOnly ? WRITE_RUNTIME : WRITE_CONFIG;
        AuthorizationResult authResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, true, writeEffect);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            AuthorizationResponseImpl authResp = this.authorizations.get(this.activeStep.operationId);
            assert (authResp != null) : "no AuthorizationResponse";
            String opName = this.activeStep.operation.get("operation").asString();
            authResp.addOperationResult(opName, authResult);
            authResult = authResp.validateAddAttributeEffects(opName, writeEffect);
            authResp.addOperationResult(opName, authResult);
            if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
                throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
            }
        }
    }

    private AuthorizationResult authorize(AbstractOperationContext.OperationId opId, ModelNode operation, boolean allAttributes, Set<Action.ActionEffect> actionEffects) {
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        AuthorizationResponseImpl authResp = this.authorizations.get(opId);
        if (authResp == null) {
            authResp = this.getBasicAuthorizationResponse(opId, operation);
        }
        if (authResp == null) {
            return AuthorizationResult.PERMITTED;
        }
        for (Action.ActionEffect requiredEffect : actionEffects) {
            AuthorizationResult effectResult = authResp.getResourceResult(requiredEffect);
            if (effectResult == null) {
                Action action = authResp.standardAction.limitAction(requiredEffect);
                effectResult = this.modelController.getAuthorizer().authorize(this.getCaller(), this.getCallEnvironment(), action, authResp.targetResource);
                authResp.addResourceResult(requiredEffect, effectResult);
            }
            if (effectResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
            return effectResult;
        }
        if (allAttributes) {
            ImmutableManagementResourceRegistration mrr = authResp.targetResource.getResourceRegistration();
            ModelNode model = authResp.targetResource.getResource().getModel();
            Set<Action.ActionEffect> attributeEffects = actionEffects.isEmpty() ? authResp.standardAction.getActionEffects() : actionEffects;
            Iterator<String> i$ = mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS).iterator();
            while (i$.hasNext()) {
                String attr;
                ModelNode currentValue = model.has(attr = i$.next()) ? model.get(attr) : new ModelNode();
                AuthorizationResult attrResult = this.authorize(opId, attr, currentValue, attributeEffects);
                if (attrResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
                return attrResult;
            }
            authResp.attributesComplete = true;
        }
        return AuthorizationResult.PERMITTED;
    }

    private AuthorizationResult authorize(AbstractOperationContext.OperationId operationId, String attribute, ModelNode currentValue, Set<Action.ActionEffect> actionEffects) {
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        AuthorizationResponseImpl authResp = this.authorizations.get(operationId);
        assert (authResp != null) : "perform resource authorization before attribute authorization";
        TargetAttribute targetAttribute = null;
        Set<Action.ActionEffect> attributeEffects = actionEffects.isEmpty() ? authResp.standardAction.getActionEffects() : actionEffects;
        for (Action.ActionEffect actionEffect : attributeEffects) {
            AuthorizationResult authResult = authResp.getAttributeResult(attribute, actionEffect);
            if (authResult == null) {
                Action action = authResp.standardAction.limitAction(actionEffect);
                if (targetAttribute == null) {
                    AttributeAccess attributeAccess = authResp.targetResource.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attribute);
                    targetAttribute = new TargetAttribute(attribute, attributeAccess, currentValue, authResp.targetResource);
                }
                authResult = this.modelController.getAuthorizer().authorize(this.getCaller(), this.getCallEnvironment(), action, targetAttribute);
                authResp.addAttributeResult(attribute, actionEffect, authResult);
            }
            if (authResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
            return authResult;
        }
        return AuthorizationResult.PERMITTED;
    }

    private AuthorizationResponseImpl getBasicAuthorizationResponse(AbstractOperationContext.OperationId opId, ModelNode operation) {
        TargetResource targetResource;
        Caller caller = this.getCaller();
        ManagementResourceRegistration mrr = this.modelController.getRootRegistration().getSubModel(opId.address);
        if (mrr == null) {
            return null;
        }
        Action action = this.getAuthorizationAction(mrr, opId.name, operation);
        if (action == null) {
            return null;
        }
        Resource resource = this.getAuthorizationResource(opId.address);
        ProcessType processType = this.getProcessType();
        if (processType.isManagedDomain()) {
            HostServerGroupTracker.HostServerGroupEffect hostServerGroupEffect;
            if (processType.isServer()) {
                ModelNode rootModel = this.model.getModel();
                String serverGroup = rootModel.get("server-group").asString();
                String host = rootModel.get("host").asString();
                hostServerGroupEffect = HostServerGroupTracker.HostServerGroupEffect.forServer(opId.address, serverGroup, host);
            } else {
                hostServerGroupEffect = this.hostServerGroupTracker.getHostServerGroupEffects(opId.address, operation, this.model);
            }
            targetResource = TargetResource.forDomain(opId.address, mrr, resource, hostServerGroupEffect, hostServerGroupEffect);
        } else {
            targetResource = TargetResource.forStandalone(opId.address, mrr, resource);
        }
        AuthorizationResponseImpl result = new AuthorizationResponseImpl(action, targetResource);
        AuthorizationResult simple = this.modelController.getAuthorizer().authorize(caller, this.getCallEnvironment(), action, targetResource);
        if (simple.getDecision() == AuthorizationResult.Decision.PERMIT) {
            for (Action.ActionEffect actionEffect : action.getActionEffects()) {
                result.addResourceResult(actionEffect, simple);
            }
        }
        this.authorizations.put(opId, result);
        return result;
    }

    private Resource getAuthorizationResource(PathAddress address) {
        Resource model = this.model;
        for (PathElement element : address) {
            if (element.isWildcard()) {
                model = Resource.Factory.create();
                Set<Resource.ResourceEntry> children = model.getChildren(element.getKey());
                for (Resource.ResourceEntry entry : children) {
                    model.registerChild(entry.getPathElement(), entry);
                }
                continue;
            }
            if (model.hasChild(element)) {
                model = model.getChild(element);
                continue;
            }
            return Resource.Factory.create();
        }
        return model;
    }

    private Action getAuthorizationAction(ImmutableManagementResourceRegistration mrr, String operationName, ModelNode operation) {
        OperationEntry entry = mrr.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
        if (entry == null) {
            return null;
        }
        return new Action(operation, entry);
    }

    private void checkHostServerGroupTracker(PathAddress pathAddress) {
        String key0;
        if (this.hostServerGroupTracker != null && !this.isBooting() && pathAddress.size() > 0 && ("server-group".equals(key0 = pathAddress.getElement(0).getKey()) || pathAddress.size() > 1 && "host".equals(key0) && "server-config".equals(pathAddress.getElement(1).getKey()))) {
            this.hostServerGroupTracker = new HostServerGroupTracker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingTimeout getBlockingTimeout() {
        if (this.blockingTimeout == null) {
            OperationContextImpl operationContextImpl = this;
            synchronized (operationContextImpl) {
                if (this.blockingTimeout == null) {
                    this.blockingTimeout = new BlockingTimeout(this.blockingTimeoutConfig);
                }
            }
        }
        return this.blockingTimeout;
    }

    private static class BooleanHolder {
        private boolean done = false;

        private BooleanHolder() {
        }
    }

    private class ActiveOperationResource
    extends PlaceholderResource.PlaceholderResourceEntry
    implements Cancellable {
        private ActiveOperationResource() {
            super("active-operation", OperationContextImpl.this.operationId.toString());
        }

        @Override
        public boolean isModelDefined() {
            return true;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            model.get("operation").set(OperationContextImpl.this.operationName);
            model.get("address").set(OperationContextImpl.this.operationAddress);
            model.get("caller-thread").set(OperationContextImpl.this.initiatingThread.getName());
            ModelNode accessMechanismNode = model.get("access-mechanism");
            if (OperationContextImpl.this.accessMechanism != null) {
                accessMechanismNode.set(accessMechanismNode.toString());
            }
            model.get("execution-status").set(this.getExecutionStatus());
            model.get("running-time").set(System.nanoTime() - OperationContextImpl.this.startTime);
            long exclusive = OperationContextImpl.this.exclusiveStartTime;
            if (exclusive > -1L) {
                exclusive = System.nanoTime() - exclusive;
            }
            model.get("exclusive-running-time").set(exclusive);
            model.get("cancelled").set(OperationContextImpl.this.cancelled);
            return model;
        }

        private String getExecutionStatus() {
            OperationContext.ExecutionStatus currentStatus = OperationContextImpl.this.executionStatus;
            if (currentStatus == OperationContext.ExecutionStatus.EXECUTING) {
                currentStatus = OperationContextImpl.this.resultAction == OperationContext.ResultAction.ROLLBACK ? OperationContext.ExecutionStatus.ROLLING_BACK : (OperationContextImpl.this.currentStage == OperationContext.Stage.DONE ? OperationContext.ExecutionStatus.COMPLETING : OperationContext.ExecutionStatus.EXECUTING);
            }
            return currentStatus.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            BooleanHolder booleanHolder = OperationContextImpl.this.done;
            synchronized (booleanHolder) {
                boolean canCancel;
                boolean bl = canCancel = !OperationContextImpl.this.done.done;
                if (canCancel) {
                    OperationContextImpl.this.done.done = true;
                    ControllerLogger.MGMT_OP_LOGGER.cancellingOperation(OperationContextImpl.this.operationName, OperationContextImpl.this.operationId, OperationContextImpl.this.initiatingThread.getName());
                    OperationContextImpl.this.initiatingThread.interrupt();
                }
                return canCancel;
            }
        }
    }

    private class DescriptionCachingResourceRegistration
    extends DelegatingManagementResourceRegistration {
        private final PathAddress address;

        public DescriptionCachingResourceRegistration(ManagementResourceRegistration delegate, PathAddress address) {
            super(delegate);
            this.address = address;
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress relativeAddress) {
            PathAddress fullAddress = this.address.append(relativeAddress);
            DescriptionProvider realProvider = super.getModelDescription(relativeAddress);
            return new CachingDescriptionProvider(fullAddress, realProvider);
        }
    }

    private class DescriptionCachingImmutableResourceRegistration
    extends DelegatingImmutableManagementResourceRegistration {
        private final PathAddress address;

        public DescriptionCachingImmutableResourceRegistration(ImmutableManagementResourceRegistration delegate, PathAddress address) {
            super(delegate);
            this.address = address;
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress relativeAddress) {
            PathAddress fullAddress = this.address.append(relativeAddress);
            DescriptionProvider realProvider = super.getModelDescription(relativeAddress);
            return new CachingDescriptionProvider(fullAddress, realProvider);
        }
    }

    private class CachingDescriptionProvider
    implements DescriptionProvider {
        private final PathAddress cacheAddress;
        private final DescriptionProvider delegate;

        private CachingDescriptionProvider(PathAddress cacheAddress, DescriptionProvider delegate) {
            this.cacheAddress = cacheAddress;
            this.delegate = delegate;
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            ModelNode result = this.delegate.getModelDescription(locale);
            OperationContextImpl.this.resourceDescriptions.put(this.cacheAddress, result);
            return result;
        }
    }

    private class AuthorizationResponseImpl
    implements ResourceAuthorization {
        private Map<Action.ActionEffect, AuthorizationResult> resourceResults = new HashMap<Action.ActionEffect, AuthorizationResult>();
        private Map<String, Map<Action.ActionEffect, AuthorizationResult>> attributeResults = new HashMap<String, Map<Action.ActionEffect, AuthorizationResult>>();
        private Map<String, AuthorizationResult> operationResults = new HashMap<String, AuthorizationResult>();
        private final TargetResource targetResource;
        private final Action standardAction;
        private volatile boolean attributesComplete = false;

        AuthorizationResponseImpl(Action standardAction, TargetResource targetResource) {
            this.standardAction = standardAction;
            this.targetResource = targetResource;
        }

        @Override
        public AuthorizationResult getResourceResult(Action.ActionEffect actionEffect) {
            return this.resourceResults.get((Object)actionEffect);
        }

        @Override
        public AuthorizationResult getAttributeResult(String attribute, Action.ActionEffect actionEffect) {
            Map<Action.ActionEffect, AuthorizationResult> attrResults = this.attributeResults.get(attribute);
            return attrResults == null ? null : attrResults.get((Object)actionEffect);
        }

        @Override
        public AuthorizationResult getOperationResult(String operationName) {
            return this.operationResults.get(operationName);
        }

        private void addResourceResult(Action.ActionEffect actionEffect, AuthorizationResult result) {
            this.resourceResults.put(actionEffect, result);
        }

        private void addAttributeResult(String attribute, Action.ActionEffect actionEffect, AuthorizationResult result) {
            Map<Action.ActionEffect, AuthorizationResult> attrResults = this.attributeResults.get(attribute);
            if (attrResults == null) {
                attrResults = new HashMap<Action.ActionEffect, AuthorizationResult>();
                this.attributeResults.put(attribute, attrResults);
            }
            attrResults.put(actionEffect, result);
        }

        private void addOperationResult(String operationName, AuthorizationResult result) {
            this.operationResults.put(operationName, result);
        }

        private AuthorizationResult validateAddAttributeEffects(String operationName, Set<Action.ActionEffect> actionEffects) {
            AuthorizationResult basic = this.operationResults.get(operationName);
            assert (basic != null) : " no basic authorization has been performed for operation 'add'";
            if (basic.getDecision() == AuthorizationResult.Decision.DENY) {
                ImmutableManagementResourceRegistration resourceRegistration = this.targetResource.getResourceRegistration();
                ModelNode model = this.targetResource.getResource().getModel();
                boolean attributeWasDenied = false;
                for (Map.Entry<String, Map<Action.ActionEffect, AuthorizationResult>> attributeResultEntry : this.attributeResults.entrySet()) {
                    String attrName = attributeResultEntry.getKey();
                    boolean attrDenied = this.isAttributeDenied(attributeResultEntry.getValue(), actionEffects);
                    if (!attrDenied) continue;
                    attributeWasDenied = true;
                    if (!model.hasDefined(attrName) && !this.isAddableAttribute(attrName, resourceRegistration)) continue;
                    Map<Action.ActionEffect, AuthorizationResult> attrResults = attributeResultEntry.getValue();
                    for (Action.ActionEffect actionEffect : actionEffects) {
                        AuthorizationResult authResult = attrResults.get((Object)actionEffect);
                        if (authResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
                        this.addOperationResult(operationName, authResult);
                        return authResult;
                    }
                }
                if (attributeWasDenied) {
                    this.addOperationResult(operationName, AuthorizationResult.PERMITTED);
                    return AuthorizationResult.PERMITTED;
                }
            }
            return basic;
        }

        private boolean isAttributeDenied(Map<Action.ActionEffect, AuthorizationResult> attributeResults, Set<Action.ActionEffect> actionEffects) {
            for (Action.ActionEffect actionEffect : actionEffects) {
                AuthorizationResult ar = attributeResults.get((Object)actionEffect);
                if (ar == null || ar.getDecision() != AuthorizationResult.Decision.DENY) continue;
                return true;
            }
            return false;
        }

        private boolean isAddableAttribute(String attrName, ImmutableManagementResourceRegistration resourceRegistration) {
            AttributeAccess attributeAccess = resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attrName);
            if (attributeAccess == null) {
                return this.isRequiredConfigFromDescription(attrName, resourceRegistration);
            }
            if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION && attributeAccess.getAccessType() == AttributeAccess.AccessType.READ_WRITE) {
                AttributeDefinition ad = attributeAccess.getAttributeDefinition();
                if (ad == null) {
                    return this.isRequiredConfigFromDescription(attrName, resourceRegistration);
                }
                if (!ad.isAllowNull() || ad.getDefaultValue() != null && ad.getDefaultValue().isDefined() || ad.isNullSignificant()) {
                    return true;
                }
            }
            return false;
        }

        private boolean isRequiredConfigFromDescription(String attrName, ImmutableManagementResourceRegistration resourceRegistration) {
            ModelNode attributes;
            PathAddress address = this.targetResource.getResourceAddress();
            ModelNode resourceDescription = (ModelNode)OperationContextImpl.this.resourceDescriptions.get(address);
            if (resourceDescription == null) {
                resourceDescription = resourceRegistration.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(Locale.ENGLISH);
                OperationContextImpl.this.resourceDescriptions.put(address, resourceDescription);
            }
            if (resourceDescription.hasDefined("attributes") && (attributes = resourceDescription.get("attributes")).hasDefined(attrName)) {
                ModelNode attrDesc = attributes.get(attrName);
                if (attrDesc.hasDefined("required")) {
                    return attrDesc.get("required").asBoolean();
                }
                if (attrDesc.hasDefined("nillable")) {
                    return !attrDesc.get("nillable").asBoolean() || attrDesc.hasDefined("default") || attrDesc.hasDefined("nil-significant") && attrDesc.get("nil-significant").asBoolean();
                }
                return true;
            }
            return false;
        }
    }

    private class OperationContextServiceController<S>
    implements ServiceController<S> {
        private final ServiceController<S> controller;

        public OperationContextServiceController(ServiceController<S> controller) {
            this.controller = controller;
        }

        public ServiceController<?> getParent() {
            return this.controller.getParent();
        }

        public ServiceContainer getServiceContainer() {
            return this.controller.getServiceContainer();
        }

        public ServiceController.Mode getMode() {
            return this.controller.getMode();
        }

        public boolean compareAndSetMode(ServiceController.Mode expected, ServiceController.Mode newMode) {
            this.checkModeTransition(newMode);
            return this.controller.compareAndSetMode(expected, newMode);
        }

        public void setMode(ServiceController.Mode mode) {
            this.checkModeTransition(mode);
            this.controller.setMode(mode);
        }

        private void checkModeTransition(ServiceController.Mode mode) {
            if (mode == ServiceController.Mode.REMOVE) {
                throw ControllerLogger.ROOT_LOGGER.useOperationContextRemoveService();
            }
        }

        public ServiceController.State getState() {
            return this.controller.getState();
        }

        public ServiceController.Substate getSubstate() {
            return this.controller.getSubstate();
        }

        public S getValue() throws IllegalStateException {
            return (S)this.controller.getValue();
        }

        public Service<S> getService() throws IllegalStateException {
            return this.controller.getService();
        }

        public ServiceName getName() {
            return this.controller.getName();
        }

        public ServiceName[] getAliases() {
            return this.controller.getAliases();
        }

        public void addListener(ServiceListener<? super S> serviceListener) {
            this.controller.addListener(serviceListener);
        }

        public void removeListener(ServiceListener<? super S> serviceListener) {
            this.controller.removeListener(serviceListener);
        }

        public StartException getStartException() {
            return this.controller.getStartException();
        }

        public void retry() {
            this.controller.retry();
        }

        public Set<ServiceName> getImmediateUnavailableDependencies() {
            return this.controller.getImmediateUnavailableDependencies();
        }

        public S awaitValue() throws IllegalStateException, InterruptedException {
            return (S)this.controller.awaitValue();
        }

        public S awaitValue(long time, TimeUnit unit) throws IllegalStateException, InterruptedException, TimeoutException {
            return (S)this.controller.awaitValue(time, unit);
        }
    }

    private class OperationContextServiceRegistry
    implements ServiceRegistry {
        private final ServiceRegistry registry;

        public OperationContextServiceRegistry(ServiceRegistry registry) {
            this.registry = registry;
        }

        public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
            return new OperationContextServiceController(this.registry.getRequiredService(serviceName));
        }

        public ServiceController<?> getService(ServiceName serviceName) {
            ServiceController controller = this.registry.getService(serviceName);
            if (controller == null) {
                return null;
            }
            return new OperationContextServiceController(controller);
        }

        public List<ServiceName> getServiceNames() {
            return this.registry.getServiceNames();
        }
    }

    private class ServiceRemovalVerificationHandler
    implements OperationStepHandler {
        private final ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport;

        private ServiceRemovalVerificationHandler(ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport) {
            this.containerStateChangeReport = containerStateChangeReport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>> missingByStep = new HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>>();
            Map map = OperationContextImpl.this.realRemovingControllers;
            synchronized (map) {
                for (Map.Entry<ServiceName, ContainerStateMonitor.MissingDependencyInfo> entry : this.containerStateChangeReport.getMissingServices().entrySet()) {
                    ContainerStateMonitor.MissingDependencyInfo missingDependencyInfo = entry.getValue();
                    AbstractOperationContext.Step removalStep = (AbstractOperationContext.Step)OperationContextImpl.this.removalSteps.get(entry.getKey());
                    if (removalStep == null) continue;
                    HashMap<ServiceName, Set<ServiceName>> stepBadRemovals = (HashMap<ServiceName, Set<ServiceName>>)missingByStep.get(removalStep);
                    if (stepBadRemovals == null) {
                        stepBadRemovals = new HashMap<ServiceName, Set<ServiceName>>();
                        missingByStep.put(removalStep, stepBadRemovals);
                    }
                    stepBadRemovals.put(entry.getKey(), missingDependencyInfo.getDependents());
                }
            }
            for (Map.Entry entry : missingByStep.entrySet()) {
                AbstractOperationContext.Step step = (AbstractOperationContext.Step)entry.getKey();
                if (step.response.hasDefined("failure-description")) continue;
                StringBuilder sb = new StringBuilder(ControllerLogger.ROOT_LOGGER.removingServiceUnsatisfiedDependencies());
                for (Map.Entry removed : ((Map)entry.getValue()).entrySet()) {
                    sb.append(ControllerLogger.ROOT_LOGGER.removingServiceUnsatisfiedDependencies(((ServiceName)removed.getKey()).getCanonicalName()));
                    boolean first = true;
                    for (ServiceName dependent : (Set)removed.getValue()) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(dependent);
                    }
                }
                step.response.get("failure-description").set(sb.toString());
            }
            if (!missingByStep.isEmpty() && context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    class ContextServiceBuilder<T>
    implements ServiceBuilder<T> {
        private final ServiceBuilder<T> realBuilder;
        private final ServiceName name;

        ContextServiceBuilder(ServiceBuilder<T> realBuilder, ServiceName name) {
            this.realBuilder = realBuilder;
            this.name = name;
        }

        public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
            this.realBuilder.addAliases(aliases);
            return this;
        }

        public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            this.realBuilder.setInitialMode(mode);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency) {
            this.realBuilder.addDependency(dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
            this.realBuilder.addDependency(dependencyType, dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependency, target);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependencyType, dependency, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependencyType, dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
            this.realBuilder.addInjection(target, value);
            return this;
        }

        public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
            this.realBuilder.addInjectionValue(target, value);
            return this;
        }

        public ServiceBuilder<T> addInjection(Injector<? super T> target) {
            this.realBuilder.addInjection(target);
            return this;
        }

        public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
            this.realBuilder.addMonitor(monitor);
            return this;
        }

        public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
            this.realBuilder.addMonitors(monitors);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
            this.realBuilder.addListener(listener);
            return this;
        }

        @SafeVarargs
        public final ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceController<T> install() throws ServiceRegistryException, IllegalStateException {
            Map map = OperationContextImpl.this.realRemovingControllers;
            synchronized (map) {
                ServiceController serviceController;
                block12: {
                    boolean intr = false;
                    try {
                        long timeout;
                        boolean containsKey = OperationContextImpl.this.realRemovingControllers.containsKey(this.name);
                        long waitTime = timeout = (long)OperationContextImpl.this.getBlockingTimeout().getBlockingTimeout();
                        long end = System.currentTimeMillis() + waitTime;
                        while (containsKey && waitTime > 0L) {
                            block11: {
                                try {
                                    OperationContextImpl.this.realRemovingControllers.wait(waitTime);
                                }
                                catch (InterruptedException e) {
                                    intr = true;
                                    if (!OperationContextImpl.this.respectInterruption) break block11;
                                    OperationContextImpl.this.cancelled = true;
                                    throw ControllerLogger.ROOT_LOGGER.serviceInstallCancelled();
                                }
                            }
                            containsKey = OperationContextImpl.this.realRemovingControllers.containsKey(this.name);
                            waitTime = end - System.currentTimeMillis();
                        }
                        if (containsKey) {
                            throw ControllerLogger.ROOT_LOGGER.serviceInstallTimedOut(timeout, this.name);
                        }
                        OperationContextImpl.this.removalSteps.remove(this.name);
                        serviceController = this.realBuilder.install();
                        if (!intr) break block12;
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable throwable) {
                        if (intr) {
                            Thread.currentThread().interrupt();
                        }
                        throw throwable;
                    }
                }
                return serviceController;
            }
        }
    }

    class ContextServiceTarget
    implements ServiceTarget {
        private final ModelControllerImpl modelController;

        ContextServiceTarget(ModelControllerImpl modelController) {
            this.modelController = modelController;
        }

        public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) {
            ServiceBuilder realBuilder = this.modelController.getServiceTarget().addServiceValue(name, value);
            return new ContextServiceBuilder(realBuilder, name);
        }

        public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
            return this.addServiceValue(name, (Value<? extends Service<T>>)new ImmediateValue(service));
        }

        public ServiceTarget addMonitor(StabilityMonitor monitor) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addMonitors(StabilityMonitor ... monitors) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeMonitor(StabilityMonitor monitor) {
            throw new UnsupportedOperationException();
        }

        public Set<StabilityMonitor> getMonitors() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        @SafeVarargs
        public final ServiceTarget addListener(ServiceListener<Object> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceListener<Object>> getListeners() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName ... dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceName> getDependencies() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget subTarget() {
            throw new UnsupportedOperationException();
        }

        public BatchServiceTarget batchTarget() {
            throw new UnsupportedOperationException();
        }
    }
}

