/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.notification;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.notification.NotificationRegistry;
import org.jboss.as.controller.notification.NotificationRegistryImpl;
import org.jboss.as.controller.notification.NotificationSupport;

class NotificationSupports {
    NotificationSupports() {
    }

    private static void fireNotifications(NotificationRegistryImpl registry, Notification ... notifications) {
        for (Notification notification : notifications) {
            try {
                for (NotificationHandler handler : registry.findMatchingNotificationHandlers(notification)) {
                    handler.handleNotification(notification);
                }
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToEmitNotification(notification, t);
            }
        }
    }

    static class NonBlockingNotificationSupport
    implements NotificationSupport {
        private final NotificationRegistryImpl registry;
        private final ExecutorService executor;
        private final Queue<Notification> queue = new ConcurrentLinkedQueue<Notification>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        public NonBlockingNotificationSupport(NotificationRegistryImpl registry, ExecutorService executor) {
            this.registry = registry;
            this.executor = executor;
        }

        @Override
        public synchronized void emit(Notification ... notifications) {
            this.queue.addAll(Arrays.asList(notifications));
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    NonBlockingNotificationSupport.this.lock.writeLock().lock();
                    try {
                        Notification notification;
                        while ((notification = (Notification)NonBlockingNotificationSupport.this.queue.poll()) != null) {
                            NotificationSupports.fireNotifications(NonBlockingNotificationSupport.this.registry, new Notification[]{notification});
                        }
                    }
                    finally {
                        NonBlockingNotificationSupport.this.lock.writeLock().unlock();
                    }
                }
            });
        }

        @Override
        public NotificationRegistry getNotificationRegistry() {
            return this.registry;
        }
    }

    static class BlockingNotificationSupport
    implements NotificationSupport {
        private final NotificationRegistryImpl registry;

        public BlockingNotificationSupport(NotificationRegistryImpl registry) {
            this.registry = registry;
        }

        @Override
        public void emit(Notification ... notifications) {
            NotificationSupports.fireNotifications(this.registry, notifications);
        }

        @Override
        public NotificationRegistry getNotificationRegistry() {
            return this.registry;
        }
    }
}

