/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.controller.capability;

import java.util.Set;

/**
 * A capability exposed in a running WildFly process.
 *
 * @param <T> the type of the runtime API object exposed by the capability
 *
 * @author Brian Stansberry (c) 2014 Red Hat Inc.
 */
public class RuntimeCapability<T> extends AbstractCapability  {

    private final T runtimeAPI;

    /**
     * Creates a new capability
     * @param name the name of the capability. Cannot be {@code null}
     * @param runtimeAPI implementation of the API exposed by this capability to other capabilities. May be {@code null}
     * @param requirements names of other capabilities upon which this capability has a hard requirement. May be {@code null}
     * @param optionalRequirements names of other capabilities upon which this capability has an optional requirement. May be {@code null}
     */
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements, Set<String> optionalRequirements) {
        super(name, requirements, optionalRequirements);
        this.runtimeAPI = runtimeAPI;
    }

    /**
     * Creates a new capability
     * @param name the name of the capability. Cannot be {@code null}
     * @param runtimeAPI implementation of the API exposed by this capability to other capabilities. May be {@code null}
     * @param requirements names of other capabilities upon which this capability has a hard requirement. May be {@code null}
     */
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements) {
        this(name, runtimeAPI, requirements, null);
    }

    /**
     * Creates a new capability
     * @param name the name of the capability. Cannot be {@code null}
     * @param runtimeAPI implementation of the API exposed by this capability to other capabilities. May be {@code null}
     * @param requirements names of other capabilities upon which this capability has a hard requirement. May be {@code null}
     */
    public RuntimeCapability(String name, T runtimeAPI, String... requirements) {
        super(name, requirements);
        this.runtimeAPI = runtimeAPI;
    }

    /**
     * Object encapsulating the API exposed by this capability to other capabilities that require it, if it does
     * expose such an API.
     *
     * @return the API object, or {@code null} if the capability exposes no API to other capabilities
     */
    public T getRuntimeAPI() {
        return runtimeAPI;
    }
}
