/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleMapAttributeDefinition
extends MapAttributeDefinition {
    private final ModelType valueType;

    private SimpleMapAttributeDefinition(Builder builder) {
        super(builder);
        this.valueType = builder.valueType;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        node.get("value-type").set(this.valueType);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        node.get("value-type").set(this.valueType);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        node.get("value-type").set(this.valueType);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, false);
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, true);
    }

    private void handleCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue, boolean remove) {
        CapabilityReferenceRecorder refRecorder = this.getReferenceRecorder();
        if (refRecorder != null && attributeValue.isDefined()) {
            Set KeyList = attributeValue.keys();
            String[] attributeValues = new String[KeyList.size()];
            int position = 0;
            for (String key : KeyList) {
                ModelNode current = attributeValue.get(key);
                if (!current.isDefined() || current.getType().equals((Object)ModelType.EXPRESSION)) {
                    return;
                }
                attributeValues[position++] = current.asString();
            }
            if (remove) {
                refRecorder.removeCapabilityRequirements(context, resource, this.getName(), attributeValues);
            } else {
                refRecorder.addCapabilityRequirements(context, resource, this.getName(), attributeValues);
            }
        }
    }

    public static final class Builder
    extends MapAttributeDefinition.Builder<Builder, SimpleMapAttributeDefinition> {
        private ModelType valueType = ModelType.STRING;

        public Builder(String name, boolean optional) {
            super(name, optional);
            this.setDefaults();
        }

        public Builder(String name, ModelType valueType, boolean optional) {
            super(name, optional);
            this.valueType = valueType;
            this.setDefaults();
        }

        private void setDefaults() {
            this.setAttributeParser(AttributeParser.PROPERTIES_PARSER);
            this.setAttributeMarshaller(AttributeMarshaller.PROPERTIES_MARSHALLER);
        }

        public Builder(SimpleMapAttributeDefinition basis) {
            super(basis);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        public Builder setValueType(ModelType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public SimpleMapAttributeDefinition build() {
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(this.valueType);
            }
            return new SimpleMapAttributeDefinition(this);
        }
    }
}

