/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CompositeOperationHandler
implements OperationStepHandler {
    @Deprecated
    public static final OperationContext.AttachmentKey<Boolean> DOMAIN_EXECUTION_KEY = OperationContext.AttachmentKey.create(Boolean.class);
    public static final CompositeOperationHandler INSTANCE = new CompositeOperationHandler();
    public static final String NAME = "composite";
    private static final AttributeDefinition STEPS = new PrimitiveListAttributeDefinition.Builder("steps", ModelType.OBJECT).build();
    public static final OperationDefinition DEFINITION = new WFLY1316HackOperationDefinitionBuilder("composite", ControllerResolver.getResolver("root")).addParameter(STEPS).setReplyType(ModelType.OBJECT).setPrivateEntry().build();

    public static String getUnexplainedFailureMessage() {
        return ControllerLogger.ROOT_LOGGER.compositeOperationRolledBack();
    }

    protected CompositeOperationHandler() {
    }

    @Override
    public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        int i;
        STEPS.validateOperation(operation);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        List list = operation.get("steps").asList();
        final ModelNode responseMap = context.getResult().setEmptyObject();
        HashMap<String, OperationStepHandler> stepHandlerMap = new HashMap<String, OperationStepHandler>();
        final int size = list.size();
        for (i = 0; i < size; ++i) {
            String stepName = "step-" + (i + 1);
            responseMap.get(stepName);
            ModelNode subOperation = (ModelNode)list.get(i);
            PathAddress stepAddress = PathAddress.pathAddress(subOperation.get("address"));
            String stepOpName = subOperation.require("operation").asString();
            OperationEntry operationEntry = registry.getOperationEntry(stepAddress, stepOpName);
            if (operationEntry == null) {
                ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
                if (child == null) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(stepAddress));
                } else {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                return;
            }
            OperationStepHandler stepHandler = this.getOperationStepHandler(stepOpName, stepAddress, subOperation, operationEntry);
            stepHandlerMap.put(stepName, stepHandler);
        }
        for (i = size - 1; i >= 0; --i) {
            ModelNode subOperation = (ModelNode)list.get(i);
            String stepName = "step-" + (i + 1);
            OperationStepHandler osh = (OperationStepHandler)stepHandlerMap.get(stepName);
            context.addStep(responseMap.get(stepName).setEmptyObject(), subOperation, osh, OperationContext.Stage.MODEL, true);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Registered composite op step for %s using %s", subOperation, osh);
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (context.getAttachment(DOMAIN_EXECUTION_KEY) != null || context.hasFailureDescription()) {
                    return;
                }
                ModelNode failureMsg = new ModelNode();
                for (int i = 0; i < size; ++i) {
                    String stepName = "step-" + (i + 1);
                    ModelNode stepResponse = responseMap.get(stepName);
                    if (!stepResponse.hasDefined("failure-description")) continue;
                    failureMsg.get(new String[]{ControllerLogger.ROOT_LOGGER.compositeOperationFailed(), ControllerLogger.ROOT_LOGGER.operation(stepName)}).set(stepResponse.get("failure-description"));
                }
                if (!failureMsg.isDefined()) {
                    failureMsg.set(CompositeOperationHandler.getUnexplainedFailureMessage());
                }
                context.getFailureDescription().set(failureMsg);
            }
        });
    }

    protected OperationStepHandler getOperationStepHandler(String operationName, PathAddress address, ModelNode operation, OperationEntry operationEntry) {
        return operationEntry.getOperationHandler();
    }

    private static class WFLY1316HackOperationDefinitionBuilder
    extends SimpleOperationDefinitionBuilder {
        public WFLY1316HackOperationDefinitionBuilder(String name, ResourceDescriptionResolver resolver) {
            super(name, resolver);
        }

        @Override
        protected SimpleOperationDefinition internalBuild(ResourceDescriptionResolver resolver, ResourceDescriptionResolver attributeResolver) {
            if (this.entryType != OperationEntry.EntryType.PRIVATE) {
                return super.internalBuild(resolver, attributeResolver);
            }
            return new SimpleOperationDefinition(this.name, resolver, attributeResolver, this.entryType, this.flags, this.replyType, this.replyValueType, this.replyAllowNull, this.deprecationData, this.replyParameters, this.parameters){

                @Override
                public DescriptionProvider getDescriptionProvider() {
                    return new DescriptionProvider(){

                        @Override
                        public ModelNode getModelDescription(Locale locale) {
                            return new DefaultOperationDescriptionProvider(this.getName(), resolver, attributeResolver, replyType, replyValueType, replyAllowNull, deprecationData, replyParameters, parameters, accessConstraints).getModelDescription(locale);
                        }
                    };
                }
            };
        }
    }
}

