/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Collections;
import java.util.Map;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.msc.service.ServiceName;

public interface ServiceNameProvider {
    public ServiceName getCapabilityServiceName(Class<?> var1);

    public ServiceName getCapabilityServiceName(Class<?> var1, String var2);

    public static class DefaultProvider
    implements ServiceNameProvider {
        private final String capabilityName;
        private final Map<Class, ServiceName> serviceNames;

        public static ServiceName capabilityToServiceName(String capabilityName) {
            assert (capabilityName != null);
            assert (capabilityName.length() > 0);
            return ServiceName.of((String[])capabilityName.split("\\."));
        }

        public DefaultProvider(String capabilityName) {
            assert (capabilityName != null);
            this.capabilityName = capabilityName;
            this.serviceNames = Collections.emptyMap();
        }

        public DefaultProvider(String capabilityName, Class legalType) {
            assert (legalType != null);
            this.capabilityName = capabilityName;
            this.serviceNames = Collections.singletonMap(legalType, DefaultProvider.capabilityToServiceName(capabilityName));
        }

        public DefaultProvider(String capabilityName, Map<Class, ServiceName> services) {
            assert (capabilityName != null);
            assert (services != null);
            this.capabilityName = capabilityName;
            this.serviceNames = services;
        }

        @Override
        public ServiceName getCapabilityServiceName(Class<?> serviceType) {
            assert (serviceType != null);
            ServiceName result = this.serviceNames.get(serviceType);
            if (result == null) {
                for (Map.Entry<Class, ServiceName> entry : this.serviceNames.entrySet()) {
                    if (!serviceType.isAssignableFrom(entry.getKey())) continue;
                    return entry.getValue();
                }
                throw ControllerLogger.MGMT_OP_LOGGER.invalidCapabilityServiceType(this.capabilityName, serviceType);
            }
            return result;
        }

        @Override
        public ServiceName getCapabilityServiceName(Class<?> serviceType, String dynamicPortion) {
            if (dynamicPortion == null) {
                throw ControllerLogger.MGMT_OP_LOGGER.nullVar("dynamicPortion");
            }
            return this.getCapabilityServiceName(serviceType).append(new String[]{dynamicPortion});
        }
    }
}

