/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.resource;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractSocketBindingGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement("socket-binding-group");
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setResourceOnly()).setValidator(new StringLengthValidator(1))).build();
    public static final SimpleAttributeDefinition DEFAULT_INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-interface", ModelType.STRING, false).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES)).build();
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG.wrapAsList();

    public AbstractSocketBindingGroupResourceDefinition(OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PATH, ControllerResolver.getResolver("socket-binding-group"), addHandler, removeHandler, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(NAME, null);
        resourceRegistration.registerReadWriteAttribute(DEFAULT_INTERFACE, null, new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEFAULT_INTERFACE}){

            @Override
            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                AbstractSocketBindingGroupResourceDefinition.validateDefaultInterfaceReference(context, model.getModel());
            }
        });
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static void validateDefaultInterfaceReference(OperationContext context, ModelNode bindingGroup) throws OperationFailedException {
        ModelNode defaultInterfaceNode = bindingGroup.get(DEFAULT_INTERFACE.getName());
        if (defaultInterfaceNode.getType() == ModelType.STRING) {
            String defaultInterface = defaultInterfaceNode.asString();
            PathAddress interfaceAddress = PathAddress.pathAddress(PathElement.pathElement("interface", defaultInterface));
            try {
                context.readResourceFromRoot(interfaceAddress, false);
            }
            catch (RuntimeException e) {
                throw ControllerLogger.ROOT_LOGGER.nonexistentInterface(defaultInterface, DEFAULT_INTERFACE.getName());
            }
        }
    }
}

