/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class ServiceRemoveStepHandler
extends AbstractRemoveStepHandler {
    private static final RuntimeCapability[] NO_CAPABILITIES = new RuntimeCapability[0];
    private final ServiceName baseServiceName;
    private final AbstractAddStepHandler addOperation;
    private final RuntimeCapability[] unavailableCapabilities;

    public ServiceRemoveStepHandler(ServiceName baseServiceName, AbstractAddStepHandler addOperation, RuntimeCapability ... unavailableCapabilities) {
        super(unavailableCapabilities);
        this.baseServiceName = baseServiceName;
        this.addOperation = addOperation;
        this.unavailableCapabilities = unavailableCapabilities;
    }

    public ServiceRemoveStepHandler(ServiceName baseServiceName, AbstractAddStepHandler addOperation) {
        this(baseServiceName, addOperation, NO_CAPABILITIES);
    }

    public ServiceRemoveStepHandler(AbstractAddStepHandler addOperation, RuntimeCapability ... unavailableCapabilities) {
        this(null, addOperation, unavailableCapabilities);
    }

    protected ServiceRemoveStepHandler(AbstractAddStepHandler addOperation) {
        this(null, addOperation);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        if (context.isResourceServiceRestartAllowed()) {
            PathAddress address = context.getCurrentAddress();
            String name = address.getLastElement().getValue();
            ServiceName nonCapabilityServiceName = this.serviceName(name, address);
            if (nonCapabilityServiceName != null) {
                context.removeService(this.serviceName(name, address));
            }
            for (RuntimeCapability capability : this.unavailableCapabilities) {
                if (capability.getCapabilityServiceValueType() == null) continue;
                ServiceName sname = capability.isDynamicallyNamed() ? capability.getCapabilityServiceName(name) : capability.getCapabilityServiceName();
                context.removeService(sname);
            }
        } else {
            context.reloadRequired();
        }
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return this.addOperation.requiresRuntime(context);
    }

    protected ServiceName serviceName(String name, PathAddress address) {
        return this.serviceName(name);
    }

    protected ServiceName serviceName(String name) {
        return this.baseServiceName != null ? this.baseServiceName.append(new String[]{name}) : null;
    }

    @Override
    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.addOperation.performRuntime(context, operation, model);
        } else {
            context.revertReloadRequired();
        }
    }
}

