/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import org.jboss.as.controller.capability.registry.HostCapabilityContext;
import org.jboss.as.controller.capability.registry.ProfileChildCapabilityContext;
import org.jboss.as.controller.capability.registry.ProfilesCapabilityContext;
import org.jboss.as.controller.capability.registry.ServerConfigCapabilityContext;
import org.jboss.as.controller.capability.registry.ServerGroupsCapabilityContext;
import org.jboss.as.controller.capability.registry.SocketBindingGroupChildContext;
import org.jboss.as.controller.capability.registry.SocketBindingGroupsCapabilityContext;

public interface CapabilityContext {
    public static final CapabilityContext GLOBAL = new CapabilityContext(){

        @Override
        public boolean canSatisfyRequirement(CapabilityId dependent, String required, CapabilityResolutionContext context) {
            return true;
        }

        @Override
        public boolean requiresConsistencyCheck() {
            return false;
        }

        @Override
        public String getName() {
            return "global";
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{global}";
        }
    };

    public boolean canSatisfyRequirement(CapabilityId var1, String var2, CapabilityResolutionContext var3);

    public boolean requiresConsistencyCheck();

    public String getName();

    default public Set<CapabilityContext> getIncludingContexts(CapabilityResolutionContext context) {
        return Collections.emptySet();
    }

    public static class Factory {
        public static CapabilityContext create(ProcessType processType, PathAddress address) {
            PathElement pe;
            CapabilityContext context = GLOBAL;
            PathElement pathElement = pe = processType.isServer() || address.size() == 0 ? null : address.getElement(0);
            if (pe != null) {
                String type;
                switch (type = pe.getKey()) {
                    case "profile": {
                        context = address.size() == 1 ? ProfilesCapabilityContext.INSTANCE : new ProfileChildCapabilityContext(pe.getValue());
                        break;
                    }
                    case "socket-binding-group": {
                        context = address.size() == 1 ? SocketBindingGroupsCapabilityContext.INSTANCE : new SocketBindingGroupChildContext(pe.getValue());
                        break;
                    }
                    case "host": {
                        String hostType;
                        if (address.size() < 2) break;
                        PathElement hostElement = address.getElement(1);
                        switch (hostType = hostElement.getKey()) {
                            case "subsystem": 
                            case "socket-binding-group": {
                                context = HostCapabilityContext.INSTANCE;
                                break;
                            }
                            case "server-config": {
                                context = ServerConfigCapabilityContext.INSTANCE;
                            }
                        }
                        break;
                    }
                    case "server-group": {
                        context = ServerGroupsCapabilityContext.INSTANCE;
                    }
                }
            }
            return context;
        }
    }
}

