/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.AbstractCollectionHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MapOperations {
    public static final OperationDefinition MAP_CLEAR_DEFINITION = new SimpleOperationDefinitionBuilder("map-clear", ControllerResolver.getResolver("global")).setParameters(AbstractMapHandler.NAME).setRuntimeOnly().build();
    public static final OperationDefinition MAP_REMOVE_DEFINITION = new SimpleOperationDefinitionBuilder("map-remove", ControllerResolver.getResolver("global")).setParameters(AbstractMapHandler.NAME, AbstractMapHandler.KEY).setRuntimeOnly().build();
    public static final OperationDefinition MAP_GET_DEFINITION = new SimpleOperationDefinitionBuilder("map-get", ControllerResolver.getResolver("global")).setParameters(AbstractMapHandler.NAME, AbstractMapHandler.KEY).setRuntimeOnly().setReadOnly().build();
    public static final OperationDefinition MAP_PUT_DEFINITION = new SimpleOperationDefinitionBuilder("map-put", ControllerResolver.getResolver("global")).setParameters(AbstractMapHandler.NAME, AbstractMapHandler.KEY, AbstractMapHandler.VALUE).setRuntimeOnly().build();
    public static final OperationStepHandler MAP_CLEAR_HANDLER = new MapClearHandler();
    public static final OperationStepHandler MAP_GET_HANDLER = new MapGetHandler();
    public static final OperationStepHandler MAP_REMOVE_HANDLER = new MapRemoveHandler();
    public static final OperationStepHandler MAP_PUT_HANDLER = new MapPutHandler();
    public static final Set<String> MAP_OPERATION_NAMES = new HashSet<String>(Arrays.asList(MAP_CLEAR_DEFINITION.getName(), MAP_REMOVE_DEFINITION.getName(), MAP_PUT_DEFINITION.getName(), MAP_GET_DEFINITION.getName()));

    public static class MapRemoveHandler
    extends AbstractMapHandler {
        private MapRemoveHandler() {
            super(KEY);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, AttributeDefinition attributeDefinition, ModelNode attribute) throws OperationFailedException {
            String key = KEY.resolveModelAttribute(context, model).asString();
            attribute.remove(key);
            if (attribute.asList().isEmpty()) {
                attribute.clear();
            }
        }
    }

    public static class MapPutHandler
    extends AbstractMapHandler {
        private MapPutHandler() {
            super(KEY, VALUE);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, AttributeDefinition attributeDefinition, ModelNode attribute) throws OperationFailedException {
            String key = KEY.resolveModelAttribute(context, model).asString();
            ModelNode value = VALUE.resolveModelAttribute(context, model);
            attribute.get(key).set(value);
        }
    }

    public static class MapGetHandler
    extends AbstractMapHandler {
        private MapGetHandler() {
            super(false, KEY);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, AttributeDefinition attributeDefinition, ModelNode attribute) throws OperationFailedException {
            String key = KEY.resolveModelAttribute(context, model).asString();
            if (attribute.hasDefined(key)) {
                context.getResult().set(attribute.get(key));
            }
        }
    }

    public static class MapClearHandler
    extends AbstractMapHandler {
        private MapClearHandler() {
            super(true, new AttributeDefinition[0]);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, AttributeDefinition attributeDefinition, ModelNode attribute) throws OperationFailedException {
            attribute.setEmptyObject();
        }
    }

    static abstract class AbstractMapHandler
    extends AbstractCollectionHandler {
        static final SimpleAttributeDefinition KEY = new SimpleAttributeDefinition("key", ModelType.STRING, false);

        AbstractMapHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        AbstractMapHandler(boolean requiredReadWrite, AttributeDefinition ... attributes) {
            super(requiredReadWrite, attributes);
        }

        @Override
        abstract void updateModel(OperationContext var1, ModelNode var2, AttributeDefinition var3, ModelNode var4) throws OperationFailedException;
    }
}

