/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.WildcardReadResourceDescriptionAddressHack;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AliasStepHandler
implements OperationStepHandler {
    private final AliasEntry aliasEntry;

    AliasStepHandler(AliasEntry aliasEntry) {
        this.aliasEntry = aliasEntry;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String op = operation.require("operation").asString();
        PathAddress addr = context.getCurrentAddress();
        WildcardReadResourceDescriptionAddressHack.attachAliasAddress(context, operation);
        AliasEntry.AliasContext aliasContext = AliasEntry.AliasContext.create(operation, context);
        PathAddress mapped = this.aliasEntry.convertToTargetAddress(addr, aliasContext);
        OperationStepHandler targetHandler = context.getRootResourceRegistration().getOperationHandler(mapped, op);
        if (targetHandler == null) {
            throw ControllerLogger.ROOT_LOGGER.aliasStepHandlerOperationNotFound(op, addr, mapped);
        }
        ModelNode copy = operation.clone();
        copy.get("address").set(mapped.toModelNode());
        context.addStep(copy, targetHandler, OperationContext.Stage.MODEL, true);
        if (this.isTrimReadResourceDefinitionArray(op, addr, mapped)) {
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    List list;
                    ModelNode result = context.getResult();
                    if (result.getType() == ModelType.LIST && (list = result.asList()).size() == 1) {
                        ModelNode entry = (ModelNode)list.get(0);
                        context.getResult().set(entry.get("result"));
                    }
                }
            });
        }
    }

    private boolean isTrimReadResourceDefinitionArray(String opName, PathAddress aliasAddr, PathAddress targetAddr) {
        if (!opName.equals("read-resource-description")) {
            return false;
        }
        if (aliasAddr.isMultiTarget()) {
            return false;
        }
        return targetAddr.isMultiTarget();
    }
}

