/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.controller;

import org.jboss.dmr.ModelNode;

/**
 * {@link OperationStepHandler} that reads the address of the operation and returns the value of its
 * last element as the operation result. Intended for use as a {@code read-attribute} handler for resources
 * that have "name" attribute.
 *
 * @author Brian Stansberry (c) 2012 Red Hat Inc.
 */
public class ReadResourceNameOperationStepHandler implements OperationStepHandler {

    public static final ReadResourceNameOperationStepHandler INSTANCE = new ReadResourceNameOperationStepHandler();

    private ReadResourceNameOperationStepHandler() {

    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();

        context.getResult().set(name);
    }
}
