/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.BlockingTimeoutImpl;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ContainerStateVerificationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.HostServerGroupTracker;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHeaders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.ThreadDumpUtil;
import org.jboss.as.controller.UninterruptibleCountDownLatch;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.access.ResourceNotAddressableException;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.DelegatingImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ContextAttachments;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.DelegatingServiceController;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

final class OperationContextImpl
extends AbstractOperationContext {
    private static final Object NULL = new Object();
    private static final Set<Action.ActionEffect> ADDRESS = EnumSet.of(Action.ActionEffect.ADDRESS);
    private static final Set<Action.ActionEffect> READ_CONFIG = EnumSet.of(Action.ActionEffect.READ_CONFIG);
    private static final Set<Action.ActionEffect> READ_RUNTIME = EnumSet.of(Action.ActionEffect.READ_RUNTIME);
    private static final Set<Action.ActionEffect> READ_WRITE_CONFIG = EnumSet.of(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.WRITE_CONFIG);
    private static final Set<Action.ActionEffect> READ_WRITE_RUNTIME = EnumSet.of(Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_RUNTIME);
    private static final Set<Action.ActionEffect> WRITE_CONFIG = EnumSet.of(Action.ActionEffect.WRITE_CONFIG);
    private static final Set<Action.ActionEffect> WRITE_RUNTIME = EnumSet.of(Action.ActionEffect.WRITE_RUNTIME);
    private static final Set<Action.ActionEffect> ALL_READ_WRITE = EnumSet.of(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_CONFIG, Action.ActionEffect.WRITE_RUNTIME);
    private final ModelControllerImpl modelController;
    private final OperationMessageHandler messageHandler;
    private final Map<ServiceName, ServiceController<?>> realRemovingControllers = new HashMap();
    private final Map<ServiceName, AbstractOperationContext.Step> removalSteps = new HashMap<ServiceName, AbstractOperationContext.Step>();
    private final OperationAttachments attachments;
    private final Map<PathAddress, Object> affectsModel;
    private Map<PathAddress, Object> restartedResources = Collections.emptyMap();
    private final ContextAttachments contextAttachments = new ContextAttachments();
    private final Map<AbstractOperationContext.OperationId, AuthorizationResponseImpl> authorizations = new ConcurrentHashMap<AbstractOperationContext.OperationId, AuthorizationResponseImpl>();
    private final Set<ContextServiceTarget> serviceTargets = Collections.synchronizedSet(new HashSet());
    private final Set<OperationContextServiceRegistry> serviceRegistries = Collections.synchronizedSet(new HashSet());
    private volatile BlockingTimeout blockingTimeout;
    private final long startTime = System.nanoTime();
    private volatile long exclusiveStartTime = -1L;
    private volatile boolean affectsResourceTree;
    private volatile boolean affectsResourceRegistration;
    private volatile boolean affectsCapabilityRegistry;
    private volatile ModelControllerImpl.ManagementModelImpl managementModel;
    private final ModelControllerImpl.ManagementModelImpl originalModel;
    private volatile HostServerGroupTracker hostServerGroupTracker;
    private volatile boolean affectsRuntime;
    private AbstractOperationContext.Step lockStep;
    private AbstractOperationContext.Step containerMonitorStep;
    private boolean notifiedModificationBegun;
    private volatile Boolean requiresModelUpdateAuthorization;
    private volatile boolean readOnly = true;
    private final ConcurrentMap<RuntimeRequirementRegistration, Set<AbstractOperationContext.Step>> addedRequirements = new ConcurrentHashMap<RuntimeRequirementRegistration, Set<AbstractOperationContext.Step>>();
    private final ConcurrentMap<CapabilityId, AbstractOperationContext.Step> removedCapabilities = new ConcurrentHashMap<CapabilityId, AbstractOperationContext.Step>();
    private final Integer operationId;
    private final String operationName;
    private final ModelNode operationAddress;
    private final AccessAuditContext accessAuditContext;
    private final ActiveOperationResource activeOperationResource;
    private final BooleanHolder done = new BooleanHolder();
    private final boolean capabilitiesAlreadyBroken;
    private final boolean partialModel;
    private final boolean forBoot;
    private volatile OperationContext.ExecutionStatus executionStatus = OperationContext.ExecutionStatus.EXECUTING;

    OperationContextImpl(Integer operationId, String operationName, ModelNode operationAddress, ModelControllerImpl modelController, ProcessType processType, RunningMode runningMode, OperationHeaders operationHeaders, OperationMessageHandler messageHandler, OperationAttachments attachments, ModelControllerImpl.ManagementModelImpl managementModel, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, AuditLogger auditLogger, boolean booting, boolean forBoot, HostServerGroupTracker hostServerGroupTracker, AccessAuditContext accessAuditContext, NotificationSupport notificationSupport, boolean skipModelValidation, OperationStepHandler extraValidationStepHandler, boolean partialModel, Supplier<SecurityIdentity> securityIdentitySupplier) {
        super(processType, runningMode, transactionControl, processState, booting, auditLogger, notificationSupport, modelController, skipModelValidation, extraValidationStepHandler, operationHeaders, securityIdentitySupplier);
        this.operationId = operationId;
        this.operationName = operationName;
        this.operationAddress = operationAddress.isDefined() ? operationAddress : ModelControllerImpl.EMPTY_ADDRESS;
        this.managementModel = managementModel;
        this.originalModel = managementModel;
        this.modelController = modelController;
        this.messageHandler = messageHandler;
        this.attachments = attachments;
        this.affectsModel = booting ? new ConcurrentHashMap(256) : new HashMap(1);
        this.forBoot = forBoot;
        this.hostServerGroupTracker = hostServerGroupTracker;
        this.activeOperationResource = new ActiveOperationResource();
        this.accessAuditContext = accessAuditContext;
        this.partialModel = partialModel;
        if (runningMode == RunningMode.ADMIN_ONLY) {
            boolean hostXmlOnly = booting && !processType.isServer() && partialModel;
            CapabilityRegistry.CapabilityValidation validation = managementModel.validateCapabilityRegistry(true, hostXmlOnly);
            this.capabilitiesAlreadyBroken = !validation.isValid();
        } else {
            this.capabilitiesAlreadyBroken = false;
        }
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        if (this.attachments == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (InputStream)this.attachments.getInputStreams().get(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.attachments == null ? 0 : this.attachments.getInputStreams().size();
    }

    @Override
    boolean stageCompleted(OperationContext.Stage stage) {
        return stage != OperationContext.Stage.MODEL || this.validateCapabilities();
    }

    @Override
    ModelControllerImpl.ManagementModelImpl getManagementModel() {
        return this.managementModel;
    }

    @Override
    boolean isBootOperation() {
        return this.forBoot;
    }

    private boolean validateCapabilities() {
        boolean ignoreFailures;
        if (!(this.affectsResourceTree || this.affectsCapabilityRegistry || this.affectsResourceRegistration || this.affectsRuntime)) {
            return true;
        }
        boolean hostXmlOnly = !this.getProcessType().isServer() && this.partialModel;
        CapabilityRegistry.CapabilityValidation validation = this.managementModel.validateCapabilityRegistry(false, hostXmlOnly);
        boolean ok = validation.isValid();
        boolean adminOnly = this.getRunningMode() == RunningMode.ADMIN_ONLY;
        boolean bl = ignoreFailures = adminOnly && (this.capabilitiesAlreadyBroken || this.isBooting());
        if (!ok) {
            Object msg;
            boolean failureRecorded = false;
            StringBuilder unexplainedProblem = null;
            boolean ignoreContext = this.getProcessType().isServer();
            CapabilityResolutionContext resolutionContext = validation.getCapabilityResolutionContext();
            Map<CapabilityId, Set<RuntimeRequirementRegistration>> missing = validation.getMissingRequirements();
            HashMap<AbstractOperationContext.Step, HashSet<CapabilityId>> missingForStep = new HashMap<AbstractOperationContext.Step, HashSet<CapabilityId>>();
            for (Map.Entry<CapabilityId, Set<RuntimeRequirementRegistration>> entry : missing.entrySet()) {
                CapabilityId required = entry.getKey();
                AbstractOperationContext.Step guilty = this.findCapabilityRemovalStep(required, ignoreContext, resolutionContext);
                if (guilty != null) {
                    msg = new StringBuilder();
                    msg = ignoreContext ? ((StringBuilder)msg).append(ControllerLogger.ROOT_LOGGER.cannotRemoveRequiredCapability(required.getName())) : ((StringBuilder)msg).append(ControllerLogger.ROOT_LOGGER.cannotRemoveRequiredCapabilityInContext(required.getName(), required.getScope().getName()));
                    for (RuntimeRequirementRegistration reg : entry.getValue()) {
                        RegistrationPoint registrationPoint = reg.getOldestRegistrationPoint();
                        if (registrationPoint.getAttribute() == null) {
                            msg = ((StringBuilder)msg).append('\n').append(ControllerLogger.ROOT_LOGGER.requirementPointSimple(reg.getDependentName(), registrationPoint.getAddress().toCLIStyleString()));
                            continue;
                        }
                        msg = ((StringBuilder)msg).append('\n').append(ControllerLogger.ROOT_LOGGER.requirementPointFull(reg.getDependentName(), registrationPoint.getAttribute(), registrationPoint.getAddress().toCLIStyleString()));
                    }
                    String msgString = ((StringBuilder)msg).toString();
                    if (!ignoreFailures) {
                        guilty.response.get("failure-description").set(msgString);
                    }
                    failureRecorded = true;
                    if (!this.isBooting() && !ignoreFailures) continue;
                    ControllerLogger.ROOT_LOGGER.error(guilty.address.toCLIStyleString() + " -- " + msgString);
                    continue;
                }
                for (RuntimeRequirementRegistration reqReq : entry.getValue()) {
                    Set bereft = (Set)this.addedRequirements.get(reqReq);
                    if (bereft != null && !bereft.isEmpty()) {
                        Iterator iterator = bereft.iterator();
                        while (iterator.hasNext()) {
                            AbstractOperationContext.Step step = (AbstractOperationContext.Step)iterator.next();
                            HashSet<CapabilityId> set = (HashSet<CapabilityId>)missingForStep.get(step);
                            if (set == null) {
                                set = new HashSet<CapabilityId>();
                                missingForStep.put(step, set);
                            }
                            set.add(required);
                        }
                        continue;
                    }
                    if (unexplainedProblem == null) {
                        unexplainedProblem = new StringBuilder(ControllerLogger.ROOT_LOGGER.requiredCapabilityMissing());
                    }
                    String string = ignoreContext ? ControllerLogger.ROOT_LOGGER.formattedCapabilityName(reqReq.getRequiredName()) : ControllerLogger.ROOT_LOGGER.formattedCapabilityId(reqReq.getRequiredName(), reqReq.getDependentContext().getName());
                    Set<PathAddress> possiblePoints = this.managementModel.getCapabilityRegistry().getPossibleProviderPoints(reqReq.getDependentId());
                    OperationContextImpl.appendPossibleProviderPoints(unexplainedProblem, string, possiblePoints);
                }
            }
            for (Map.Entry<CapabilityId, Set<RuntimeRequirementRegistration>> entry : missingForStep.entrySet()) {
                AbstractOperationContext.Step step = (AbstractOperationContext.Step)((Object)entry.getKey());
                ModelNode response = step.response;
                msg = response.hasDefined("failure-description") ? null : new StringBuilder(ControllerLogger.ROOT_LOGGER.requiredCapabilityMissing());
                StringBuilder bootMsg = this.isBooting() || ignoreFailures ? new StringBuilder(ControllerLogger.ROOT_LOGGER.requiredCapabilityMissing(step.address.toCLIStyleString())) : null;
                for (CapabilityId capabilityId : entry.getValue()) {
                    String formattedCapability = ignoreContext ? ControllerLogger.ROOT_LOGGER.formattedCapabilityName(capabilityId.getName()) : ControllerLogger.ROOT_LOGGER.formattedCapabilityId(capabilityId.getName(), capabilityId.getScope().getName());
                    Set<PathAddress> possiblePoints = this.managementModel.getCapabilityRegistry().getPossibleProviderPoints(capabilityId);
                    if (msg != null) {
                        msg = OperationContextImpl.appendPossibleProviderPoints((StringBuilder)msg, formattedCapability, possiblePoints);
                    }
                    if (bootMsg == null) continue;
                    bootMsg = OperationContextImpl.appendPossibleProviderPoints(bootMsg, formattedCapability, possiblePoints);
                }
                if (msg != null) {
                    if (!ignoreFailures) {
                        response.get("failure-description").set(((StringBuilder)msg).toString());
                    }
                    failureRecorded = true;
                }
                if (bootMsg == null) continue;
                ControllerLogger.ROOT_LOGGER.error(bootMsg.toString());
            }
            if (!ignoreContext) {
                for (RuntimeRequirementRegistration runtimeRequirementRegistration : validation.getInconsistentRequirements()) {
                    Set inconsistent = (Set)this.addedRequirements.get(runtimeRequirementRegistration);
                    if (inconsistent != null && !inconsistent.isEmpty()) {
                        for (AbstractOperationContext.Step step : inconsistent) {
                            ModelNode response = step.response;
                            String depConName = runtimeRequirementRegistration.getDependentContext().getName();
                            if (!response.hasDefined("failure-description")) {
                                if (!adminOnly || !this.isBooting()) {
                                    response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.inconsistentCapabilityContexts(runtimeRequirementRegistration.getRequiredName(), runtimeRequirementRegistration.getDependentName(), depConName, depConName));
                                }
                                failureRecorded = true;
                            }
                            if (!this.isBooting()) continue;
                            ControllerLogger.ROOT_LOGGER.inconsistentCapabilityContexts(runtimeRequirementRegistration.getDependentName(), depConName, step.address.toCLIStyleString(), runtimeRequirementRegistration.getRequiredName(), depConName);
                        }
                        continue;
                    }
                    if (unexplainedProblem == null) {
                        unexplainedProblem = new StringBuilder();
                    } else {
                        unexplainedProblem.append('\n');
                    }
                    String depConName = runtimeRequirementRegistration.getDependentContext().getName();
                    unexplainedProblem.append(ControllerLogger.ROOT_LOGGER.inconsistentCapabilityContexts(runtimeRequirementRegistration.getRequiredName(), runtimeRequirementRegistration.getDependentName(), depConName, depConName));
                }
            }
            if (!failureRecorded && unexplainedProblem != null && !this.initialResponse.hasDefined("failure-description")) {
                if (!ignoreFailures) {
                    this.initialResponse.get("failure-description").set(unexplainedProblem.toString());
                }
                if (this.isBooting() || ignoreFailures) {
                    ControllerLogger.ROOT_LOGGER.error(unexplainedProblem);
                }
            }
        }
        return ok || ignoreFailures;
    }

    private static StringBuilder appendPossibleProviderPoints(StringBuilder sb, String formattedCapability, Set<PathAddress> possible) {
        sb = sb.append(System.lineSeparator()).append(formattedCapability);
        if (possible.isEmpty()) {
            return sb.append(ControllerLogger.ROOT_LOGGER.noKnownProviderPoints());
        }
        if (ExpressionResolver.EXPRESSION_PATTERN.matcher(formattedCapability).matches()) {
            return sb.append(ControllerLogger.ROOT_LOGGER.unsupportedUsageOfExpression());
        }
        StringBuffer points = new StringBuffer();
        for (PathAddress c : possible) {
            points = points.append(System.lineSeparator()).append("\t\t").append(c.toCLIStyleString());
        }
        return sb.append(ControllerLogger.ROOT_LOGGER.possibleCapabilityProviderPoints(points.toString()));
    }

    private AbstractOperationContext.Step findCapabilityRemovalStep(CapabilityId missingRequirement, boolean ignoreContext, CapabilityResolutionContext resolutionContext) {
        AbstractOperationContext.Step result = (AbstractOperationContext.Step)this.removedCapabilities.get(missingRequirement);
        if (result == null && !ignoreContext) {
            String missingName = missingRequirement.getName();
            for (Map.Entry entry : this.removedCapabilities.entrySet()) {
                CapabilityId removedId = (CapabilityId)entry.getKey();
                if (!missingName.equals(removedId.getName()) || !removedId.getScope().canSatisfyRequirement(missingRequirement.getName(), missingRequirement.getScope(), resolutionContext)) continue;
                result = (AbstractOperationContext.Step)entry.getValue();
                break;
            }
        }
        return result;
    }

    @Override
    void awaitServiceContainerStability() throws InterruptedException, TimeoutException {
        if (this.affectsRuntime) {
            ControllerLogger.MGMT_OP_LOGGER.debugf("Entered VERIFY stage; waiting for service container to settle", new Object[0]);
            long timeout = this.getBlockingTimeout().getLocalBlockingTimeout();
            OperationContext.ExecutionStatus originalExecutionStatus = this.executionStatus;
            try {
                this.executionStatus = OperationContext.ExecutionStatus.AWAITING_STABILITY;
                this.waitForRemovals();
                ContainerStateMonitor.ContainerStateChangeReport changeReport = this.modelController.awaitContainerStateChangeReport(timeout, TimeUnit.MILLISECONDS);
                if (changeReport != null && changeReport.hasNewProblems()) {
                    if (!changeReport.getMissingServices().isEmpty()) {
                        ServiceRemovalVerificationHandler removalVerificationHandler = new ServiceRemovalVerificationHandler(changeReport);
                        this.addStep(new ModelNode(), new ModelNode(), PathAddress.EMPTY_ADDRESS, removalVerificationHandler, OperationContext.Stage.VERIFY);
                    }
                    ContainerStateVerificationHandler csvh = new ContainerStateVerificationHandler(changeReport);
                    this.addStep(this.initialResponse, this.initialOperation, PathAddress.EMPTY_ADDRESS, csvh, OperationContext.Stage.VERIFY);
                }
            }
            catch (TimeoutException te) {
                this.getBlockingTimeout().timeoutDetected();
                ControllerLogger.MGMT_OP_LOGGER.timeoutExecutingOperation(timeout / 1000L, this.containerMonitorStep.operationId.name, this.containerMonitorStep.address);
                ThreadDumpUtil.threadDump();
                throw te;
            }
            finally {
                this.executionStatus = originalExecutionStatus;
                this.notifyModificationsComplete();
            }
        }
    }

    private void notifyModificationsComplete() {
        if (this.notifiedModificationBegun) {
            Notification notification = new Notification("runtime-modification-complete", this.modelController.getModelControllerResourceAddress(this.managementModel), ControllerLogger.MGMT_OP_LOGGER.runtimeModificationComplete());
            this.notificationSupport.emit(notification);
            this.notifiedModificationBegun = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitForRemovals() throws InterruptedException, TimeoutException {
        if (this.affectsRuntime && !this.cancelled) {
            Map<ServiceName, ServiceController<?>> map = this.realRemovingControllers;
            synchronized (map) {
                boolean wait;
                long waitTime = this.getBlockingTimeout().getLocalBlockingTimeout();
                long end = System.currentTimeMillis() + waitTime;
                boolean bl = wait = !this.realRemovingControllers.isEmpty() && !this.cancelled;
                while (wait && waitTime > 0L) {
                    this.realRemovingControllers.wait(waitTime);
                    wait = !this.realRemovingControllers.isEmpty() && !this.cancelled;
                    waitTime = end - System.currentTimeMillis();
                }
                if (wait) {
                    this.getBlockingTimeout().timeoutDetected();
                    throw new TimeoutException();
                }
            }
        }
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return this.affectsResourceTree || this.affectsCapabilityRegistry || this.affectsResourceRegistration ? this.modelController.writeModel(this.managementModel, this.affectsModel.keySet(), this.affectsResourceTree, this.affectsCapabilityRegistry, this.affectsResourceRegistration) : null;
    }

    @Override
    void operationRollingBack() {
        this.modelController.discardModel(this.managementModel, this.affectsResourceTree, this.affectsCapabilityRegistry, this.affectsResourceRegistration);
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return this.operationHeaders.getContextFlags().contains((Object)AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL);
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return this.operationHeaders.getContextFlags().contains((Object)AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        return this.getMutableResourceRegistration(this.activeStep.address);
    }

    private ManagementResourceRegistration getMutableResourceRegistration(PathAddress absoluteAddress) {
        this.readOnly = false;
        assert (this.isControllingThread());
        OperationContextImpl.assertNotComplete(this.currentStage);
        this.authorize(false, READ_WRITE_CONFIG);
        this.ensureLocalManagementResourceRegistration();
        ManagementResourceRegistration mrr = this.managementModel.getRootResourceRegistration();
        return absoluteAddress == null ? mrr : mrr.getSubModel(absoluteAddress);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        assert (this.isControllingThread());
        OperationContextImpl.assertNotComplete(this.currentStage);
        this.authorize(false, Collections.emptySet());
        ManagementResourceRegistration delegate = this.activeStep.getManagementResourceRegistration(this.managementModel);
        return delegate == null ? null : new DelegatingImmutableManagementResourceRegistration(delegate);
    }

    @Override
    public ImmutableManagementResourceRegistration getRootResourceRegistration() {
        assert (this.isControllingThread());
        OperationContextImpl.assertNotComplete(this.currentStage);
        ManagementResourceRegistration delegate = this.managementModel.getRootResourceRegistration();
        return delegate == null ? null : new DelegatingImmutableManagementResourceRegistration(delegate);
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        return this.getServiceRegistry(modify, this.activeStep);
    }

    ServiceRegistry getServiceRegistry(boolean modify, AbstractOperationContext.Step registryActiveStep) {
        if (modify) {
            this.readOnly = false;
        }
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (modify) {
            if (!this.isRuntimeChangeAllowed()) {
                throw ControllerLogger.ROOT_LOGGER.serviceRegistryRuntimeOperationsOnly();
            }
        } else {
            OperationContextImpl.assertNotComplete(currentStage);
        }
        this.authorize(false, modify ? READ_WRITE_RUNTIME : READ_RUNTIME);
        if (modify) {
            this.ensureWriteLockForRuntime();
        }
        OperationContextServiceRegistry registry = new OperationContextServiceRegistry(this.modelController.getServiceRegistry(), registryActiveStep);
        this.serviceRegistries.add(registry);
        return registry;
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        this.readOnly = false;
        assert (this.isControllingThread());
        if (!this.isRuntimeChangeAllowed()) {
            throw ControllerLogger.ROOT_LOGGER.serviceRemovalRuntimeOperationsOnly();
        }
        this.authorize(false, WRITE_RUNTIME);
        this.ensureWriteLockForRuntime();
        ServiceController controller = this.modelController.getServiceRegistry().getService(name);
        if (controller != null) {
            this.doRemove(controller);
        }
        return controller;
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.containsKey(resource)) {
            return false;
        }
        if (this.restartedResources == Collections.EMPTY_MAP) {
            this.restartedResources = new HashMap<PathAddress, Object>();
        }
        this.restartedResources.put(resource, owner);
        return true;
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.get(resource) == owner) {
            this.restartedResources.remove(resource);
            return true;
        }
        return false;
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        this.readOnly = false;
        assert (this.isControllingThread());
        if (!this.isRuntimeChangeAllowed()) {
            throw ControllerLogger.ROOT_LOGGER.serviceRemovalRuntimeOperationsOnly();
        }
        this.authorize(false, WRITE_RUNTIME);
        this.ensureWriteLockForRuntime();
        if (controller != null) {
            this.doRemove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(ServiceController<?> controller) {
        final AbstractOperationContext.Step removalStep = this.activeStep;
        removalStep.hasRemovals = true;
        final UninterruptibleCountDownLatch latch = new UninterruptibleCountDownLatch(1);
        controller.addListener(new LifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                latch.awaitUninterruptibly();
                if (event == LifecycleEvent.REMOVED) {
                    Map<ServiceName, ServiceController<?>> map = OperationContextImpl.this.realRemovingControllers;
                    synchronized (map) {
                        ServiceName name = controller.getName();
                        if (OperationContextImpl.this.realRemovingControllers.get(name) == controller) {
                            OperationContextImpl.this.realRemovingControllers.remove(name);
                            OperationContextImpl.this.removalSteps.put(name, removalStep);
                            OperationContextImpl.this.realRemovingControllers.notifyAll();
                        }
                    }
                }
            }
        });
        try {
            ServiceController realController = this.unwrap(controller);
            Map<ServiceName, ServiceController<?>> map = this.realRemovingControllers;
            synchronized (map) {
                this.realRemovingControllers.put(controller.getName(), realController);
                realController.setMode(ServiceController.Mode.REMOVE);
            }
        }
        finally {
            latch.countDown();
        }
    }

    private ServiceController unwrap(ServiceController<?> controller) {
        if (controller instanceof OperationContextServiceController) {
            return ((OperationContextServiceController)controller).getDelegate();
        }
        return controller;
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        return this.getCapabilityServiceTarget();
    }

    @Override
    public CapabilityServiceTarget getCapabilityServiceTarget() throws UnsupportedOperationException {
        return this.getServiceTarget(this.activeStep);
    }

    CapabilityServiceTarget getServiceTarget(final AbstractOperationContext.Step targetActiveStep) throws UnsupportedOperationException {
        this.readOnly = false;
        assert (this.isControllingThread());
        if (!this.isRuntimeChangeAllowed()) {
            throw ControllerLogger.ROOT_LOGGER.serviceTargetRuntimeOperationsOnly();
        }
        this.ensureWriteLockForRuntime();
        ContextServiceBuilderSupplier supplier = new ContextServiceBuilderSupplier(){

            @Override
            public <T> ContextServiceBuilder<T> getContextServiceBuilder(ServiceBuilder<T> delegate, final ServiceName name) {
                ContextServiceInstaller csi = new ContextServiceInstaller(){

                    public <X> ServiceController<X> installService(ServiceBuilder<X> realBuilder) {
                        return OperationContextImpl.this.installService(realBuilder, name, targetActiveStep);
                    }

                    @Override
                    public ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType, PathAddress address) {
                        return OperationContextImpl.this.getCapabilityServiceName(capabilityName, serviceType, address);
                    }
                };
                return new ContextServiceBuilder<T>(delegate, csi);
            }
        };
        ServiceTarget delegate = targetActiveStep.getScopedServiceTarget(this.modelController.getServiceTarget());
        ContextServiceTarget cst = new ContextServiceTarget(delegate, supplier, targetActiveStep.address);
        this.serviceTargets.add(cst);
        return cst;
    }

    Resource.ResourceEntry getActiveOperationResource() {
        return this.activeOperationResource;
    }

    private void takeWriteLock() {
        if (this.lockStep == null) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw ControllerLogger.ROOT_LOGGER.invalidModificationAfterCompletedStep();
            }
            OperationContext.ExecutionStatus originalStatus = this.executionStatus;
            try {
                this.executionStatus = OperationContext.ExecutionStatus.AWAITING_OTHER_OPERATION;
                this.modelController.acquireWriteLock(this.operationId, this.respectInterruption);
                this.exclusiveStartTime = System.nanoTime();
                this.lockStep = this.activeStep;
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                Thread.currentThread().interrupt();
                throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
            }
            finally {
                this.executionStatus = originalStatus;
            }
        }
    }

    private void ensureWriteLockForRuntime() {
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            if (this.containerMonitorStep == null) {
                if (this.currentStage == OperationContext.Stage.DONE) {
                    throw ControllerLogger.ROOT_LOGGER.invalidModificationAfterCompletedStep();
                }
                this.containerMonitorStep = this.activeStep;
                int timeout = this.getBlockingTimeout().getLocalBlockingTimeout();
                OperationContext.ExecutionStatus origStatus = this.executionStatus;
                try {
                    this.executionStatus = OperationContext.ExecutionStatus.AWAITING_STABILITY;
                    this.modelController.awaitContainerStability(timeout, TimeUnit.MILLISECONDS, false);
                    this.notifyModificationBegun();
                }
                catch (InterruptedException e) {
                    if (this.resultAction != OperationContext.ResultAction.ROLLBACK) {
                        this.cancelled = true;
                    }
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
                }
                catch (TimeoutException te) {
                    this.getBlockingTimeout().timeoutDetected();
                    this.processState.setRestartRequired();
                    ControllerLogger.MGMT_OP_LOGGER.timeoutAwaitingInitialStability(timeout / 1000, this.activeStep.operationId.name, this.activeStep.operationId.address);
                    this.setRollbackOnly();
                    ThreadDumpUtil.threadDump();
                    throw new OperationFailedRuntimeException(ControllerLogger.ROOT_LOGGER.timeoutAwaitingInitialStability());
                }
                finally {
                    this.executionStatus = origStatus;
                }
            }
        } else if (!this.notifiedModificationBegun) {
            this.notifyModificationBegun();
        }
    }

    private void notifyModificationBegun() {
        PathAddress pa = this.modelController.getModelControllerResourceAddress(this.managementModel);
        if (pa != null) {
            Notification notification = new Notification("runtime-modification-begun", pa, ControllerLogger.MGMT_OP_LOGGER.runtimeModificationBegun());
            this.notificationSupport.emit(notification);
            this.notifiedModificationBegun = true;
        }
    }

    @Override
    public Resource readResource(PathAddress requestAddress) {
        return this.readResource(requestAddress, true);
    }

    @Override
    public Resource readResource(PathAddress requestAddress, boolean recursive) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        return this.readResourceFromRoot(address, recursive);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.readResourceFromRoot(address, true);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
        assert (this.isControllingThread());
        OperationContextImpl.assertNotComplete(this.currentStage);
        ModelNode operation = this.activeStep.operation.clone();
        operation.get("operation").set(ReadResourceHandler.DEFINITION.getName());
        operation.get("address").set(address.toModelNode());
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult authResult = this.authorize(opId, operation, false, READ_CONFIG);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            AuthorizationResult addressResult = this.authorize(opId, operation, false, ADDRESS);
            if (addressResult.getDecision() == AuthorizationResult.Decision.DENY) {
                throw new ResourceNotAddressableException(this.activeStep.address);
            }
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
        }
        return this.readResourceFromRoot(this.managementModel, address, recursive);
    }

    @Override
    Resource readResourceFromRoot(ManagementModel managementModel, PathAddress address, boolean recursive) {
        Resource model = managementModel.getRootResource();
        Iterator iterator = address.iterator();
        while (iterator.hasNext()) {
            PathElement element = (PathElement)iterator.next();
            if (element.isWildcard() && !iterator.hasNext()) {
                Set<Resource.ResourceEntry> children = model.getChildren(element.getKey());
                if (children.isEmpty()) {
                    PathAddress parent = address.subAddress(0, address.size() - 1);
                    Set<String> childrenTypes = managementModel.getRootResourceRegistration().getChildNames(parent);
                    if (!childrenTypes.contains(element.getKey())) {
                        throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
                    }
                    return Resource.Factory.create();
                }
                model = Resource.Factory.create();
                for (Resource.ResourceEntry entry : children) {
                    model.registerChild(entry.getPathElement(), entry);
                }
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        if (recursive) {
            return model.clone();
        }
        return model.shallowCopy();
    }

    @Override
    public Resource readResourceForUpdate(PathAddress requestAddress) {
        boolean runtimeOnly;
        this.readOnly = false;
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        PathAddress address = this.activeStep.address.append(requestAddress);
        boolean bl = runtimeOnly = !this.isBooting() && this.isResourceRuntimeOnly(address);
        if (!runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(address);
        this.authorize(false, runtimeOnly ? READ_WRITE_RUNTIME : READ_WRITE_CONFIG);
        this.ensureLocalRootResource();
        this.affectsModel.put(address, NULL);
        Resource resource = this.managementModel.getRootResource();
        for (PathElement element : address) {
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotWriteTo("*");
            }
            resource = OperationContextImpl.requireChild(resource, element, address);
        }
        return resource;
    }

    private boolean isResourceRuntimeOnly(PathAddress fullAddress) {
        Resource resource = this.managementModel.getRootResource();
        Iterator it = fullAddress.iterator();
        while (it.hasNext() && resource != null) {
            PathElement element = (PathElement)it.next();
            if (element.isMultiTarget()) {
                resource = null;
                continue;
            }
            resource = resource.getChild(element);
        }
        if (resource != null) {
            return resource.isRuntime();
        }
        ManagementResourceRegistration mrr = this.managementModel.getRootResourceRegistration().getSubModel(fullAddress);
        return mrr != null && mrr.isRuntimeOnly();
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.originalModel.getRootResource().clone();
    }

    @Override
    public Resource createResource(PathAddress relativeAddress) {
        return this.createResourceInternal(relativeAddress, -1);
    }

    private Resource createResourceInternal(PathAddress relativeAddress, int index) throws UnsupportedOperationException {
        ImmutableManagementResourceRegistration current = this.getResourceRegistration();
        ImmutableManagementResourceRegistration mrr = relativeAddress == PathAddress.EMPTY_ADDRESS ? current : current.getSubModel(relativeAddress);
        Resource toAdd = Resource.Factory.create(mrr.isRuntimeOnly());
        this.addResourceInternal(relativeAddress, index, toAdd);
        return toAdd;
    }

    @Override
    public void addResource(PathAddress relativeAddress, Resource toAdd) {
        this.addResourceInternal(relativeAddress, -1, toAdd);
    }

    @Override
    public void addResource(PathAddress relativeAddress, int index, Resource toAdd) {
        assert (index >= 0) : "index must be 0 or greater";
        this.addResourceInternal(relativeAddress, index, toAdd);
    }

    private void addResourceInternal(PathAddress relativeAddress, int index, Resource toAdd) {
        this.readOnly = false;
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        PathAddress absoluteAddress = this.activeStep.address.append(relativeAddress);
        if (absoluteAddress.size() == 0) {
            throw ControllerLogger.ROOT_LOGGER.duplicateResourceAddress(absoluteAddress);
        }
        boolean runtimeOnly = toAdd.isRuntime();
        if (!runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(absoluteAddress);
        this.authorizeAdd(runtimeOnly);
        this.ensureLocalRootResource();
        this.affectsModel.put(absoluteAddress, NULL);
        Resource model = this.managementModel.getRootResource();
        Iterator i = absoluteAddress.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotWriteTo("*");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (model.hasChild(element)) {
                    throw ControllerLogger.ROOT_LOGGER.duplicateResourceAddress(absoluteAddress);
                }
                PathAddress parent = absoluteAddress.subAddress(0, absoluteAddress.size() - 1);
                Set<String> childrenNames = this.managementModel.getRootResourceRegistration().getChildNames(parent);
                if (!childrenNames.contains(key)) {
                    throw ControllerLogger.ROOT_LOGGER.noChildType(key);
                }
                if (index < 0) {
                    model.registerChild(element, toAdd);
                } else {
                    model.registerChild(element, index, toAdd);
                }
                model = toAdd;
                continue;
            }
            if ((model = model.getChild(element)) != null) continue;
            PathAddress ancestor = PathAddress.EMPTY_ADDRESS;
            for (PathElement pe : absoluteAddress) {
                ancestor = ancestor.append(pe);
                if (!element.equals(pe)) continue;
                break;
            }
            throw ControllerLogger.ROOT_LOGGER.resourceNotFound(ancestor, absoluteAddress);
        }
        Notification notification = new Notification("resource-added", absoluteAddress, ControllerLogger.ROOT_LOGGER.resourceWasAdded(absoluteAddress));
        this.emit(notification);
    }

    @Override
    public Resource removeResource(PathAddress requestAddress) {
        this.readOnly = false;
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        PathAddress address = this.activeStep.address.append(requestAddress);
        boolean runtimeOnly = this.isResourceRuntimeOnly(address);
        if (!runtimeOnly) {
            this.rejectUserDomainServerUpdates();
        }
        this.checkHostServerGroupTracker(address);
        this.authorize(false, runtimeOnly ? READ_WRITE_RUNTIME : READ_WRITE_CONFIG);
        this.ensureLocalRootResource();
        this.affectsModel.put(address, NULL);
        Resource model = this.managementModel.getRootResource();
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerLogger.ROOT_LOGGER.cannotRemove("*");
            }
            if (!i.hasNext()) {
                model = model.removeChild(element);
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        Notification notification = new Notification("resource-removed", address, ControllerLogger.ROOT_LOGGER.resourceWasRemoved(address));
        this.emit(notification);
        return model;
    }

    @Override
    public void acquireControllerLock() {
        this.takeWriteLock();
    }

    @Override
    public boolean isModelAffected() {
        return this.affectsResourceTree;
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.affectsRuntime;
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.affectsResourceRegistration;
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        try {
            if (this.messageHandler != null) {
                this.messageHandler.handleReport(severity, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    void handleUncaughtException(RuntimeException e) {
        try {
            if (this.lockStep != null) {
                this.releaseModelControllerLock();
            }
        }
        finally {
            if (this.containerMonitorStep != null) {
                this.resetContainerStateChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseStepLocks(AbstractOperationContext.Step step) {
        boolean interrupted = false;
        try {
            if (this.containerMonitorStep == step) {
                long timeout = this.getBlockingTimeout().getLocalBlockingTimeout();
                try {
                    this.modelController.awaitContainerStability(timeout, TimeUnit.MILLISECONDS, false);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.modelController.containerCannotStabilize();
                    ControllerLogger.MGMT_OP_LOGGER.interruptedWaitingStability(this.activeStep.operationId.name, this.activeStep.operationId.address);
                }
                catch (TimeoutException te) {
                    this.modelController.containerCannotStabilize();
                    ControllerLogger.MGMT_OP_LOGGER.timeoutCompletingOperation(timeout / 1000L, this.activeStep.operationId.name, this.activeStep.operationId.address);
                    ThreadDumpUtil.threadDump();
                }
            }
            if (this.lockStep == step) {
                this.releaseModelControllerLock();
            }
        }
        finally {
            try {
                if (this.containerMonitorStep == step) {
                    this.notifyModificationsComplete();
                    this.resetContainerStateChanges();
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void releaseModelControllerLock() {
        this.modelController.releaseWriteLock(this.operationId);
        this.exclusiveStartTime = -1L;
        this.lockStep = null;
    }

    private void resetContainerStateChanges() {
        this.modelController.logContainerStateChangesAndReset();
        this.containerMonitorStep = null;
    }

    @Override
    boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    ManagementResourceRegistration getRootResourceRegistrationForUpdate() {
        return this.getMutableResourceRegistration(null);
    }

    private static Resource requireChild(Resource resource, PathElement childPath, PathAddress fullAddress) {
        if (resource.hasChild(childPath)) {
            return resource.requireChild(childPath);
        }
        PathAddress missing = PathAddress.EMPTY_ADDRESS;
        for (PathElement search : fullAddress) {
            missing = missing.append(search);
            if (!search.equals(childPath)) continue;
            break;
        }
        throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(missing);
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.modelController.resolveExpressions(node, this);
    }

    public <V> V getAttachment(OperationContext.AttachmentKey<V> key) {
        return this.contextAttachments.getAttachment(key);
    }

    @Override
    void logAuditRecord() {
        super.logAuditRecord();
    }

    public <V> V attach(OperationContext.AttachmentKey<V> key, V value) {
        return this.contextAttachments.attach(key, value);
    }

    public <V> V attachIfAbsent(OperationContext.AttachmentKey<V> key, V value) {
        return this.contextAttachments.attachIfAbsent(key, value);
    }

    public <V> V detach(OperationContext.AttachmentKey<V> key) {
        return this.contextAttachments.detach(key);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation) {
        return this.authorize(operation, EnumSet.noneOf(Action.ActionEffect.class));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, Set<Action.ActionEffect> effects) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        return this.authorize(opId, operation, false, effects);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue) {
        return this.authorize(operation, attribute, currentValue, EnumSet.noneOf(Action.ActionEffect.class));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue, Set<Action.ActionEffect> effects) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult resourceResult = this.authorize(opId, operation, false, effects);
        if (resourceResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return resourceResult;
        }
        return this.authorize(opId, attribute, currentValue, effects);
    }

    @Override
    public AuthorizationResponseImpl authorizeResource(boolean attributes, boolean isDefaultResponse) {
        AbstractOperationContext.OperationId opId;
        AuthorizationResponseImpl authResp;
        ModelNode op = new ModelNode();
        op.get("operation").set(isDefaultResponse ? "check-default-resource-access" : "check-resource-access");
        op.get("address").set(this.activeStep.operation.get("address"));
        if (this.activeStep.operation.hasDefined("operation-headers")) {
            op.get("operation-headers").set(this.activeStep.operation.get("operation-headers"));
        }
        if ((authResp = this.authorizations.get(opId = new AbstractOperationContext.OperationId(op))) == null) {
            authResp = this.getBasicAuthorizationResponse(opId, op);
        }
        if (authResp == null) {
            return null;
        }
        Environment callEnvironment = this.getCallEnvironment();
        if (authResp.getResourceResult(Action.ActionEffect.ADDRESS) == null) {
            Action action = authResp.standardAction.limitAction(Action.ActionEffect.ADDRESS);
            authResp.addResourceResult(Action.ActionEffect.ADDRESS, this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), callEnvironment, action, authResp.targetResource));
        }
        if (authResp.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() == AuthorizationResult.Decision.PERMIT) {
            for (Action.ActionEffect requiredEffect : ALL_READ_WRITE) {
                AuthorizationResult effectResult = authResp.getResourceResult(requiredEffect);
                if (effectResult != null) continue;
                Action action = authResp.standardAction.limitAction(requiredEffect);
                effectResult = this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), callEnvironment, action, authResp.targetResource);
                authResp.addResourceResult(requiredEffect, effectResult);
            }
        }
        if (attributes) {
            ImmutableManagementResourceRegistration mrr = authResp.targetResource.getResourceRegistration();
            if (!authResp.attributesComplete) {
                for (String attr : mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
                    TargetAttribute targetAttribute = null;
                    if (authResp.getAttributeResult(attr, Action.ActionEffect.ADDRESS) == null) {
                        authResp.addAttributeResult(attr, Action.ActionEffect.ADDRESS, AuthorizationResult.PERMITTED);
                    }
                    for (Action.ActionEffect actionEffect : ALL_READ_WRITE) {
                        AuthorizationResult authResult = authResp.getAttributeResult(attr, actionEffect);
                        if (authResult != null) continue;
                        Action action = authResp.standardAction.limitAction(actionEffect);
                        if (targetAttribute == null) {
                            targetAttribute = this.createTargetAttribute(authResp, attr, isDefaultResponse);
                        }
                        authResult = this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), callEnvironment, action, targetAttribute);
                        authResp.addAttributeResult(attr, actionEffect, authResult);
                    }
                }
                authResp.attributesComplete = true;
            }
        }
        return authResp;
    }

    @Override
    Resource getModel() {
        return this.managementModel.getRootResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OperationContext.ResultAction executeOperation() {
        try {
            if (!this.isBooting()) {
                this.attach((OperationContext.AttachmentKey)BlockingTimeout.Factory.ATTACHMENT_KEY, (V)this.getBlockingTimeout());
            }
            OperationContext.ResultAction resultAction = super.executeOperation();
            return resultAction;
        }
        finally {
            try {
                try {
                    for (ContextServiceTarget serviceTarget : this.serviceTargets) {
                        serviceTarget.done();
                    }
                    this.serviceTargets.clear();
                }
                catch (Throwable throwable) {
                    for (OperationContextServiceRegistry serviceRegistry : this.serviceRegistries) {
                        serviceRegistry.done();
                    }
                    this.serviceRegistries.clear();
                    throw throwable;
                }
                for (OperationContextServiceRegistry serviceRegistry : this.serviceRegistries) {
                    serviceRegistry.done();
                }
                this.serviceRegistries.clear();
            }
            finally {
                BooleanHolder booleanHolder = this.done;
                synchronized (booleanHolder) {
                    if (this.done.done) {
                        Thread.interrupted();
                    } else {
                        this.done.done = true;
                    }
                }
            }
        }
    }

    private TargetAttribute createTargetAttribute(AuthorizationResponseImpl authResp, String attributeName, boolean isDefaultResponse) {
        ModelNode model = authResp.targetResource.getResource().getModel();
        ModelNode currentValue = isDefaultResponse ? new ModelNode() : (model.has(attributeName) ? model.get(attributeName) : new ModelNode());
        AttributeAccess attributeAccess = authResp.targetResource.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        return new TargetAttribute(attributeName, attributeAccess, currentValue, authResp.targetResource);
    }

    @Override
    public AuthorizationResult authorizeOperation(ModelNode operation) {
        AbstractOperationContext.OperationId opId = new AbstractOperationContext.OperationId(operation);
        AuthorizationResult resourceResult = this.authorize(opId, operation, false, EnumSet.of(Action.ActionEffect.ADDRESS));
        if (resourceResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return resourceResult;
        }
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        String operationName = operation.require("operation").asString();
        AuthorizationResponseImpl authResp = this.authorizations.get(opId);
        assert (authResp != null) : "perform resource authorization before operation authorization";
        AuthorizationResult authResult = authResp.getOperationResult(operationName);
        if (authResult == null) {
            OperationEntry operationEntry = authResp.targetResource.getResourceRegistration().getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            operation.get("operation-headers").set(this.activeStep.operation.get("operation-headers"));
            Action targetAction = new Action(operation, operationEntry);
            authResult = this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), this.getCallEnvironment(), targetAction, authResp.targetResource);
            authResp.addOperationResult(operationName, authResult);
            if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT && operationName.equals("add")) {
                if (!authResp.attributesComplete) {
                    authResp = this.authorizeResource(true, false);
                    authResp.addOperationResult(operationName, authResult);
                }
                authResult = authResp.validateAddAttributeEffects("add", targetAction.getActionEffects(), this.activeStep.operation);
            }
        }
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            return authResult;
        }
        return AuthorizationResult.PERMITTED;
    }

    @Override
    public void registerCapability(RuntimeCapability capability) {
        this.registerCapability(capability, this.activeStep, null);
    }

    void registerCapability(RuntimeCapability<?> capability, AbstractOperationContext.Step step, String attribute) {
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        this.ensureLocalCapabilityRegistry();
        RuntimeCapabilityRegistration registration = this.createCapabilityRegistration(capability, step, attribute);
        this.managementModel.getCapabilityRegistry().registerCapability(registration);
        for (String required : capability.getRequirements()) {
            RuntimeRequirementRegistration requirementRegistration = this.createRequirementRegistration(required, capability.getName(), false, step, attribute);
            this.recordRequirement(requirementRegistration, step);
        }
    }

    @Override
    public void registerAdditionalCapabilityRequirement(String required, String dependent, String attribute) {
        this.registerAdditionalCapabilityRequirement(required, dependent, this.activeStep, attribute);
    }

    void registerAdditionalCapabilityRequirement(String required, String dependent, AbstractOperationContext.Step step, String attribute) {
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        this.ensureLocalCapabilityRegistry();
        RuntimeRequirementRegistration requirementRegistration = this.createRequirementRegistration(required, dependent, false, step, attribute);
        this.managementModel.getCapabilityRegistry().registerAdditionalCapabilityRequirement(requirementRegistration);
        this.recordRequirement(requirementRegistration, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordRequirement(RuntimeRequirementRegistration reg, AbstractOperationContext.Step step) {
        Set existing;
        Set<AbstractOperationContext.Step> dependents = (HashSet<AbstractOperationContext.Step>)this.addedRequirements.get(reg);
        if (dependents == null && (existing = (Set)this.addedRequirements.putIfAbsent(reg, dependents = new HashSet<AbstractOperationContext.Step>())) != null) {
            dependents = existing;
        }
        HashSet<AbstractOperationContext.Step> hashSet = dependents;
        synchronized (hashSet) {
            dependents.add(step);
        }
    }

    @Override
    public boolean hasOptionalCapability(String required, String dependent, String attribute) {
        return this.requestOptionalCapability(required, dependent, true, this.activeStep, attribute);
    }

    boolean requestOptionalCapability(String required, String dependent, boolean runtimeOnly, AbstractOperationContext.Step step, String attribute) {
        assert (this.isControllingThread());
        OperationContextImpl.assertCapabilitiesAvailable(this.currentStage);
        this.ensureLocalCapabilityRegistry();
        RuntimeCapabilityRegistry registry = this.managementModel.getCapabilityRegistry();
        if (dependent == null) {
            assert (runtimeOnly);
            CapabilityScope context = this.createCapabilityContext(step.address);
            return registry.hasCapability(required, context);
        }
        RuntimeRequirementRegistration registration = this.createRequirementRegistration(required, dependent, runtimeOnly, step, attribute);
        CapabilityScope context = registration.getDependentContext();
        if (registry.hasCapability(required, context)) {
            registry.registerAdditionalCapabilityRequirement(registration);
            this.recordRequirement(registration, step);
            return true;
        }
        return false;
    }

    @Override
    public void requireOptionalCapability(String required, String dependent, String attribute) throws OperationFailedException {
        this.requireOptionalCapability(required, dependent, this.activeStep, attribute);
    }

    void requireOptionalCapability(String required, String dependent, AbstractOperationContext.Step step, String attribute) throws OperationFailedException {
        if (!this.requestOptionalCapability(required, dependent, false, step, attribute)) {
            Object msg = ControllerLogger.ROOT_LOGGER.requiredCapabilityMissing();
            msg = this.getProcessType().isServer() ? (String)msg + "\n" + ControllerLogger.ROOT_LOGGER.formattedCapabilityName(required) : "\n" + ControllerLogger.ROOT_LOGGER.formattedCapabilityId(required, this.createCapabilityContext(step.address).getName());
            throw new OperationFailedException((String)msg);
        }
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent) {
        this.deregisterCapabilityRequirement(required, dependent, null);
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent, String attribute) {
        this.removeCapabilityRequirement(required, dependent, this.activeStep, attribute);
    }

    void removeCapabilityRequirement(String required, String dependent, AbstractOperationContext.Step step, String attributeName) {
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        this.ensureLocalCapabilityRegistry();
        RuntimeRequirementRegistration registration = this.createRequirementRegistration(required, dependent, false, step, attributeName);
        this.managementModel.getCapabilityRegistry().removeCapabilityRequirement(registration);
        this.removeRequirement(required, registration.getDependentContext(), step);
    }

    @Override
    public void deregisterCapability(String capability) {
        this.removeCapability(capability, this.activeStep);
    }

    void removeCapability(String capabilityName, AbstractOperationContext.Step step) {
        assert (this.isControllingThread());
        OperationContextImpl.assertStageModel(this.currentStage);
        this.ensureLocalCapabilityRegistry();
        CapabilityScope context = this.createCapabilityContext(step.address);
        RuntimeCapabilityRegistration capReg = this.managementModel.getCapabilityRegistry().removeCapability(capabilityName, context, step.address);
        if (capReg != null) {
            RuntimeCapability capability = (RuntimeCapability)capReg.getCapability();
            for (String required : capability.getRequirements()) {
                this.removeRequirement(required, context, step);
            }
            this.removedCapabilities.put(capReg.getCapabilityId(), step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequirement(String required, CapabilityScope context, AbstractOperationContext.Step step) {
        CapabilityId id = new CapabilityId(required, context);
        Set dependents = (Set)this.addedRequirements.get(id);
        if (dependents != null) {
            Set set = dependents;
            synchronized (set) {
                dependents.remove(step);
            }
        }
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, Class<T> apiType) {
        return this.getCapabilityRuntimeAPI(capabilityName, apiType, this.activeStep);
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityBaseName, String dynamicPart, Class<T> apiType) {
        return this.getCapabilityRuntimeAPI(RuntimeCapability.buildDynamicCapabilityName(capabilityBaseName, dynamicPart), apiType, this.activeStep);
    }

    <T> T getCapabilityRuntimeAPI(String capabilityName, Class<T> apiType, AbstractOperationContext.Step step) {
        assert (this.isControllingThread());
        OperationContextImpl.assertCapabilitiesAvailable(this.currentStage);
        CapabilityScope context = this.createCapabilityContext(step.address);
        return this.managementModel.getCapabilityRegistry().getCapabilityRuntimeAPI(capabilityName, context, apiType);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType) {
        return this.getCapabilityServiceName(capabilityName, serviceType, this.activeStep.address);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, String dynamicPart, Class<?> serviceType) {
        return this.getCapabilityServiceName(capabilityBaseName, serviceType, dynamicPart);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, Class<?> serviceType, String ... dynamicParts) {
        return this.getCapabilityServiceName(capabilityBaseName, serviceType).append(dynamicParts);
    }

    ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType, PathAddress address) {
        assert (this.isControllingThread());
        OperationContextImpl.assertCapabilitiesAvailable(this.currentStage);
        CapabilityScope context = this.createCapabilityContext(address);
        try {
            return this.managementModel.getCapabilityRegistry().getCapabilityServiceName(capabilityName, context, serviceType);
        }
        catch (IllegalStateException illegalStateException) {
            ControllerLogger.ROOT_LOGGER.debugf("OperationContext: Parsing ServiceName for %s", capabilityName);
            return ServiceNameFactory.parseServiceName(capabilityName);
        }
    }

    private void rejectUserDomainServerUpdates() {
        ModelNode op;
        if (this.isModelUpdateRejectionRequired() && (op = this.activeStep.operation).hasDefined(new String[]{"operation-headers", "caller-type"}) && "user".equals(op.get(new String[]{"operation-headers", "caller-type"}).asString())) {
            throw ControllerLogger.ROOT_LOGGER.modelUpdateNotAuthorized(op.require("operation").asString(), this.activeStep.address);
        }
    }

    @Override
    public CapabilityServiceSupport getCapabilityServiceSupport() {
        assert (this.isControllingThread());
        OperationContextImpl.assertCapabilitiesAvailable(this.currentStage);
        return new CapabilityServiceSupportImpl(this.managementModel);
    }

    @Override
    RuntimeCapabilityRegistry.RuntimeStatus getStepCapabilityStatus(AbstractOperationContext.Step step) {
        RuntimeCapabilityRegistry.RuntimeStatus result = RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
        Map<CapabilityId, RuntimeCapabilityRegistry.RuntimeStatus> statuses = this.managementModel.getCapabilityRegistry().getRuntimeStatus(step.address, step.getManagementResourceRegistration(this.managementModel));
        if (!statuses.isEmpty()) {
            for (RuntimeCapabilityRegistry.RuntimeStatus status : statuses.values()) {
                if (status == RuntimeCapabilityRegistry.RuntimeStatus.NORMAL) continue;
                result = status;
                break;
            }
        }
        return result;
    }

    private boolean isModelUpdateRejectionRequired() {
        if (this.requiresModelUpdateAuthorization == null) {
            this.requiresModelUpdateAuthorization = !this.isBooting() && this.getProcessType() == ProcessType.DOMAIN_SERVER;
        }
        return this.requiresModelUpdateAuthorization;
    }

    private void authorize(boolean allAttributes, Set<Action.ActionEffect> actionEffects) {
        AuthorizationResult accessResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, false, ADDRESS);
        if (accessResult.getDecision() == AuthorizationResult.Decision.DENY) {
            if (this.activeStep.address.size() > 0) {
                throw new ResourceNotAddressableException(this.activeStep.address);
            }
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, accessResult.getExplanation());
        }
        AuthorizationResult authResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, allAttributes, actionEffects);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
        }
    }

    private void authorizeAdd(boolean runtimeOnly) {
        AuthorizationResult accessResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, false, ADDRESS);
        if (accessResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw new ResourceNotAddressableException(this.activeStep.address);
        }
        Set<Action.ActionEffect> writeEffect = runtimeOnly ? WRITE_RUNTIME : WRITE_CONFIG;
        AuthorizationResult authResult = this.authorize(this.activeStep.operationId, this.activeStep.operation, true, writeEffect);
        if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
            AuthorizationResponseImpl authResp = this.authorizations.get(this.activeStep.operationId);
            assert (authResp != null) : "no AuthorizationResponse";
            String opName = this.activeStep.operation.get("operation").asString();
            authResp.addOperationResult(opName, authResult);
            authResult = authResp.validateAddAttributeEffects(opName, writeEffect, this.activeStep.operation);
            authResp.addOperationResult(opName, authResult);
            if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
                throw ControllerLogger.ROOT_LOGGER.unauthorized(this.activeStep.operationId.name, this.activeStep.address, authResult.getExplanation());
            }
        }
    }

    private AuthorizationResult authorize(AbstractOperationContext.OperationId opId, ModelNode operation, boolean allAttributes, Set<Action.ActionEffect> actionEffects) {
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        AuthorizationResponseImpl authResp = this.authorizations.get(opId);
        if (authResp == null) {
            authResp = this.getBasicAuthorizationResponse(opId, operation);
        }
        if (authResp == null) {
            return AuthorizationResult.PERMITTED;
        }
        for (Action.ActionEffect requiredEffect : actionEffects) {
            AuthorizationResult effectResult = authResp.getResourceResult(requiredEffect);
            if (effectResult == null) {
                Action action = authResp.standardAction.limitAction(requiredEffect);
                effectResult = this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), this.getCallEnvironment(), action, authResp.targetResource);
                authResp.addResourceResult(requiredEffect, effectResult);
            }
            if (effectResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
            return effectResult;
        }
        AuthorizationResult errResult = null;
        if (allAttributes) {
            ImmutableManagementResourceRegistration mrr = authResp.targetResource.getResourceRegistration();
            ModelNode model = authResp.targetResource.getResource().getModel();
            Set<Action.ActionEffect> attributeEffects = actionEffects.isEmpty() ? authResp.standardAction.getActionEffects() : actionEffects;
            Iterator<String> iterator = mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS).iterator();
            while (iterator.hasNext()) {
                String attr;
                ModelNode currentValue = model.has(attr = iterator.next()) ? model.get(attr) : new ModelNode();
                AuthorizationResult attrResult = this.authorize(opId, attr, currentValue, attributeEffects);
                if (attrResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
                errResult = attrResult;
            }
            authResp.attributesComplete = true;
        }
        return errResult != null ? errResult : AuthorizationResult.PERMITTED;
    }

    private AuthorizationResult authorize(AbstractOperationContext.OperationId operationId, String attribute, ModelNode currentValue, Set<Action.ActionEffect> actionEffects) {
        if (this.isBooting()) {
            return AuthorizationResult.PERMITTED;
        }
        AuthorizationResponseImpl authResp = this.authorizations.get(operationId);
        assert (authResp != null) : "perform resource authorization before attribute authorization";
        TargetAttribute targetAttribute = null;
        Set<Action.ActionEffect> attributeEffects = actionEffects.isEmpty() ? authResp.standardAction.getActionEffects() : actionEffects;
        for (Action.ActionEffect actionEffect : attributeEffects) {
            AuthorizationResult authResult = authResp.getAttributeResult(attribute, actionEffect);
            if (authResult == null) {
                Action action = authResp.standardAction.limitAction(actionEffect);
                if (targetAttribute == null) {
                    AttributeAccess attributeAccess = authResp.targetResource.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attribute);
                    targetAttribute = new TargetAttribute(attribute, attributeAccess, currentValue, authResp.targetResource);
                }
                authResult = this.modelController.getAuthorizer().authorize(this.getSecurityIdentity(), this.getCallEnvironment(), action, targetAttribute);
                authResp.addAttributeResult(attribute, actionEffect, authResult);
            }
            if (authResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
            return authResult;
        }
        return AuthorizationResult.PERMITTED;
    }

    private AuthorizationResponseImpl getBasicAuthorizationResponse(AbstractOperationContext.OperationId opId, ModelNode operation) {
        TargetResource targetResource;
        SecurityIdentity identity = this.getSecurityIdentity();
        ManagementResourceRegistration mrr = this.managementModel.getRootResourceRegistration().getSubModel(opId.address);
        if (mrr == null) {
            return null;
        }
        Action action = this.getAuthorizationAction(mrr, opId.name, operation);
        if (action == null) {
            return null;
        }
        Resource resource = this.getAuthorizationResource(opId.address);
        ProcessType processType = this.getProcessType();
        if (processType.isManagedDomain()) {
            HostServerGroupTracker.HostServerGroupEffect hostServerGroupEffect;
            if (processType.isServer()) {
                ModelNode rootModel = this.managementModel.getRootResource().getModel();
                String serverGroup = rootModel.get("server-group").asString();
                String host = rootModel.get("host").asString();
                hostServerGroupEffect = HostServerGroupTracker.HostServerGroupEffect.forServer(opId.address, serverGroup, host);
            } else {
                hostServerGroupEffect = this.hostServerGroupTracker.getHostServerGroupEffects(opId.address, operation, this.managementModel.getRootResource());
            }
            targetResource = TargetResource.forDomain(opId.address, mrr, resource, hostServerGroupEffect, hostServerGroupEffect);
        } else {
            targetResource = TargetResource.forStandalone(opId.address, mrr, resource);
        }
        AuthorizationResponseImpl result = new AuthorizationResponseImpl(action, targetResource);
        AuthorizationResult simple = this.modelController.getAuthorizer().authorize(identity, this.getCallEnvironment(), action, targetResource);
        if (simple.getDecision() == AuthorizationResult.Decision.PERMIT) {
            for (Action.ActionEffect actionEffect : action.getActionEffects()) {
                result.addResourceResult(actionEffect, simple);
            }
        }
        this.authorizations.put(opId, result);
        return result;
    }

    private Resource getAuthorizationResource(PathAddress address) {
        Resource model = this.managementModel.getRootResource();
        for (PathElement element : address) {
            if (element.isWildcard()) {
                model = Resource.Factory.create();
                Set<Resource.ResourceEntry> children = model.getChildren(element.getKey());
                for (Resource.ResourceEntry entry : children) {
                    model.registerChild(entry.getPathElement(), entry);
                }
                continue;
            }
            if ((model = model.getChild(element)) != null) continue;
            return Resource.Factory.create();
        }
        return model;
    }

    private Action getAuthorizationAction(ImmutableManagementResourceRegistration mrr, String operationName, ModelNode operation) {
        OperationEntry entry = mrr.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
        if (entry == null) {
            return null;
        }
        return new Action(operation, entry);
    }

    private void checkHostServerGroupTracker(PathAddress pathAddress) {
        String key0;
        if (this.hostServerGroupTracker != null && !this.isBooting() && pathAddress.size() > 0 && ("server-group".equals(key0 = pathAddress.getElement(0).getKey()) || pathAddress.size() > 1 && "host".equals(key0) && "server-config".equals(pathAddress.getElement(1).getKey()))) {
            this.hostServerGroupTracker = new HostServerGroupTracker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingTimeout getBlockingTimeout() {
        if (this.blockingTimeout == null) {
            OperationContextImpl operationContextImpl = this;
            synchronized (operationContextImpl) {
                if (this.blockingTimeout == null) {
                    this.blockingTimeout = new BlockingTimeoutImpl(this.operationHeaders.getBlockingTimeout());
                }
            }
        }
        return this.blockingTimeout;
    }

    private synchronized void ensureLocalRootResource() {
        if (!this.affectsResourceTree) {
            this.takeWriteLock();
            this.managementModel = this.managementModel.cloneRootResource();
            this.affectsResourceTree = true;
        }
    }

    private synchronized void ensureLocalManagementResourceRegistration() {
        if (!this.affectsResourceRegistration) {
            this.takeWriteLock();
            this.affectsResourceRegistration = true;
        }
    }

    private synchronized void ensureLocalCapabilityRegistry() {
        if (!this.affectsCapabilityRegistry) {
            this.takeWriteLock();
            this.affectsCapabilityRegistry = true;
        }
    }

    private boolean isRuntimeChangeAllowed() {
        OperationContextImpl.assertNotComplete(this.currentStage);
        boolean validStage = this.currentStage == OperationContext.Stage.RUNTIME || this.currentStage == OperationContext.Stage.VERIFY || this.isRollingBack();
        return validStage && (this.getProcessType().isServer() || this.activeStep == null || this.activeStep.address.size() < 2 || !"profile".equals(this.activeStep.address.getElement(0).getKey()));
    }

    private static void assertNotComplete(OperationContext.Stage currentStage) {
        if (currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
    }

    private static void assertStageModel(OperationContext.Stage currentStage) {
        OperationContextImpl.assertNotComplete(currentStage);
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
    }

    private static void assertCapabilitiesAvailable(OperationContext.Stage currentStage) {
        OperationContextImpl.assertNotComplete(currentStage);
        if (currentStage == OperationContext.Stage.MODEL) {
            throw ControllerLogger.ROOT_LOGGER.capabilitiesNotAvailable(currentStage, OperationContext.Stage.RUNTIME);
        }
    }

    private RuntimeRequirementRegistration createRequirementRegistration(String required, String dependent, boolean runtimeOnly, AbstractOperationContext.Step step, String attribute) {
        CapabilityScope context = this.createCapabilityContext(step.address);
        RegistrationPoint rp = new RegistrationPoint(step.address, attribute);
        return new RuntimeRequirementRegistration(required, dependent, context, rp, runtimeOnly);
    }

    private RuntimeCapabilityRegistration createCapabilityRegistration(RuntimeCapability<?> capability, AbstractOperationContext.Step step, String attribute) {
        CapabilityScope context = this.createCapabilityContext(step.address);
        RegistrationPoint rp = new RegistrationPoint(step.address, attribute);
        return new RuntimeCapabilityRegistration(capability, context, rp);
    }

    private CapabilityScope createCapabilityContext(PathAddress address) {
        return CapabilityScope.Factory.create(this.getProcessType(), address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ServiceController<T> installService(ServiceBuilder<T> builder, ServiceName name, AbstractOperationContext.Step step) throws ServiceRegistryException, IllegalStateException {
        Map<ServiceName, ServiceController<?>> map = this.realRemovingControllers;
        synchronized (map) {
            ServiceController serviceController;
            block12: {
                boolean intr = false;
                try {
                    long timeout;
                    boolean containsKey = this.realRemovingControllers.containsKey(name);
                    long waitTime = timeout = (long)this.getBlockingTimeout().getLocalBlockingTimeout();
                    long end = System.currentTimeMillis() + waitTime;
                    while (containsKey && waitTime > 0L) {
                        block11: {
                            try {
                                this.realRemovingControllers.wait(waitTime);
                            }
                            catch (InterruptedException e) {
                                intr = true;
                                if (!this.respectInterruption) break block11;
                                this.cancelled = true;
                                throw ControllerLogger.ROOT_LOGGER.serviceInstallCancelled();
                            }
                        }
                        containsKey = this.realRemovingControllers.containsKey(name);
                        waitTime = end - System.currentTimeMillis();
                    }
                    if (containsKey) {
                        throw ControllerLogger.ROOT_LOGGER.serviceInstallTimedOut(timeout / 1000L, name);
                    }
                    this.removalSteps.remove(name);
                    ServiceController controller = builder.install();
                    step.serviceAdded(controller);
                    serviceController = controller;
                    if (!intr) break block12;
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            return serviceController;
        }
    }

    private static class CapabilityServiceBuilderImpl<T>
    extends DelegatingServiceBuilder<T>
    implements CapabilityServiceBuilder<T> {
        private final PathAddress targetAddress;

        CapabilityServiceBuilderImpl(ServiceBuilder<T> delegate, PathAddress targetAddress) {
            super(delegate);
            this.targetAddress = targetAddress;
        }

        @Override
        public <I> CapabilityServiceBuilder<T> addCapabilityRequirement(String capabilityBaseName, Class<I> serviceType, Injector<I> target, String ... referenceNames) {
            String capabilityName = RuntimeCapability.buildDynamicCapabilityName(capabilityBaseName, referenceNames);
            ServiceName serviceName = this.getCapabilityServiceName(capabilityName, serviceType);
            this.addDependency(serviceName, serviceType, target);
            return this;
        }

        @Override
        public <I> CapabilityServiceBuilder<T> addCapabilityRequirement(String capabilityName, Class<I> type, Injector<I> target) {
            ServiceName serviceName = this.getCapabilityServiceName(capabilityName, type);
            this.addDependency(serviceName, type, target);
            return this;
        }

        @Override
        public <I> CapabilityServiceBuilder<T> addCapabilityRequirement(String capabilityName, Class<I> type) {
            ServiceName serviceName = this.getCapabilityServiceName(capabilityName, type);
            this.requires(serviceName);
            return this;
        }

        @Override
        public CapabilityServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            super.setInitialMode(mode);
            return this;
        }

        @Override
        public CapabilityServiceBuilder<T> setInstance(org.jboss.msc.Service service) {
            super.setInstance(service);
            return this;
        }

        @Override
        public <V> Consumer<V> provides(RuntimeCapability<?> ... capabilities) {
            Assert.checkNotEmptyParam((String)"capabilities", (Object[])capabilities);
            return this.provides(capabilities, (ServiceName[])null);
        }

        @Override
        public <V> Consumer<V> provides(RuntimeCapability<?> capability, ServiceName alias, ServiceName ... aliases) {
            Assert.checkNotNullParam((String)"capability", capability);
            Assert.checkNotNullParam((String)"alias", (Object)alias);
            int aliasesLength = aliases == null ? 0 : aliases.length;
            ServiceName[] serviceNames = new ServiceName[2 + aliasesLength];
            serviceNames[0] = capability.isDynamicallyNamed() ? capability.getCapabilityServiceName(this.targetAddress) : capability.getCapabilityServiceName();
            serviceNames[1] = alias;
            for (int i = 0; i < aliasesLength; ++i) {
                serviceNames[i + 2] = aliases[i];
            }
            return super.provides(serviceNames);
        }

        @Override
        public <V> Consumer<V> provides(RuntimeCapability<?>[] capabilities, ServiceName[] aliases) {
            int i;
            if (capabilities == null || capabilities.length == 0) {
                Assert.checkNotEmptyParam((String)"aliases", (Object[])aliases);
            }
            if (capabilities == null || capabilities.length == 0) {
                return super.provides(aliases);
            }
            if (aliases == null || aliases.length == 0) {
                ServiceName[] serviceNames = new ServiceName[capabilities.length];
                for (int i2 = 0; i2 < capabilities.length; ++i2) {
                    Assert.checkNotNullArrayParam((String)"capabilities", (int)i2, capabilities[i2]);
                    serviceNames[i2] = capabilities[i2].isDynamicallyNamed() ? capabilities[i2].getCapabilityServiceName(this.targetAddress) : capabilities[i2].getCapabilityServiceName();
                }
                return super.provides(serviceNames);
            }
            ServiceName[] serviceNames = new ServiceName[capabilities.length + aliases.length];
            for (i = 0; i < capabilities.length; ++i) {
                Assert.checkNotNullArrayParam((String)"capabilities", (int)i, capabilities[i]);
                serviceNames[i] = capabilities[i].isDynamicallyNamed() ? capabilities[i].getCapabilityServiceName(this.targetAddress) : capabilities[i].getCapabilityServiceName();
            }
            for (i = 0; i < aliases.length; ++i) {
                serviceNames[i + capabilities.length] = (ServiceName)Assert.checkNotNullArrayParam((String)"aliases", (int)i, (Object)aliases[i]);
            }
            return super.provides(serviceNames);
        }

        @Override
        public <V> Supplier<V> requiresCapability(String capabilityBaseName, Class<V> dependencyType, String ... referenceNames) {
            String capabilityName = referenceNames != null && referenceNames.length > 0 ? RuntimeCapability.buildDynamicCapabilityName(capabilityBaseName, referenceNames) : capabilityBaseName;
            ServiceName serviceName = this.getCapabilityServiceName(capabilityName, dependencyType);
            return this.requires(serviceName);
        }

        private ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType) {
            return this.getCapabilityServiceName(capabilityName, serviceType, this.targetAddress);
        }

        private ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType, PathAddress address) {
            return ((ContextServiceBuilder)this.getDelegate()).getCapabilityServiceName(capabilityName, serviceType, address);
        }
    }

    private static class CapabilityServiceSupportImpl
    implements CapabilityServiceSupport {
        private final ManagementModel managementModel;

        private CapabilityServiceSupportImpl(ManagementModel managementModel) {
            this.managementModel = managementModel;
        }

        @Override
        public boolean hasCapability(String capabilityName) {
            return this.managementModel.getCapabilityRegistry().hasCapability(capabilityName, CapabilityScope.GLOBAL);
        }

        @Override
        public <T> T getCapabilityRuntimeAPI(String capabilityName, Class<T> apiType) throws CapabilityServiceSupport.NoSuchCapabilityException {
            try {
                return this.managementModel.getCapabilityRegistry().getCapabilityRuntimeAPI(capabilityName, CapabilityScope.GLOBAL, apiType);
            }
            catch (IllegalStateException e) {
                throw new CapabilityServiceSupport.NoSuchCapabilityException(capabilityName);
            }
        }

        @Override
        public <T> T getCapabilityRuntimeAPI(String capabilityBaseName, String dynamicPart, Class<T> apiType) throws CapabilityServiceSupport.NoSuchCapabilityException {
            String fullName = RuntimeCapability.buildDynamicCapabilityName(capabilityBaseName, dynamicPart);
            return this.getCapabilityRuntimeAPI(fullName, apiType);
        }

        @Override
        public <T> Optional<T> getOptionalCapabilityRuntimeAPI(String capabilityName, Class<T> apiType) {
            try {
                return Optional.of(this.getCapabilityRuntimeAPI(capabilityName, apiType));
            }
            catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
                return Optional.empty();
            }
        }

        @Override
        public <T> Optional<T> getOptionalCapabilityRuntimeAPI(String capabilityBaseName, String dynamicPart, Class<T> apiType) {
            try {
                return Optional.of(this.getCapabilityRuntimeAPI(capabilityBaseName, dynamicPart, apiType));
            }
            catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
                return Optional.empty();
            }
        }

        @Override
        public ServiceName getCapabilityServiceName(String capabilityName) {
            try {
                return this.managementModel.getCapabilityRegistry().getCapabilityServiceName(capabilityName, CapabilityScope.GLOBAL, null);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                ControllerLogger.ROOT_LOGGER.debugf("CapabilityServiceSupport: Parsing ServiceName for %s", capabilityName);
                return ServiceNameFactory.parseServiceName(capabilityName);
            }
        }

        @Override
        public ServiceName getCapabilityServiceName(String capabilityBaseName, String ... dynamicPart) {
            return this.getCapabilityServiceName(capabilityBaseName).append(dynamicPart);
        }
    }

    private static class BooleanHolder {
        private boolean done = false;

        private BooleanHolder() {
        }
    }

    private class ActiveOperationResource
    extends PlaceholderResource.PlaceholderResourceEntry
    implements Cancellable {
        private ActiveOperationResource() {
            super("active-operation", OperationContextImpl.this.operationId.toString());
        }

        @Override
        public boolean isModelDefined() {
            return true;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            model.get("operation").set(OperationContextImpl.this.operationName);
            model.get("address").set(OperationContextImpl.this.operationAddress);
            model.get("caller-thread").set(OperationContextImpl.this.initiatingThread.getName());
            ModelNode accessMechanismNode = model.get("access-mechanism");
            ModelNode domainUUIDNode = model.get("domain-uuid");
            boolean domainRollout = false;
            if (OperationContextImpl.this.accessAuditContext != null) {
                String domainUUID;
                AccessMechanism accessMechanism = OperationContextImpl.this.accessAuditContext.getAccessMechanism();
                if (accessMechanism != null) {
                    accessMechanismNode.set(accessMechanism.toString());
                }
                if ((domainUUID = OperationContextImpl.this.accessAuditContext.getDomainUuid()) != null) {
                    domainUUIDNode.set(domainUUID);
                }
                domainRollout = OperationContextImpl.this.accessAuditContext.isDomainRollout();
            }
            model.get("domain-rollout").set(domainRollout);
            model.get("execution-status").set(this.getExecutionStatus());
            model.get("running-time").set(System.nanoTime() - OperationContextImpl.this.startTime);
            long exclusive = OperationContextImpl.this.exclusiveStartTime;
            if (exclusive > -1L) {
                exclusive = System.nanoTime() - exclusive;
            }
            model.get("exclusive-running-time").set(exclusive);
            model.get("cancelled").set(OperationContextImpl.this.cancelled);
            return model;
        }

        private String getExecutionStatus() {
            OperationContext.ExecutionStatus currentStatus = OperationContextImpl.this.executionStatus;
            if (currentStatus == OperationContext.ExecutionStatus.EXECUTING) {
                currentStatus = OperationContextImpl.this.resultAction == OperationContext.ResultAction.ROLLBACK ? OperationContext.ExecutionStatus.ROLLING_BACK : (OperationContextImpl.this.currentStage == OperationContext.Stage.DONE ? OperationContext.ExecutionStatus.COMPLETING : OperationContext.ExecutionStatus.EXECUTING);
            }
            return currentStatus.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            BooleanHolder booleanHolder = OperationContextImpl.this.done;
            synchronized (booleanHolder) {
                boolean canCancel;
                boolean bl = canCancel = !OperationContextImpl.this.done.done;
                if (canCancel) {
                    OperationContextImpl.this.done.done = true;
                    ControllerLogger.MGMT_OP_LOGGER.cancellingOperation(OperationContextImpl.this.operationName, OperationContextImpl.this.operationId, OperationContextImpl.this.initiatingThread.getName());
                    OperationContextImpl.this.initiatingThread.interrupt();
                }
                return canCancel;
            }
        }
    }

    private class AuthorizationResponseImpl
    implements ResourceAuthorization {
        private Map<Action.ActionEffect, AuthorizationResult> resourceResults = new HashMap<Action.ActionEffect, AuthorizationResult>();
        private Map<String, Map<Action.ActionEffect, AuthorizationResult>> attributeResults = new HashMap<String, Map<Action.ActionEffect, AuthorizationResult>>();
        private Map<String, AuthorizationResult> operationResults = new HashMap<String, AuthorizationResult>();
        private final TargetResource targetResource;
        private final Action standardAction;
        private volatile boolean attributesComplete = false;

        AuthorizationResponseImpl(Action standardAction, TargetResource targetResource) {
            this.standardAction = standardAction;
            this.targetResource = targetResource;
        }

        @Override
        public AuthorizationResult getResourceResult(Action.ActionEffect actionEffect) {
            return this.resourceResults.get((Object)actionEffect);
        }

        @Override
        public AuthorizationResult getAttributeResult(String attribute, Action.ActionEffect actionEffect) {
            Map<Action.ActionEffect, AuthorizationResult> attrResults = this.attributeResults.get(attribute);
            return attrResults == null ? null : attrResults.get((Object)actionEffect);
        }

        @Override
        public AuthorizationResult getOperationResult(String operationName) {
            return this.operationResults.get(operationName);
        }

        private void addResourceResult(Action.ActionEffect actionEffect, AuthorizationResult result) {
            this.resourceResults.put(actionEffect, result);
        }

        private void addAttributeResult(String attribute, Action.ActionEffect actionEffect, AuthorizationResult result) {
            Map<Action.ActionEffect, AuthorizationResult> attrResults = this.attributeResults.get(attribute);
            if (attrResults == null) {
                attrResults = new HashMap<Action.ActionEffect, AuthorizationResult>();
                this.attributeResults.put(attribute, attrResults);
            }
            attrResults.put(actionEffect, result);
        }

        private void addOperationResult(String operationName, AuthorizationResult result) {
            this.operationResults.put(operationName, result);
        }

        private AuthorizationResult validateAddAttributeEffects(String operationName, Set<Action.ActionEffect> actionEffects, ModelNode operation) {
            AuthorizationResult basic = this.operationResults.get(operationName);
            assert (basic != null) : " no basic authorization has been performed for operation 'add'";
            if (basic.getDecision() == AuthorizationResult.Decision.DENY) {
                ImmutableManagementResourceRegistration resourceRegistration = this.targetResource.getResourceRegistration();
                ModelNode model = this.targetResource.getResource().getModel();
                boolean attributeWasDenied = false;
                for (Map.Entry<String, Map<Action.ActionEffect, AuthorizationResult>> attributeResultEntry : this.attributeResults.entrySet()) {
                    String attrName = attributeResultEntry.getKey();
                    boolean attrDenied = this.isAttributeDenied(attributeResultEntry.getValue(), actionEffects);
                    if (!attrDenied) continue;
                    attributeWasDenied = true;
                    if (!operation.hasDefined(attrName) && !model.hasDefined(attrName) && !this.isAddableAttribute(attrName, resourceRegistration)) continue;
                    Map<Action.ActionEffect, AuthorizationResult> attrResults = attributeResultEntry.getValue();
                    for (Action.ActionEffect actionEffect : actionEffects) {
                        AuthorizationResult authResult = attrResults.get((Object)actionEffect);
                        if (authResult.getDecision() != AuthorizationResult.Decision.DENY) continue;
                        this.addOperationResult(operationName, authResult);
                        return authResult;
                    }
                }
                if (attributeWasDenied) {
                    this.addOperationResult(operationName, AuthorizationResult.PERMITTED);
                    return AuthorizationResult.PERMITTED;
                }
            }
            return basic;
        }

        private boolean isAttributeDenied(Map<Action.ActionEffect, AuthorizationResult> attributeResults, Set<Action.ActionEffect> actionEffects) {
            for (Action.ActionEffect actionEffect : actionEffects) {
                AuthorizationResult ar = attributeResults.get((Object)actionEffect);
                if (ar == null || ar.getDecision() != AuthorizationResult.Decision.DENY) continue;
                return true;
            }
            return false;
        }

        private boolean isAddableAttribute(String attrName, ImmutableManagementResourceRegistration resourceRegistration) {
            AttributeAccess attributeAccess = resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attrName);
            if (attributeAccess == null) {
                return false;
            }
            if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION && attributeAccess.getAccessType() == AttributeAccess.AccessType.READ_WRITE) {
                AttributeDefinition ad = attributeAccess.getAttributeDefinition();
                if (ad == null) {
                    return false;
                }
                if (ad.isRequired() || ad.isNullSignificant()) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class OperationContextServiceController<S>
    extends DelegatingServiceController<S> {
        private volatile AbstractOperationContext.Step registryActiveStep;

        private OperationContextServiceController(ServiceController<S> controller, AbstractOperationContext.Step registryActiveStep) {
            super(controller);
            this.registryActiveStep = registryActiveStep;
        }

        void done() {
            this.registryActiveStep = null;
        }

        public boolean compareAndSetMode(ServiceController.Mode expected, ServiceController.Mode newMode) {
            this.checkModeTransition(newMode);
            boolean changed = this.getDelegate().compareAndSetMode(expected, newMode);
            AbstractOperationContext.Step step = this.registryActiveStep;
            if (changed && step != null) {
                step.serviceModeChanged(this.getDelegate());
            }
            return changed;
        }

        public void setMode(ServiceController.Mode mode) {
            this.checkModeTransition(mode);
            this.getDelegate().setMode(mode);
            AbstractOperationContext.Step step = this.registryActiveStep;
            if (step != null) {
                step.serviceModeChanged(this.getDelegate());
            }
        }

        protected ServiceController<S> getDelegate() {
            return super.getDelegate();
        }

        private void checkModeTransition(ServiceController.Mode mode) {
            if (mode == ServiceController.Mode.REMOVE) {
                throw ControllerLogger.ROOT_LOGGER.useOperationContextRemoveService();
            }
        }
    }

    private static class OperationContextServiceRegistry
    extends DelegatingServiceRegistry {
        private final Set<OperationContextServiceController> controllers = Collections.synchronizedSet(new HashSet());
        private AbstractOperationContext.Step registryActiveStep;

        private OperationContextServiceRegistry(ServiceRegistry registry, AbstractOperationContext.Step registryActiveStep) {
            super(registry);
            this.registryActiveStep = registryActiveStep;
        }

        synchronized void done() {
            this.registryActiveStep = null;
            for (OperationContextServiceController controller : this.controllers) {
                controller.done();
            }
            this.controllers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
            Object result = this.getDelegate().getRequiredService(serviceName);
            OperationContextServiceRegistry operationContextServiceRegistry = this;
            synchronized (operationContextServiceRegistry) {
                if (this.registryActiveStep != null) {
                    OperationContextServiceController ocsc = new OperationContextServiceController(result, this.registryActiveStep);
                    result = ocsc;
                    this.controllers.add(ocsc);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceController<?> getService(ServiceName serviceName) {
            Object result = this.getDelegate().getService(serviceName);
            if (result != null) {
                OperationContextServiceRegistry operationContextServiceRegistry = this;
                synchronized (operationContextServiceRegistry) {
                    if (this.registryActiveStep != null) {
                        OperationContextServiceController ocsc = new OperationContextServiceController(result, this.registryActiveStep);
                        result = ocsc;
                        this.controllers.add(ocsc);
                    }
                }
            }
            return result;
        }
    }

    private class ServiceRemovalVerificationHandler
    implements OperationStepHandler {
        private final ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport;

        private ServiceRemovalVerificationHandler(ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport) {
            this.containerStateChangeReport = containerStateChangeReport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>> missingByStep = new HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>>();
            Map<ServiceName, ServiceController<?>> map = OperationContextImpl.this.realRemovingControllers;
            synchronized (map) {
                for (Map.Entry<ServiceName, ContainerStateMonitor.MissingDependencyInfo> entry : this.containerStateChangeReport.getMissingServices().entrySet()) {
                    ContainerStateMonitor.MissingDependencyInfo missingDependencyInfo = entry.getValue();
                    AbstractOperationContext.Step removalStep = OperationContextImpl.this.removalSteps.get(entry.getKey());
                    if (removalStep == null) continue;
                    HashMap<ServiceName, Set<ServiceName>> stepBadRemovals = (HashMap<ServiceName, Set<ServiceName>>)missingByStep.get(removalStep);
                    if (stepBadRemovals == null) {
                        stepBadRemovals = new HashMap<ServiceName, Set<ServiceName>>();
                        missingByStep.put(removalStep, stepBadRemovals);
                    }
                    stepBadRemovals.put(entry.getKey(), missingDependencyInfo.getDependents());
                }
            }
            for (Map.Entry entry : missingByStep.entrySet()) {
                AbstractOperationContext.Step step = (AbstractOperationContext.Step)entry.getKey();
                if (step.response.hasDefined("failure-description")) continue;
                StringBuilder sb = new StringBuilder(ControllerLogger.ROOT_LOGGER.removingServiceUnsatisfiedDependencies());
                for (Map.Entry removed : ((Map)entry.getValue()).entrySet()) {
                    sb.append(ControllerLogger.ROOT_LOGGER.removingServiceUnsatisfiedDependencies(((ServiceName)removed.getKey()).getCanonicalName()));
                    boolean first = true;
                    for (ServiceName dependent : (Set)removed.getValue()) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(dependent);
                    }
                }
                step.response.get("failure-description").set(sb.toString());
            }
            if (!missingByStep.isEmpty()) {
                context.attach(ContainerStateVerificationHandler.FAILURE_REPORTED_ATTACHMENT, Boolean.TRUE);
                if (context.isRollbackOnRuntimeFailure()) {
                    context.setRollbackOnly();
                }
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private static class ContextServiceBuilder<T>
    extends DelegatingServiceBuilder<T> {
        private final ServiceBuilder<T> realBuilder;
        private volatile ContextServiceInstaller serviceInstaller;

        ContextServiceBuilder(ServiceBuilder<T> realBuilder, ContextServiceInstaller serviceInstaller) {
            super(realBuilder);
            this.realBuilder = realBuilder;
            this.serviceInstaller = serviceInstaller;
        }

        void done() {
            this.serviceInstaller = null;
        }

        public ServiceController<T> install() throws ServiceRegistryException, IllegalStateException {
            ContextServiceInstaller installer = this.serviceInstaller;
            return installer == null ? this.realBuilder.install() : installer.installService(this.realBuilder);
        }

        ServiceName getCapabilityServiceName(String capabilityName, Class<?> serviceType, PathAddress address) {
            return this.serviceInstaller.getCapabilityServiceName(capabilityName, serviceType, address);
        }
    }

    private static interface ContextServiceInstaller {
        public <T> ServiceController<T> installService(ServiceBuilder<T> var1);

        public ServiceName getCapabilityServiceName(String var1, Class<?> var2, PathAddress var3);
    }

    private static class ContextServiceTarget
    extends DelegatingServiceTarget
    implements CapabilityServiceTarget {
        private final Set<ContextServiceBuilder> builders = new HashSet<ContextServiceBuilder>();
        private volatile ContextServiceBuilderSupplier builderSupplier;
        private final PathAddress targetAddress;

        ContextServiceTarget(ServiceTarget delegate, ContextServiceBuilderSupplier builderSupplier, PathAddress targetAddress) {
            super(delegate);
            this.builderSupplier = builderSupplier;
            this.targetAddress = targetAddress;
        }

        synchronized void done() {
            this.builderSupplier = null;
            for (ContextServiceBuilder builder : this.builders) {
                builder.done();
            }
            this.builders.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceBuilder<?> addService(ServiceName name) {
            ServiceBuilder realBuilder = super.getDelegate().addService(name);
            ContextServiceTarget contextServiceTarget = this;
            synchronized (contextServiceTarget) {
                if (this.builderSupplier == null) {
                    return realBuilder;
                }
                ContextServiceBuilder csb = this.builderSupplier.getContextServiceBuilder(realBuilder, name);
                this.builders.add(csb);
                return csb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) {
            ServiceBuilder realBuilder = super.getDelegate().addServiceValue(name, value);
            ContextServiceTarget contextServiceTarget = this;
            synchronized (contextServiceTarget) {
                if (this.builderSupplier == null) {
                    return realBuilder;
                }
                ContextServiceBuilder csb = this.builderSupplier.getContextServiceBuilder(realBuilder, name);
                this.builders.add(csb);
                return csb;
            }
        }

        public <T> CapabilityServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
            return new CapabilityServiceBuilderImpl<T>(this.addServiceValue(name, () -> service), this.targetAddress);
        }

        @Override
        public CapabilityServiceBuilder<?> addCapability(RuntimeCapability<?> capability) throws IllegalArgumentException {
            if (capability.isDynamicallyNamed()) {
                return new CapabilityServiceBuilderImpl(this.addService(capability.getCapabilityServiceName(this.targetAddress)), this.targetAddress);
            }
            return new CapabilityServiceBuilderImpl(this.addService(capability.getCapabilityServiceName()), this.targetAddress);
        }

        protected ServiceTarget getDelegate() {
            this.checkNotInManagementOperation();
            return super.getDelegate();
        }

        private void checkNotInManagementOperation() {
            if (this.builderSupplier != null) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static interface ContextServiceBuilderSupplier {
        public <T> ContextServiceBuilder<T> getContextServiceBuilder(ServiceBuilder<T> var1, ServiceName var2);
    }
}

