/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public interface ProxyOperationAddressTranslator {
    public static final ProxyOperationAddressTranslator NOOP = new ProxyOperationAddressTranslator(){

        @Override
        public PathAddress translateAddress(PathAddress address) {
            return address;
        }

        @Override
        public PathAddress restoreAddress(PathAddress opAddress, PathAddress translatedAddress) {
            return translatedAddress;
        }
    };
    public static final ProxyOperationAddressTranslator SERVER = new ProxyOperationAddressTranslator(){

        @Override
        public PathAddress translateAddress(PathAddress address) {
            PathAddress translated = address;
            translated = this.lookForAndTrim(translated, "host");
            translated = this.lookForAndTrim(translated, "server");
            return translated;
        }

        @Override
        public PathAddress restoreAddress(PathAddress opAddress, PathAddress translatedAddress) {
            ModelNode result = new ModelNode();
            for (PathElement pe : opAddress) {
                boolean found = false;
                if (pe.isWildcard()) {
                    for (PathElement tpe : translatedAddress) {
                        if (!tpe.getKey().equals(pe.getKey())) continue;
                        found = true;
                        result.add(tpe.getKey(), tpe.getValue());
                        break;
                    }
                }
                if (found) continue;
                result.add(pe.getKey(), pe.getValue());
            }
            return PathAddress.pathAddress(result);
        }

        private PathAddress lookForAndTrim(PathAddress addr, String search) {
            if (addr.size() == 0) {
                return addr;
            }
            if (addr.getElement(0).getKey().equals(search)) {
                return addr.subAddress(1);
            }
            return addr;
        }
    };
    public static final ProxyOperationAddressTranslator HOST = new ProxyOperationAddressTranslator(){

        @Override
        public PathAddress translateAddress(PathAddress address) {
            return address;
        }

        @Override
        public PathAddress restoreAddress(PathAddress opAddress, PathAddress translatedAddress) {
            return translatedAddress;
        }
    };

    public PathAddress translateAddress(PathAddress var1);

    public PathAddress restoreAddress(PathAddress var1, PathAddress var2);
}

