/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemModel;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.version.Stability;

public interface ResourceDefinition
extends ResourceRegistration {
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration var1);

    public void registerOperations(ManagementResourceRegistration var1);

    public void registerAttributes(ManagementResourceRegistration var1);

    public void registerNotifications(ManagementResourceRegistration var1);

    public void registerChildren(ManagementResourceRegistration var1);

    default public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
    }

    default public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
    }

    public List<AccessConstraintDefinition> getAccessConstraints();

    public boolean isRuntime();

    public boolean isOrderedChild();

    default public int getMaxOccurs() {
        PathElement pe = this.getPathElement();
        return pe == null || !pe.isWildcard() ? 1 : Integer.MAX_VALUE;
    }

    default public int getMinOccurs() {
        return this.getPathElement() != null ? 0 : 1;
    }

    default public boolean isFeature() {
        return false;
    }

    public static Builder builder(ResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        return ResourceDefinition.builder(registration, descriptionResolver, null);
    }

    public static Builder builder(ResourceRegistration registration, ResourceDescriptionResolver descriptionResolver, SubsystemModel deprecation) {
        Objects.requireNonNull(registration);
        Objects.requireNonNull(descriptionResolver);
        return new MinimalBuilder(registration, descriptionResolver, deprecation != null ? new DeprecationData(deprecation.getVersion()) : null);
    }

    public static Builder builder(ResourceRegistration registration, DescriptionProvider descriptionProvider) {
        Objects.requireNonNull(registration);
        Objects.requireNonNull(descriptionProvider);
        return new MinimalBuilder(registration, descriptionProvider);
    }

    public static class MinimalResourceDefinition
    implements ResourceDefinition {
        private final PathElement path;
        private final Stability stability;
        private final Function<ImmutableManagementResourceRegistration, DescriptionProvider> descriptionProviderFactory;
        private final int minOccurance;
        private final int maxOccurance;
        private final List<AccessConstraintDefinition> accessConstraints;
        private final boolean runtime;
        private final boolean orderedChild;
        private final boolean feature;

        MinimalResourceDefinition(AbstractConfigurator<?> configurator) {
            this.path = configurator.path;
            this.stability = configurator.stability;
            this.descriptionProviderFactory = configurator.descriptionProviderFactory;
            this.minOccurance = configurator.minOccurance;
            this.maxOccurance = configurator.maxOccurance;
            this.accessConstraints = configurator.accessConstraints;
            this.runtime = configurator.runtime;
            this.orderedChild = configurator.orderedChild;
            this.feature = configurator.feature;
        }

        @Override
        public PathElement getPathElement() {
            return this.path;
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }

        @Override
        public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration registration) {
            return this.descriptionProviderFactory.apply(registration);
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurance;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurance;
        }

        @Override
        public List<AccessConstraintDefinition> getAccessConstraints() {
            return this.accessConstraints;
        }

        @Override
        public boolean isRuntime() {
            return this.runtime;
        }

        @Override
        public boolean isOrderedChild() {
            return this.orderedChild;
        }

        @Override
        public boolean isFeature() {
            return this.feature;
        }

        @Override
        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        }

        @Override
        public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
        }

        @Override
        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        }

        @Override
        public void registerAdditionalRuntimePackages(ManagementResourceRegistration registration) {
        }
    }

    public static class MinimalBuilder
    extends AbstractConfigurator<Builder>
    implements Builder {
        MinimalBuilder(ResourceRegistration registration, final ResourceDescriptionResolver resolver, final DeprecationData deprecation) {
            super(registration, new Function<ImmutableManagementResourceRegistration, DescriptionProvider>(){

                @Override
                public DescriptionProvider apply(ImmutableManagementResourceRegistration registration) {
                    return new DefaultResourceDescriptionProvider(registration, resolver, deprecation);
                }
            });
        }

        MinimalBuilder(ResourceRegistration registration, final DescriptionProvider provider) {
            super(registration, new Function<ImmutableManagementResourceRegistration, DescriptionProvider>(){

                @Override
                public DescriptionProvider apply(ImmutableManagementResourceRegistration registration) {
                    return provider;
                }
            });
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResourceDefinition build() {
            return new MinimalResourceDefinition(this);
        }
    }

    public static interface Builder
    extends Configurator<Builder> {
        public ResourceDefinition build();
    }

    public static abstract class AbstractConfigurator<C extends Configurator<C>>
    implements Configurator<C> {
        private final PathElement path;
        private final Stability stability;
        private final Function<ImmutableManagementResourceRegistration, DescriptionProvider> descriptionProviderFactory;
        private int minOccurance;
        private int maxOccurance;
        private List<AccessConstraintDefinition> accessConstraints = List.of();
        private boolean runtime = false;
        private boolean orderedChild = false;
        private boolean feature = true;

        AbstractConfigurator(ResourceRegistration registration, Function<ImmutableManagementResourceRegistration, DescriptionProvider> descriptionProviderFactory) {
            this.path = registration.getPathElement();
            this.stability = registration.getStability();
            this.descriptionProviderFactory = descriptionProviderFactory;
            this.minOccurance = this.path == null ? 1 : 0;
            this.maxOccurance = this.path == null || !this.path.isWildcard() ? 1 : Integer.MAX_VALUE;
        }

        protected abstract C self();

        @Override
        public C withMinOccurance(int occurance) {
            this.minOccurance = occurance;
            return this.self();
        }

        @Override
        public C withMaxOccurance(int occurance) {
            this.maxOccurance = occurance;
            return this.self();
        }

        @Override
        public C withAccessConstraints(Collection<AccessConstraintDefinition> accessConstraints) {
            this.accessConstraints = List.copyOf(accessConstraints);
            return this.self();
        }

        @Override
        public C addAccessConstraints(Collection<AccessConstraintDefinition> accessConstraints) {
            if (this.accessConstraints.isEmpty()) {
                return this.withAccessConstraints(accessConstraints);
            }
            this.accessConstraints = Stream.concat(this.accessConstraints.stream(), accessConstraints.stream()).collect(Collectors.toUnmodifiableList());
            return this.self();
        }

        @Override
        public C asRuntime() {
            this.runtime = true;
            return this.self();
        }

        @Override
        public C asOrderedChild() {
            this.orderedChild = true;
            return this.self();
        }

        @Override
        public C asNonFeature() {
            this.feature = false;
            return this.self();
        }
    }

    public static interface Configurator<C extends Configurator<C>> {
        default public C withAccessConstraint(AccessConstraintDefinition accessConstraint) {
            return this.withAccessConstraints(List.of(accessConstraint));
        }

        default public C withAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            return this.withAccessConstraints(List.of(accessConstraints));
        }

        public C withAccessConstraints(Collection<AccessConstraintDefinition> var1);

        default public C addAccessConstraint(AccessConstraintDefinition accessConstraint) {
            return this.addAccessConstraints(List.of(accessConstraint));
        }

        default public C addAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            return this.addAccessConstraints(List.of(accessConstraints));
        }

        public C addAccessConstraints(Collection<AccessConstraintDefinition> var1);

        public C asRuntime();

        public C asOrderedChild();

        public C asNonFeature();

        public C withMinOccurance(int var1);

        public C withMaxOccurance(int var1);
    }
}

