/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLConfiguration;
import org.jboss.as.controller.persistence.xml.ResourceXMLContainer;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface ResourceXMLElement
extends ResourceXMLContainer,
XMLElement<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> {
    public static ResourceXMLElement ignore(final QName name, XMLCardinality cardinality) {
        return new DefaultResourceXMLElement(name, cardinality, new XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>>(){

            public void readElement(XMLExtendedStreamReader reader, Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) throws XMLStreamException {
                ControllerLogger.ROOT_LOGGER.elementIgnored(name);
                this.skipElement(reader);
            }

            private void skipElement(XMLExtendedStreamReader reader) throws XMLStreamException {
                while (reader.hasNext() && reader.nextTag() != 2) {
                    this.skipElement(reader);
                }
            }
        }, XMLContentWriter.empty(), Stability.DEFAULT);
    }

    public static class DefaultResourceXMLElement
    extends XMLElement.DefaultXMLElement<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode>
    implements ResourceXMLElement {
        DefaultResourceXMLElement(QName name, XMLCardinality cardinality, XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> reader, XMLContentWriter<ModelNode> writer, Stability stability) {
            super(name, cardinality, reader, writer, stability);
        }
    }

    public static class DefaultBuilder
    extends ResourceXMLContainer.AbstractBuilder<ResourceXMLElement, Builder>
    implements Builder {
        private final QName name;
        private final Stability stability;

        DefaultBuilder(QName name, Stability stability, FeatureRegistry registry, QNameResolver resolver) {
            this(name, stability, registry, resolver, AttributeDefinitionXMLConfiguration.of(resolver));
        }

        DefaultBuilder(QName name, Stability stability, FeatureRegistry registry, QNameResolver resolver, AttributeDefinitionXMLConfiguration configuration) {
            super(registry, resolver, configuration);
            this.name = name;
            this.stability = stability;
        }

        @Override
        protected Builder builder() {
            return this;
        }

        @Override
        public ResourceXMLElement build() {
            Collection<AttributeDefinition> attributes = this.getAttributes();
            AttributeDefinitionXMLConfiguration configuration = this.getConfiguration();
            XMLContent<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> content = this.getContent();
            ResourceXMLContainer.ResourceXMLContainerReader reader = new ResourceXMLContainer.ResourceXMLContainerReader(new ResourceXMLContainer.ResourceAttributesXMLContentReader(attributes, configuration), content);
            ResourceXMLContainer.ResourceXMLContainerWriter<ModelNode> writer = new ResourceXMLContainer.ResourceXMLContainerWriter<ModelNode>(this.name, (XMLContentWriter)new ResourceXMLContainer.ResourceAttributesXMLContentWriter(attributes, configuration), Function.identity(), content){

                @Override
                public void writeContent(XMLExtendedStreamWriter writer, ModelNode content) throws XMLStreamException {
                    if (!this.isEmpty(content)) {
                        super.writeContent(writer, content);
                    }
                }
            };
            return new DefaultResourceXMLElement(this.name, this.getCardinality(), reader, (XMLContentWriter<ModelNode>)writer, this.stability);
        }
    }

    public static interface Builder
    extends ResourceXMLContainer.Builder<ResourceXMLElement, Builder> {
    }
}

