/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementGroup;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;

public interface XMLAll<RC, WC>
extends XMLElementGroup<RC, WC> {

    public static class DefaultXMLAll<RC, WC>
    extends XMLElementGroup.DefaultXMLElementGroup<RC, WC>
    implements XMLAll<RC, WC> {
        static <RC, WC> SortedMap<QName, XMLElement<RC, WC>> collect(Collection<? extends XMLElement<RC, WC>> elements) {
            TreeMap<QName, XMLElement<RC, WC>> result = new TreeMap<QName, XMLElement<RC, WC>>(QNameResolver.COMPARATOR);
            for (XMLElement<RC, WC> element : elements) {
                if (result.put(element.getName(), element) == null) continue;
                throw ControllerLogger.ROOT_LOGGER.duplicateElements(element.getName());
            }
            return Collections.unmodifiableSortedMap(result);
        }

        protected DefaultXMLAll(Collection<? extends XMLElement<RC, WC>> elements, XMLCardinality cardinality) {
            this(DefaultXMLAll.collect(elements), Collections.unmodifiableCollection(elements), cardinality);
        }

        private DefaultXMLAll(final SortedMap<QName, XMLElement<RC, WC>> elements, final Collection<XMLElement<RC, WC>> orderedElements, final XMLCardinality cardinality) {
            super(elements.keySet(), orderedElements, cardinality, new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    Assert.assertTrue((boolean)reader.isStartElement());
                    TreeMap remaining = new TreeMap(elements);
                    if (remaining.containsKey(reader.getName())) {
                        do {
                            ((XMLElement)remaining.remove(reader.getName())).getReader().readElement(reader, context);
                        } while (reader.hasNext() && reader.nextTag() != 2 && remaining.containsKey(reader.getName()));
                    } else if (cardinality.isRequired()) {
                        throw ParseUtils.unexpectedElement(reader, elements.keySet());
                    }
                    if (!remaining.isEmpty()) {
                        TreeSet<QName> required = new TreeSet<QName>(QNameResolver.COMPARATOR);
                        for (XMLElement remainingElement : remaining.values()) {
                            if (!remainingElement.getCardinality().isRequired()) continue;
                            required.add(remainingElement.getName());
                        }
                        if (!required.isEmpty()) {
                            throw ParseUtils.minOccursNotReached(reader, required, XMLCardinality.Single.REQUIRED);
                        }
                        for (XMLElement remainingElement : remaining.values()) {
                            remainingElement.getReader().handleAbsentElement(context);
                        }
                    }
                }

                @Override
                public void handleAbsentElement(RC context) {
                    for (XMLElement element : orderedElements) {
                        element.getReader().handleAbsentElement(context);
                    }
                }
            });
        }
    }

    public static class DefaultBuilder<RC, WC>
    extends XMLElementGroup.AbstractBuilder<RC, WC, XMLElement<RC, WC>, XMLAll<RC, WC>, Builder<RC, WC>>
    implements Builder<RC, WC> {
        DefaultBuilder(FeatureRegistry registry) {
            super(registry);
        }

        @Override
        public Builder<RC, WC> withCardinality(XMLCardinality cardinality) {
            if (cardinality.isRepeatable()) {
                throw ControllerLogger.ROOT_LOGGER.illegalXMLCardinality(cardinality);
            }
            return (Builder)super.withCardinality(cardinality);
        }

        @Override
        public Builder<RC, WC> addElement(XMLElement<RC, WC> element) {
            if (element.getCardinality().isRepeatable()) {
                throw ControllerLogger.ROOT_LOGGER.illegalXMLAllElementCardinality(element);
            }
            return (Builder)super.addElement(element);
        }

        @Override
        public XMLAll<RC, WC> build() {
            return new DefaultXMLAll(this.getElements(), this.getCardinality());
        }

        @Override
        protected Builder<RC, WC> builder() {
            return this;
        }
    }

    public static interface Builder<RC, WC>
    extends XMLElementGroup.Builder<RC, WC, XMLElement<RC, WC>, XMLAll<RC, WC>, Builder<RC, WC>> {
    }
}

