/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContainer;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.controller.xml.XMLParticle;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.XMLAttributeReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.Assert;

public interface XMLElement<RC, WC>
extends XMLContainer<RC, WC> {
    public QName getName();

    public static <RC, WC> XMLElement<RC, WC> ignore(final QName name, XMLCardinality cardinality) {
        return new DefaultXMLElement(name, cardinality, new XMLElementReader<RC>(){

            public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                ControllerLogger.ROOT_LOGGER.elementIgnored(name);
                this.skipElement(reader);
            }

            private void skipElement(XMLExtendedStreamReader reader) throws XMLStreamException {
                while (reader.hasNext() && reader.nextTag() != 2) {
                    this.skipElement(reader);
                }
            }
        }, XMLContentWriter.empty(), Stability.DEFAULT);
    }

    public static class DefaultXMLElement<RC, WC>
    extends XMLParticle.DefaultXMLParticle<RC, WC>
    implements XMLElement<RC, WC> {
        private final QName name;

        protected DefaultXMLElement(final QName name, XMLCardinality cardinality, final XMLElementReader<RC> elementReader, XMLContentWriter<WC> elementWriter, Stability stability) {
            super(cardinality, new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC value) throws XMLStreamException {
                    Assert.assertTrue((boolean)reader.isStartElement());
                    if (!reader.getName().equals(name)) {
                        throw ParseUtils.unexpectedElement(reader, Set.of(name));
                    }
                    elementReader.readElement(reader, value);
                    if (!reader.isEndElement()) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    if (!reader.getName().equals(name)) {
                        throw ParseUtils.unexpectedEndElement(reader);
                    }
                }
            }, elementWriter, stability);
            this.name = name;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof XMLElement)) {
                return false;
            }
            XMLElement element = (XMLElement)object;
            return this.getName().equals(element.getName());
        }

        public String toString() {
            return String.format("<xs:element name=\"%s\" %s/>", this.name.getLocalPart(), XMLCardinality.toString(this.getCardinality()));
        }
    }

    public static class DefaultBuilder<RC, WC>
    extends XMLContainer.AbstractBuilder<RC, WC, XMLElement<RC, WC>, Builder<RC, WC>>
    implements Builder<RC, WC> {
        private final QName name;
        private volatile Map<QName, XMLAttributeReader<RC>> attributeReaders = Map.of();
        private volatile XMLContentWriter<WC> attributesWriter = XMLContentWriter.empty();
        private final Stability stability;

        DefaultBuilder(QName name, Stability stability) {
            this.name = name;
            this.stability = stability;
        }

        @Override
        public Builder<RC, WC> withAttributes(Map<QName, XMLAttributeReader<RC>> readers, XMLContentWriter<WC> writer) {
            if (this.attributeReaders.isEmpty()) {
                this.attributeReaders = new TreeMap<QName, XMLAttributeReader<RC>>(QNameResolver.COMPARATOR);
            }
            this.attributeReaders.putAll(readers);
            this.attributesWriter = this.attributesWriter.andThen(writer);
            return this;
        }

        @Override
        protected Builder<RC, WC> builder() {
            return this;
        }

        @Override
        public XMLElement<RC, WC> build() {
            final QName name = this.name;
            final Map<QName, XMLAttributeReader<RC>> attributeReaders = this.attributeReaders;
            final XMLContentWriter<WC> attributesWriter = this.attributesWriter;
            final XMLContent content = this.getContent();
            XMLElementReader reader = new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttributeReader attributeReader;
                        QName attributeName = reader.getAttributeName(i);
                        if (attributeName.getNamespaceURI().equals("") && !reader.getName().getNamespaceURI().equals("")) {
                            attributeName = new QName(reader.getName().getNamespaceURI(), name.getLocalPart());
                        }
                        if ((attributeReader = (XMLAttributeReader)attributeReaders.get(attributeName)) == null) {
                            throw ParseUtils.unexpectedAttribute(reader, i, attributeReaders.keySet());
                        }
                        attributeReader.readAttribute((XMLStreamReader)reader, i, context);
                    }
                    content.readContent(reader, context);
                }
            };
            XMLContentWriter writer = new XMLContentWriter<WC>(){

                public void writeContent(XMLExtendedStreamWriter writer, WC value) throws XMLStreamException {
                    writer.writeStartElement(name.getNamespaceURI(), name.getLocalPart());
                    attributesWriter.writeContent(writer, value);
                    content.writeContent(writer, value);
                    writer.writeEndElement();
                }

                @Override
                public boolean isEmpty(WC value) {
                    return content.isEmpty(value);
                }
            };
            return new DefaultXMLElement(this.name, this.getCardinality(), reader, writer, this.stability);
        }
    }

    public static interface Builder<RC, WC>
    extends XMLContainer.Builder<RC, WC, XMLElement<RC, WC>, Builder<RC, WC>> {
        public Builder<RC, WC> withAttributes(Map<QName, XMLAttributeReader<RC>> var1, XMLContentWriter<WC> var2);
    }
}

