/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class ParsedBootOp {
    public final ModelNode operation;
    public final String operationName;
    public final PathAddress address;
    public final OperationStepHandler handler;
    public final ModelNode response;
    private List<ModelNode> childOperations;
    private boolean bootHandlerUpdateNeeded = false;

    ParsedBootOp(ModelNode operation) {
        this(operation, null, new ModelNode());
    }

    public ParsedBootOp(ModelNode operation, OperationStepHandler handler) {
        this(operation, handler, new ModelNode());
    }

    ParsedBootOp(ModelNode operation, OperationStepHandler handler, ModelNode response) {
        this.operation = operation;
        this.address = PathAddress.pathAddress(operation.get("address"));
        this.operationName = operation.require("operation").asString();
        this.handler = handler;
        this.response = response;
    }

    public ParsedBootOp(ParsedBootOp toCopy, OperationStepHandler handler) {
        this.operation = toCopy.operation;
        this.address = toCopy.address;
        this.operationName = toCopy.operationName;
        this.handler = handler;
        this.response = toCopy.response;
    }

    public void addChildOperation(ParsedBootOp child) {
        if (this.childOperations == null) {
            this.childOperations = new ArrayList<ModelNode>();
        }
        this.childOperations.add(child.operation);
    }

    boolean isExtensionAdd() {
        return this.address.size() == 1 && this.address.getElement(0).getKey().equals("extension") && this.operationName.equals("add");
    }

    boolean isInterfaceOperation() {
        return this.address.size() > 0 && this.address.getElement(0).getKey().equals("interface");
    }

    boolean isSocketOperation() {
        return this.address.size() > 0 && this.address.getElement(0).getKey().equals("socket-binding-group");
    }

    public List<ModelNode> getChildOperations() {
        return this.childOperations == null ? Collections.emptyList() : Collections.unmodifiableList(this.childOperations);
    }

    public PathAddress getAddress() {
        return this.address;
    }

    public boolean isBootHandlerUpdateNeeded() {
        return this.handler instanceof ParallelBootOperationStepHandler && this.bootHandlerUpdateNeeded;
    }

    public void bootHandlerUpdateNeeded() {
        this.bootHandlerUpdateNeeded = true;
    }

    public String toString() {
        return "ParsedBootOp{operation=" + String.valueOf(this.operation) + ", operationName=" + this.operationName + ", address=" + String.valueOf(this.address) + ", handler=" + String.valueOf(this.handler) + ", response=" + String.valueOf(this.response) + ", childOperations=" + String.valueOf(this.childOperations) + "}";
    }
}

