/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.controller.AccessAuditContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    static ServerAuthenticationContext createServerAuthenticationContext(SecurityDomain securityDomain) {
        return SecurityActions.createElytronActions().createServerAuthenticationContext(securityDomain);
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return WildFlySecurityManager.isChecking() ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static ElytronActions createElytronActions() {
        return WildFlySecurityManager.isChecking() ? ElytronActions.PRIVILEGED : ElytronActions.NON_PRIVILEGED;
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }

    private static interface ElytronActions {
        public static final ElytronActions NON_PRIVILEGED = new ElytronActions(){

            @Override
            public ServerAuthenticationContext createServerAuthenticationContext(SecurityDomain securityDomain) {
                return securityDomain.createNewAuthenticationContext();
            }
        };
        public static final ElytronActions PRIVILEGED = new ElytronActions(){

            @Override
            public ServerAuthenticationContext createServerAuthenticationContext(SecurityDomain securityDomain) {
                return AccessController.doPrivileged(() -> NON_PRIVILEGED.createServerAuthenticationContext(securityDomain));
            }
        };

        public ServerAuthenticationContext createServerAuthenticationContext(SecurityDomain var1);
    }
}

