/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Collections;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ValidateOperationHandler
implements OperationStepHandler {
    public static final ValidateOperationHandler INSTANCE = new ValidateOperationHandler(false);
    public static final ValidateOperationHandler SLAVE_HC_INSTANCE = new ValidateOperationHandler(true);
    private static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.OBJECT).setAllowNull(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("validate-operation", ControllerResolver.getResolver("global")).setParameters(VALUE).setReadOnly().setRuntimeOnly().build();
    public static final OperationDefinition DEFINITION_PRIVATE = new SimpleOperationDefinitionBuilder("validate-operation", ControllerResolver.getResolver("global")).setParameters(VALUE).setReadOnly().setRuntimeOnly().setPrivateEntry().build();
    private final boolean slave;

    private ValidateOperationHandler(boolean slave) {
        this.slave = slave;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode op = VALUE.validateOperation(operation);
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (this.slave) {
            op = op.clone();
            if (addr.size() > 0 && addr.getElement(0).getKey().equals("host")) {
                addr = addr.subAddress(1);
                op.get("address").set(addr.toModelNode());
            }
        }
        ProxyOperationAddressTranslator translator = null;
        ImmutableManagementResourceRegistration proxyReg = null;
        PathAddress proxyAddr = PathAddress.EMPTY_ADDRESS;
        for (PathElement element : addr) {
            proxyAddr = proxyAddr.append(element);
            ImmutableManagementResourceRegistration reg = context.getResourceRegistration().getSubModel(proxyAddr);
            if (reg == null || !reg.isRemote()) continue;
            translator = element.getKey().equals("server") ? ProxyOperationAddressTranslator.SERVER : ProxyOperationAddressTranslator.HOST;
            proxyReg = reg;
            break;
        }
        if (proxyReg != null) {
            ModelNode proxyOp = operation.clone();
            proxyOp.get("address").set(proxyAddr.toModelNode());
            proxyOp.get(new String[]{VALUE.getName(), "address"}).set(translator.translateAddress(addr).toModelNode());
            final ModelNode result = new ModelNode();
            context.addStep(result, proxyOp, proxyReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, "validate-operation"), OperationContext.Stage.MODEL, true);
            context.completeStep(new OperationContext.RollbackHandler(){

                @Override
                public void handleRollback(OperationContext context, ModelNode operation) {
                    context.getFailureDescription().set(result.get("failure-description"));
                }
            });
        } else {
            try {
                if (this.authorize(context, op, operation).getDecision() == AuthorizationResult.Decision.DENY) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.managementResourceNotFoundMessage(addr));
                } else {
                    new OperationValidator(context.getResourceRegistration(), false, false).validateOperation(op);
                }
            }
            catch (IllegalArgumentException e) {
                context.getFailureDescription().set(e.getMessage());
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private AuthorizationResult authorize(OperationContext context, ModelNode authOp, ModelNode opWithHeaders) {
        authOp.get("operation-headers").set(opWithHeaders.get("operation-headers"));
        return context.authorize(authOp, Collections.singleton(Action.ActionEffect.ADDRESS));
    }
}

