/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.function.Consumer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.management.ManagementWriteAttributeHandler;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class BaseHttpInterfaceResourceDefinition
extends SimpleResourceDefinition {
    public static final RuntimeCapability<Void> HTTP_MANAGEMENT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.http-interface").build();
    protected static final PathElement RESOURCE_PATH = PathElement.pathElement("management-interface", "http-interface");
    public static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, true).setMinSize(1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).setCapabilityReference("org.wildfly.security.http-authentication-factory", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF)).setNullSignificant(true)).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setMinSize(1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).setCapabilityReference("org.wildfly.security.ssl-context", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName())).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition HTTP_UPGRADE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-upgrade-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.HTTP_UPGRADE_ENABLED.getLocalName())).setDeprecated(ModelVersion.create(5), true)).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition SASL_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-authentication-factory", ModelType.STRING, true).setMinSize(1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).setCapabilityReference("org.wildfly.security.sasl-authentication-factory", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).build();
    public static final ObjectTypeAttributeDefinition HTTP_UPGRADE = new ObjectTypeAttributeDefinition.Builder("http-upgrade", ENABLED, SASL_AUTHENTICATION_FACTORY).build();
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setDefaultValue(new ModelNode("remote"))).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    public static final StringListAttributeDefinition ALLOWED_ORIGINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("allowed-origins").setAllowExpression(true)).setAllowNull(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    protected static final AttributeDefinition[] COMMON_ATTRIBUTES = new AttributeDefinition[]{HTTP_AUTHENTICATION_FACTORY, SSL_CONTEXT, SECURITY_REALM, CONSOLE_ENABLED, HTTP_UPGRADE_ENABLED, HTTP_UPGRADE, SASL_PROTOCOL, SERVER_NAME, ALLOWED_ORIGINS};

    protected BaseHttpInterfaceResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(parameters.addAccessConstraints(SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES).addCapabilities(HTTP_MANAGEMENT_RUNTIME_CAPABILITY).setDeprecatedSince(ModelVersion.create(1, 7)));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AttributeDefinition[] attributeDefinitions = this.getAttributeDefinitions();
        ManagementWriteAttributeHandler defaultWriteHandler = new ManagementWriteAttributeHandler(attributeDefinitions, this.getValidationConsumer());
        for (AttributeDefinition attr : attributeDefinitions) {
            if (attr.equals(HTTP_UPGRADE_ENABLED)) {
                HttpUpgradeAttributeHandler handler = new HttpUpgradeAttributeHandler();
                resourceRegistration.registerReadWriteAttribute(attr, handler, handler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, defaultWriteHandler);
        }
    }

    protected abstract Consumer<OperationContext> getValidationConsumer();

    protected abstract AttributeDefinition[] getAttributeDefinitions();

    protected static AttributeDefinition[] combine(AttributeDefinition[] commonAttributes, AttributeDefinition ... additionalAttributes) {
        AttributeDefinition[] combined = new AttributeDefinition[commonAttributes.length + additionalAttributes.length];
        System.arraycopy(commonAttributes, 0, combined, 0, commonAttributes.length);
        System.arraycopy(additionalAttributes, 0, combined, commonAttributes.length, additionalAttributes.length);
        return combined;
    }

    protected class HttpUpgradeAttributeHandler
    implements OperationStepHandler {
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode submodel = resource.getModel();
            ModelNode httpUpgrade = submodel.get("http-upgrade");
            String operationName = operation.require("operation").asString();
            assert ("http-upgrade-enabled".equals(operation.require("name").asString()));
            switch (operationName) {
                case "read-attribute": {
                    context.getResult().set(ENABLED.resolveModelAttribute(context, httpUpgrade));
                    break;
                }
                case "write-attribute": {
                    httpUpgrade.get("enabled").set(operation.require("value").asBoolean());
                    context.reloadRequired();
                }
            }
        }
    }
}

