/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class PersistentResourceXMLDescription {
    protected final PathElement pathElement;
    private final String xmlElementName;
    private final String xmlWrapperElement;
    private final LinkedHashMap<String, LinkedHashMap<String, AttributeDefinition>> attributesByGroup;
    protected final List<PersistentResourceXMLDescription> children;
    private final Map<String, AttributeDefinition> attributeElements = new HashMap<String, AttributeDefinition>();
    private final boolean useValueAsElementName;
    private final boolean noAddOperation;
    private final AdditionalOperationsGenerator additionalOperationsGenerator;
    private boolean flushRequired = true;
    private boolean childAlreadyRead = false;
    private final Map<String, AttributeParser> attributeParsers;
    private final Map<String, AttributeMarshaller> attributeMarshallers;
    private final boolean useElementsForGroups;
    private final String namespaceURI;
    private final Set<String> attributeGroups;
    private final String forcedName;
    private final boolean marshallDefaultValues;
    private final String nameAttributeName;

    private PersistentResourceXMLDescription(PersistentResourceXMLBuilder builder) {
        this.pathElement = builder.pathElement;
        this.xmlElementName = builder.xmlElementName;
        this.xmlWrapperElement = builder.xmlWrapperElement;
        this.useElementsForGroups = builder.useElementsForGroups;
        this.attributesByGroup = new LinkedHashMap();
        this.namespaceURI = builder.namespaceURI;
        this.attributeGroups = new HashSet<String>();
        if (this.useElementsForGroups) {
            this.attributesByGroup.put(null, new LinkedHashMap());
            for (Object ad : builder.attributeList) {
                LinkedHashMap<String, AttributeDefinition> forGroup = this.attributesByGroup.get(((AttributeDefinition)ad).getAttributeGroup());
                if (forGroup == null) {
                    forGroup = new LinkedHashMap();
                    this.attributesByGroup.put(((AttributeDefinition)ad).getAttributeGroup(), forGroup);
                    this.attributeGroups.add(((AttributeDefinition)ad).getAttributeGroup());
                }
                forGroup.put(((AttributeDefinition)ad).getXmlName(), (AttributeDefinition)ad);
                AttributeParser ap = builder.attributeParsers.getOrDefault(((AttributeDefinition)ad).getXmlName(), ((AttributeDefinition)ad).getParser());
                if (ap == null || !ap.isParseAsElement()) continue;
                this.attributeElements.put(ap.getXmlName((AttributeDefinition)ad), (AttributeDefinition)ad);
            }
        } else {
            LinkedHashMap<String, AttributeDefinition> attrs = new LinkedHashMap<String, AttributeDefinition>();
            for (AttributeDefinition ad : builder.attributeList) {
                attrs.put(ad.getXmlName(), ad);
                if (ad.getParser() == null || !ad.getParser().isParseAsElement()) continue;
                this.attributeElements.put(ad.getParser().getXmlName(ad), ad);
            }
            this.attributesByGroup.put(null, attrs);
        }
        this.children = new ArrayList<PersistentResourceXMLDescription>();
        for (PersistentResourceXMLBuilder b : builder.childrenBuilders) {
            this.children.add(b.build());
        }
        builder.children.forEach(this.children::add);
        this.useValueAsElementName = builder.useValueAsElementName;
        this.noAddOperation = builder.noAddOperation;
        this.additionalOperationsGenerator = builder.additionalOperationsGenerator;
        this.attributeParsers = builder.attributeParsers;
        this.attributeMarshallers = builder.attributeMarshallers;
        this.forcedName = builder.forcedName;
        this.marshallDefaultValues = builder.marshallDefaultValues;
        this.nameAttributeName = builder.nameAttributeName;
    }

    public PathElement getPathElement() {
        return this.pathElement;
    }

    public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = Util.createAddOperation();
        boolean wildcard = this.getPathElement().isWildcard();
        String name = this.parseAttributeGroups(reader, op, wildcard);
        if (wildcard && name == null) {
            if (this.forcedName != null) {
                name = this.forcedName;
            } else {
                throw ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(new StringBuilder("name"), reader.getLocation());
            }
        }
        PathElement path = wildcard ? PathElement.pathElement(this.getPathElement().getKey(), name) : this.getPathElement();
        PathAddress address = parentAddress.append(path);
        if (!this.noAddOperation) {
            op.get("address").set(address.toModelNode());
            list.add(op);
        }
        if (this.additionalOperationsGenerator != null) {
            this.additionalOperationsGenerator.additionalOperations(address, op, list);
        }
        if (!reader.isEndElement()) {
            this.parseChildren(reader, address, list, op);
        }
    }

    private String parseAttributeGroups(XMLExtendedStreamReader reader, ModelNode op, boolean wildcard) throws XMLStreamException {
        String name = this.parseAttributes(reader, op, (Map<String, AttributeDefinition>)this.attributesByGroup.get(null), wildcard);
        if (!this.attributeGroups.isEmpty()) {
            while (reader.hasNext() && reader.nextTag() != 2) {
                boolean element = this.attributeElements.containsKey(reader.getLocalName());
                if (this.attributeGroups.contains(reader.getLocalName()) || element) {
                    if (element) {
                        AttributeDefinition ad = this.attributeElements.get(reader.getLocalName());
                        ad.getParser().parseElement(ad, reader, op);
                        if (this.attributeGroups.contains(reader.getLocalName())) {
                            this.parseGroup(reader, op, wildcard);
                            continue;
                        }
                        if (!reader.isEndElement() || this.attributeGroups.contains(reader.getLocalName()) || this.attributeElements.containsKey(reader.getLocalName())) continue;
                        this.childAlreadyRead = true;
                        break;
                    }
                    this.parseGroup(reader, op, wildcard);
                    continue;
                }
                this.childAlreadyRead = true;
                return name;
            }
            this.flushRequired = false;
        }
        return name;
    }

    private void parseGroup(XMLExtendedStreamReader reader, ModelNode op, boolean wildcard) throws XMLStreamException {
        Map groupAttrs = this.attributesByGroup.get(reader.getLocalName());
        this.parseAttributes(reader, op, groupAttrs, wildcard);
        while (reader.hasNext() && reader.nextTag() != 2) {
            String attrName = reader.getLocalName();
            if (this.attributeElements.containsKey(attrName) && groupAttrs.containsKey(attrName)) {
                AttributeDefinition ad = this.attributeElements.get(reader.getLocalName());
                ad.getParser().parseElement(ad, reader, op);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private String parseAttributes(XMLExtendedStreamReader reader, ModelNode op, Map<String, AttributeDefinition> attributes, boolean wildcard) throws XMLStreamException {
        String name = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (wildcard && this.nameAttributeName.equals(attributeName)) {
                name = value;
                continue;
            }
            if (attributes.containsKey(attributeName)) {
                AttributeDefinition def = attributes.get(attributeName);
                AttributeParser parser = this.attributeParsers.getOrDefault(attributeName, def.getParser());
                assert (parser != null);
                parser.parseAndSetParameter(def, value, op, (XMLStreamReader)reader);
                continue;
            }
            LinkedHashSet<String> possible = new LinkedHashSet<String>(attributes.keySet());
            possible.add(this.nameAttributeName);
            throw ParseUtils.unexpectedAttribute(reader, i, possible);
        }
        if (this.attributeGroups.isEmpty() && !this.attributeElements.isEmpty() && reader.isStartElement()) {
            String originalStartElement = reader.getLocalName();
            if (reader.hasNext() && reader.nextTag() != 2) {
                do {
                    if (!this.attributeElements.containsKey(reader.getLocalName())) {
                        return name;
                    }
                    AttributeDefinition ad = this.attributeElements.get(reader.getLocalName());
                    AttributeParser parser = this.attributeParsers.getOrDefault(ad.getXmlName(), ad.getParser());
                    parser.parseElement(ad, reader, op);
                    this.childAlreadyRead = true;
                } while (!reader.getLocalName().equals(originalStartElement) && reader.hasNext() && reader.nextTag() != 2);
            }
        }
        return name;
    }

    private Map<String, PersistentResourceXMLDescription> getChildrenMap() {
        HashMap<String, PersistentResourceXMLDescription> res = new HashMap<String, PersistentResourceXMLDescription>();
        for (PersistentResourceXMLDescription child : this.children) {
            if (child.xmlWrapperElement != null) {
                res.put(child.xmlWrapperElement, child);
                continue;
            }
            res.put(child.xmlElementName, child);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseChildren(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list, ModelNode op) throws XMLStreamException {
        if (this.children.size() == 0) {
            if (this.flushRequired && this.attributeGroups.isEmpty() && this.attributeElements.isEmpty()) {
                ParseUtils.requireNoContent(reader);
            }
            if (!this.childAlreadyRead) return;
            throw ParseUtils.unexpectedElement(reader);
        }
        Map<String, PersistentResourceXMLDescription> children = this.getChildrenMap();
        if (!this.childAlreadyRead && (!reader.hasNext() || reader.nextTag() == 2)) return;
        do {
            PersistentResourceXMLDescription child;
            if ((child = children.get(reader.getLocalName())) != null) {
                if (child.xmlWrapperElement != null) {
                    if (!reader.getLocalName().equals(child.xmlWrapperElement)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    if (reader.hasNext() && reader.nextTag() == 2) {
                        return;
                    }
                    child.parse(reader, parentAddress, list);
                    while (reader.nextTag() != 2 && !reader.getLocalName().equals(child.xmlWrapperElement)) {
                        child.parse(reader, parentAddress, list);
                    }
                    continue;
                } else {
                    child.parse(reader, parentAddress, list);
                    continue;
                }
            }
            if (!this.attributeElements.containsKey(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement(reader, children.keySet());
            }
            AttributeDefinition ad = this.attributeElements.get(reader.getLocalName());
            ad.getParser().parseElement(ad, reader, op);
        } while (reader.hasNext() && reader.nextTag() != 2);
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.persist(writer, model, this.namespaceURI);
    }

    private void writeStartElement(XMLExtendedStreamWriter writer, String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI != null) {
            writer.writeStartElement(namespaceURI, localName);
        } else {
            writer.writeStartElement(localName);
        }
    }

    private void startSubsystemElement(XMLExtendedStreamWriter writer, String namespaceURI, boolean empty) throws XMLStreamException {
        if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
            writer.setDefaultNamespace(namespaceURI);
            if (empty) {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            } else {
                writer.writeStartElement(Element.SUBSYSTEM.getLocalName());
            }
            writer.writeNamespace(null, namespaceURI);
        } else if (empty) {
            writer.writeEmptyElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        } else {
            writer.writeStartElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
        boolean writeWrapper;
        boolean wildcard = this.getPathElement().isWildcard();
        model = wildcard ? model.get(this.getPathElement().getKey()) : model.get(this.getPathElement().getKeyValuePair());
        boolean isSubsystem = this.getPathElement().getKey().equals("subsystem");
        if (!(isSubsystem || model.isDefined() || this.useValueAsElementName)) {
            return;
        }
        boolean bl = writeWrapper = this.xmlWrapperElement != null;
        if (writeWrapper) {
            this.writeStartElement(writer, namespaceURI, this.xmlWrapperElement);
        }
        if (wildcard) {
            for (String name : model.keys()) {
                ModelNode subModel = model.get(name);
                if (this.useValueAsElementName) {
                    this.writeStartElement(writer, namespaceURI, name);
                } else {
                    this.writeStartElement(writer, namespaceURI, this.xmlElementName);
                    writer.writeAttribute(this.nameAttributeName, name);
                }
                this.persistAttributes(writer, subModel);
                this.persistChildren(writer, subModel);
                writer.writeEndElement();
            }
        } else {
            boolean empty;
            boolean bl2 = empty = this.attributeGroups.isEmpty() && this.children.isEmpty();
            if (this.useValueAsElementName) {
                this.writeStartElement(writer, namespaceURI, this.getPathElement().getValue());
            } else if (isSubsystem) {
                this.startSubsystemElement(writer, namespaceURI, empty);
            } else {
                this.writeStartElement(writer, namespaceURI, this.xmlElementName);
            }
            this.persistAttributes(writer, model);
            this.persistChildren(writer, model);
            if (!isSubsystem || !empty) {
                writer.writeEndElement();
            }
        }
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    private void persistAttributes(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.marshallAttributes(writer, model, this.attributesByGroup.get(null).values(), null);
        if (this.useElementsForGroups) {
            for (Map.Entry<String, LinkedHashMap<String, AttributeDefinition>> entry : this.attributesByGroup.entrySet()) {
                if (entry.getKey() == null) continue;
                this.marshallAttributes(writer, model, entry.getValue().values(), entry.getKey());
            }
        }
    }

    private void marshallAttributes(XMLExtendedStreamWriter writer, ModelNode model, Collection<AttributeDefinition> attributes, String group) throws XMLStreamException {
        boolean started = false;
        ArrayList<AttributeDefinition> sortedAds = new ArrayList<AttributeDefinition>(attributes.size());
        ArrayList<AttributeDefinition> elementAds = null;
        for (AttributeDefinition ad : attributes) {
            if (ad.getParser().isParseAsElement()) {
                if (elementAds == null) {
                    elementAds = new ArrayList<AttributeDefinition>();
                }
                elementAds.add(ad);
                continue;
            }
            sortedAds.add(ad);
        }
        if (elementAds != null) {
            sortedAds.addAll(elementAds);
        }
        for (AttributeDefinition ad : sortedAds) {
            AttributeMarshaller marshaller = this.attributeMarshallers.getOrDefault(ad.getXmlName(), ad.getAttributeMarshaller());
            if (!marshaller.isMarshallable(ad, model, this.marshallDefaultValues)) continue;
            if (!started && group != null) {
                if (elementAds != null) {
                    writer.writeStartElement(group);
                } else {
                    writer.writeEmptyElement(group);
                }
                started = true;
            }
            marshaller.marshall(ad, model, this.marshallDefaultValues, (XMLStreamWriter)writer);
        }
        if (elementAds != null && started) {
            writer.writeEndElement();
        }
    }

    public void persistChildren(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        for (PersistentResourceXMLDescription child : this.children) {
            child.persist(writer, model);
        }
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(PersistentResourceDefinition resource) {
        return new PersistentResourceXMLBuilder(resource.getPathElement());
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(ResourceDefinition resource) {
        return new PersistentResourceXMLBuilder(resource.getPathElement());
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(PersistentResourceDefinition resource, String namespaceURI) {
        return new PersistentResourceXMLBuilder(resource.getPathElement(), namespaceURI);
    }

    public static PersistentResourceXMLBuilder builder(PathElement pathElement) {
        return new PersistentResourceXMLBuilder(pathElement);
    }

    public static PersistentResourceXMLBuilder builder(PathElement pathElement, String namespaceURI) {
        return new PersistentResourceXMLBuilder(pathElement, namespaceURI);
    }

    public static interface AdditionalOperationsGenerator {
        public void additionalOperations(PathAddress var1, ModelNode var2, List<ModelNode> var3);
    }

    public static final class PersistentResourceXMLBuilder {
        protected final PathElement pathElement;
        private final String namespaceURI;
        private String xmlElementName;
        private String xmlWrapperElement;
        private boolean useValueAsElementName;
        private boolean noAddOperation;
        private AdditionalOperationsGenerator additionalOperationsGenerator;
        private final LinkedList<AttributeDefinition> attributeList = new LinkedList();
        private final List<PersistentResourceXMLBuilder> childrenBuilders = new ArrayList<PersistentResourceXMLBuilder>();
        private final List<PersistentResourceXMLDescription> children = new ArrayList<PersistentResourceXMLDescription>();
        private final LinkedHashMap<String, AttributeParser> attributeParsers = new LinkedHashMap();
        private final LinkedHashMap<String, AttributeMarshaller> attributeMarshallers = new LinkedHashMap();
        private boolean useElementsForGroups = true;
        private String forcedName;
        private boolean marshallDefaultValues = false;
        private String nameAttributeName = "name";

        private PersistentResourceXMLBuilder(PathElement pathElement) {
            this.pathElement = pathElement;
            this.namespaceURI = null;
            this.xmlElementName = pathElement.isWildcard() ? pathElement.getKey() : pathElement.getValue();
        }

        private PersistentResourceXMLBuilder(PathElement pathElement, String namespaceURI) {
            this.pathElement = pathElement;
            this.namespaceURI = namespaceURI;
            this.xmlElementName = pathElement.isWildcard() ? pathElement.getKey() : pathElement.getValue();
        }

        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLBuilder builder) {
            this.childrenBuilders.add(builder);
            return this;
        }

        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLDescription builder) {
            this.children.add(builder);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute) {
            this.attributeList.add(attribute);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser) {
            this.attributeList.add(attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
            this.attributeList.add(attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            this.attributeMarshallers.put(attribute.getXmlName(), attributeMarshaller);
            return this;
        }

        public PersistentResourceXMLBuilder addAttributes(AttributeDefinition ... attributes) {
            Collections.addAll(this.attributeList, attributes);
            return this;
        }

        public PersistentResourceXMLBuilder setXmlWrapperElement(String xmlWrapperElement) {
            this.xmlWrapperElement = xmlWrapperElement;
            return this;
        }

        public PersistentResourceXMLBuilder setXmlElementName(String xmlElementName) {
            this.xmlElementName = xmlElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setUseValueAsElementName(boolean useValueAsElementName) {
            this.useValueAsElementName = useValueAsElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setNoAddOperation(boolean noAddOperation) {
            this.noAddOperation = noAddOperation;
            return this;
        }

        public PersistentResourceXMLBuilder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
            this.additionalOperationsGenerator = additionalOperationsGenerator;
            return this;
        }

        public PersistentResourceXMLBuilder setForcedName(String forcedName) {
            this.forcedName = forcedName;
            return this;
        }

        public PersistentResourceXMLBuilder setUseElementsForGroups(boolean useElementsForGroups) {
            this.useElementsForGroups = useElementsForGroups;
            return this;
        }

        public PersistentResourceXMLBuilder setMarshallDefaultValues(boolean marshallDefault) {
            this.marshallDefaultValues = marshallDefault;
            return this;
        }

        public PersistentResourceXMLBuilder setNameAttributeName(String nameAttributeName) {
            this.nameAttributeName = nameAttributeName;
            return this;
        }

        public PersistentResourceXMLDescription build() {
            return new PersistentResourceXMLDescription(this);
        }
    }
}

