/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CommandCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public final class CredentialReference {
    public static final String CREDENTIAL_STORE_CAPABILITY = "org.wildfly.security.credential-store";
    public static final String CREDENTIAL_REFERENCE = "credential-reference";
    public static final String STORE = "store";
    public static final String ALIAS = "alias";
    public static final String TYPE = "type";
    public static final String CLEAR_TEXT = "clear-text";
    static final SimpleAttributeDefinition credentialStoreAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("store", ModelType.STRING, true).setXmlName("store")).build();
    static final SimpleAttributeDefinition credentialAliasAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, true).setXmlName("alias")).build();
    static final SimpleAttributeDefinition credentialTypeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setXmlName("type")).build();
    static final SimpleAttributeDefinition clearTextAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("clear-text", ModelType.STRING, true).setXmlName("clear-text")).build();
    static final ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition = CredentialReference.getAttributeBuilder("credential-reference", "credential-reference", false).build();

    private CredentialReference() {
    }

    public static ObjectTypeAttributeDefinition getAttributeDefinition() {
        return credentialReferenceAttributeDefinition;
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull) {
        return ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder(name, credentialStoreAttribute, credentialAliasAttribute, credentialTypeAttribute, clearTextAttribute).setXmlName(xmlName)).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setAttributeParser(AttributeParser.OBJECT_PARSER)).setAllowNull(allowNull);
    }

    public static String credentialReferencePartAsStringIfDefined(ModelNode credentialReferenceValue, String name) throws OperationFailedException {
        assert (credentialReferenceValue.isDefined()) : credentialReferenceValue;
        ModelNode result = credentialReferenceValue.get(name);
        if (result.isDefined()) {
            return result.asString();
        }
        return null;
    }

    public static ExceptionSupplier<CredentialSource, Exception> getCredentialSourceSupplier(OperationContext context, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        String secret;
        String credentialType;
        String credentialAlias;
        String credentialStoreName;
        ModelNode value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined(value, STORE);
            credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined(value, ALIAS);
            credentialType = CredentialReference.credentialReferencePartAsStringIfDefined(value, TYPE);
            secret = CredentialReference.credentialReferencePartAsStringIfDefined(value, CLEAR_TEXT);
        } else {
            credentialStoreName = null;
            credentialAlias = null;
            credentialType = null;
            secret = null;
        }
        final InjectedValue credentialStoreInjectedValue = new InjectedValue();
        if (credentialAlias != null) {
            String credentialStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName(CREDENTIAL_STORE_CAPABILITY, credentialStoreName);
            ServiceName credentialStoreServiceName = context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class);
            serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, credentialStoreServiceName, CredentialStore.class, (Injector)credentialStoreInjectedValue);
        }
        return new ExceptionSupplier<CredentialSource, Exception>(){

            private String[] parseCommand(String command) {
                String[] parsedCommand = command.split("(?<!\\\\),");
                for (int k = 0; k < parsedCommand.length; ++k) {
                    if (parsedCommand[k].indexOf(92) == -1) continue;
                    parsedCommand[k] = parsedCommand[k].replaceAll("\\\\,", ",");
                }
                return parsedCommand;
            }

            private String stripType(String commandSpec) {
                StringTokenizer tokenizer = new StringTokenizer(commandSpec, "{}");
                tokenizer.nextToken();
                return tokenizer.nextToken();
            }

            public CredentialSource get() throws Exception {
                if (credentialAlias != null) {
                    return new CredentialStoreCredentialSource((CredentialStore)credentialStoreInjectedValue.getValue(), credentialAlias);
                }
                if (credentialType != null && credentialType.equalsIgnoreCase("COMMAND")) {
                    CommandCredentialSource.Builder command = CommandCredentialSource.builder();
                    String commandSpec = secret.trim();
                    if (commandSpec.startsWith("{EXT")) {
                        commandSpec = this.stripType(commandSpec);
                        command.addCommand(commandSpec);
                    } else if (commandSpec.startsWith("{CMD")) {
                        String[] parts;
                        for (String part : parts = this.parseCommand(this.stripType(commandSpec))) {
                            command.addCommand(part);
                        }
                    }
                    return command.build();
                }
                if (secret != null && secret.startsWith("MASK-")) {
                    return new CredentialSource(){

                        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                            return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
                        }

                        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                            int iterationCount;
                            String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
                            String DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL = "somearbitrarycrazystringthatdoesnotmatter";
                            String[] part = secret.substring(5).split(";");
                            if (part.length != 3) {
                                throw ControllerLogger.ROOT_LOGGER.wrongMaskedPasswordFormat();
                            }
                            String salt = part[1];
                            try {
                                iterationCount = Integer.parseInt(part[2]);
                            }
                            catch (NumberFormatException e) {
                                throw ControllerLogger.ROOT_LOGGER.wrongMaskedPasswordFormat();
                            }
                            try {
                                PasswordBasedEncryptionUtil decryptUtil = new PasswordBasedEncryptionUtil.Builder().alphabet((Alphabet)Alphabet.Base64Alphabet.PICKETBOX_COMPATIBILITY).keyAlgorithm("PBEWithMD5AndDES").password("somearbitrarycrazystringthatdoesnotmatter").salt(salt).iteration(iterationCount).decryptMode().build();
                                return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])decryptUtil.decodeAndDecrypt(part[0])))));
                            }
                            catch (GeneralSecurityException e) {
                                throw new IOException(e);
                            }
                        }
                    };
                }
                if (secret != null) {
                    return new CredentialSource(){

                        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                            return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
                        }

                        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                            return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray()))));
                        }
                    };
                }
                return null;
            }
        };
    }
}

