/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.jboss.as.controller.interfaces.OverallInterfaceCriteria;
import org.jboss.as.controller.logging.ControllerLogger;
import org.wildfly.common.Assert;

public class InetAddressMatchInterfaceCriteria
extends AbstractInterfaceCriteria {
    private static final long serialVersionUID = 149404752878332750L;
    private String address;
    private InetAddress resolved;
    private boolean unknownHostLogged;
    private boolean anyLocalLogged;

    public InetAddressMatchInterfaceCriteria(InetAddress address) {
        Assert.checkNotNullParam((String)"address", (Object)address);
        this.resolved = address;
        this.address = this.resolved.getHostAddress();
    }

    public InetAddressMatchInterfaceCriteria(String address) {
        Assert.checkNotNullParam((String)"address", (Object)address);
        Assert.checkNotEmptyParam((String)"address", (String)address.trim());
        this.address = address;
    }

    public synchronized InetAddress getAddress() throws UnknownHostException {
        if (this.resolved == null) {
            this.resolved = InetAddress.getByName(this.address);
        }
        return this.resolved;
    }

    @Override
    public Map<NetworkInterface, Set<InetAddress>> getAcceptableAddresses(Map<NetworkInterface, Set<InetAddress>> candidates) throws SocketException {
        Map<NetworkInterface, Set<InetAddress>> pruned;
        Map<NetworkInterface, Set<InetAddress>> result = super.getAcceptableAddresses(candidates);
        Map<NetworkInterface, Set<InetAddress>> map = pruned = result.size() > 1 ? OverallInterfaceCriteria.pruneAliasDuplicates(result) : result;
        if (pruned.size() > 1 || pruned.size() == 1 && pruned.values().iterator().next().size() > 1) {
            this.logMultipleValidInterfaces(pruned);
            result = Collections.emptyMap();
        }
        return result;
    }

    @Override
    protected InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        try {
            InetAddress toMatch = this.getAddress();
            if (!this.anyLocalLogged && toMatch.isAnyLocalAddress()) {
                ControllerLogger.MGMT_OP_LOGGER.invalidWildcardAddress(this.address, "inet-address", "any-address");
                this.anyLocalLogged = true;
            }
            if (toMatch.equals(address)) {
                if (toMatch instanceof Inet6Address) {
                    return InetAddressMatchInterfaceCriteria.matchIPv6((Inet6Address)toMatch, (Inet6Address)address);
                }
                return toMatch;
            }
        }
        catch (UnknownHostException e) {
            if (!this.unknownHostLogged) {
                ControllerLogger.MGMT_OP_LOGGER.cannotResolveAddress(this.address);
                this.unknownHostLogged = true;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InetAddressMatchInterfaceCriteria(");
        sb.append("address=");
        sb.append(this.address);
        sb.append(",resolved=");
        sb.append(this.resolved);
        sb.append(')');
        return sb.toString();
    }

    private static InetAddress matchIPv6(Inet6Address toMatch, Inet6Address address) {
        return toMatch.getScopeId() == 0 || toMatch.getScopeId() == address.getScopeId() ? address : null;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof InetAddressMatchInterfaceCriteria && this.address != null) {
            return this.address.equals(((InetAddressMatchInterfaceCriteria)o).address);
        }
        return false;
    }

    private void logMultipleValidInterfaces(Map<NetworkInterface, Set<InetAddress>> matches) {
        HashSet<String> nis = new HashSet<String>();
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : matches.entrySet()) {
            nis.add(entry.getKey().getName());
            addresses.addAll((Collection<InetAddress>)entry.getValue());
        }
        String toMatch = this.resolved != null ? this.resolved.getHostAddress() : this.address;
        ControllerLogger.ROOT_LOGGER.multipleMatchingAddresses(toMatch, addresses, nis);
    }
}

