package org.jboss.as.controller.logging;

import java.util.Locale;
import java.io.Serializable;
import java.io.Closeable;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import java.lang.String;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.OperationContext.Stage;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import org.jboss.modules.ModuleNotFoundException;
import java.lang.Character;
import java.lang.NumberFormatException;
import org.jboss.as.controller.registry.OperationEntry.Flag;
import java.util.concurrent.CancellationException;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.dmr.ModelNode;
import java.util.Arrays;
import java.net.InetAddress;
import java.io.File;
import org.jboss.modules.ModuleLoadException;
import java.lang.IllegalStateException;
import java.lang.StringBuilder;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.logging.Logger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.registry.Resource.NoSuchResourceException;
import org.jboss.as.controller.ProcessType;
import java.lang.RuntimeException;
import java.lang.Number;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.msc.service.StartException;
import org.jboss.modules.ModuleIdentifier;
import java.nio.file.Path;
import javax.annotation.Generated;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.Exception;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.access.rbac.UnknowRoleException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.dmr.ModelType;
import org.jboss.as.controller._private.OperationCancellationException;
import org.jboss.as.controller.ModelVersion;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-13T10:53:22-0500")
public class ControllerLogger_$logger extends DelegatingBasicLogger implements ControllerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ControllerLogger_$logger.class.getName();
    public ControllerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotResolveAddress(final String address) {
        super.log.logf(FQCN, WARN, null, cannotResolveAddress$str(), address);
    }
    private static final String cannotResolveAddress = "WFLYCTL0001: Cannot resolve address %s, so cannot match it to any InetAddress";
    protected String cannotResolveAddress$str() {
        return cannotResolveAddress;
    }
    @Override
    public final void errorBootingContainer(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorBootingContainer0$str());
    }
    private static final String errorBootingContainer0 = "WFLYCTL0002: Error booting the container";
    protected String errorBootingContainer0$str() {
        return errorBootingContainer0;
    }
    @Override
    public final void errorBootingContainer(final Throwable cause, final long bootStackSize, final String name) {
        super.log.logf(FQCN, ERROR, cause, errorBootingContainer2$str(), bootStackSize, name);
    }
    private static final String errorBootingContainer2 = "WFLYCTL0003: Error booting the container due to insufficient stack space for the thread used to execute boot operations. The thread was configured with a stack size of [%1$d]. Setting system property %2$s to a value higher than [%1$d] may resolve this problem.";
    protected String errorBootingContainer2$str() {
        return errorBootingContainer2;
    }
    @Override
    public final void errorRevertingOperation(final Throwable cause, final String className, final String op, final PathAddress address) {
        super.log.logf(FQCN, ERROR, cause, errorRevertingOperation$str(), className, op, address);
    }
    private static final String errorRevertingOperation = "WFLYCTL0004: %s caught exception attempting to revert operation %s at address %s";
    protected String errorRevertingOperation$str() {
        return errorRevertingOperation;
    }
    @Override
    public final void failedExecutingOperation(final Throwable cause, final ModelNode op, final PathAddress path) {
        super.log.logf(FQCN, ERROR, cause, failedExecutingOperation$str(), op, path);
    }
    private static final String failedExecutingOperation = "WFLYCTL0005: Failed executing operation %s at address %s";
    protected String failedExecutingOperation$str() {
        return failedExecutingOperation;
    }
    @Override
    public final void failedSubsystemBootOperations(final Throwable cause, final String name) {
        super.log.logf(FQCN, ERROR, cause, failedSubsystemBootOperations$str(), name);
    }
    private static final String failedSubsystemBootOperations = "WFLYCTL0006: Failed executing subsystem %s boot operations";
    protected String failedSubsystemBootOperations$str() {
        return failedSubsystemBootOperations;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final Closeable closeable) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseResource$str(), closeable);
    }
    private static final String failedToCloseResource = "WFLYCTL0007: Failed to close resource %s";
    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final XMLStreamWriter writer) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseResource$str(), writer);
    }
    @Override
    public final void failedToPersistConfigurationChange(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToPersistConfigurationChange0$str());
    }
    private static final String failedToPersistConfigurationChange0 = "WFLYCTL0008: Failed to persist configuration change";
    protected String failedToPersistConfigurationChange0$str() {
        return failedToPersistConfigurationChange0;
    }
    @Override
    public final void failedToStoreConfiguration(final Throwable cause, final String name) {
        super.log.logf(FQCN, ERROR, cause, failedToStoreConfiguration$str(), name);
    }
    private static final String failedToStoreConfiguration = "WFLYCTL0009: Failed to store configuration to %s";
    protected String failedToStoreConfiguration$str() {
        return failedToStoreConfiguration;
    }
    @Override
    public final void invalidSystemPropertyValue(final String value, final String name, final int defaultValue) {
        super.log.logf(FQCN, ERROR, null, invalidSystemPropertyValue$str(), value, name, defaultValue);
    }
    private static final String invalidSystemPropertyValue = "WFLYCTL0010: Invalid value %s for system property %s -- using default value [%d]";
    protected String invalidSystemPropertyValue$str() {
        return invalidSystemPropertyValue;
    }
    @Override
    public final void invalidWildcardAddress(final String address, final String inetAddress, final String anyAddress) {
        super.log.logf(FQCN, WARN, null, invalidWildcardAddress$str(), address, inetAddress, anyAddress);
    }
    private static final String invalidWildcardAddress = "WFLYCTL0011: Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration element to specify that an interface should use a wildcard address; use '%3$s'";
    protected String invalidWildcardAddress$str() {
        return invalidWildcardAddress;
    }
    @Override
    public final void operationFailed(final Throwable cause, final ModelNode op, final ModelNode opAddress) {
        super.log.logf(FQCN, ERROR, cause, operationFailed2$str(), op, opAddress);
    }
    private static final String operationFailed2 = "WFLYCTL0013: Operation (%s) failed - address: (%s)";
    protected String operationFailed2$str() {
        return operationFailed2;
    }
    @Override
    public final void operationFailed(final ModelNode op, final ModelNode opAddress, final ModelNode failureDescription) {
        super.log.logf(FQCN, ERROR, null, operationFailed3$str(), op, opAddress, failureDescription);
    }
    private static final String operationFailed3 = "WFLYCTL0013: Operation (%s) failed - address: (%s) - failure description: %s";
    protected String operationFailed3$str() {
        return operationFailed3;
    }
    @Override
    public final void wildcardAddressDetected() {
        super.log.logf(FQCN, WARN, null, wildcardAddressDetected$str());
    }
    private static final String wildcardAddressDetected = "WFLYCTL0015: Wildcard address detected - will ignore other interface criteria.";
    protected String wildcardAddressDetected$str() {
        return wildcardAddressDetected;
    }
    @Override
    public final void noFinalProxyOutcomeReceived(final ModelNode op, final ModelNode opAddress, final ModelNode proxyAddress) {
        super.log.logf(FQCN, ERROR, null, noFinalProxyOutcomeReceived$str(), op, opAddress, proxyAddress);
    }
    private static final String noFinalProxyOutcomeReceived = "WFLYCTL0016: Received no final outcome response for operation %s with address %s from remote process at address %s. The result of this operation will only include the remote process' preliminary response to the request.";
    protected String noFinalProxyOutcomeReceived$str() {
        return noFinalProxyOutcomeReceived;
    }
    @Override
    public final void operationFailedOnClientError(final ModelNode op, final ModelNode opAddress, final ModelNode failureDescription) {
        super.log.logf(FQCN, DEBUG, null, operationFailedOnClientError$str(), op, opAddress, failureDescription);
    }
    private static final String operationFailedOnClientError = "WFLYCTL0017: Operation (%s) failed - address: (%s) - failure description: %s";
    protected String operationFailedOnClientError$str() {
        return operationFailedOnClientError;
    }
    @Override
    public final void gracefulManagementChannelHandlerShutdownTimedOut(final int timeout) {
        super.log.logf(FQCN, WARN, null, gracefulManagementChannelHandlerShutdownTimedOut$str(), timeout);
    }
    private static final String gracefulManagementChannelHandlerShutdownTimedOut = "WFLYCTL0019: Graceful shutdown of the handler used for native management requests did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding";
    protected String gracefulManagementChannelHandlerShutdownTimedOut$str() {
        return gracefulManagementChannelHandlerShutdownTimedOut;
    }
    @Override
    public final void gracefulManagementChannelHandlerShutdownFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, gracefulManagementChannelHandlerShutdownFailed$str());
    }
    private static final String gracefulManagementChannelHandlerShutdownFailed = "WFLYCTL0020: Graceful shutdown of the handler used for native management requests failed but shutdown of the underlying communication channel is proceeding";
    protected String gracefulManagementChannelHandlerShutdownFailed$str() {
        return gracefulManagementChannelHandlerShutdownFailed;
    }
    @Override
    public final void invalidChannelCloseTimeout(final NumberFormatException cause, final String propertyName, final String propValue) {
        super.log.logf(FQCN, WARN, cause, invalidChannelCloseTimeout$str(), propertyName, propValue);
    }
    private static final String invalidChannelCloseTimeout = "WFLYCTL0021: Invalid value '%s' for system property '%s' -- value must be convertible into an int";
    protected String invalidChannelCloseTimeout$str() {
        return invalidChannelCloseTimeout;
    }
    @Override
    public final void multipleMatchingAddresses(final String interfaceName, final java.util.Set<InetAddress> addresses, final java.util.Set<String> nis, final InetAddress inetAddress, final String networkInterface) {
        super.log.logf(FQCN, WARN, null, multipleMatchingAddresses5$str(), interfaceName, addresses, nis, inetAddress, networkInterface);
    }
    private static final String multipleMatchingAddresses5 = "WFLYCTL0022: Multiple addresses or network interfaces matched the selection criteria for interface '%s'. Matching addresses: %s.  Matching network interfaces: %s. The interface will use address %s and network interface %s.";
    protected String multipleMatchingAddresses5$str() {
        return multipleMatchingAddresses5;
    }
    @Override
    public final void multipleMatchingAddresses(final String toMatch, final java.util.Set<InetAddress> addresses, final java.util.Set<String> nis) {
        super.log.logf(FQCN, WARN, null, multipleMatchingAddresses3$str(), toMatch, addresses, nis);
    }
    private static final String multipleMatchingAddresses3 = "WFLYCTL0023: Value '%s' for interface selection criteria 'inet-address' is ambiguous, as more than one address or network interface available on the machine matches it. Because of this ambiguity, no address will be selected as a match. Matching addresses: %s.  Matching network interfaces: %s.";
    protected String multipleMatchingAddresses3$str() {
        return multipleMatchingAddresses3;
    }
    @Override
    public final void cannotReadTargetDefinition(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotReadTargetDefinition$str());
    }
    private static final String cannotReadTargetDefinition = "WFLYCTL0024: Could not read target definition!";
    protected String cannotReadTargetDefinition$str() {
        return cannotReadTargetDefinition;
    }
    @Override
    public final void interruptedWaitingStability(final String operation, final PathAddress address) {
        super.log.logf(FQCN, ERROR, null, interruptedWaitingStability$str(), operation, address);
    }
    private static final String interruptedWaitingStability = "WFLYCTL0027: Operation was interrupted before service container stability could be reached. Process should be restarted. Step that first updated the service container was '%s' at address '%s'";
    protected String interruptedWaitingStability$str() {
        return interruptedWaitingStability;
    }
    @Override
    public final void attributeDeprecated(final String name, final String address) {
        super.log.logf(FQCN, INFO, null, attributeDeprecated$str(), name, address);
    }
    private static final String attributeDeprecated = "WFLYCTL0028: Attribute '%s' in the resource at address '%s' is deprecated, and may be removed in future version. See the attribute description in the output of the read-resource-description operation to learn more about the deprecation.";
    protected String attributeDeprecated$str() {
        return attributeDeprecated;
    }
    @Override
    public final void cannotDeleteTempFile(final String name) {
        super.log.logf(FQCN, WARN, null, cannotDeleteTempFile$str(), name);
    }
    private static final String cannotDeleteTempFile = "WFLYCTL0029: Cannot delete temp file %s, will be deleted on exit";
    protected String cannotDeleteTempFile$str() {
        return cannotDeleteTempFile;
    }
    private static final String noSuchResourceType = "WFLYCTL0030: No resource definition is registered for address %s";
    protected String noSuchResourceType$str() {
        return noSuchResourceType;
    }
    @Override
    public final String noSuchResourceType(final PathAddress address) {
        return String.format(getLoggingLocale(), noSuchResourceType$str(), address);
    }
    private static final String noHandlerForOperation = "WFLYCTL0031: No operation named '%s' exists at address %s";
    protected String noHandlerForOperation$str() {
        return noHandlerForOperation;
    }
    @Override
    public final String noHandlerForOperation(final String operationName, final PathAddress address) {
        return String.format(getLoggingLocale(), noHandlerForOperation$str(), operationName, address);
    }
    @Override
    public final void transformationWarnings(final String hostName, final java.util.Set<String> problems) {
        super.log.logf(FQCN, WARN, null, transformationWarnings$str(), hostName, problems);
    }
    private static final String transformationWarnings = "WFLYCTL0032: There were problems during the transformation process for target host: '%s' %nProblems found: %n%s";
    protected String transformationWarnings$str() {
        return transformationWarnings;
    }
    @Override
    public final void extensionDeprecated(final String extensionName) {
        super.log.logf(FQCN, WARN, null, extensionDeprecated$str(), extensionName);
    }
    private static final String extensionDeprecated = "WFLYCTL0033: Extension '%s' is deprecated and may not be supported in future versions";
    protected String extensionDeprecated$str() {
        return extensionDeprecated;
    }
    @Override
    public final void ignoringUnsupportedLegacyExtension(final java.util.List<String> subsystemNames, final String extensionName) {
        super.log.logf(FQCN, INFO, null, ignoringUnsupportedLegacyExtension$str(), subsystemNames, extensionName);
    }
    private static final String ignoringUnsupportedLegacyExtension = "WFLYCTL0034: Subsystems %s provided by legacy extension '%s' are not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain. On this server the extension will not register any subsystems, and future attempts to create or address subsystem resources on this server will result in failure.";
    protected String ignoringUnsupportedLegacyExtension$str() {
        return ignoringUnsupportedLegacyExtension;
    }
    @Override
    public final void failedToUpdateAuditLog(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToUpdateAuditLog$str());
    }
    private static final String failedToUpdateAuditLog = "WFLYCTL0035: Update of the management operation audit log failed";
    protected String failedToUpdateAuditLog$str() {
        return failedToUpdateAuditLog;
    }
    @Override
    public final void disablingLoggingDueToFailures(final short failureCount) {
        super.log.logf(FQCN, ERROR, null, disablingLoggingDueToFailures$str(), failureCount);
    }
    private static final String disablingLoggingDueToFailures = "WFLYCTL0036: [%d] consecutive management operation audit logging failures have occurred; disabling audit logging";
    protected String disablingLoggingDueToFailures$str() {
        return disablingLoggingDueToFailures;
    }
    @Override
    public final void logHandlerWriteFailed(final Throwable t, final String name) {
        super.log.logf(FQCN, ERROR, t, logHandlerWriteFailed$str(), name);
    }
    private static final String logHandlerWriteFailed = "WFLYCTL0037: Update of the management operation audit log failed in handler '%s'";
    protected String logHandlerWriteFailed$str() {
        return logHandlerWriteFailed;
    }
    @Override
    public final void disablingLogHandlerDueToFailures(final int failureCount, final String name) {
        super.log.logf(FQCN, ERROR, null, disablingLogHandlerDueToFailures$str(), failureCount, name);
    }
    private static final String disablingLogHandlerDueToFailures = "WFLYCTL0038: [%d] consecutive management operation audit logging failures have occurred in handler '%s'; disabling this handler for audit logging";
    protected String disablingLogHandlerDueToFailures$str() {
        return disablingLogHandlerDueToFailures;
    }
    private static final String alreadyDefined = "WFLYCTL0039: %s already defined";
    protected String alreadyDefined$str() {
        return alreadyDefined;
    }
    @Override
    public final XMLStreamException alreadyDefined(final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), alreadyDefined$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyDeclared4 = "WFLYCTL0041: A %s %s already declared has already been declared in %s %s";
    protected String alreadyDeclared4$str() {
        return alreadyDeclared4;
    }
    @Override
    public final XMLStreamException alreadyDeclared(final String name, final String value, final String parentName, final String parentValue, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), alreadyDeclared4$str(), name, value, parentName, parentValue), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyDeclared5 = "WFLYCTL0042: A %s or a %s %s already declared has already been declared in %s %s";
    protected String alreadyDeclared5$str() {
        return alreadyDeclared5;
    }
    @Override
    public final XMLStreamException alreadyDeclared(final String name1, final String name2, final String value, final String parentName, final String parentValue, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), alreadyDeclared5$str(), name1, name2, value, parentName, parentValue), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyRegistered = "WFLYCTL0043: An %s named '%s' is already registered at location '%s'";
    protected String alreadyRegistered$str() {
        return alreadyRegistered;
    }
    @Override
    public final IllegalArgumentException alreadyRegistered(final String type, final String name, final String location) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), alreadyRegistered$str(), type, name, location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambiguousConfigurationFiles = "WFLYCTL0044: Ambiguous configuration file name '%s' as there are multiple files in %s that end in %s";
    protected String ambiguousConfigurationFiles$str() {
        return ambiguousConfigurationFiles;
    }
    @Override
    public final IllegalStateException ambiguousConfigurationFiles(final String backupType, final File searchDir, final String suffix) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ambiguousConfigurationFiles$str(), backupType, searchDir, suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambiguousName = "WFLYCTL0045: Ambiguous name '%s' in %s: %s";
    protected String ambiguousName$str() {
        return ambiguousName;
    }
    @Override
    public final IllegalArgumentException ambiguousName(final String prefix, final String dir, final java.util.Collection<String> files) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ambiguousName$str(), prefix, dir, files));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeNotWritable = "WFLYCTL0048: Attribute %s is not writable";
    protected String attributeNotWritable$str() {
        return attributeNotWritable;
    }
    @Override
    public final String attributeNotWritable(final String attributeName) {
        return String.format(getLoggingLocale(), attributeNotWritable$str(), attributeName);
    }
    private static final String cannotDetermineDefaultName = "WFLYCTL0050: Unable to determine a default name based on the local host name";
    protected String cannotDetermineDefaultName$str() {
        return cannotDetermineDefaultName;
    }
    @Override
    public final RuntimeException cannotDetermineDefaultName(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotDetermineDefaultName$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreate = "WFLYCTL0051: Could not create %s";
    protected String cannotCreate$str() {
        return cannotCreate;
    }
    @Override
    public final IllegalStateException cannotCreate(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCreate$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDelete = "WFLYCTL0052: Could not delete %s";
    protected String cannotDelete$str() {
        return cannotDelete;
    }
    @Override
    public final IllegalStateException cannotDelete(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotDelete$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRegisterSubmodelWithNullPath = "WFLYCTL0053: Cannot register submodels with a null PathElement";
    protected String cannotRegisterSubmodelWithNullPath$str() {
        return cannotRegisterSubmodelWithNullPath;
    }
    @Override
    public final IllegalArgumentException cannotRegisterSubmodelWithNullPath() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRegisterSubmodelWithNullPath$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRegisterSubmodel = "WFLYCTL0054: Cannot register non-runtime-only submodels with a runtime-only parent";
    protected String cannotRegisterSubmodel$str() {
        return cannotRegisterSubmodel;
    }
    @Override
    public final IllegalArgumentException cannotRegisterSubmodel() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRegisterSubmodel$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemove = "WFLYCTL0055: Cannot remove %s";
    protected String cannotRemove$str() {
        return cannotRemove;
    }
    @Override
    public final OperationFailedRuntimeException cannotRemove(final String name) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), cannotRemove$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotRename(final IOException ioe, final Path fromPath, final Path toPath) {
        super.log.logf(FQCN, ERROR, ioe, cannotRename$str(), fromPath, toPath);
    }
    private static final String cannotRename = "WFLYCTL0056: Could not rename %s to %s";
    protected String cannotRename$str() {
        return cannotRename;
    }
    private static final String cannotWriteTo = "WFLYCTL0057: Cannot write to %s";
    protected String cannotWriteTo$str() {
        return cannotWriteTo;
    }
    @Override
    public final IllegalArgumentException cannotWriteTo(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotWriteTo$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String childAlreadyDeclared = "WFLYCTL0058: Child %s of element %s already declared";
    protected String childAlreadyDeclared$str() {
        return childAlreadyDeclared;
    }
    @Override
    public final XMLStreamException childAlreadyDeclared(final String childName, final String parentName, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), childAlreadyDeclared$str(), childName, parentName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canonicalBootFileNotFound = "WFLYCTL0059: Could not get canonical file for boot file: %s";
    protected String canonicalBootFileNotFound$str() {
        return canonicalBootFileNotFound;
    }
    @Override
    public final RuntimeException canonicalBootFileNotFound(final Throwable cause, final File file) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), canonicalBootFileNotFound$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canonicalMainFileNotFound = "WFLYCTL0060: Could not get canonical file for main file: %s";
    protected String canonicalMainFileNotFound$str() {
        return canonicalMainFileNotFound;
    }
    @Override
    public final IllegalStateException canonicalMainFileNotFound(final Throwable cause, final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), canonicalMainFileNotFound$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String compositeOperationFailed = "WFLYCTL0062: Composite operation failed and was rolled back. Steps that failed:";
    protected String compositeOperationFailed$str() {
        return compositeOperationFailed;
    }
    @Override
    public final String compositeOperationFailed() {
        return String.format(getLoggingLocale(), compositeOperationFailed$str());
    }
    private static final String compositeOperationRolledBack = "WFLYCTL0063: Composite operation was rolled back";
    protected String compositeOperationRolledBack$str() {
        return compositeOperationRolledBack;
    }
    @Override
    public final String compositeOperationRolledBack() {
        return String.format(getLoggingLocale(), compositeOperationRolledBack$str());
    }
    private static final String configurationFileNameNotAllowed = "WFLYCTL0064: Configuration files whose complete name is %s are not allowed";
    protected String configurationFileNameNotAllowed$str() {
        return configurationFileNameNotAllowed;
    }
    @Override
    public final IllegalArgumentException configurationFileNameNotAllowed(final String backupType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), configurationFileNameNotAllowed$str(), backupType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationFileNotFound = "WFLYCTL0065: No configuration file ending in %s found in %s";
    protected String configurationFileNotFound$str() {
        return configurationFileNotFound;
    }
    @Override
    public final IllegalStateException configurationFileNotFound(final String suffix, final File dir) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationFileNotFound$str(), suffix, dir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String directoryNotFound = "WFLYCTL0066: No directory %s was found";
    protected String directoryNotFound$str() {
        return directoryNotFound;
    }
    @Override
    public final IllegalArgumentException directoryNotFound(final String pathName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), directoryNotFound$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainControllerMustBeDeclared = "WFLYCTL0067: Either a %s or %s domain controller configuration must be declared.";
    protected String domainControllerMustBeDeclared$str() {
        return domainControllerMustBeDeclared;
    }
    @Override
    public final XMLStreamException domainControllerMustBeDeclared(final String remoteName, final String localName, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), domainControllerMustBeDeclared$str(), remoteName, localName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateAttribute = "WFLYCTL0068: An attribute named '%s' has already been declared";
    protected String duplicateAttribute$str() {
        return duplicateAttribute;
    }
    @Override
    public final XMLStreamException duplicateAttribute(final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateAttribute$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateDeclaration1 = "WFLYCTL0069: Duplicate %s declaration";
    protected String duplicateDeclaration1$str() {
        return duplicateDeclaration1;
    }
    @Override
    public final XMLStreamException duplicateDeclaration(final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateDeclaration1$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateDeclaration2 = "WFLYCTL0070: Duplicate %s declaration %s";
    protected String duplicateDeclaration2$str() {
        return duplicateDeclaration2;
    }
    @Override
    public final XMLStreamException duplicateDeclaration(final String name, final String value, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateDeclaration2$str(), name, value), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateElement = "WFLYCTL0071: Duplicate path element '%s' found";
    protected String duplicateElement$str() {
        return duplicateElement;
    }
    @Override
    public final OperationFailedRuntimeException duplicateElement(final String name) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), duplicateElement$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateInterfaceDeclaration = "WFLYCTL0072: Duplicate interface declaration";
    protected String duplicateInterfaceDeclaration$str() {
        return duplicateInterfaceDeclaration;
    }
    @Override
    public final XMLStreamException duplicateInterfaceDeclaration(final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateInterfaceDeclaration$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateNamedElement = "WFLYCTL0073: An element of this type named '%s' has already been declared";
    protected String duplicateNamedElement$str() {
        return duplicateNamedElement;
    }
    @Override
    public final XMLStreamException duplicateNamedElement(final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateNamedElement$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateResource = "WFLYCTL0075: Duplicate resource %s";
    protected String duplicateResource$str() {
        return duplicateResource;
    }
    @Override
    public final IllegalStateException duplicateResource(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateResourceType = "WFLYCTL0076: Duplicate resource type %s";
    protected String duplicateResourceType$str() {
        return duplicateResourceType;
    }
    @Override
    public final IllegalStateException duplicateResourceType(final String type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateResourceType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedInitializingModule = "WFLYCTL0079: Failed initializing module %s";
    protected String failedInitializingModule$str() {
        return failedInitializingModule;
    }
    @Override
    public final RuntimeException failedInitializingModule(final Throwable cause, final String name) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedInitializingModule$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedServices = "WFLYCTL0080: Failed services";
    protected String failedServices$str() {
        return failedServices;
    }
    @Override
    public final String failedServices() {
        return String.format(getLoggingLocale(), failedServices$str());
    }
    private static final String failedToBackup = "WFLYCTL0081: Failed to back up %s";
    protected String failedToBackup$str() {
        return failedToBackup;
    }
    @Override
    public final ConfigurationPersistenceException failedToBackup(final Throwable cause, final File file) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToBackup$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreateConfigurationBackup = "WFLYCTL0082: Failed to create backup copies of configuration file %s";
    protected String failedToCreateConfigurationBackup$str() {
        return failedToCreateConfigurationBackup;
    }
    @Override
    public final ConfigurationPersistenceException failedToCreateConfigurationBackup(final Throwable cause, final File file) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToCreateConfigurationBackup$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadModule0 = "WFLYCTL0083: Failed to load module";
    protected String failedToLoadModule0$str() {
        return failedToLoadModule0;
    }
    @Override
    public final XMLStreamException failedToLoadModule(final Throwable cause) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), failedToLoadModule0$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadModule1 = "WFLYCTL0083: Failed to load module %s";
    protected String failedToLoadModule1$str() {
        return failedToLoadModule1;
    }
    @Override
    public final XMLStreamException failedToLoadModule(final Throwable cause, final String name) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), failedToLoadModule1$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToMarshalConfiguration = "WFLYCTL0084: Failed to marshal configuration";
    protected String failedToMarshalConfiguration$str() {
        return failedToMarshalConfiguration;
    }
    @Override
    public final ConfigurationPersistenceException failedToMarshalConfiguration(final Throwable cause) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToMarshalConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseConfiguration = "WFLYCTL0085: Failed to parse configuration";
    protected String failedToParseConfiguration$str() {
        return failedToParseConfiguration;
    }
    @Override
    public final ConfigurationPersistenceException failedToParseConfiguration(final Throwable cause) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToParseConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToPersistConfigurationChange1 = "WFLYCTL0086: Failed to persist configuration change: %s";
    protected String failedToPersistConfigurationChange1$str() {
        return failedToPersistConfigurationChange1;
    }
    @Override
    public final String failedToPersistConfigurationChange(final String cause) {
        return String.format(getLoggingLocale(), failedToPersistConfigurationChange1$str(), cause);
    }
    private static final String failedToTakeSnapshot = "WFLYCTL0088: Failed to take a snapshot of %s to %s";
    protected String failedToTakeSnapshot$str() {
        return failedToTakeSnapshot;
    }
    @Override
    public final ConfigurationPersistenceException failedToTakeSnapshot(final Throwable cause, final File file, final File snapshot) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToTakeSnapshot$str(), file, snapshot), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToWriteConfiguration = "WFLYCTL0089: Failed to write configuration";
    protected String failedToWriteConfiguration$str() {
        return failedToWriteConfiguration;
    }
    @Override
    public final ConfigurationPersistenceException failedToWriteConfiguration(final Throwable cause) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToWriteConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileNotFound = "WFLYCTL0090: %s does not exist";
    protected String fileNotFound$str() {
        return fileNotFound;
    }
    @Override
    public final IllegalArgumentException fileNotFound(final String path1) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fileNotFound$str(), path1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileNotFoundWithPrefix = "WFLYCTL0091: No files beginning with '%s' found in %s";
    protected String fileNotFoundWithPrefix$str() {
        return fileNotFoundWithPrefix;
    }
    @Override
    public final IllegalArgumentException fileNotFoundWithPrefix(final String prefix, final String dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fileNotFoundWithPrefix$str(), prefix, dir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fullServerBootRequired = "WFLYCTL0092: %s cannot be used except in a full server boot";
    protected String fullServerBootRequired$str() {
        return fullServerBootRequired;
    }
    @Override
    public final IllegalStateException fullServerBootRequired(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), fullServerBootRequired$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalInterfaceCriteria = "WFLYCTL0094: Illegal interface criteria type %s; must be %s";
    protected String illegalInterfaceCriteria$str() {
        return illegalInterfaceCriteria;
    }
    @Override
    public final String illegalInterfaceCriteria(final ModelType invalidType, final ModelType validType) {
        return String.format(getLoggingLocale(), illegalInterfaceCriteria$str(), invalidType, validType);
    }
    private static final String illegalValueForInterfaceCriteria = "WFLYCTL0095: Illegal value %s for interface criteria %s; must be %s";
    protected String illegalValueForInterfaceCriteria$str() {
        return illegalValueForInterfaceCriteria;
    }
    @Override
    public final String illegalValueForInterfaceCriteria(final ModelType valueType, final String id, final ModelType validType) {
        return String.format(getLoggingLocale(), illegalValueForInterfaceCriteria$str(), valueType, id, validType);
    }
    private static final String immutableResource = "WFLYCTL0096: Resource is immutable";
    protected String immutableResource$str() {
        return immutableResource;
    }
    @Override
    public final UnsupportedOperationException immutableResource() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), immutableResource$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectType = "WFLYCTL0097: Wrong type for '%s'. Expected %s but was %s";
    protected String incorrectType$str() {
        return incorrectType;
    }
    @Override
    public final OperationFailedException incorrectType(final String name, final java.util.Collection<ModelType> validTypes, final ModelType invalidType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), incorrectType$str(), name, validTypes, invalidType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalid1 = "WFLYCTL0099: %s is invalid";
    protected String invalid1$str() {
        return invalid1;
    }
    @Override
    public final String invalid(final String name) {
        return String.format(getLoggingLocale(), invalid1$str(), name);
    }
    private static final String invalid2 = "WFLYCTL0100: %d is not a valid %s";
    protected String invalid2$str() {
        return invalid2;
    }
    @Override
    public final XMLStreamException invalid(final Throwable cause, final int value, final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalid2$str(), value, name), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddress = "WFLYCTL0101: Invalid address %s (%s)";
    protected String invalidAddress$str() {
        return invalidAddress;
    }
    @Override
    public final String invalidAddress(final String address, final String msg) {
        return String.format(getLoggingLocale(), invalidAddress$str(), address, msg);
    }
    private static final String invalidAddressMaskValue = "WFLYCTL0102: Invalid 'value' %s -- must be of the form address/mask";
    protected String invalidAddressMaskValue$str() {
        return invalidAddressMaskValue;
    }
    @Override
    public final String invalidAddressMaskValue(final String value) {
        return String.format(getLoggingLocale(), invalidAddressMaskValue$str(), value);
    }
    private static final String invalidAddressMask = "WFLYCTL0103: Invalid mask %s (%s)";
    protected String invalidAddressMask$str() {
        return invalidAddressMask;
    }
    @Override
    public final String invalidAddressMask(final String mask, final String msg) {
        return String.format(getLoggingLocale(), invalidAddressMask$str(), mask, msg);
    }
    private static final String invalidAddressValue = "WFLYCTL0104: Invalid address %s (%s)";
    protected String invalidAddressValue$str() {
        return invalidAddressValue;
    }
    @Override
    public final String invalidAddressValue(final String value, final String msg) {
        return String.format(getLoggingLocale(), invalidAddressValue$str(), value, msg);
    }
    private static final String invalidAttributeCombo = "WFLYCTL0105: %s is invalid in combination with %s";
    protected String invalidAttributeCombo$str() {
        return invalidAttributeCombo;
    }
    @Override
    public final String invalidAttributeCombo(final String attributeName, final StringBuilder combos) {
        return String.format(getLoggingLocale(), invalidAttributeCombo$str(), attributeName, combos);
    }
    private static final String invalidAttributeValue2 = "WFLYCTL0106: Invalid value '%s' for attribute '%s'";
    protected String invalidAttributeValue2$str() {
        return invalidAttributeValue2;
    }
    @Override
    public final XMLStreamException invalidAttributeValue(final String value, final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidAttributeValue2$str(), value, name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAttributeValue4 = "WFLYCTL0107: Illegal value %d for attribute '%s' must be between %d and %d (inclusive)";
    protected String invalidAttributeValue4$str() {
        return invalidAttributeValue4;
    }
    @Override
    public final XMLStreamException invalidAttributeValue(final int value, final QName name, final int minInclusive, final int maxInclusive, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidAttributeValue4$str(), value, name, minInclusive, maxInclusive), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAttributeValueInt = "WFLYCTL0108: Illegal value '%s' for attribute '%s' must be an integer";
    protected String invalidAttributeValueInt$str() {
        return invalidAttributeValueInt;
    }
    @Override
    public final XMLStreamException invalidAttributeValueInt(final Throwable cause, final String value, final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidAttributeValueInt$str(), value, name), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInterfaceCriteriaPattern = "WFLYCTL0109: Invalid pattern %s for interface criteria %s";
    protected String invalidInterfaceCriteriaPattern$str() {
        return invalidInterfaceCriteriaPattern;
    }
    @Override
    public final String invalidInterfaceCriteriaPattern(final String pattern, final String name) {
        return String.format(getLoggingLocale(), invalidInterfaceCriteriaPattern$str(), pattern, name);
    }
    private static final String invalidPathElementKey = "WFLYCTL0110: Invalid resource address element '%s'. The key '%s' is not valid for an element in a resource address.";
    protected String invalidPathElementKey$str() {
        return invalidPathElementKey;
    }
    @Override
    public final String invalidPathElementKey(final String element, final String key) {
        return String.format(getLoggingLocale(), invalidPathElementKey$str(), element, key);
    }
    private static final String invalidLoadFactor = "WFLYCTL0111: Load factor must be greater than 0 and less than or equal to 1";
    protected String invalidLoadFactor$str() {
        return invalidLoadFactor;
    }
    @Override
    public final IllegalArgumentException invalidLoadFactor() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidLoadFactor$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMaxLength = "WFLYCTL0112: '%s' is an invalid value for parameter %s. Values must have a maximum length of %d characters";
    protected String invalidMaxLength$str() {
        return invalidMaxLength;
    }
    @Override
    public final String invalidMaxLength(final String value, final String name, final int length) {
        return String.format(getLoggingLocale(), invalidMaxLength$str(), value, name, length);
    }
    private static final String invalidMinLength = "WFLYCTL0113: '%s' is an invalid value for parameter %s. Values must have a minimum length of %d characters";
    protected String invalidMinLength$str() {
        return invalidMinLength;
    }
    @Override
    public final String invalidMinLength(final String value, final String name, final int length) {
        return String.format(getLoggingLocale(), invalidMinLength$str(), value, name, length);
    }
    private static final String invalidMaxSize = "WFLYCTL0114: [%d] is an invalid size for parameter %s. A maximum length of [%d] is required";
    protected String invalidMaxSize$str() {
        return invalidMaxSize;
    }
    @Override
    public final String invalidMaxSize(final int size, final String name, final int maxSize) {
        return String.format(getLoggingLocale(), invalidMaxSize$str(), size, name, maxSize);
    }
    private static final String invalidMinSize = "WFLYCTL0115: [%d] is an invalid size for parameter %s. A minimum length of [%d] is required";
    protected String invalidMinSize$str() {
        return invalidMinSize;
    }
    @Override
    public final String invalidMinSize(final int size, final String name, final int minSize) {
        return String.format(getLoggingLocale(), invalidMinSize$str(), size, name, minSize);
    }
    private static final String invalidMaxValue = "WFLYCTL0116: %d is an invalid value for parameter %s. A maximum value of %d is required";
    protected String invalidMaxValue$str() {
        return invalidMaxValue;
    }
    @Override
    public final String invalidMaxValue(final int value, final String name, final int maxValue) {
        return String.format(getLoggingLocale(), invalidMaxValue$str(), value, name, maxValue);
    }
    @Override
    public final String invalidMaxValue(final long value, final String name, final long maxValue) {
        return String.format(getLoggingLocale(), invalidMaxValue$str(), value, name, maxValue);
    }
    private static final String invalidMinValue = "WFLYCTL0117: %d is an invalid value for parameter %s. A minimum value of %d is required";
    protected String invalidMinValue$str() {
        return invalidMinValue;
    }
    @Override
    public final String invalidMinValue(final int value, final String name, final int minValue) {
        return String.format(getLoggingLocale(), invalidMinValue$str(), value, name, minValue);
    }
    @Override
    public final String invalidMinValue(final long value, final String name, final long minValue) {
        return String.format(getLoggingLocale(), invalidMinValue$str(), value, name, minValue);
    }
    private static final String invalidModificationAfterCompletedStep = "WFLYCTL0118: Invalid modification after completed step";
    protected String invalidModificationAfterCompletedStep$str() {
        return invalidModificationAfterCompletedStep;
    }
    @Override
    public final IllegalStateException invalidModificationAfterCompletedStep() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidModificationAfterCompletedStep$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMulticastAddress = "WFLYCTL0119: Value %s for attribute %s is not a valid multicast address";
    protected String invalidMulticastAddress$str() {
        return invalidMulticastAddress;
    }
    @Override
    public final OperationFailedException invalidMulticastAddress(final String value, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidMulticastAddress$str(), value, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOutboundSocketBinding = "WFLYCTL0120: An outbound socket binding: %s cannot have both %s as well as a %s at the same time";
    protected String invalidOutboundSocketBinding$str() {
        return invalidOutboundSocketBinding;
    }
    @Override
    public final XMLStreamException invalidOutboundSocketBinding(final String name, final String localTag, final String remoteTag, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidOutboundSocketBinding$str(), name, localTag, remoteTag), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterValue = "WFLYCTL0121: %s is not a valid value for parameter %s -- must be one of %s";
    protected String invalidParameterValue$str() {
        return invalidParameterValue;
    }
    @Override
    public final IllegalArgumentException invalidParameterValue(final Flag flag, final String name, final java.util.Collection<Flag> validFlags) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidParameterValue$str(), flag, name, validFlags));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSha1Value = "WFLYCTL0122: Value %s for attribute %s does not represent a properly hex-encoded SHA1 hash";
    protected String invalidSha1Value$str() {
        return invalidSha1Value;
    }
    @Override
    public final XMLStreamException invalidSha1Value(final Throwable cause, final String value, final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidSha1Value$str(), value, name), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStage = "WFLYCTL0123: Stage %s is not valid for context process type %s";
    protected String invalidStage$str() {
        return invalidStage;
    }
    @Override
    public final IllegalStateException invalidStage(final Stage stage, final ProcessType processType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidStage$str(), stage, processType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStepStage = "WFLYCTL0124: Invalid step stage specified";
    protected String invalidStepStage$str() {
        return invalidStepStage;
    }
    @Override
    public final IllegalArgumentException invalidStepStage() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidStepStage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTableSize = "WFLYCTL0126: Can not have a negative size table!";
    protected String invalidTableSize$str() {
        return invalidTableSize;
    }
    @Override
    public final IllegalArgumentException invalidTableSize() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTableSize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidType = "WFLYCTL0127: Invalid type %s";
    protected String invalidType$str() {
        return invalidType;
    }
    @Override
    public final String invalidType(final ModelType type) {
        return String.format(getLoggingLocale(), invalidType$str(), type);
    }
    private static final String invalidPathElementValue = "WFLYCTL0128: Invalid resource address element '%s'. The value '%s' is not valid for an element in a resource address. Character '%s' is not allowed.";
    protected String invalidPathElementValue$str() {
        return invalidPathElementValue;
    }
    @Override
    public final String invalidPathElementValue(final String element, final String value, final Character character) {
        return String.format(getLoggingLocale(), invalidPathElementValue$str(), element, value, character);
    }
    private static final String invalidValue = "WFLYCTL0129: Invalid value %s for %s; legal values are %s";
    protected String invalidValue$str() {
        return invalidValue;
    }
    @Override
    public final String invalidValue(final String value, final String name, final java.util.Collection<?> validValues) {
        return String.format(getLoggingLocale(), invalidValue$str(), value, name, validValues);
    }
    private static final String missingOneOf = "WFLYCTL0132: Must include one of the following elements: %s";
    protected String missingOneOf$str() {
        return missingOneOf;
    }
    @Override
    public final XMLStreamException missingOneOf(final StringBuilder sb, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), missingOneOf$str(), sb), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredAttributes = "WFLYCTL0133: Missing required attribute(s): %s";
    protected String missingRequiredAttributes$str() {
        return missingRequiredAttributes;
    }
    @Override
    public final XMLStreamException missingRequiredAttributes(final StringBuilder sb, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), missingRequiredAttributes$str(), sb), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredElements = "WFLYCTL0134: Missing required element(s): %s";
    protected String missingRequiredElements$str() {
        return missingRequiredElements;
    }
    @Override
    public final XMLStreamException missingRequiredElements(final StringBuilder sb, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), missingRequiredElements$str(), sb), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleLoadingInterrupted = "WFLYCTL0135: Interrupted awaiting loading of module %s";
    protected String moduleLoadingInterrupted$str() {
        return moduleLoadingInterrupted;
    }
    @Override
    public final XMLStreamException moduleLoadingInterrupted(final String name) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), moduleLoadingInterrupted$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleInitializationInterrupted = "WFLYCTL0136: Interrupted awaiting initialization of module %s";
    protected String moduleInitializationInterrupted$str() {
        return moduleInitializationInterrupted;
    }
    @Override
    public final RuntimeException moduleInitializationInterrupted(final String name) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), moduleInitializationInterrupted$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleModelNodes = "WFLYCTL0137: Model contains multiple %s nodes";
    protected String multipleModelNodes$str() {
        return multipleModelNodes;
    }
    @Override
    public final IllegalStateException multipleModelNodes(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleModelNodes$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String namespaceAlreadyRegistered = "WFLYCTL0138: Namespace with prefix %s already registered with schema URI %s";
    protected String namespaceAlreadyRegistered$str() {
        return namespaceAlreadyRegistered;
    }
    @Override
    public final String namespaceAlreadyRegistered(final String prefix, final String uri) {
        return String.format(getLoggingLocale(), namespaceAlreadyRegistered$str(), prefix, uri);
    }
    private static final String namespaceNotFound = "WFLYCTL0139: No namespace with URI %s found";
    protected String namespaceNotFound$str() {
        return namespaceNotFound;
    }
    @Override
    public final String namespaceNotFound(final String prefix) {
        return String.format(getLoggingLocale(), namespaceNotFound$str(), prefix);
    }
    private static final String nestedElementNotAllowed = "WFLYCTL0140: Nested %s not allowed";
    protected String nestedElementNotAllowed$str() {
        return nestedElementNotAllowed;
    }
    @Override
    public final String nestedElementNotAllowed(final Element element) {
        return String.format(getLoggingLocale(), nestedElementNotAllowed$str(), element);
    }
    private static final String noActiveStep = "WFLYCTL0144: No active step";
    protected String noActiveStep$str() {
        return noActiveStep;
    }
    @Override
    public final IllegalStateException noActiveStep() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noActiveStep$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noChildType = "WFLYCTL0147: No child type %s";
    protected String noChildType$str() {
        return noChildType;
    }
    @Override
    public final OperationFailedRuntimeException noChildType(final String name) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), noChildType$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterfaceCriteria = "WFLYCTL0149: No interface criteria was provided";
    protected String noInterfaceCriteria$str() {
        return noInterfaceCriteria;
    }
    @Override
    public final String noInterfaceCriteria() {
        return String.format(getLoggingLocale(), noInterfaceCriteria$str());
    }
    private static final String noOperationHandler0 = "WFLYCTL0150: No operation handler";
    protected String noOperationHandler0$str() {
        return noOperationHandler0;
    }
    @Override
    public final String noOperationHandler() {
        return String.format(getLoggingLocale(), noOperationHandler0$str());
    }
    private static final String notADirectory = "WFLYCTL0152: %s is not a directory";
    protected String notADirectory$str() {
        return notADirectory;
    }
    @Override
    public final IllegalStateException notADirectory(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notADirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notFound = "WFLYCTL0153: No %s%s found for %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final IllegalStateException notFound(final String path, final String className, final ModuleIdentifier id) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notFound$str(), path, className, id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullAsynchronousExecutor = "WFLYCTL0154: Cannot execute asynchronous operation without an executor";
    protected String nullAsynchronousExecutor$str() {
        return nullAsynchronousExecutor;
    }
    @Override
    public final IllegalStateException nullAsynchronousExecutor() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nullAsynchronousExecutor$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullNotAllowed = "WFLYCTL0155: '%s' may not be null";
    protected String nullNotAllowed$str() {
        return nullNotAllowed;
    }
    @Override
    public final OperationFailedException nullNotAllowed(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), nullNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operation = "Operation %s";
    protected String operation$str() {
        return operation;
    }
    @Override
    public final String operation(final String step) {
        return String.format(getLoggingLocale(), operation$str(), step);
    }
    private static final String operationAlreadyComplete = "WFLYCTL0157: Operation already complete";
    protected String operationAlreadyComplete$str() {
        return operationAlreadyComplete;
    }
    @Override
    public final IllegalStateException operationAlreadyComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operationAlreadyComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationHandlerFailed = "WFLYCTL0158: Operation handler failed: %s";
    protected String operationHandlerFailed$str() {
        return operationHandlerFailed;
    }
    @Override
    public final String operationHandlerFailed(final String msg) {
        return String.format(getLoggingLocale(), operationHandlerFailed$str(), msg);
    }
    private static final String operationRollingBack = "WFLYCTL0160: Operation rolling back";
    protected String operationRollingBack$str() {
        return operationRollingBack;
    }
    @Override
    public final String operationRollingBack() {
        return String.format(getLoggingLocale(), operationRollingBack$str());
    }
    private static final String operationSucceeded = "WFLYCTL0161: Operation succeeded, committing";
    protected String operationSucceeded$str() {
        return operationSucceeded;
    }
    @Override
    public final String operationSucceeded() {
        return String.format(getLoggingLocale(), operationSucceeded$str());
    }
    private static final String operationNotRegistered = "WFLYCTL0162: There is no operation %s registered at address %s";
    protected String operationNotRegistered$str() {
        return operationNotRegistered;
    }
    @Override
    public final String operationNotRegistered(final String op, final PathAddress address) {
        return String.format(getLoggingLocale(), operationNotRegistered$str(), op, address);
    }
    private static final String parsingProblem = "WFLYCTL0164: Parsing problem at [row,col]:[%d ,%d]%nMessage: %s";
    protected String parsingProblem$str() {
        return parsingProblem;
    }
    @Override
    public final String parsingProblem(final int row, final int col, final String msg) {
        return String.format(getLoggingLocale(), parsingProblem$str(), row, col, msg);
    }
    private static final String persisterNotInjected = "WFLYCTL0165: No configuration persister was injected";
    protected String persisterNotInjected$str() {
        return persisterNotInjected;
    }
    @Override
    public final StartException persisterNotInjected() {
        final StartException result = new StartException(String.format(getLoggingLocale(), persisterNotInjected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String proxyHandlerAlreadyRegistered = "WFLYCTL0169: A proxy handler is already registered at location '%s'";
    protected String proxyHandlerAlreadyRegistered$str() {
        return proxyHandlerAlreadyRegistered;
    }
    @Override
    public final IllegalArgumentException proxyHandlerAlreadyRegistered(final String location) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), proxyHandlerAlreadyRegistered$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String removingServiceUnsatisfiedDependencies0 = "WFLYCTL0171: Removing services has lead to unsatisfied dependencies:";
    protected String removingServiceUnsatisfiedDependencies0$str() {
        return removingServiceUnsatisfiedDependencies0;
    }
    @Override
    public final String removingServiceUnsatisfiedDependencies() {
        return String.format(getLoggingLocale(), removingServiceUnsatisfiedDependencies0$str());
    }
    private static final String removingServiceUnsatisfiedDependencies1 = "%nService %s was depended upon by ";
    protected String removingServiceUnsatisfiedDependencies1$str() {
        return removingServiceUnsatisfiedDependencies1;
    }
    @Override
    public final String removingServiceUnsatisfiedDependencies(final String name) {
        return String.format(getLoggingLocale(), removingServiceUnsatisfiedDependencies1$str(), name);
    }
    private static final String required = "WFLYCTL0172: %s is required";
    protected String required$str() {
        return required;
    }
    @Override
    public final String required(final String name) {
        return String.format(getLoggingLocale(), required$str(), name);
    }
    private static final String reserved = "WFLYCTL0173: %s is reserved";
    protected String reserved$str() {
        return reserved;
    }
    @Override
    public final XMLStreamException reserved(final String name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), reserved$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceNotFound = "WFLYCTL0175: Resource %s does not exist; a resource at address %s cannot be created until all ancestor resources have been added";
    protected String resourceNotFound$str() {
        return resourceNotFound;
    }
    @Override
    public final OperationFailedRuntimeException resourceNotFound(final PathAddress ancestor, final PathAddress address) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), resourceNotFound$str(), ancestor, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackAlreadyInvoked = "WFLYCTL0176: rollback() has already been invoked";
    protected String rollbackAlreadyInvoked$str() {
        return rollbackAlreadyInvoked;
    }
    @Override
    public final IllegalStateException rollbackAlreadyInvoked() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rollbackAlreadyInvoked$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String schemaAlreadyRegistered = "WFLYCTL0177: Schema with URI %s already registered with location %s";
    protected String schemaAlreadyRegistered$str() {
        return schemaAlreadyRegistered;
    }
    @Override
    public final String schemaAlreadyRegistered(final String schemaUri, final String location) {
        return String.format(getLoggingLocale(), schemaAlreadyRegistered$str(), schemaUri, location);
    }
    private static final String schemaNotFound = "WFLYCTL0178: No schema location with URI %s found";
    protected String schemaNotFound$str() {
        return schemaNotFound;
    }
    @Override
    public final String schemaNotFound(final String uri) {
        return String.format(getLoggingLocale(), schemaNotFound$str(), uri);
    }
    private static final String serviceInstallCancelled = "WFLYCTL0179: Service install was cancelled";
    protected String serviceInstallCancelled$str() {
        return serviceInstallCancelled;
    }
    @Override
    public final CancellationException serviceInstallCancelled() {
        final CancellationException result = new CancellationException(String.format(getLoggingLocale(), serviceInstallCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String servicesMissing = "is missing [%s]";
    protected String servicesMissing$str() {
        return servicesMissing;
    }
    @Override
    public final String servicesMissing(final StringBuilder sb) {
        return String.format(getLoggingLocale(), servicesMissing$str(), sb);
    }
    private static final String servicesMissingDependencies = "WFLYCTL0180: Services with missing/unavailable dependencies";
    protected String servicesMissingDependencies$str() {
        return servicesMissingDependencies;
    }
    @Override
    public final String servicesMissingDependencies() {
        return String.format(getLoggingLocale(), servicesMissingDependencies$str());
    }
    private static final String serviceRegistryRuntimeOperationsOnly = "WFLYCTL0181: Get service registry only supported in runtime operations";
    protected String serviceRegistryRuntimeOperationsOnly$str() {
        return serviceRegistryRuntimeOperationsOnly;
    }
    @Override
    public final IllegalStateException serviceRegistryRuntimeOperationsOnly() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceRegistryRuntimeOperationsOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceRemovalRuntimeOperationsOnly = "WFLYCTL0182: Service removal only supported in runtime operations";
    protected String serviceRemovalRuntimeOperationsOnly$str() {
        return serviceRemovalRuntimeOperationsOnly;
    }
    @Override
    public final IllegalStateException serviceRemovalRuntimeOperationsOnly() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceRemovalRuntimeOperationsOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceStatusReportHeader = "WFLYCTL0183: Service status report%n";
    protected String serviceStatusReportHeader$str() {
        return serviceStatusReportHeader;
    }
    @Override
    public final String serviceStatusReportHeader() {
        return String.format(getLoggingLocale(), serviceStatusReportHeader$str());
    }
    private static final String serviceStatusReportDependencies = "WFLYCTL0184:    New missing/unsatisfied dependencies:%n";
    protected String serviceStatusReportDependencies$str() {
        return serviceStatusReportDependencies;
    }
    @Override
    public final String serviceStatusReportDependencies() {
        return String.format(getLoggingLocale(), serviceStatusReportDependencies$str());
    }
    private static final String serviceStatusReportMissing = "      %s (missing) dependents: %s %n";
    protected String serviceStatusReportMissing$str() {
        return serviceStatusReportMissing;
    }
    @Override
    public final String serviceStatusReportMissing(final ServiceName serviceName, final String dependents) {
        return String.format(getLoggingLocale(), serviceStatusReportMissing$str(), serviceName, dependents);
    }
    private static final String serviceStatusReportUnavailable = "      %s (unavailable) dependents: %s %n";
    protected String serviceStatusReportUnavailable$str() {
        return serviceStatusReportUnavailable;
    }
    @Override
    public final String serviceStatusReportUnavailable(final ServiceName serviceName, final String dependents) {
        return String.format(getLoggingLocale(), serviceStatusReportUnavailable$str(), serviceName, dependents);
    }
    private static final String serviceStatusReportCorrected = "WFLYCTL0185:    Newly corrected services:%n";
    protected String serviceStatusReportCorrected$str() {
        return serviceStatusReportCorrected;
    }
    @Override
    public final String serviceStatusReportCorrected() {
        return String.format(getLoggingLocale(), serviceStatusReportCorrected$str());
    }
    private static final String serviceStatusReportNoLongerRequired = "      %s (no longer required)%n";
    protected String serviceStatusReportNoLongerRequired$str() {
        return serviceStatusReportNoLongerRequired;
    }
    @Override
    public final String serviceStatusReportNoLongerRequired(final ServiceName serviceName) {
        return String.format(getLoggingLocale(), serviceStatusReportNoLongerRequired$str(), serviceName);
    }
    private static final String serviceStatusReportAvailable = "      %s (new available)%n";
    protected String serviceStatusReportAvailable$str() {
        return serviceStatusReportAvailable;
    }
    @Override
    public final String serviceStatusReportAvailable(final ServiceName serviceName) {
        return String.format(getLoggingLocale(), serviceStatusReportAvailable$str(), serviceName);
    }
    private static final String serviceStatusReportFailed = "WFLYCTL0186:   Services which failed to start:";
    protected String serviceStatusReportFailed$str() {
        return serviceStatusReportFailed;
    }
    @Override
    public final String serviceStatusReportFailed() {
        return String.format(getLoggingLocale(), serviceStatusReportFailed$str());
    }
    private static final String serviceTargetRuntimeOperationsOnly = "WFLYCTL0187: Get service target only supported in runtime operations";
    protected String serviceTargetRuntimeOperationsOnly$str() {
        return serviceTargetRuntimeOperationsOnly;
    }
    @Override
    public final IllegalStateException serviceTargetRuntimeOperationsOnly() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceTargetRuntimeOperationsOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stageAlreadyComplete = "WFLYCTL0188: Stage %s is already complete";
    protected String stageAlreadyComplete$str() {
        return stageAlreadyComplete;
    }
    @Override
    public final IllegalStateException stageAlreadyComplete(final Stage stage) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), stageAlreadyComplete$str(), stage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stepHandlerFailedRollback = "WFLYCTL0190: Step handler %s for operation %s at address %s failed handling operation rollback -- %s";
    protected String stepHandlerFailedRollback$str() {
        return stepHandlerFailedRollback;
    }
    @Override
    public final String stepHandlerFailedRollback(final OperationStepHandler handler, final String op, final PathAddress address, final Throwable cause) {
        return String.format(getLoggingLocale(), stepHandlerFailedRollback$str(), handler, op, address, cause);
    }
    private static final String subsystemBootInterrupted = "WFLYCTL0191: Interrupted awaiting subsystem boot operation execution";
    protected String subsystemBootInterrupted$str() {
        return subsystemBootInterrupted;
    }
    @Override
    public final String subsystemBootInterrupted() {
        return String.format(getLoggingLocale(), subsystemBootInterrupted$str());
    }
    private static final String subsystemBootOperationFailed = "WFLYCTL0192: Boot operations for subsystem %s failed without explanation";
    protected String subsystemBootOperationFailed$str() {
        return subsystemBootOperationFailed;
    }
    @Override
    public final String subsystemBootOperationFailed(final String name) {
        return String.format(getLoggingLocale(), subsystemBootOperationFailed$str(), name);
    }
    private static final String subsystemBootOperationFailedExecuting = "WFLYCTL0193: Failed executing subsystem %s boot operations";
    protected String subsystemBootOperationFailedExecuting$str() {
        return subsystemBootOperationFailedExecuting;
    }
    @Override
    public final String subsystemBootOperationFailedExecuting(final String name) {
        return String.format(getLoggingLocale(), subsystemBootOperationFailedExecuting$str(), name);
    }
    private static final String tableIsFull = "WFLYCTL0194: Table is full!";
    protected String tableIsFull$str() {
        return tableIsFull;
    }
    @Override
    public final IllegalStateException tableIsFull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tableIsFull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionInterrupted = "WFLYCTL0195: Interrupted awaiting transaction commit or rollback";
    protected String transactionInterrupted$str() {
        return transactionInterrupted;
    }
    @Override
    public final RuntimeException transactionInterrupted() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), transactionInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedAttribute1 = "WFLYCTL0197: Unexpected attribute '%s' encountered";
    protected String unexpectedAttribute1$str() {
        return unexpectedAttribute1;
    }
    @Override
    public final XMLStreamException unexpectedAttribute(final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedAttribute1$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement1 = "WFLYCTL0198: Unexpected element '%s' encountered";
    protected String unexpectedElement1$str() {
        return unexpectedElement1;
    }
    @Override
    public final XMLStreamException unexpectedElement(final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedElement1$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEndElement = "WFLYCTL0199: Unexpected end of element '%s' encountered";
    protected String unexpectedEndElement$str() {
        return unexpectedEndElement;
    }
    @Override
    public final XMLStreamException unexpectedEndElement(final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedEndElement$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAttribute = "WFLYCTL0201: Unknown attribute '%s'";
    protected String unknownAttribute$str() {
        return unknownAttribute;
    }
    @Override
    public final String unknownAttribute(final String name) {
        return String.format(getLoggingLocale(), unknownAttribute$str(), name);
    }
    private static final String unknownChildType = "WFLYCTL0202: No known child type named %s";
    protected String unknownChildType$str() {
        return unknownChildType;
    }
    @Override
    public final String unknownChildType(final String name) {
        return String.format(getLoggingLocale(), unknownChildType$str(), name);
    }
    private static final String unknownCriteriaInterfaceProperty = "WFLYCTL0203: Unknown property in interface criteria list: %s";
    protected String unknownCriteriaInterfaceProperty$str() {
        return unknownCriteriaInterfaceProperty;
    }
    @Override
    public final RuntimeException unknownCriteriaInterfaceProperty(final String name) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownCriteriaInterfaceProperty$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownCriteriaInterfaceType = "WFLYCTL0204: Unknown interface criteria type %s";
    protected String unknownCriteriaInterfaceType$str() {
        return unknownCriteriaInterfaceType;
    }
    @Override
    public final String unknownCriteriaInterfaceType(final String type) {
        return String.format(getLoggingLocale(), unknownCriteriaInterfaceType$str(), type);
    }
    private static final String unknownInterface = "WFLYCTL0205: Unknown interface %s %s must be declared in element %s";
    protected String unknownInterface$str() {
        return unknownInterface;
    }
    @Override
    public final XMLStreamException unknownInterface(final String value, final String attributeName, final String elementName, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unknownInterface$str(), value, attributeName, elementName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownValueForElement = "WFLYCTL0206: Unknown %s %s %s must be declared in element %s";
    protected String unknownValueForElement$str() {
        return unknownValueForElement;
    }
    @Override
    public final XMLStreamException unknownValueForElement(final String elementName1, final String value, final String elementName2, final String parentElement, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unknownValueForElement$str(), elementName1, value, elementName2, parentElement), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailed = "WFLYCTL0207: Validation failed for %s";
    protected String validationFailed$str() {
        return validationFailed;
    }
    @Override
    public final String validationFailed(final String name) {
        return String.format(getLoggingLocale(), validationFailed$str(), name);
    }
    private static final String andNMore = "WFLYCTL0208: ... and %s more";
    protected String andNMore$str() {
        return andNMore;
    }
    @Override
    public final String andNMore(final int number) {
        return String.format(getLoggingLocale(), andNMore$str(), number);
    }
    private static final String invalidAttributeValue3 = "WFLYCTL0209: Invalid value '%s' for attribute '%s' -- valid values are %s";
    protected String invalidAttributeValue3$str() {
        return invalidAttributeValue3;
    }
    @Override
    public final XMLStreamException invalidAttributeValue(final String value, final QName name, final java.util.Set<String> validValues, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidAttributeValue3$str(), value, name, validValues), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPermissionToResolveExpression = "WFLYCTL0210: Caught SecurityException attempting to resolve expression '%s' -- %s";
    protected String noPermissionToResolveExpression$str() {
        return noPermissionToResolveExpression;
    }
    @Override
    public final String noPermissionToResolveExpression(final ModelNode toResolve, final SecurityException e) {
        return String.format(getLoggingLocale(), noPermissionToResolveExpression$str(), toResolve, e);
    }
    private static final String cannotResolveExpression = "WFLYCTL0211: Cannot resolve expression '%s'";
    protected String cannotResolveExpression$str() {
        return cannotResolveExpression;
    }
    @Override
    public final OperationFailedException cannotResolveExpression(final String toResolve) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotResolveExpression$str(), toResolve));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateResourceAddress = "WFLYCTL0212: Duplicate resource %s";
    protected String duplicateResourceAddress$str() {
        return duplicateResourceAddress;
    }
    @Override
    public final OperationFailedRuntimeException duplicateResourceAddress(final PathAddress address) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), duplicateResourceAddress$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mainFileNotFound = "WFLYCTL0214: Could not get main file: %s. Specified files must be relative to the configuration dir: %s";
    protected String mainFileNotFound$str() {
        return mainFileNotFound;
    }
    @Override
    public final IllegalStateException mainFileNotFound(final String name, final File configurationDir) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mainFileNotFound$str(), name, configurationDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managementResourceNotFound = "WFLYCTL0216: Management resource '%s' not found";
    protected String managementResourceNotFound$str() {
        return managementResourceNotFound;
    }
    @Override
    public final NoSuchResourceException managementResourceNotFound(final PathAddress pathAddress) {
        final NoSuchResourceException result = new NoSuchResourceException(String.format(getLoggingLocale(), managementResourceNotFound$str(), pathAddress));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String childResourceNotFound = "WFLYCTL0217: Child resource '%s' not found";
    protected String childResourceNotFound$str() {
        return childResourceNotFound;
    }
    @Override
    public final String childResourceNotFound(final PathElement childAddress) {
        return String.format(getLoggingLocale(), childResourceNotFound$str(), childAddress);
    }
    private static final String nodeAlreadyRegistered = "WFLYCTL0218: A node is already registered at '%s'";
    protected String nodeAlreadyRegistered$str() {
        return nodeAlreadyRegistered;
    }
    @Override
    public final IllegalArgumentException nodeAlreadyRegistered(final String location) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nodeAlreadyRegistered$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String removingExtensionWithRegisteredSubsystem = "WFLYCTL0219: An attempt was made to unregister extension %s which still has subsystem %s registered";
    protected String removingExtensionWithRegisteredSubsystem$str() {
        return removingExtensionWithRegisteredSubsystem;
    }
    @Override
    public final IllegalStateException removingExtensionWithRegisteredSubsystem(final String moduleName, final String subsystem) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), removingExtensionWithRegisteredSubsystem$str(), moduleName, subsystem));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotOverrideRootRegistration = "WFLYCTL0220: An override model registration is not allowed for the root model registration";
    protected String cannotOverrideRootRegistration$str() {
        return cannotOverrideRootRegistration;
    }
    @Override
    public final IllegalStateException cannotOverrideRootRegistration() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotOverrideRootRegistration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotOverrideNonWildCardRegistration = "WFLYCTL0221: An override model registration is not allowed for non-wildcard model registrations. This registration is for the non-wildcard name '%s'.";
    protected String cannotOverrideNonWildCardRegistration$str() {
        return cannotOverrideNonWildCardRegistration;
    }
    @Override
    public final IllegalStateException cannotOverrideNonWildCardRegistration(final String valueName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotOverrideNonWildCardRegistration$str(), valueName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardRegistrationIsNotAnOverride = "WFLYCTL0222: A registration named '*' is not an override model and cannot be unregistered via the unregisterOverrideModel API.";
    protected String wildcardRegistrationIsNotAnOverride$str() {
        return wildcardRegistrationIsNotAnOverride;
    }
    @Override
    public final IllegalArgumentException wildcardRegistrationIsNotAnOverride() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wildcardRegistrationIsNotAnOverride$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rootRegistrationIsNotOverridable = "WFLYCTL0223: The root resource registration does not support overrides, so no override can be removed.";
    protected String rootRegistrationIsNotOverridable$str() {
        return rootRegistrationIsNotOverridable;
    }
    @Override
    public final IllegalStateException rootRegistrationIsNotOverridable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rootRegistrationIsNotOverridable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNotRegisteredException = "WFLYCTL0224: There is no operation %s registered at address %s";
    protected String operationNotRegisteredException$str() {
        return operationNotRegisteredException;
    }
    @Override
    public final IllegalArgumentException operationNotRegisteredException(final String op, final PathAddress address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), operationNotRegisteredException$str(), op, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRecoverServices = "WFLYCTL0225: Failed to recover services during operation rollback";
    protected String failedToRecoverServices$str() {
        return failedToRecoverServices;
    }
    @Override
    public final RuntimeException failedToRecoverServices(final OperationFailedException cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToRecoverServices$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSubsystem = "WFLYCTL0226: A subsystem named '%s' cannot be registered by extension '%s' -- a subsystem with that name has already been registered by extension '%s'.";
    protected String duplicateSubsystem$str() {
        return duplicateSubsystem;
    }
    @Override
    public final IllegalStateException duplicateSubsystem(final String subsystemName, final String duplicatingModule, final String existingModule) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateSubsystem$str(), subsystemName, duplicatingModule, existingModule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedOperationHasNoField = "WFLYCTL0227: Operation has no '%s' field. %s";
    protected String validationFailedOperationHasNoField$str() {
        return validationFailedOperationHasNoField;
    }
    @Override
    public final IllegalArgumentException validationFailedOperationHasNoField(final String field, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedOperationHasNoField$str(), field, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedOperationHasANullOrEmptyName = "WFLYCTL0228: Operation has a null or empty name. %s";
    protected String validationFailedOperationHasANullOrEmptyName$str() {
        return validationFailedOperationHasANullOrEmptyName;
    }
    @Override
    public final IllegalArgumentException validationFailedOperationHasANullOrEmptyName(final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedOperationHasANullOrEmptyName$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedNoOperationFound = "WFLYCTL0229: No operation called '%s' at '%s'. %s";
    protected String validationFailedNoOperationFound$str() {
        return validationFailedNoOperationFound;
    }
    @Override
    public final IllegalArgumentException validationFailedNoOperationFound(final String name, final PathAddress address, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedNoOperationFound$str(), name, address, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedActualParameterNotDescribed = "WFLYCTL0230: Operation contains a parameter '%s' which is not one of the expected parameters %s. %s";
    protected String validationFailedActualParameterNotDescribed$str() {
        return validationFailedActualParameterNotDescribed;
    }
    @Override
    public final IllegalArgumentException validationFailedActualParameterNotDescribed(final String paramName, final java.util.Set<String> parameterNames, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedActualParameterNotDescribed$str(), paramName, parameterNames, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedRequiredParameterNotPresent = "WFLYCTL0231: Required parameter %s is not present. %s";
    protected String validationFailedRequiredParameterNotPresent$str() {
        return validationFailedRequiredParameterNotPresent;
    }
    @Override
    public final IllegalArgumentException validationFailedRequiredParameterNotPresent(final String paramName, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedRequiredParameterNotPresent$str(), paramName, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedRequiredParameterPresentAsWellAsAlternative = "WFLYCTL0232: Alternative parameter '%s' for required parameter '%s' was used. Please use one or the other. %s";
    protected String validationFailedRequiredParameterPresentAsWellAsAlternative$str() {
        return validationFailedRequiredParameterPresentAsWellAsAlternative;
    }
    @Override
    public final IllegalArgumentException validationFailedRequiredParameterPresentAsWellAsAlternative(final String alternative, final String paramName, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedRequiredParameterPresentAsWellAsAlternative$str(), alternative, paramName, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedCouldNotConvertParamToType = "WFLYCTL0233: Could not convert the parameter '%s' to a %s. %s";
    protected String validationFailedCouldNotConvertParamToType$str() {
        return validationFailedCouldNotConvertParamToType;
    }
    @Override
    public final IllegalArgumentException validationFailedCouldNotConvertParamToType(final String paramName, final ModelType type, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedCouldNotConvertParamToType$str(), paramName, type, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedValueIsSmallerThanMin = "WFLYCTL0234: The value '%s' passed in for '%s' is smaller than the minimum value '%s'. %s";
    protected String validationFailedValueIsSmallerThanMin$str() {
        return validationFailedValueIsSmallerThanMin;
    }
    @Override
    public final IllegalArgumentException validationFailedValueIsSmallerThanMin(final Number value, final String paramName, final Number min, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedValueIsSmallerThanMin$str(), value, paramName, min, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedValueIsGreaterThanMax = "WFLYCTL0235: The value '%s' passed in for '%s' is bigger than the maximum value '%s'. %s";
    protected String validationFailedValueIsGreaterThanMax$str() {
        return validationFailedValueIsGreaterThanMax;
    }
    @Override
    public final IllegalArgumentException validationFailedValueIsGreaterThanMax(final Number value, final String paramName, final Number max, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedValueIsGreaterThanMax$str(), value, paramName, max, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedValueIsShorterThanMinLength = "WFLYCTL0236: The value '%s' passed in for '%s' is shorter than the minimum length '%s'. %s";
    protected String validationFailedValueIsShorterThanMinLength$str() {
        return validationFailedValueIsShorterThanMinLength;
    }
    @Override
    public final IllegalArgumentException validationFailedValueIsShorterThanMinLength(final Object value, final String paramName, final Object minLength, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedValueIsShorterThanMinLength$str(), value, paramName, minLength, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedValueIsLongerThanMaxLength = "WFLYCTL0237: The value '%s' passed in for '%s' is longer than the maximum length '%s'. %s";
    protected String validationFailedValueIsLongerThanMaxLength$str() {
        return validationFailedValueIsLongerThanMaxLength;
    }
    @Override
    public final IllegalArgumentException validationFailedValueIsLongerThanMaxLength(final Object value, final String paramName, final Object maxLength, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedValueIsLongerThanMaxLength$str(), value, paramName, maxLength, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validationFailedInvalidElementType = "WFLYCTL0238: %s is expected to be a list of %s. %s";
    protected String validationFailedInvalidElementType$str() {
        return validationFailedInvalidElementType;
    }
    @Override
    public final IllegalArgumentException validationFailedInvalidElementType(final String paramName, final ModelType elementType, final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationFailedInvalidElementType$str(), paramName, elementType, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDescriptionRequiredFlagIsNotABoolean = "WFLYCTL0239: 'required' parameter: '%s' must be a boolean in the description of the operation at %s: %s";
    protected String invalidDescriptionRequiredFlagIsNotABoolean$str() {
        return invalidDescriptionRequiredFlagIsNotABoolean;
    }
    @Override
    public final String invalidDescriptionRequiredFlagIsNotABoolean(final String paramName, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionRequiredFlagIsNotABoolean$str(), paramName, address, description);
    }
    private static final String invalidDescriptionUndefinedRequestProperty = "WFLYCTL0240: Undefined request property '%s' in description of the operation at %s: %s";
    protected String invalidDescriptionUndefinedRequestProperty$str() {
        return invalidDescriptionUndefinedRequestProperty;
    }
    @Override
    public final String invalidDescriptionUndefinedRequestProperty(final String name, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionUndefinedRequestProperty$str(), name, address, description);
    }
    private static final String invalidDescriptionNoParamTypeInDescription = "WFLYCTL0241: There is no type for parameter '%s' in the description of the operation at %s: %s";
    protected String invalidDescriptionNoParamTypeInDescription$str() {
        return invalidDescriptionNoParamTypeInDescription;
    }
    @Override
    public final String invalidDescriptionNoParamTypeInDescription(final String paramName, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionNoParamTypeInDescription$str(), paramName, address, description);
    }
    private static final String invalidDescriptionInvalidParamTypeInDescription = "WFLYCTL0242: Could not determine the type of parameter '%s' in the description of the operation at %s: %s";
    protected String invalidDescriptionInvalidParamTypeInDescription$str() {
        return invalidDescriptionInvalidParamTypeInDescription;
    }
    @Override
    public final String invalidDescriptionInvalidParamTypeInDescription(final String paramName, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionInvalidParamTypeInDescription$str(), paramName, address, description);
    }
    private static final String invalidDescriptionMinMaxForParameterHasWrongType = "WFLYCTL0243: The '%s' attribute of the '%s' parameter can not be converted to its type: %s in the description of the operation at %s: %s";
    protected String invalidDescriptionMinMaxForParameterHasWrongType$str() {
        return invalidDescriptionMinMaxForParameterHasWrongType;
    }
    @Override
    public final String invalidDescriptionMinMaxForParameterHasWrongType(final String minOrMax, final String paramName, final ModelType expectedType, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionMinMaxForParameterHasWrongType$str(), minOrMax, paramName, expectedType, address, description);
    }
    private static final String invalidDescriptionMinMaxLengthForParameterHasWrongType = "WFLYCTL0244: The '%s' attribute of the '%s' parameter can not be converted to an integer in the description of the operation at %s: %s";
    protected String invalidDescriptionMinMaxLengthForParameterHasWrongType$str() {
        return invalidDescriptionMinMaxLengthForParameterHasWrongType;
    }
    @Override
    public final String invalidDescriptionMinMaxLengthForParameterHasWrongType(final String minOrMaxLength, final String paramName, final PathAddress address, final ModelNode description) {
        return String.format(getLoggingLocale(), invalidDescriptionMinMaxLengthForParameterHasWrongType$str(), minOrMaxLength, paramName, address, description);
    }
    private static final String invalidPort = "WFLYCTL0245: Illegal '%s' value %s -- must be a valid port number";
    protected String invalidPort$str() {
        return invalidPort;
    }
    @Override
    public final XMLStreamException invalidPort(final String name, final String value, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidPort$str(), name, value), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveProcessUUID = "WFLYCTL0246: Cannot resolve the localhost address to create a UUID-based name for this process";
    protected String cannotResolveProcessUUID$str() {
        return cannotResolveProcessUUID;
    }
    @Override
    public final RuntimeException cannotResolveProcessUUID(final UnknownHostException cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotResolveProcessUUID$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String useOperationContextRemoveService = "WFLYCTL0247: Do not call ServiceController.setMode(REMOVE), use OperationContext.removeService() instead.";
    protected String useOperationContextRemoveService$str() {
        return useOperationContextRemoveService;
    }
    @Override
    public final IllegalStateException useOperationContextRemoveService() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), useOperationContextRemoveService$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEnumValue = "WFLYCTL0248: Invalid value %s for %s; legal values are %s";
    protected String invalidEnumValue$str() {
        return invalidEnumValue;
    }
    @Override
    public final OperationFailedException invalidEnumValue(final String value, final String parameterName, final java.util.Set<?> allowedValues) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidEnumValue$str(), value, parameterName, allowedValues));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String modelUpdateNotAuthorized = "WFLYCTL0249: Operation '%s' targeted at resource '%s' was directly invoked by a user. User operations are not permitted to directly update the persistent configuration of a server in a managed domain.";
    protected String modelUpdateNotAuthorized$str() {
        return modelUpdateNotAuthorized;
    }
    @Override
    public final OperationFailedRuntimeException modelUpdateNotAuthorized(final String operation, final PathAddress address) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), modelUpdateNotAuthorized$str(), operation, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverResultsAccessNotAllowed = "WFLYCTL0250: An operation handler attempted to access the operation response server results object on a process type other than '%s'. The current process type is '%s'";
    protected String serverResultsAccessNotAllowed$str() {
        return serverResultsAccessNotAllowed;
    }
    @Override
    public final IllegalStateException serverResultsAccessNotAllowed(final ProcessType validType, final ProcessType processType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverResultsAccessNotAllowed$str(), validType, processType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantHaveBothLoopbackAndInetAddressCriteria = "WFLYCTL0251: Can't have both loopback and inet-address criteria";
    protected String cantHaveBothLoopbackAndInetAddressCriteria$str() {
        return cantHaveBothLoopbackAndInetAddressCriteria;
    }
    @Override
    public final String cantHaveBothLoopbackAndInetAddressCriteria() {
        return String.format(getLoggingLocale(), cantHaveBothLoopbackAndInetAddressCriteria$str());
    }
    private static final String cantHaveSameCriteriaForBothNotAndInclusion = "WFLYCTL0253: Can't have same criteria for both not and inclusion %s";
    protected String cantHaveSameCriteriaForBothNotAndInclusion$str() {
        return cantHaveSameCriteriaForBothNotAndInclusion;
    }
    @Override
    public final String cantHaveSameCriteriaForBothNotAndInclusion(final InterfaceCriteria interfaceCriteria) {
        return String.format(getLoggingLocale(), cantHaveSameCriteriaForBothNotAndInclusion$str(), interfaceCriteria);
    }
    private static final String nonexistentInterface = "WFLYCTL0254: Invalid value '%s' for attribute '%s' -- no interface configuration with that name exists";
    protected String nonexistentInterface$str() {
        return nonexistentInterface;
    }
    @Override
    public final OperationFailedException nonexistentInterface(final String attributeValue, final String attributeName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), nonexistentInterface$str(), attributeValue, attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathEntryNotFound = "WFLYCTL0256: Could not find a path called '%s'";
    protected String pathEntryNotFound$str() {
        return pathEntryNotFound;
    }
    @Override
    public final IllegalArgumentException pathEntryNotFound(final String pathName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathEntryNotFound$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathEntryIsReadOnly = "WFLYCTL0257: Path entry is read-only: '%s'";
    protected String pathEntryIsReadOnly$str() {
        return pathEntryIsReadOnly;
    }
    @Override
    public final IllegalArgumentException pathEntryIsReadOnly(final String pathName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathEntryIsReadOnly$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathEntryAlreadyExists = "WFLYCTL0258: There is already a path entry called: '%s'";
    protected String pathEntryAlreadyExists$str() {
        return pathEntryAlreadyExists;
    }
    @Override
    public final IllegalArgumentException pathEntryAlreadyExists(final String pathName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathEntryAlreadyExists$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRelativePathValue = "WFLYCTL0260: Invalid relativePath value '%s'";
    protected String invalidRelativePathValue$str() {
        return invalidRelativePathValue;
    }
    @Override
    public final IllegalArgumentException invalidRelativePathValue(final String relativePath) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRelativePathValue$str(), relativePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathIsAWindowsAbsolutePath = "WFLYCTL0261: '%s' is a Windows absolute path";
    protected String pathIsAWindowsAbsolutePath$str() {
        return pathIsAWindowsAbsolutePath;
    }
    @Override
    public final IllegalArgumentException pathIsAWindowsAbsolutePath(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathIsAWindowsAbsolutePath$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveReadOnlyPath = "WFLYCTL0262: Path '%s' is read-only; it cannot be removed";
    protected String cannotRemoveReadOnlyPath$str() {
        return cannotRemoveReadOnlyPath;
    }
    @Override
    public final OperationFailedException cannotRemoveReadOnlyPath(final String pathName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveReadOnlyPath$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotModifyReadOnlyPath = "WFLYCTL0263: Path '%s' is read-only; it cannot be modified";
    protected String cannotModifyReadOnlyPath$str() {
        return cannotModifyReadOnlyPath;
    }
    @Override
    public final OperationFailedException cannotModifyReadOnlyPath(final String pathName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotModifyReadOnlyPath$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionNotAllowed = "WFLYCTL0264: %s may not be ModelType.EXPRESSION";
    protected String expressionNotAllowed$str() {
        return expressionNotAllowed;
    }
    @Override
    public final OperationFailedException expressionNotAllowed(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), expressionNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathManagerNotAvailable = "WFLYCTL0265: PathManager not available on processes of type '%s'";
    protected String pathManagerNotAvailable$str() {
        return pathManagerNotAvailable;
    }
    @Override
    public final IllegalStateException pathManagerNotAvailable(final ProcessType processType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), pathManagerNotAvailable$str(), processType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMulticastAddress = "WFLYCTL0266: Value %s for attribute %s is not a valid multicast address";
    protected String unknownMulticastAddress$str() {
        return unknownMulticastAddress;
    }
    @Override
    public final OperationFailedException unknownMulticastAddress(final UnknownHostException cause, final String value, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unknownMulticastAddress$str(), value, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemovePathWithDependencies = "WFLYCTL0267: Path '%s' cannot be removed, since the following paths depend on it: %s";
    protected String cannotRemovePathWithDependencies$str() {
        return cannotRemovePathWithDependencies;
    }
    @Override
    public final OperationFailedException cannotRemovePathWithDependencies(final String pathName, final java.util.Set<String> dependencies) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemovePathWithDependencies$str(), pathName, dependencies));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRenameTempFile = "WFLYCTL0268: Failed to rename temp file %s to %s";
    protected String failedToRenameTempFile$str() {
        return failedToRenameTempFile;
    }
    @Override
    public final ConfigurationPersistenceException failedToRenameTempFile(final Throwable cause, final File temp, final File file) {
        final ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(getLoggingLocale(), failedToRenameTempFile$str(), temp, file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLocaleString = "WFLYCTL0269: Invalid locale format:  %s";
    protected String invalidLocaleString$str() {
        return invalidLocaleString;
    }
    @Override
    public final String invalidLocaleString(final String unparsed) {
        return String.format(getLoggingLocale(), invalidLocaleString$str(), unparsed);
    }
    private static final String operationCancelled = "WFLYCTL0271: Operation cancelled";
    protected String operationCancelled$str() {
        return operationCancelled;
    }
    @Override
    public final String operationCancelled() {
        return String.format(getLoggingLocale(), operationCancelled$str());
    }
    private static final String operationCancelledAsynchronously = "WFLYCTL0272: Operation cancelled asynchronously";
    protected String operationCancelledAsynchronously$str() {
        return operationCancelledAsynchronously;
    }
    @Override
    public final OperationCancellationException operationCancelledAsynchronously() {
        final OperationCancellationException result = new OperationCancellationException(String.format(getLoggingLocale(), operationCancelledAsynchronously$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String streamWasKilled = "WFLYCTL0273: Stream was killed";
    protected String streamWasKilled$str() {
        return streamWasKilled;
    }
    @Override
    public final IOException streamWasKilled() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamWasKilled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String streamWasClosed = "WFLYCTL0274: Stream was closed";
    protected String streamWasClosed$str() {
        return streamWasClosed;
    }
    @Override
    public final IOException streamWasClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamWasClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotHaveBothParameters = "WFLYCTL0275: Cannot define both '%s' and '%s'";
    protected String cannotHaveBothParameters$str() {
        return cannotHaveBothParameters;
    }
    @Override
    public final OperationFailedException cannotHaveBothParameters(final String nameA, final String name2) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotHaveBothParameters$str(), nameA, name2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDeleteFile = "WFLYCTL0276: Failed to delete file %s";
    protected String couldNotDeleteFile$str() {
        return couldNotDeleteFile;
    }
    @Override
    public final IllegalStateException couldNotDeleteFile(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotDeleteFile$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aliasAlreadyRegistered = "WFLYCTL0277: An alias is already registered at location '%s'";
    protected String aliasAlreadyRegistered$str() {
        return aliasAlreadyRegistered;
    }
    @Override
    public final IllegalArgumentException aliasAlreadyRegistered(final String location) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), aliasAlreadyRegistered$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aliasTargetResourceRegistrationNotFound = "WFLYCTL0279: Alias target address not found: %s";
    protected String aliasTargetResourceRegistrationNotFound$str() {
        return aliasTargetResourceRegistrationNotFound;
    }
    @Override
    public final IllegalArgumentException aliasTargetResourceRegistrationNotFound(final PathAddress targetAddress) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), aliasTargetResourceRegistrationNotFound$str(), targetAddress));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aliasStepHandlerOperationNotFound = "WFLYCTL0280: No operation called '%s' found for alias address '%s' which maps to '%s'";
    protected String aliasStepHandlerOperationNotFound$str() {
        return aliasStepHandlerOperationNotFound;
    }
    @Override
    public final IllegalArgumentException aliasStepHandlerOperationNotFound(final String name, final PathAddress aliasAddress, final PathAddress targetAddress) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), aliasStepHandlerOperationNotFound$str(), name, aliasAddress, targetAddress));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceRegistrationIsNotAnAlias = "WFLYCTL0281: Resource registration is not an alias";
    protected String resourceRegistrationIsNotAnAlias$str() {
        return resourceRegistrationIsNotAnAlias;
    }
    @Override
    public final IllegalStateException resourceRegistrationIsNotAnAlias() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), resourceRegistrationIsNotAnAlias$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String modelFieldsNotKnown = "WFLYCTL0282: Model contains fields that are not known in definition, fields: %s, path: %s";
    protected String modelFieldsNotKnown$str() {
        return modelFieldsNotKnown;
    }
    @Override
    public final RuntimeException modelFieldsNotKnown(final java.util.Set<String> fields, final PathAddress address) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), modelFieldsNotKnown$str(), fields, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotMarshalAttributeAsElement = "WFLYCTL0283: Could not marshal attribute as element: %s";
    protected String couldNotMarshalAttributeAsElement$str() {
        return couldNotMarshalAttributeAsElement;
    }
    @Override
    public final UnsupportedOperationException couldNotMarshalAttributeAsElement(final String attributeName) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), couldNotMarshalAttributeAsElement$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotMarshalAttributeAsAttribute = "WFLYCTL0284: Could not marshal attribute as attribute: %s";
    protected String couldNotMarshalAttributeAsAttribute$str() {
        return couldNotMarshalAttributeAsAttribute;
    }
    @Override
    public final UnsupportedOperationException couldNotMarshalAttributeAsAttribute(final String attributeName) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), couldNotMarshalAttributeAsAttribute$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardOperationFailedAtSingleAddress = "WFLYCTL0285: Operation %s invoked against multiple target addresses failed at address %s with failure description %s";
    protected String wildcardOperationFailedAtSingleAddress$str() {
        return wildcardOperationFailedAtSingleAddress;
    }
    @Override
    public final String wildcardOperationFailedAtSingleAddress(final String operation, final PathAddress address, final String failureMessage) {
        return String.format(getLoggingLocale(), wildcardOperationFailedAtSingleAddress$str(), operation, address, failureMessage);
    }
    private static final String wildcardOperationFailedAtSingleAddressWithComplexFailure = "WFLYCTL0286: Operation %s invoked against multiple target addresses failed at address %s. See the operation result for details.";
    protected String wildcardOperationFailedAtSingleAddressWithComplexFailure$str() {
        return wildcardOperationFailedAtSingleAddressWithComplexFailure;
    }
    @Override
    public final String wildcardOperationFailedAtSingleAddressWithComplexFailure(final String operation, final PathAddress address) {
        return String.format(getLoggingLocale(), wildcardOperationFailedAtSingleAddressWithComplexFailure$str(), operation, address);
    }
    private static final String wildcardOperationFailedAtMultipleAddresses = "WFLYCTL0287: Operation %s invoked against multiple target addresses failed at addresses %s. See the operation result for details.";
    protected String wildcardOperationFailedAtMultipleAddresses$str() {
        return wildcardOperationFailedAtMultipleAddresses;
    }
    @Override
    public final String wildcardOperationFailedAtMultipleAddresses(final String operation, final java.util.Set<PathAddress> addresses) {
        return String.format(getLoggingLocale(), wildcardOperationFailedAtMultipleAddresses$str(), operation, addresses);
    }
    private static final String missingTransitiveDependencyProblem = "WFLYCTL0288: One or more services were unable to start due to one or more indirect dependencies not being available.";
    protected String missingTransitiveDependencyProblem$str() {
        return missingTransitiveDependencyProblem;
    }
    @Override
    public final String missingTransitiveDependencyProblem() {
        return String.format(getLoggingLocale(), missingTransitiveDependencyProblem$str());
    }
    private static final String missingTransitiveDependents = "Services that were unable to start:";
    protected String missingTransitiveDependents$str() {
        return missingTransitiveDependents;
    }
    @Override
    public final String missingTransitiveDependents() {
        return String.format(getLoggingLocale(), missingTransitiveDependents$str());
    }
    private static final String missingTransitiveDependencies = "Services that may be the cause:";
    protected String missingTransitiveDependencies$str() {
        return missingTransitiveDependencies;
    }
    @Override
    public final String missingTransitiveDependencies() {
        return String.format(getLoggingLocale(), missingTransitiveDependencies$str());
    }
    private static final String noOperationEntry = "WFLYCTL0289: No operation entry called '%s' registered at '%s'";
    protected String noOperationEntry$str() {
        return noOperationEntry;
    }
    @Override
    public final String noOperationEntry(final String op, final PathAddress pathAddress) {
        return String.format(getLoggingLocale(), noOperationEntry$str(), op, pathAddress);
    }
    private static final String noOperationHandler2 = "WFLYCTL0290: No operation handler called '%s' registered at '%s'";
    protected String noOperationHandler2$str() {
        return noOperationHandler2;
    }
    @Override
    public final String noOperationHandler(final String op, final PathAddress pathAddress) {
        return String.format(getLoggingLocale(), noOperationHandler2$str(), op, pathAddress);
    }
    private static final String noPathToResolve = "WFLYCTL0291: There is no registered path to resolve with path attribute '%s' and/or relative-to attribute '%s on: %s";
    protected String noPathToResolve$str() {
        return noPathToResolve;
    }
    @Override
    public final IllegalStateException noPathToResolve(final String pathAttributeName, final String relativeToAttributeName, final ModelNode model) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noPathToResolve$str(), pathAttributeName, relativeToAttributeName, model));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributesDontSupportExpressions = "WFLYCTL0292: Attributes do not support expressions in the target model version and this resource will need to be ignored on the target host.";
    protected String attributesDontSupportExpressions$str() {
        return attributesDontSupportExpressions;
    }
    @Override
    public final String attributesDontSupportExpressions() {
        return String.format(getLoggingLocale(), attributesDontSupportExpressions$str());
    }
    private static final String attributesAreNotUnderstoodAndMustBeIgnored0 = "WFLYCTL0293: Attributes are not understood in the target model version and this resource will need to be ignored on the target host.";
    protected String attributesAreNotUnderstoodAndMustBeIgnored0$str() {
        return attributesAreNotUnderstoodAndMustBeIgnored0;
    }
    @Override
    public final String attributesAreNotUnderstoodAndMustBeIgnored() {
        return String.format(getLoggingLocale(), attributesAreNotUnderstoodAndMustBeIgnored0$str());
    }
    private static final String transformerLoggerCoreModelResourceTransformerAttributes = "WFLYCTL0294: Transforming resource %s to core model version '%s' -- %s %s";
    protected String transformerLoggerCoreModelResourceTransformerAttributes$str() {
        return transformerLoggerCoreModelResourceTransformerAttributes;
    }
    @Override
    public final String transformerLoggerCoreModelResourceTransformerAttributes(final PathAddress pathAddress, final ModelVersion modelVersion, final String attributeNames, final String message) {
        return String.format(getLoggingLocale(), transformerLoggerCoreModelResourceTransformerAttributes$str(), pathAddress, modelVersion, attributeNames, message);
    }
    private static final String transformerLoggerCoreModelOperationTransformerAttributes = "WFLYCTL0295: Transforming operation %s at resource %s to core model version '%s' -- %s %s";
    protected String transformerLoggerCoreModelOperationTransformerAttributes$str() {
        return transformerLoggerCoreModelOperationTransformerAttributes;
    }
    @Override
    public final String transformerLoggerCoreModelOperationTransformerAttributes(final ModelNode op, final PathAddress pathAddress, final ModelVersion modelVersion, final String attributeNames, final String message) {
        return String.format(getLoggingLocale(), transformerLoggerCoreModelOperationTransformerAttributes$str(), op, pathAddress, modelVersion, attributeNames, message);
    }
    private static final String transformerLoggerSubsystemModelResourceTransformerAttributes = "WFLYCTL0296: Transforming resource %s to subsystem '%s' model version '%s' -- %s %s";
    protected String transformerLoggerSubsystemModelResourceTransformerAttributes$str() {
        return transformerLoggerSubsystemModelResourceTransformerAttributes;
    }
    @Override
    public final String transformerLoggerSubsystemModelResourceTransformerAttributes(final PathAddress pathAddress, final String subsystem, final ModelVersion modelVersion, final String attributeNames, final String message) {
        return String.format(getLoggingLocale(), transformerLoggerSubsystemModelResourceTransformerAttributes$str(), pathAddress, subsystem, modelVersion, attributeNames, message);
    }
    private static final String transformerLoggerSubsystemModelOperationTransformerAttributes = "WFLYCTL0297: Transforming operation %s at resource %s to subsystem '%s' model version '%s' -- %s %s";
    protected String transformerLoggerSubsystemModelOperationTransformerAttributes$str() {
        return transformerLoggerSubsystemModelOperationTransformerAttributes;
    }
    @Override
    public final String transformerLoggerSubsystemModelOperationTransformerAttributes(final ModelNode op, final PathAddress pathAddress, final String subsystem, final ModelVersion modelVersion, final String attributeNames, final String message) {
        return String.format(getLoggingLocale(), transformerLoggerSubsystemModelOperationTransformerAttributes$str(), op, pathAddress, subsystem, modelVersion, attributeNames, message);
    }
    private static final String illegalUnresolvedModel = "WFLYCTL0298: Node contains an unresolved expression %s -- a resolved model is required";
    protected String illegalUnresolvedModel$str() {
        return illegalUnresolvedModel;
    }
    @Override
    public final OperationFailedException illegalUnresolvedModel(final String expression) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), illegalUnresolvedModel$str(), expression));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rejectAttributesCoreModelResourceTransformer = "WFLYCTL0299: Transforming resource %s for host controller '%s' to core model version '%s' -- there were problems with some of the attributes and this resource will need to be ignored on that host. Details of the problems: %s";
    protected String rejectAttributesCoreModelResourceTransformer$str() {
        return rejectAttributesCoreModelResourceTransformer;
    }
    @Override
    public final OperationFailedException rejectAttributesCoreModelResourceTransformer(final PathAddress pathAddress, final String legacyHostName, final ModelVersion modelVersion, final java.util.List<String> details) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), rejectAttributesCoreModelResourceTransformer$str(), pathAddress, legacyHostName, modelVersion, details));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rejectAttributesSubsystemModelResourceTransformer = "WFLYCTL0300: Transforming resource %s for host controller '%s' to subsystem '%s' model version '%s' --there were problems with some of the attributes and this resource will need to be ignored on that host. Details of problems: %s";
    protected String rejectAttributesSubsystemModelResourceTransformer$str() {
        return rejectAttributesSubsystemModelResourceTransformer;
    }
    @Override
    public final OperationFailedException rejectAttributesSubsystemModelResourceTransformer(final PathAddress pathAddress, final String legacyHostName, final String subsystem, final ModelVersion modelVersion, final java.util.List<String> details) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), rejectAttributesSubsystemModelResourceTransformer$str(), pathAddress, legacyHostName, subsystem, modelVersion, details));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributesDoNotSupportExpressions = "WFLYCTL0301: The following attributes do not support expressions: %s";
    protected String attributesDoNotSupportExpressions$str() {
        return attributesDoNotSupportExpressions;
    }
    @Override
    public final String attributesDoNotSupportExpressions(final java.util.Set<String> attributeNames) {
        return String.format(getLoggingLocale(), attributesDoNotSupportExpressions$str(), attributeNames);
    }
    private static final String attributeNames = "attributes %s";
    protected String attributeNames$str() {
        return attributeNames;
    }
    @Override
    public final String attributeNames(final java.util.Set<String> attributes) {
        return String.format(getLoggingLocale(), attributeNames$str(), attributes);
    }
    private static final String attributesAreNotUnderstoodAndMustBeIgnored1 = "WFLYCTL0302: The following attributes are not understood in the target model version and this resource will need to be ignored on the target host: %s";
    protected String attributesAreNotUnderstoodAndMustBeIgnored1$str() {
        return attributesAreNotUnderstoodAndMustBeIgnored1;
    }
    @Override
    public final String attributesAreNotUnderstoodAndMustBeIgnored(final java.util.Set<String> attributeNames) {
        return String.format(getLoggingLocale(), attributesAreNotUnderstoodAndMustBeIgnored1$str(), attributeNames);
    }
    private static final String rejectedResourceResourceTransformation = "WFLYCTL0303: Resource %s is rejected on the target host, and will need to be ignored on the host";
    protected String rejectedResourceResourceTransformation$str() {
        return rejectedResourceResourceTransformation;
    }
    @Override
    public final String rejectedResourceResourceTransformation(final PathAddress address) {
        return String.format(getLoggingLocale(), rejectedResourceResourceTransformation$str(), address);
    }
    private static final String rejectResourceOperationTransformation = "WFLYCTL0304: Operation %2$s at %1s is rejected on the target host and will need to be ignored on the host";
    protected String rejectResourceOperationTransformation$str() {
        return rejectResourceOperationTransformation;
    }
    @Override
    public final String rejectResourceOperationTransformation(final PathAddress address, final ModelNode operation) {
        return String.format(getLoggingLocale(), rejectResourceOperationTransformation$str(), address, operation);
    }
    private static final String discoveryOptionsMustBeDeclared = "WFLYCTL0305: Unless the Host Controller is started with command line option %s and the %s attribute is not set to %s, %s must be declared or the %s and the %s need to be provided.";
    protected String discoveryOptionsMustBeDeclared$str() {
        return discoveryOptionsMustBeDeclared;
    }
    @Override
    public final XMLStreamException discoveryOptionsMustBeDeclared(final String adminOnlyCmd, final String policyAttribute, final String fetchValue, final String discoveryOptionsName, final String hostName, final String portName, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), discoveryOptionsMustBeDeclared$str(), adminOnlyCmd, policyAttribute, fetchValue, discoveryOptionsName, hostName, portName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyContext = "WFLYCTL0306: read only context";
    protected String readOnlyContext$str() {
        return readOnlyContext;
    }
    @Override
    public final IllegalStateException readOnlyContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), readOnlyContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGetControllerLock = "WFLYCTL0307: We are trying to read data from the master host controller, which is currently busy executing another set of operations. This is a temporary situation, please retry";
    protected String cannotGetControllerLock$str() {
        return cannotGetControllerLock;
    }
    @Override
    public final String cannotGetControllerLock() {
        return String.format(getLoggingLocale(), cannotGetControllerLock$str());
    }
    private static final String unsupportedLegacyExtension = "WFLYCTL0309: Legacy extension '%s' is not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain";
    protected String unsupportedLegacyExtension$str() {
        return unsupportedLegacyExtension;
    }
    @Override
    public final String unsupportedLegacyExtension(final String extensionName) {
        return String.format(getLoggingLocale(), unsupportedLegacyExtension$str(), extensionName);
    }
    private static final String extensionModuleNotFound = "WFLYCTL0310: Extension module %s not found";
    protected String extensionModuleNotFound$str() {
        return extensionModuleNotFound;
    }
    @Override
    public final OperationFailedRuntimeException extensionModuleNotFound(final ModuleNotFoundException cause, final String module) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), extensionModuleNotFound$str(), module));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionModuleLoadingFailure = "WFLYCTL0311: Failed to load Extension module %s";
    protected String extensionModuleLoadingFailure$str() {
        return extensionModuleLoadingFailure;
    }
    @Override
    public final RuntimeException extensionModuleLoadingFailure(final ModuleLoadException cause, final String module) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), extensionModuleLoadingFailure$str(), module), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noContextToDelegateTo = "WFLYCTL0312: no context to delegate with id: %s";
    protected String noContextToDelegateTo$str() {
        return noContextToDelegateTo;
    }
    @Override
    public final IllegalStateException noContextToDelegateTo(final int operationId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noContextToDelegateTo$str(), operationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "WFLYCTL0313: Unauthorized to execute operation '%s' for resource '%s' -- %s";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final UnauthorizedException unauthorized(final String name, final PathAddress address, final ModelNode explanation) {
        final UnauthorizedException result = new UnauthorizedException(String.format(getLoggingLocale(), unauthorized$str(), name, address, explanation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalMultipleRoles = "WFLYCTL0314: Users with multiple roles are not allowed";
    protected String illegalMultipleRoles$str() {
        return illegalMultipleRoles;
    }
    @Override
    public final SecurityException illegalMultipleRoles() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), illegalMultipleRoles$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noHandlerCalled = "WFLYCTL0317: There is no handler called '%s'";
    protected String noHandlerCalled$str() {
        return noHandlerCalled;
    }
    @Override
    public final IllegalStateException noHandlerCalled(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noHandlerCalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationContextIsNotAbstractOperationContext = "WFLYCTL0318: The operation context is not an AbstractOperationContext";
    protected String operationContextIsNotAbstractOperationContext$str() {
        return operationContextIsNotAbstractOperationContext;
    }
    @Override
    public final OperationFailedException operationContextIsNotAbstractOperationContext() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), operationContextIsNotAbstractOperationContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerIsReferencedBy = "WFLYCTL0319: The handler is referenced by %s and so cannot be removed";
    protected String handlerIsReferencedBy$str() {
        return handlerIsReferencedBy;
    }
    @Override
    public final IllegalStateException handlerIsReferencedBy(final java.util.Set<PathAddress> references) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), handlerIsReferencedBy$str(), references));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resolvedFileDoesNotExistOrIsDirectory = "WFLYCTL0320: The resolved file %s either does not exist or is a directory";
    protected String resolvedFileDoesNotExistOrIsDirectory$str() {
        return resolvedFileDoesNotExistOrIsDirectory;
    }
    @Override
    public final IllegalStateException resolvedFileDoesNotExistOrIsDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), resolvedFileDoesNotExistOrIsDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotBackUp = "WFLYCTL0321: Could not back up '%s' to '%s'";
    protected String couldNotBackUp$str() {
        return couldNotBackUp;
    }
    @Override
    public final IllegalStateException couldNotBackUp(final IOException cause, final String absolutePath, final String absolutePath1) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotBackUp$str(), absolutePath, absolutePath1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attemptToBothRemoveAndAddHandlerUpdateInstead = "WFLYCTL0322: Attempt was made to both remove and add a handler from a composite operation - update the handler instead";
    protected String attemptToBothRemoveAndAddHandlerUpdateInstead$str() {
        return attemptToBothRemoveAndAddHandlerUpdateInstead;
    }
    @Override
    public final IllegalStateException attemptToBothRemoveAndAddHandlerUpdateInstead() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), attemptToBothRemoveAndAddHandlerUpdateInstead$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attemptToBothAddAndRemoveAndHandlerFromCompositeOperation = "WFLYCTL0323: Attempt was made to both add and remove a handler from a composite operation";
    protected String attemptToBothAddAndRemoveAndHandlerFromCompositeOperation$str() {
        return attemptToBothAddAndRemoveAndHandlerFromCompositeOperation;
    }
    @Override
    public final IllegalStateException attemptToBothAddAndRemoveAndHandlerFromCompositeOperation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), attemptToBothAddAndRemoveAndHandlerFromCompositeOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attemptToBothUpdateAndRemoveHandlerFromCompositeOperation = "WFLYCTL0324: Attempt was made to both update and remove a handler from a composite operation";
    protected String attemptToBothUpdateAndRemoveHandlerFromCompositeOperation$str() {
        return attemptToBothUpdateAndRemoveHandlerFromCompositeOperation;
    }
    @Override
    public final IllegalStateException attemptToBothUpdateAndRemoveHandlerFromCompositeOperation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), attemptToBothUpdateAndRemoveHandlerFromCompositeOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation = "WFLYCTL0325: Attempt was made to both remove and add a handler reference from a composite operation";
    protected String attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation$str() {
        return attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation;
    }
    @Override
    public final IllegalStateException attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownRole = "WFLYCTL0327: Unknown role '%s'";
    protected String unknownRole$str() {
        return unknownRole;
    }
    @Override
    public final UnknowRoleException unknownRole(final String roleName) {
        final UnknowRoleException result = new UnknowRoleException(String.format(getLoggingLocale(), unknownRole$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveStandardRole = "WFLYCTL0328: Cannot remove standard role '%s'";
    protected String cannotRemoveStandardRole$str() {
        return cannotRemoveStandardRole;
    }
    @Override
    public final IllegalStateException cannotRemoveStandardRole(final String roleName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRemoveStandardRole$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownBaseRole = "WFLYCTL0329: Unknown base role '%s'";
    protected String unknownBaseRole$str() {
        return unknownBaseRole;
    }
    @Override
    public final IllegalArgumentException unknownBaseRole(final String roleName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownBaseRole$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String roleIsAlreadyRegistered = "WFLYCTL0330: Role '%s' is already registered";
    protected String roleIsAlreadyRegistered$str() {
        return roleIsAlreadyRegistered;
    }
    @Override
    public final IllegalStateException roleIsAlreadyRegistered(final String roleName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), roleIsAlreadyRegistered$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canOnlyCreateChildAuditLoggerForMainAuditLogger = "WFLYCTL0331: Can only create child audit logger for main audit logger";
    protected String canOnlyCreateChildAuditLoggerForMainAuditLogger$str() {
        return canOnlyCreateChildAuditLoggerForMainAuditLogger;
    }
    @Override
    public final IllegalStateException canOnlyCreateChildAuditLoggerForMainAuditLogger() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), canOnlyCreateChildAuditLoggerForMainAuditLogger$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionDenied = "WFLYCTL0332: Permission denied";
    protected String permissionDenied$str() {
        return permissionDenied;
    }
    @Override
    public final String permissionDenied() {
        return String.format(getLoggingLocale(), permissionDenied$str());
    }
    private static final String permissionCollectionIsReadOnly = "WFLYCTL0333: Cannot add a Permission to a readonly PermissionCollection";
    protected String permissionCollectionIsReadOnly$str() {
        return permissionCollectionIsReadOnly;
    }
    @Override
    public final SecurityException permissionCollectionIsReadOnly() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), permissionCollectionIsReadOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatiblePermissionType = "WFLYCTL0334: Incompatible permission type %s";
    protected String incompatiblePermissionType$str() {
        return incompatiblePermissionType;
    }
    @Override
    public final IllegalArgumentException incompatiblePermissionType(final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incompatiblePermissionType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managementResourceNotFoundMessage = "WFLYCTL0335: Management resource '%s' not found";
    protected String managementResourceNotFoundMessage$str() {
        return managementResourceNotFoundMessage;
    }
    @Override
    public final String managementResourceNotFoundMessage(final PathAddress pathAddress) {
        return String.format(getLoggingLocale(), managementResourceNotFoundMessage$str(), pathAddress);
    }
    private static final String attributesMustBeDefined = "WFLYCTL0336: The following attributes are nillable in the current model but must be defined in the target model version: %s";
    protected String attributesMustBeDefined$str() {
        return attributesMustBeDefined;
    }
    @Override
    public final String attributesMustBeDefined(final java.util.Set<String> keySet) {
        return String.format(getLoggingLocale(), attributesMustBeDefined$str(), keySet);
    }
    private static final String unsupportedIdentityType = "WFLYCTL0337: Unsupported Identity type '%X' received.";
    protected String unsupportedIdentityType$str() {
        return unsupportedIdentityType;
    }
    @Override
    public final IOException unsupportedIdentityType(final byte type) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unsupportedIdentityType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedIdentityParameter = "WFLYCTL0338: Unsupported Identity parameter '%X' received parsing identity type '%X'.";
    protected String unsupportedIdentityParameter$str() {
        return unsupportedIdentityParameter;
    }
    @Override
    public final IOException unsupportedIdentityParameter(final byte parameterType, final byte principalType) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unsupportedIdentityParameter$str(), parameterType, principalType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributesMustBeDefinedAs = "WFLYCTL0339: The following attributes must be defined as %s in the current model: %s";
    protected String attributesMustBeDefinedAs$str() {
        return attributesMustBeDefinedAs;
    }
    @Override
    public final String attributesMustBeDefinedAs(final ModelNode value, final java.util.Set<String> names) {
        return String.format(getLoggingLocale(), attributesMustBeDefinedAs$str(), value, names);
    }
    private static final String attributesMustNotBeDefinedAs = "WFLYCTL0340: The following attributes must NOT be defined as %s in the current model: %s";
    protected String attributesMustNotBeDefinedAs$str() {
        return attributesMustNotBeDefinedAs;
    }
    @Override
    public final String attributesMustNotBeDefinedAs(final ModelNode value, final java.util.Set<String> names) {
        return String.format(getLoggingLocale(), attributesMustNotBeDefinedAs$str(), value, names);
    }
    private static final String badUriSyntax = "WFLYCTL0341: A uri with bad syntax '%s' was passed for validation.";
    protected String badUriSyntax$str() {
        return badUriSyntax;
    }
    @Override
    public final OperationFailedException badUriSyntax(final String uri) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), badUriSyntax$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBlockingTimeout = "WFLYCTL0342: Illegal value %d for operation header %s; value must be greater than zero";
    protected String invalidBlockingTimeout$str() {
        return invalidBlockingTimeout;
    }
    @Override
    public final OperationFailedException invalidBlockingTimeout(final long timeout, final String headerName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidBlockingTimeout$str(), timeout, headerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timeoutAwaitingInitialStability0 = "WFLYCTL0343: The service container has been destabilized by a previous operation and further runtime updates cannot be processed. Restart is required.";
    protected String timeoutAwaitingInitialStability0$str() {
        return timeoutAwaitingInitialStability0;
    }
    @Override
    public final String timeoutAwaitingInitialStability() {
        return String.format(getLoggingLocale(), timeoutAwaitingInitialStability0$str());
    }
    private static final String timeoutExecutingOperation0 = "WFLYCTL0344: Operation timed out awaiting service container stability";
    protected String timeoutExecutingOperation0$str() {
        return timeoutExecutingOperation0;
    }
    @Override
    public final String timeoutExecutingOperation() {
        return String.format(getLoggingLocale(), timeoutExecutingOperation0$str());
    }
    private static final String serviceInstallTimedOut = "WFLYCTL0345: Timeout after %d seconds waiting for existing service %s to be removed so a new instance can be installed.";
    protected String serviceInstallTimedOut$str() {
        return serviceInstallTimedOut;
    }
    @Override
    public final IllegalStateException serviceInstallTimedOut(final long timeout, final ServiceName name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceInstallTimedOut$str(), timeout, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidDefaultBlockingTimeout(final String sysPropValue, final String sysPropName, final long defaultUsed) {
        super.log.logf(FQCN, ERROR, null, invalidDefaultBlockingTimeout$str(), sysPropValue, sysPropName, defaultUsed);
    }
    private static final String invalidDefaultBlockingTimeout = "WFLYCTL0346: Invalid value %s for property %s; must be a numeric value greater than zero. Default value of %d will be used.";
    protected String invalidDefaultBlockingTimeout$str() {
        return invalidDefaultBlockingTimeout;
    }
    @Override
    public final void timeoutAwaitingInitialStability(final long blockingTimeout, final String name, final PathAddress address) {
        super.log.logf(FQCN, DEBUG, null, timeoutAwaitingInitialStability3$str(), blockingTimeout, name, address);
    }
    private static final String timeoutAwaitingInitialStability3 = "WFLYCTL0347: Timeout after [%d] seconds waiting for initial service container stability before allowing runtime changes for operation '%s' at address '%s'. Operation will roll back; process restart is required.";
    protected String timeoutAwaitingInitialStability3$str() {
        return timeoutAwaitingInitialStability3;
    }
    @Override
    public final void timeoutExecutingOperation(final long blockingTimeout, final String name, final PathAddress address) {
        super.log.logf(FQCN, ERROR, null, timeoutExecutingOperation3$str(), blockingTimeout, name, address);
    }
    private static final String timeoutExecutingOperation3 = "WFLYCTL0348: Timeout after [%d] seconds waiting for service container stability. Operation will roll back. Step that first updated the service container was '%s' at address '%s'";
    protected String timeoutExecutingOperation3$str() {
        return timeoutExecutingOperation3;
    }
    @Override
    public final void timeoutCompletingOperation(final long blockingTimeout, final String name, final PathAddress address) {
        super.log.logf(FQCN, ERROR, null, timeoutCompletingOperation$str(), blockingTimeout, name, address);
    }
    private static final String timeoutCompletingOperation = "WFLYCTL0349: Timeout after [%d] seconds waiting for service container stability while finalizing an operation. Process must be restarted. Step that first updated the service container was '%s' at address '%s'";
    protected String timeoutCompletingOperation$str() {
        return timeoutCompletingOperation;
    }
    @Override
    public final void interruptedAwaitingInitialResponse(final String operation, final PathAddress proxyNodeAddress) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingInitialResponse$str(), operation, proxyNodeAddress);
    }
    private static final String interruptedAwaitingInitialResponse = "WFLYCTL0350: Execution of operation '%s' on remote process at address '%s' interrupted while awaiting initial response; remote process has been notified to cancel operation";
    protected String interruptedAwaitingInitialResponse$str() {
        return interruptedAwaitingInitialResponse;
    }
    @Override
    public final void interruptedAwaitingFinalResponse(final String operation, final PathAddress proxyNodeAddress) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingFinalResponse$str(), operation, proxyNodeAddress);
    }
    private static final String interruptedAwaitingFinalResponse = "WFLYCTL0351: Execution of operation '%s' on remote process at address '%s' interrupted while awaiting final response; remote process has been notified to terminate operation";
    protected String interruptedAwaitingFinalResponse$str() {
        return interruptedAwaitingFinalResponse;
    }
    @Override
    public final void cancellingOperation(final String operation, final int id, final String thread) {
        super.log.logf(FQCN, INFO, null, cancellingOperation$str(), operation, id, thread);
    }
    private static final String cancellingOperation = "WFLYCTL0352: Cancelling operation '%s' with id '%d' running on thread '%s'";
    protected String cancellingOperation$str() {
        return cancellingOperation;
    }
    private static final String responseHandlerNotFound = "WFLYCTL0353: No response handler for request %s";
    protected String responseHandlerNotFound$str() {
        return responseHandlerNotFound;
    }
    @Override
    public final IOException responseHandlerNotFound(final int id) {
        final IOException result = new IOException(String.format(getLoggingLocale(), responseHandlerNotFound$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void attemptingReconnectToSyslog(final String name, final int timeout) {
        super.log.logf(FQCN, INFO, null, attemptingReconnectToSyslog$str(), name, timeout);
    }
    private static final String attemptingReconnectToSyslog = "WFLYCTL0354: Attempting reconnect to syslog handler '%s; after timeout of %d seconds";
    protected String attemptingReconnectToSyslog$str() {
        return attemptingReconnectToSyslog;
    }
    @Override
    public final void reconnectToSyslogFailed(final String name, final Throwable e) {
        super.log.logf(FQCN, INFO, e, reconnectToSyslogFailed$str(), name);
    }
    private static final String reconnectToSyslogFailed = "WFLYCTL0355: Reconnecting to syslog handler '%s failed";
    protected String reconnectToSyslogFailed$str() {
        return reconnectToSyslogFailed;
    }
    @Override
    public final void failedToEmitNotification(final Notification notification, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToEmitNotification$str(), notification);
    }
    private static final String failedToEmitNotification = "WFLYCTL0356: Failed to emit notification %s";
    protected String failedToEmitNotification$str() {
        return failedToEmitNotification;
    }
    private static final String notificationIsNotDescribed = "WFLYCTL0357: Notification of type %s is not described for the resource at the address %s";
    protected String notificationIsNotDescribed$str() {
        return notificationIsNotDescribed;
    }
    @Override
    public final String notificationIsNotDescribed(final String type, final PathAddress source) {
        return String.format(getLoggingLocale(), notificationIsNotDescribed$str(), type, source);
    }
    private static final String resourceWasAdded = "WFLYCTL0358: The resource was added at the address %s.";
    protected String resourceWasAdded$str() {
        return resourceWasAdded;
    }
    @Override
    public final String resourceWasAdded(final PathAddress address) {
        return String.format(getLoggingLocale(), resourceWasAdded$str(), address);
    }
    private static final String resourceWasRemoved = "WFLYCTL0359: The resource was removed at the address %s.";
    protected String resourceWasRemoved$str() {
        return resourceWasRemoved;
    }
    @Override
    public final String resourceWasRemoved(final PathAddress address) {
        return String.format(getLoggingLocale(), resourceWasRemoved$str(), address);
    }
    private static final String attributeValueWritten = "WFLYCTL0360: The attribute %s value has been changed from %s to %s.";
    protected String attributeValueWritten$str() {
        return attributeValueWritten;
    }
    @Override
    public final String attributeValueWritten(final String attributeName, final ModelNode currentValue, final ModelNode newVal) {
        return String.format(getLoggingLocale(), attributeValueWritten$str(), attributeName, currentValue, newVal);
    }
    private static final String capabilitiesNotAvailable = "WFLYCTL0361: Capabilities cannot be queried in stage '%s'; they are not available until stage '%s'.";
    protected String capabilitiesNotAvailable$str() {
        return capabilitiesNotAvailable;
    }
    @Override
    public final IllegalStateException capabilitiesNotAvailable(final Stage currentStage, final Stage runtime) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), capabilitiesNotAvailable$str(), currentStage, runtime));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredCapabilityMissing1 = "WFLYCTL0362: Capabilities required by resource '%s' are not available:";
    protected String requiredCapabilityMissing1$str() {
        return requiredCapabilityMissing1;
    }
    @Override
    public final String requiredCapabilityMissing(final String demandingAddress) {
        return String.format(getLoggingLocale(), requiredCapabilityMissing1$str(), demandingAddress);
    }
    private static final String capabilityAlreadyRegisteredInContext2 = "WFLYCTL0363: Capability '%s' is already registered in context '%s'.";
    protected String capabilityAlreadyRegisteredInContext2$str() {
        return capabilityAlreadyRegisteredInContext2;
    }
    @Override
    public final IllegalStateException capabilityAlreadyRegisteredInContext(final String capability, final String context) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), capabilityAlreadyRegisteredInContext2$str(), capability, context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownCapability = "WFLYCTL0364: Capability '%s' is unknown.";
    protected String unknownCapability$str() {
        return unknownCapability;
    }
    @Override
    public final IllegalStateException unknownCapability(final String capability) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownCapability$str(), capability));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownCapabilityInContext = "WFLYCTL0365: Capability '%s' is unknown in context '%s'.";
    protected String unknownCapabilityInContext$str() {
        return unknownCapabilityInContext;
    }
    @Override
    public final IllegalStateException unknownCapabilityInContext(final String capability, final String context) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownCapabilityInContext$str(), capability, context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String capabilityDoesNotExposeRuntimeAPI = "WFLYCTL0366: Capability '%s' does not expose a runtime API.";
    protected String capabilityDoesNotExposeRuntimeAPI$str() {
        return capabilityDoesNotExposeRuntimeAPI;
    }
    @Override
    public final IllegalArgumentException capabilityDoesNotExposeRuntimeAPI(final String capabilityName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), capabilityDoesNotExposeRuntimeAPI$str(), capabilityName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveRequiredCapability = "WFLYCTL0367: Cannot remove capability '%s' as it is required by other capabilities:";
    protected String cannotRemoveRequiredCapability$str() {
        return cannotRemoveRequiredCapability;
    }
    @Override
    public final String cannotRemoveRequiredCapability(final String capability) {
        return String.format(getLoggingLocale(), cannotRemoveRequiredCapability$str(), capability);
    }
    private static final String cannotRemoveRequiredCapabilityInContext = "WFLYCTL0368: Cannot remove capability '%s' from context '%s' as it is required by other capabilities:";
    protected String cannotRemoveRequiredCapabilityInContext$str() {
        return cannotRemoveRequiredCapabilityInContext;
    }
    @Override
    public final String cannotRemoveRequiredCapabilityInContext(final String capability, final String context) {
        return String.format(getLoggingLocale(), cannotRemoveRequiredCapabilityInContext$str(), capability, context);
    }
    private static final String requiredCapabilityMissing0 = "WFLYCTL0369: Required capabilities are not available:";
    protected String requiredCapabilityMissing0$str() {
        return requiredCapabilityMissing0;
    }
    @Override
    public final String requiredCapabilityMissing() {
        return String.format(getLoggingLocale(), requiredCapabilityMissing0$str());
    }
    private static final String requirementPointSimple = "capability '%s' requires it for address '%s'";
    protected String requirementPointSimple$str() {
        return requirementPointSimple;
    }
    @Override
    public final String requirementPointSimple(final String capability, final String requestingAddress) {
        return String.format(getLoggingLocale(), requirementPointSimple$str(), capability, requestingAddress);
    }
    private static final String requirementPointFull = "capability '%s' requires it for attribute '%s' at address '%s'";
    protected String requirementPointFull$str() {
        return requirementPointFull;
    }
    @Override
    public final String requirementPointFull(final String capability, final String attribute, final String requestingAddress) {
        return String.format(getLoggingLocale(), requirementPointFull$str(), capability, attribute, requestingAddress);
    }
    private static final String formattedCapabilityName = "    %s";
    protected String formattedCapabilityName$str() {
        return formattedCapabilityName;
    }
    @Override
    public final String formattedCapabilityName(final String capability) {
        return String.format(getLoggingLocale(), formattedCapabilityName$str(), capability);
    }
    private static final String formattedCapabilityId = "    %s in context '%s'";
    protected String formattedCapabilityId$str() {
        return formattedCapabilityId;
    }
    @Override
    public final String formattedCapabilityId(final String capability, final String context) {
        return String.format(getLoggingLocale(), formattedCapabilityId$str(), capability, context);
    }
    private static final String possibleCapabilityProviderPoints = "; Possible registration points for this capability: %s";
    protected String possibleCapabilityProviderPoints$str() {
        return possibleCapabilityProviderPoints;
    }
    @Override
    public final String possibleCapabilityProviderPoints(final String providerPoints) {
        return String.format(getLoggingLocale(), possibleCapabilityProviderPoints$str(), providerPoints);
    }
    private static final String noKnownProviderPoints = "; There are no known registration points which can provide this capability.";
    protected String noKnownProviderPoints$str() {
        return noKnownProviderPoints;
    }
    @Override
    public final String noKnownProviderPoints() {
        return String.format(getLoggingLocale(), noKnownProviderPoints$str());
    }
    private static final String incompleteExpression = "WFLYCTL0370: Incomplete expression: %s";
    protected String incompleteExpression$str() {
        return incompleteExpression;
    }
    @Override
    public final OperationFailedException incompleteExpression(final String expression) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), incompleteExpression$str(), expression));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedElement = "WFLYCTL0371: The element '%s' is no longer supported, please use '%s' instead";
    protected String unsupportedElement$str() {
        return unsupportedElement;
    }
    @Override
    public final XMLStreamException unsupportedElement(final QName name, final Location location, final String supportedElement) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unsupportedElement$str(), name, supportedElement), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateElementsInList = "WFLYCTL0372: List attribute '%s' contains duplicates, which are not allowed";
    protected String duplicateElementsInList$str() {
        return duplicateElementsInList;
    }
    @Override
    public final String duplicateElementsInList(final String name) {
        return String.format(getLoggingLocale(), duplicateElementsInList$str(), name);
    }
    private static final String deploymentResourceMustBeRuntimeOnly = "WFLYCTL0373: Deployment resource must be runtime only";
    protected String deploymentResourceMustBeRuntimeOnly$str() {
        return deploymentResourceMustBeRuntimeOnly;
    }
    @Override
    public final IllegalArgumentException deploymentResourceMustBeRuntimeOnly() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), deploymentResourceMustBeRuntimeOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveExpressions = "WFLYCTL0374: Unable to resolve expressions at this location.";
    protected String unableToResolveExpressions$str() {
        return unableToResolveExpressions;
    }
    @Override
    public final OperationFailedException unableToResolveExpressions() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToResolveExpressions$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void udpSyslogServerUnavailable(final String name, final String message) {
        super.log.logf(FQCN, WARN, null, udpSyslogServerUnavailable$str(), name, message);
    }
    private static final String udpSyslogServerUnavailable = "WFLYCTL0375: Update of the management operation audit log failed on the handler '%s' due to '%s'. Please make sure that the syslog server is running and reachable";
    protected String udpSyslogServerUnavailable$str() {
        return udpSyslogServerUnavailable;
    }
    private static final String unexpectedAttribute2 = "WFLYCTL0376: Unexpected attribute '%s' encountered. Valid attributes are: '%s'";
    protected String unexpectedAttribute2$str() {
        return unexpectedAttribute2;
    }
    @Override
    public final XMLStreamException unexpectedAttribute(final QName name, final StringBuilder possibleAttributes, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedAttribute2$str(), name, possibleAttributes), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement2 = "WFLYCTL0377: Unexpected element '%s' encountered. Valid elements are: '%s'";
    protected String unexpectedElement2$str() {
        return unexpectedElement2;
    }
    @Override
    public final XMLStreamException unexpectedElement(final QName name, final StringBuilder possible, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedElement2$str(), name, possible), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeIsWrongType = "WFLYCTL0378: Attribute '%s' is not of type '%s', it is type '%s'";
    protected String attributeIsWrongType$str() {
        return attributeIsWrongType;
    }
    @Override
    public final OperationFailedException attributeIsWrongType(final String name, final ModelType expectedType, final ModelType providedType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), attributeIsWrongType$str(), name, expectedType, providedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managementUnavailableDuringBoot = "WFLYCTL0379: System boot is in process; execution of remote management operations is not currently available";
    protected String managementUnavailableDuringBoot$str() {
        return managementUnavailableDuringBoot;
    }
    @Override
    public final String managementUnavailableDuringBoot() {
        return String.format(getLoggingLocale(), managementUnavailableDuringBoot$str());
    }
    private static final String requiredAttributeNotSet = "WFLYCTL0380: Attribute '%s' needs to be set or passed before attribute '%s' can be correctly set";
    protected String requiredAttributeNotSet$str() {
        return requiredAttributeNotSet;
    }
    @Override
    public final OperationFailedException requiredAttributeNotSet(final String required, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredAttributeNotSet$str(), required, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPermissionName = "WFLYCTL0381: Illegal permission name '%s'";
    protected String illegalPermissionName$str() {
        return illegalPermissionName;
    }
    @Override
    public final IllegalArgumentException illegalPermissionName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalPermissionName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPermissionActions = "WFLYCTL0382: Illegal permission actions '%s'";
    protected String illegalPermissionActions$str() {
        return illegalPermissionActions;
    }
    @Override
    public final IllegalArgumentException illegalPermissionActions(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalPermissionActions$str(), actions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noOperationDefined = "WFLYCTL0383: No operation is defined %s";
    protected String noOperationDefined$str() {
        return noOperationDefined;
    }
    @Override
    public final String noOperationDefined(final ModelNode operation) {
        return String.format(getLoggingLocale(), noOperationDefined$str(), operation);
    }
    private static final String registerHostCapableMustHappenFirst = "WFLYCTL0384: The call to registerHostCapable() should happen before registering models or transformers for the '%s' subsystem.";
    protected String registerHostCapableMustHappenFirst$str() {
        return registerHostCapableMustHappenFirst;
    }
    @Override
    public final IllegalStateException registerHostCapableMustHappenFirst(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), registerHostCapableMustHappenFirst$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonHostCapableSubsystemInHostModel = "WFLYCTL0385: An attempt was made to register the non-host capable subsystem '%s' from extension module '%s' in the host model.";
    protected String nonHostCapableSubsystemInHostModel$str() {
        return nonHostCapableSubsystemInHostModel;
    }
    @Override
    public final IllegalStateException nonHostCapableSubsystemInHostModel(final String subsystemName, final String extensionModuleName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nonHostCapableSubsystemInHostModel$str(), subsystemName, extensionModuleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyAccessHostControllerInfoInRuntimeStage = "WFLYCTL0386: The host controller info can only be accessed after the model stage on boot";
    protected String onlyAccessHostControllerInfoInRuntimeStage$str() {
        return onlyAccessHostControllerInfoInRuntimeStage;
    }
    @Override
    public final OperationFailedException onlyAccessHostControllerInfoInRuntimeStage() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), onlyAccessHostControllerInfoInRuntimeStage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCLIStylePathAddress = "WFLYCTL0387: Illegal path address '%s' , it is not in a correct CLI format";
    protected String illegalCLIStylePathAddress$str() {
        return illegalCLIStylePathAddress;
    }
    @Override
    public final IllegalArgumentException illegalCLIStylePathAddress(final String pathAddress) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCLIStylePathAddress$str(), pathAddress));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateEmptyConfig = "WFLYCTL0388: Could not create empty configuration file %s";
    protected String cannotCreateEmptyConfig$str() {
        return cannotCreateEmptyConfig;
    }
    @Override
    public final IllegalStateException cannotCreateEmptyConfig(final String absolutePath, final IOException cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCreateEmptyConfig$str(), absolutePath), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rejectEmptyConfig = "WFLYCTL0389: Could not create an empty configuration at file %s as there is an existing non-empty configuration there";
    protected String rejectEmptyConfig$str() {
        return rejectEmptyConfig;
    }
    @Override
    public final IllegalStateException rejectEmptyConfig(final String absolutePath) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rejectEmptyConfig$str(), absolutePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyForObjectType = "WFLYCTL0390: An invalid key '%s' has been supplied for parameter '%s'";
    protected String invalidKeyForObjectType$str() {
        return invalidKeyForObjectType;
    }
    @Override
    public final OperationFailedException invalidKeyForObjectType(final String key, final String parameter) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidKeyForObjectType$str(), key, parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotResolveExpressionIndex = "WFLYCTL0391: Could not resolve attribute expression: '%s', invalid index '%d'";
    protected String couldNotResolveExpressionIndex$str() {
        return couldNotResolveExpressionIndex;
    }
    @Override
    public final OperationFailedException couldNotResolveExpressionIndex(final String attributeExpression, final int index) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotResolveExpressionIndex$str(), attributeExpression, index));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotResolveExpressionList = "WFLYCTL0392: Could not resolve attribute expression: '%s', type is not a list";
    protected String couldNotResolveExpressionList$str() {
        return couldNotResolveExpressionList;
    }
    @Override
    public final OperationFailedException couldNotResolveExpressionList(final String attributeExpression) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotResolveExpressionList$str(), attributeExpression));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotResolveExpression = "WFLYCTL0393: Could not resolve attribute expression: '%s'";
    protected String couldNotResolveExpression$str() {
        return couldNotResolveExpression;
    }
    @Override
    public final OperationFailedException couldNotResolveExpression(final String attributeExpression) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotResolveExpression$str(), attributeExpression));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCapabilityServiceType = "WFLYCTL0394: Capability '%s' does not provide services of type '%s'";
    protected String invalidCapabilityServiceType$str() {
        return invalidCapabilityServiceType;
    }
    @Override
    public final IllegalArgumentException invalidCapabilityServiceType(final String capabilityName, final Class<?> serviceType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCapabilityServiceType$str(), capabilityName, serviceType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void operationDeprecated(final String name, final String address) {
        super.log.logf(FQCN, INFO, null, operationDeprecated$str(), name, address);
    }
    private static final String operationDeprecated = "WFLYCTL0395: Operation %s against the resource at address %s is deprecated, and it might be removed in future version. See the the output of the read-operation-description operation to learn more about the deprecation.";
    protected String operationDeprecated$str() {
        return operationDeprecated;
    }
    private static final String discardedResourceTransformation = "WFLYCTL0396: Resource %s is discarded on the target host %s";
    protected String discardedResourceTransformation$str() {
        return discardedResourceTransformation;
    }
    @Override
    public final String discardedResourceTransformation(final PathAddress address, final String host) {
        return String.format(getLoggingLocale(), discardedResourceTransformation$str(), address, host);
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYCTL0397: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement element) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), element));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String orderedChildTypeRenamed = "WFLYCTL0398: An attempt was made to rename the resource found at %s to %s. However, '%s' is one of the resource types defined to be ordered on the parent resource %s";
    protected String orderedChildTypeRenamed$str() {
        return orderedChildTypeRenamed;
    }
    @Override
    public final OperationFailedRuntimeException orderedChildTypeRenamed(final PathAddress read, final PathAddress transformed, final String type, final java.util.Set<String> parentOrderedChildren) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), orderedChildTypeRenamed$str(), read, transformed, type, parentOrderedChildren));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentCapabilityContexts4 = "WFLYCTL0399: The capability '%s' required by capability '%s' in context '%s' is available in one or more socket binding groups, but not all socket binding capabilities required by '%s' can be resolved from a single socket binding group, so this configuration is invalid";
    protected String inconsistentCapabilityContexts4$str() {
        return inconsistentCapabilityContexts4;
    }
    @Override
    public final String inconsistentCapabilityContexts(final String requiredName, final String dependentName, final String dependentContext, final String dependentContextAgain) {
        return String.format(getLoggingLocale(), inconsistentCapabilityContexts4$str(), requiredName, dependentName, dependentContext, dependentContextAgain);
    }
    @Override
    public final void inconsistentCapabilityContexts(final String dependentName, final String dependentContext, final String address, final String requiredName, final String dependentContextAgain) {
        super.log.logf(FQCN, ERROR, null, inconsistentCapabilityContexts5$str(), dependentName, dependentContext, address, requiredName, dependentContextAgain);
    }
    private static final String inconsistentCapabilityContexts5 = "WFLYCTL0400: Capability '%s' in context '%s' associated with resource '%s' requires capability '%s'. It is available in one or more socket binding groups, but not all socket binding capabilities required by '%s' can be resolved from a single socket binding group, so this configuration is invalid";
    protected String inconsistentCapabilityContexts5$str() {
        return inconsistentCapabilityContexts5;
    }
    private static final String failedToBuildReport = "WFLYCTL0401: Couldn't build the report";
    protected String failedToBuildReport$str() {
        return failedToBuildReport;
    }
    @Override
    public final RuntimeException failedToBuildReport(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToBuildReport$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void removeUnsupportedLegacyExtension(final java.util.List<String> subsystemNames, final String extensionName) {
        super.log.logf(FQCN, ERROR, null, removeUnsupportedLegacyExtension$str(), subsystemNames, extensionName);
    }
    private static final String removeUnsupportedLegacyExtension = "WFLYCTL0402: Subsystems %s provided by legacy extension '%s' are not supported on servers running this version. Both the subsystem and the extension must be removed or migrated before the server will function.";
    protected String removeUnsupportedLegacyExtension$str() {
        return removeUnsupportedLegacyExtension;
    }
    @Override
    public final void unexpectedOperationExecutionException(final Throwable t, final java.util.List<ModelNode> controllerOperations) {
        super.log.logf(FQCN, ERROR, t, unexpectedOperationExecutionException$str(), controllerOperations);
    }
    private static final String unexpectedOperationExecutionException = "WFLYCTL0403: Unexpected failure during execution of the following operation(s): %s";
    protected String unexpectedOperationExecutionException$str() {
        return unexpectedOperationExecutionException;
    }
    private static final String unexpectedOperationExecutionFailureDescription = "WFLYCTL0404: Unexpected exception during execution: %s";
    protected String unexpectedOperationExecutionFailureDescription$str() {
        return unexpectedOperationExecutionFailureDescription;
    }
    @Override
    public final String unexpectedOperationExecutionFailureDescription(final RuntimeException e) {
        return String.format(getLoggingLocale(), unexpectedOperationExecutionFailureDescription$str(), e);
    }
    @Override
    public final void couldNotFindTransformerRegistryFallingBack(final ModelVersion currentVersion, final ModelVersion fallbackVersion) {
        super.log.logf(FQCN, WARN, null, couldNotFindTransformerRegistryFallingBack$str(), currentVersion, fallbackVersion);
    }
    private static final String couldNotFindTransformerRegistryFallingBack = "WFLYCTL0405: Couldn't find a transformer to %s, falling back to %s";
    protected String couldNotFindTransformerRegistryFallingBack$str() {
        return couldNotFindTransformerRegistryFallingBack;
    }
    private static final String selectFailedCouldNotConvertAttributeToType = "WFLYCTL0406: Could not convert the attribute '%s' to a %s";
    protected String selectFailedCouldNotConvertAttributeToType$str() {
        return selectFailedCouldNotConvertAttributeToType;
    }
    @Override
    public final OperationFailedException selectFailedCouldNotConvertAttributeToType(final String attribute, final ModelType type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), selectFailedCouldNotConvertAttributeToType$str(), attribute, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedSendingCompletedResponse(final Throwable cause, final ModelNode response, final int operationId) {
        super.log.logf(FQCN, ERROR, cause, failedSendingCompletedResponse$str(), response, operationId);
    }
    private static final String failedSendingCompletedResponse = "WFLYCTL0407: Failed sending completed response %s for %d";
    protected String failedSendingCompletedResponse$str() {
        return failedSendingCompletedResponse;
    }
    @Override
    public final void failedSendingFailedResponse(final Throwable cause, final ModelNode response, final int operationId) {
        super.log.logf(FQCN, ERROR, cause, failedSendingFailedResponse$str(), response, operationId);
    }
    private static final String failedSendingFailedResponse = "WFLYCTL0408: Failed sending failure response %s for %d";
    protected String failedSendingFailedResponse$str() {
        return failedSendingFailedResponse;
    }
    private static final String proxiedOperationTimedOut = "WFLYCTL0409: Execution of operation '%s' on remote process at address '%s' timed out after %d ms while awaiting initial response; remote process has been notified to terminate operation";
    protected String proxiedOperationTimedOut$str() {
        return proxiedOperationTimedOut;
    }
    @Override
    public final String proxiedOperationTimedOut(final String operation, final PathAddress target, final long timeout) {
        return String.format(getLoggingLocale(), proxiedOperationTimedOut$str(), operation, target, timeout);
    }
    @Override
    public final void timeoutAwaitingFinalResponse(final String operation, final PathAddress proxyNodeAddress, final long timeout) {
        super.log.logf(FQCN, INFO, null, timeoutAwaitingFinalResponse$str(), operation, proxyNodeAddress, timeout);
    }
    private static final String timeoutAwaitingFinalResponse = "WFLYCTL0410: Execution of operation '%s' on remote process at address '%s' timed out after %d ms while awaiting final response; remote process has been notified to terminate operation";
    protected String timeoutAwaitingFinalResponse$str() {
        return timeoutAwaitingFinalResponse;
    }
    @Override
    public final void failedToParseElementLenient(final XMLStreamException e, final String elementName) {
        super.log.logf(FQCN, WARN, e, failedToParseElementLenient$str(), elementName);
    }
    private static final String failedToParseElementLenient = "WFLYCTL0411: Failed to parse element '%s', ignoring ...";
    protected String failedToParseElementLenient$str() {
        return failedToParseElementLenient;
    }
    private static final String missingRequiredServices = "WFLYCTL0412: Required services that are not installed:";
    protected String missingRequiredServices$str() {
        return missingRequiredServices;
    }
    @Override
    public final String missingRequiredServices() {
        return String.format(getLoggingLocale(), missingRequiredServices$str());
    }
    private static final String deprecatedAndCurrentParameterMismatch = "WFLYCTL0413: The deprecated parameter %s has been set in addition to the current parameter %s but with different values";
    protected String deprecatedAndCurrentParameterMismatch$str() {
        return deprecatedAndCurrentParameterMismatch;
    }
    @Override
    public final OperationFailedException deprecatedAndCurrentParameterMismatch(final String deprecated, final String current) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), deprecatedAndCurrentParameterMismatch$str(), deprecated, current));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotCreateHistoricalBackup(final String currentHistoryDir) {
        super.log.logf(FQCN, WARN, null, couldNotCreateHistoricalBackup$str(), currentHistoryDir);
    }
    private static final String couldNotCreateHistoricalBackup = "WFLYCTL0414: Could not create a timestamped backup of current history dir %s, so it may still include versions from the previous boot.";
    protected String couldNotCreateHistoricalBackup$str() {
        return couldNotCreateHistoricalBackup;
    }
    private static final String runtimeModificationBegun = "WFLYCTL0415: Modification of the runtime service container by a management operation has begun";
    protected String runtimeModificationBegun$str() {
        return runtimeModificationBegun;
    }
    @Override
    public final String runtimeModificationBegun() {
        return String.format(getLoggingLocale(), runtimeModificationBegun$str());
    }
    private static final String runtimeModificationComplete = "WFLYCTL0416: Modification of the runtime service container by a management operation has completed";
    protected String runtimeModificationComplete$str() {
        return runtimeModificationComplete;
    }
    @Override
    public final String runtimeModificationComplete() {
        return String.format(getLoggingLocale(), runtimeModificationComplete$str());
    }
    private static final String cannotAddMoreThanOneJvmForServerOrHost = "WFLYCTL0417: Cannot add more than one jvm. Add of '%s' attempted, but '%s' already exists";
    protected String cannotAddMoreThanOneJvmForServerOrHost$str() {
        return cannotAddMoreThanOneJvmForServerOrHost;
    }
    @Override
    public final OperationFailedException cannotAddMoreThanOneJvmForServerOrHost(final PathAddress requested, final PathAddress existing) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddMoreThanOneJvmForServerOrHost$str(), requested, existing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String socketBindingalreadyDeclared = "WFLYCTL0418: A %s or a %s %s already declared has already been declared in %s %s";
    protected String socketBindingalreadyDeclared$str() {
        return socketBindingalreadyDeclared;
    }
    @Override
    public final OperationFailedRuntimeException socketBindingalreadyDeclared(final String name1, final String name2, final String value, final String parentName, final String parentValue) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), socketBindingalreadyDeclared$str(), name1, name2, value, parentName, parentValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMaxBytesLength = "WFLYCTL0419: '%s' is an invalid value for parameter %s. Values must have a maximum length of %d bytes";
    protected String invalidMaxBytesLength$str() {
        return invalidMaxBytesLength;
    }
    @Override
    public final String invalidMaxBytesLength(final String str, final String parameterName, final int max) {
        return String.format(getLoggingLocale(), invalidMaxBytesLength$str(), str, parameterName, max);
    }
    private static final String invalidMinBytesLength = "WFLYCTL0420: '%s' is an invalid value for parameter %s. Values must have a minimum length of %d bytes";
    protected String invalidMinBytesLength$str() {
        return invalidMinBytesLength;
    }
    @Override
    public final String invalidMinBytesLength(final String str, final String parameterName, final int min) {
        return String.format(getLoggingLocale(), invalidMinBytesLength$str(), str, parameterName, min);
    }
    private static final String explodedDeploymentNotSupported = "WFLYCTL0421: Exploded deployment is not supported by some servers";
    protected String explodedDeploymentNotSupported$str() {
        return explodedDeploymentNotSupported;
    }
    @Override
    public final String explodedDeploymentNotSupported() {
        return String.format(getLoggingLocale(), explodedDeploymentNotSupported$str());
    }
    private static final String couldNotLoadModuleForTransformers = "WFLYCTL0422: Could not load module '%s' for transformers";
    protected String couldNotLoadModuleForTransformers$str() {
        return couldNotLoadModuleForTransformers;
    }
    @Override
    public final RuntimeException couldNotLoadModuleForTransformers(final String name, final ModuleLoadException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotLoadModuleForTransformers$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongMaskedPasswordFormat = "WFLYCTL0423: Masked password command has the wrong format.%nUsage: MASK-<encoded secret>;<salt>;<iteration count> where <salt>=UTF-8 characters, <iteration count>=reasonable sized positive integer";
    protected String wrongMaskedPasswordFormat$str() {
        return wrongMaskedPasswordFormat;
    }
    @Override
    public final IOException wrongMaskedPasswordFormat() {
        final IOException result = new IOException(String.format(getLoggingLocale(), wrongMaskedPasswordFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddressFormat = "WFLYCTL0433: '%s' is not a valid representation of a resource address";
    protected String invalidAddressFormat$str() {
        return invalidAddressFormat;
    }
    @Override
    public final OperationFailedException invalidAddressFormat(final ModelNode address) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidAddressFormat$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bootComplete = "WFLYCTL0434: Boot complete";
    protected String bootComplete$str() {
        return bootComplete;
    }
    @Override
    public final String bootComplete() {
        return String.format(getLoggingLocale(), bootComplete$str());
    }
    private static final String attributeWasNotMarkedAsReloadRequired = "WFLYCTL0435: Attribute %s of resource %s was not marked as reload required, either set the RESTART_ALL_SERVICES flag, or register a custom write handler.";
    protected String attributeWasNotMarkedAsReloadRequired$str() {
        return attributeWasNotMarkedAsReloadRequired;
    }
    @Override
    public final RuntimeException attributeWasNotMarkedAsReloadRequired(final String name, final PathAddress pathAddress) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), attributeWasNotMarkedAsReloadRequired$str(), name, pathAddress));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeConversionError = "Couldn't convert %s to %s";
    protected String typeConversionError$str() {
        return typeConversionError;
    }
    @Override
    public final String typeConversionError(final ModelNode value, final java.util.Collection<ModelType> validTypes) {
        return String.format(getLoggingLocale(), typeConversionError$str(), value, validTypes);
    }
    private static final String capabilityAlreadyRegisteredInContext4 = "WFLYCTL0436: Cannot register capability '%s' at location '%s' as it is already registered in context '%s' at location(s) '%s'";
    protected String capabilityAlreadyRegisteredInContext4$str() {
        return capabilityAlreadyRegisteredInContext4;
    }
    @Override
    public final OperationFailedRuntimeException capabilityAlreadyRegisteredInContext(final String capability, final RegistrationPoint newPoint, final String context, final java.util.Set<RegistrationPoint> oldPoints) {
        final OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(getLoggingLocale(), capabilityAlreadyRegisteredInContext4$str(), capability, newPoint, context, oldPoints));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateExtensionElement = "WFLYCTL0437: Duplicate extension: an %s element with %s attribute value '%s' has already been parsed";
    protected String duplicateExtensionElement$str() {
        return duplicateExtensionElement;
    }
    @Override
    public final XMLStreamException duplicateExtensionElement(final String elementConstant, final String attrConstant, final String module, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateExtensionElement$str(), elementConstant, attrConstant, module), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldntConvertWarningLevel = "WFLYCTL0438: Couldn't convert '%s' into proper warning level, threshold falling back to 'ALL'. Possible values: SEVERE,WARNING,INFO,CONFIG,FINE,FINER,FINEST,ALL,OFF";
    protected String couldntConvertWarningLevel$str() {
        return couldntConvertWarningLevel;
    }
    @Override
    public final String couldntConvertWarningLevel(final String level) {
        return String.format(getLoggingLocale(), couldntConvertWarningLevel$str(), level);
    }
    private static final String invalidSubnetFormat = "WFLYCTL0439: Value %s for attribute %s is not a valid subnet format";
    protected String invalidSubnetFormat$str() {
        return invalidSubnetFormat;
    }
    @Override
    public final OperationFailedException invalidSubnetFormat(final String value, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidSubnetFormat$str(), value, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotDeleteFileOrDirectory(final File file) {
        super.log.logf(FQCN, WARN, null, cannotDeleteFileOrDirectory$str(), file);
    }
    private static final String cannotDeleteFileOrDirectory = "WFLYCTL0440: Cannot delete file or directory %s";
    protected String cannotDeleteFileOrDirectory$str() {
        return cannotDeleteFileOrDirectory;
    }
    private static final String serviceStatusReportFailureHeader = "WFLYCTL0441: Operation has resulted in failed or missing services %n";
    protected String serviceStatusReportFailureHeader$str() {
        return serviceStatusReportFailureHeader;
    }
    @Override
    public final String serviceStatusReportFailureHeader() {
        return String.format(getLoggingLocale(), serviceStatusReportFailureHeader$str());
    }
    @Override
    public final void errorStoppingServer(final Exception cause) {
        super.log.logf(FQCN, WARN, cause, errorStoppingServer$str());
    }
    private static final String errorStoppingServer = "WFLYCTL0442: Error stopping server";
    protected String errorStoppingServer$str() {
        return errorStoppingServer;
    }
    @Override
    public final void errorObtainingPassword(final Exception cause, final String message) {
        super.log.logf(FQCN, WARN, cause, errorObtainingPassword$str(), message);
    }
    private static final String errorObtainingPassword = "WFLYCTL0443: Error getting the password from the supplier %s";
    protected String errorObtainingPassword$str() {
        return errorObtainingPassword;
    }
    @Override
    public final void invalidRuntimeStageForProfile(final String operation, final String address, final Stage stage, final ProcessType processType) {
        super.log.logf(FQCN, INFO, null, invalidRuntimeStageForProfile$str(), operation, address, stage, processType);
    }
    private static final String invalidRuntimeStageForProfile = "WFLYCTL0444: The handler for operation '%s' at address '%s' attempted to add a stage %s step. This is not valid for a 'profile' resource on process type %s so this step will not be executed.";
    protected String invalidRuntimeStageForProfile$str() {
        return invalidRuntimeStageForProfile;
    }
}
