/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class IntRangeValidator
extends ModelTypeValidator
implements MinMaxValidator {
    public static final ParameterValidator NON_NEGATIVE = new IntRangeValidator(0);
    public static final ParameterValidator POSITIVE = new IntRangeValidator(1);
    protected final int min;
    protected final int max;

    public IntRangeValidator(int min) {
        this(min, Integer.MAX_VALUE, false, false);
    }

    public IntRangeValidator(int min, int max) {
        this(min, max, false, false);
    }

    public IntRangeValidator(int min, boolean nullable) {
        this(min, Integer.MAX_VALUE, nullable, false);
    }

    public IntRangeValidator(int min, boolean nullable, boolean allowExpressions) {
        this(min, Integer.MAX_VALUE, nullable, allowExpressions);
    }

    public IntRangeValidator(int min, int max, boolean nullable, boolean allowExpressions) {
        super(ModelType.INT, nullable, allowExpressions, false);
        this.min = min;
        this.max = max;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            int val = value.asInt();
            if (val < this.min) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinValue(val, parameterName, this.min));
            }
            if (val > this.max) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMaxValue(val, parameterName, this.max));
            }
        }
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }
}

