/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Map;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLConfiguration;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLElement;
import org.jboss.as.controller.persistence.xml.MappedIterable;
import org.jboss.as.controller.persistence.xml.ResourceXMLElement;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLElementGroup;
import org.jboss.dmr.ModelNode;

public interface ResourceXMLElementGroup
extends XMLElementGroup<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> {

    public static abstract class AbstractBuilder<T extends ResourceXMLElementGroup, B extends Builder<T, B>>
    extends XMLElementGroup.AbstractBuilder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, ResourceXMLElement, T, B>
    implements Builder<T, B> {
        private final QNameResolver resolver;
        private volatile AttributeDefinitionXMLConfiguration configuration;

        AbstractBuilder(FeatureRegistry registry, QNameResolver resolver, AttributeDefinitionXMLConfiguration configuration) {
            super(registry);
            this.resolver = resolver;
            this.configuration = configuration;
        }

        @Override
        public B addElement(AttributeDefinition attribute) {
            if (this.enables(attribute)) {
                QName name = this.configuration.getName(attribute);
                AttributeParser parser = this.configuration.getParser(attribute);
                AttributeMarshaller marshaller = this.configuration.getMarshaller(attribute);
                if (parser.isParseAsElement() || marshaller.isMarshallableAsElement()) {
                    this.addElement(new AttributeDefinitionXMLElement.DefaultBuilder(attribute, this.resolver).withName(name).withParser(parser).withMarshaller(marshaller).build());
                }
            }
            return (B)((Builder)this.builder());
        }

        @Override
        public B addElements(Iterable<? extends AttributeDefinition> attributes) {
            for (AttributeDefinition attributeDefinition : attributes) {
                this.addElement(attributeDefinition);
            }
            return (B)((Builder)this.builder());
        }

        @Override
        public B withLocalNames(final Map<AttributeDefinition, String> localNames) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public QName getName(AttributeDefinition attribute) {
                    String localName = (String)localNames.get(attribute);
                    return localName != null ? this.resolve(localName) : super.getName(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withNames(final Map<AttributeDefinition, QName> names) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public QName getName(AttributeDefinition attribute) {
                    QName name = (QName)names.get(attribute);
                    return name != null ? name : super.getName(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withParsers(final Map<AttributeDefinition, AttributeParser> parsers) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public AttributeParser getParser(AttributeDefinition attribute) {
                    AttributeParser parser = (AttributeParser)parsers.get(attribute);
                    return parser != null ? parser : super.getParser(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withMarshallers(final Map<AttributeDefinition, AttributeMarshaller> marshallers) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public AttributeMarshaller getMarshaller(AttributeDefinition attribute) {
                    AttributeMarshaller marshaller = (AttributeMarshaller)marshallers.get(attribute);
                    return marshaller != null ? marshaller : super.getMarshaller(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }
    }

    public static interface Builder<T extends ResourceXMLElementGroup, B extends Builder<T, B>>
    extends XMLElementGroup.Builder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, ResourceXMLElement, T, B>,
    AttributeDefinitionXMLConfiguration.Configurator<B> {
        @Override
        public B addElement(AttributeDefinition var1);

        public B addElements(Iterable<? extends AttributeDefinition> var1);

        default public B provideElements(Iterable<? extends Supplier<AttributeDefinition>> providers) {
            return this.addElements(new MappedIterable<Supplier, AttributeDefinition>(providers, Supplier::get));
        }
    }
}

