/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationContext;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class ParallelBootOperationStepHandler
implements OperationStepHandler {
    private final Executor executor;
    private final ImmutableManagementResourceRegistration rootRegistration;
    private final ControlledProcessState processState;
    private final OperationStepHandler extraValidationStepHandler;
    private final ModelControllerImpl controller;
    private final int operationId;
    private final int maxParallelBootTasks;
    private final Map<String, List<ParsedBootOp>> opsBySubsystem = new LinkedHashMap<String, List<ParsedBootOp>>();
    private ParsedBootOp ourOp;

    ParallelBootOperationStepHandler(ExecutorService executorService, int maxParallelBootTasks, ImmutableManagementResourceRegistration rootRegistration, ControlledProcessState processState, ModelControllerImpl controller, int operationId, OperationStepHandler extraValidationStepHandler) {
        assert (maxParallelBootTasks > 1);
        this.executor = executorService;
        this.maxParallelBootTasks = maxParallelBootTasks;
        this.rootRegistration = rootRegistration;
        this.processState = processState;
        this.controller = controller;
        this.operationId = operationId;
        this.extraValidationStepHandler = extraValidationStepHandler;
    }

    boolean addSubsystemOperation(ParsedBootOp parsedOp) {
        String subsystemName = this.getSubsystemName(parsedOp.address);
        if (subsystemName != null) {
            List<ParsedBootOp> list = this.opsBySubsystem.get(subsystemName);
            if (list == null) {
                list = new ArrayList<ParsedBootOp>();
                this.opsBySubsystem.put(subsystemName, list);
            }
            list.add(parsedOp);
            this.getParsedBootOp().addChildOperation(parsedOp);
        }
        return subsystemName != null;
    }

    ParsedBootOp getParsedBootOp() {
        if (this.ourOp == null) {
            ModelNode op = Util.getEmptyOperation("parallel-subsystem-boot", new ModelNode().setEmptyList());
            this.ourOp = new ParsedBootOp(op, (OperationStepHandler)this);
        }
        return this.ourOp;
    }

    private String getSubsystemName(PathAddress address) {
        String key = null;
        if (address.size() > 0 && "subsystem".equals(address.getElement(0).getKey())) {
            key = address.getElement(0).getValue();
        }
        return key;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.isNormalServer()) {
            throw ControllerLogger.ROOT_LOGGER.fullServerBootRequired(this.getClass());
        }
        if (!(context instanceof OperationContextImpl)) {
            throw ControllerLogger.ROOT_LOGGER.operationContextIsNotAbstractOperationContext();
        }
        long start = System.currentTimeMillis();
        OperationContextImpl primaryContext = (OperationContextImpl)context;
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        OpChunk loggingModelChunk = null;
        TreeSet<OpChunk> opChunks = new TreeSet<OpChunk>();
        Set<Map.Entry<String, List<ParsedBootOp>>> sortedEntries = this.sortSubsystemsByCount();
        int count = 0;
        for (Map.Entry<String, List<ParsedBootOp>> entry : sortedEntries) {
            OpChunk opChunk;
            String subsystemName = entry.getKey();
            if ("logging".equals(subsystemName)) {
                loggingModelChunk = new OpChunk();
                loggingModelChunk.addModelPhaseOps(subsystemName, entry.getValue());
                continue;
            }
            if (count < this.maxParallelBootTasks) {
                opChunk = new OpChunk();
                ++count;
            } else {
                Iterator iter = opChunks.iterator();
                opChunk = (OpChunk)iter.next();
                iter.remove();
            }
            opChunk.addModelPhaseOps(subsystemName, entry.getValue());
            opChunks.add(opChunk);
        }
        if (loggingModelChunk != null) {
            opChunks.add(loggingModelChunk);
        }
        final LinkedHashMap<OpChunk, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<OpChunk, ParallelBootTransactionControl>();
        CountDownLatch preparedLatch = new CountDownLatch(opChunks.size());
        final CountDownLatch committedLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(opChunks.size());
        SecurityDomain bootSecurityDomain = SecurityDomain.builder().setDefaultRealmName("Empty").addRealm("Empty", SecurityRealm.EMPTY_REALM).build().build();
        for (OpChunk opChunk : opChunks) {
            ParallelBootTransactionControl parallelBootTransactionControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
            transactionControls.put(opChunk, parallelBootTransactionControl);
            Set<String> chunkSubsystems = opChunk.getSubsystemNames();
            List<ParsedBootOp> modelPhaseOps = opChunk.getModelPhaseOps();
            ControllerLogger.MGMT_OP_LOGGER.debugf("Chunk for %s has %d ops", chunkSubsystems, opChunk.opCount);
            ParallelBootOperationContext pboc = modelPhaseOps.size() == 0 ? null : this.createOperationContext(primaryContext, bootSecurityDomain, parallelBootTransactionControl, opChunk.runtimeOps);
            ParallelBootTask subsystemTask = new ParallelBootTask(chunkSubsystems, modelPhaseOps, OperationContext.Stage.MODEL, parallelBootTransactionControl, pboc);
            this.executor.execute(subsystemTask);
        }
        try {
            preparedLatch.await();
            this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.MODEL);
            if (loggingModelChunk != null) {
                opChunks.remove(loggingModelChunk);
                for (ParsedBootOp loggingOp : loggingModelChunk.runtimeOps) {
                    context.addStep(loggingOp.response, loggingOp.operation, loggingOp.handler, OperationContext.Stage.RUNTIME);
                }
            }
            LinkedHashMap<String, Resource> subsystemResources = new LinkedHashMap<String, Resource>();
            for (String string : this.opsBySubsystem.keySet()) {
                Resource resource = rootResource.removeChild(PathElement.pathElement("subsystem", string));
                if (resource == null) continue;
                subsystemResources.put(string, resource);
            }
            for (Map.Entry entry : subsystemResources.entrySet()) {
                rootResource.registerChild(PathElement.pathElement("subsystem", (String)entry.getKey()), (Resource)entry.getValue());
            }
            context.addStep(this.getRuntimeStep(opChunks, bootSecurityDomain), OperationContext.Stage.RUNTIME);
        }
        catch (InterruptedException e) {
            context.getFailureDescription().set(new ModelNode().set(ControllerLogger.ROOT_LOGGER.subsystemBootInterrupted()));
            Thread.currentThread().interrupt();
        }
        if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem model operations in [%d] ms", elapsed);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            @Override
            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.RUNTIME);
                try {
                    completeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    private ParallelBootOperationContext createOperationContext(OperationContextImpl primaryContext, SecurityDomain bootSecurityDomain, ParallelBootTransactionControl txControl, List<ParsedBootOp> runtimeOps) {
        return new ParallelBootOperationContext(txControl, this.processState, primaryContext, runtimeOps, this.controller, this.operationId, this.controller.getAuditLogger(), this.extraValidationStepHandler, () -> ((SecurityDomain)bootSecurityDomain).getAnonymousSecurityIdentity());
    }

    private Set<Map.Entry<String, List<ParsedBootOp>>> sortSubsystemsByCount() {
        TreeSet<Map.Entry<String, List<ParsedBootOp>>> result = new TreeSet<Map.Entry<String, List<ParsedBootOp>>>(new EntryComparator());
        result.addAll(this.opsBySubsystem.entrySet());
        return result;
    }

    private void checkForSubsystemFailures(OperationContext context, Map<OpChunk, ParallelBootTransactionControl> transactionControls, OperationContext.Stage stage) {
        boolean failureRecorded = false;
        for (Map.Entry<OpChunk, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) {
                String failureDesc = txControl.response.getResponseNode().hasDefined("failure-description") ? txControl.response.getResponseNode().get("failure-description").toString() : ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailed(entry.getKey().getSubsystemNames());
                ControllerLogger.MGMT_OP_LOGGER.error(failureDesc);
                if (failureRecorded) continue;
                context.getFailureDescription().set(failureDesc);
                failureRecorded = true;
                context.setRollbackOnly();
                continue;
            }
            ControllerLogger.MGMT_OP_LOGGER.debugf("Stage %s boot ops for subsystem %s succeeded", (Object)stage, entry.getKey());
        }
    }

    private void notifySubsystemTransactions(Map<OpChunk, ParallelBootTransactionControl> transactionControls, boolean rollback, CountDownLatch committedLatch, OperationContext.Stage stage) {
        for (Map.Entry<OpChunk, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) continue;
            if (!rollback) {
                txControl.transaction.commit();
                if (!ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) continue;
                ControllerLogger.MGMT_OP_LOGGER.debugf("Committed transaction for %s subsystem %s stage boot operations", entry.getKey().getSubsystemNames(), (Object)stage);
                continue;
            }
            txControl.transaction.rollback();
            if (!ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) continue;
            ControllerLogger.MGMT_OP_LOGGER.debugf("Rolled back transaction for %s subsystem %s stage boot operations", entry.getKey().getSubsystemNames(), (Object)stage);
        }
        committedLatch.countDown();
    }

    private OperationStepHandler getRuntimeStep(final Set<OpChunk> opChunks, final SecurityDomain bootSecurityDomain) {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                if (!(context instanceof OperationContextImpl)) {
                    throw ControllerLogger.ROOT_LOGGER.operationContextIsNotAbstractOperationContext();
                }
                OperationContextImpl primaryContext = (OperationContextImpl)context;
                context.getServiceRegistry(true);
                final LinkedHashMap<OpChunk, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<OpChunk, ParallelBootTransactionControl>();
                CountDownLatch preparedLatch = new CountDownLatch(opChunks.size());
                final CountDownLatch committedLatch = new CountDownLatch(1);
                final CountDownLatch completeLatch = new CountDownLatch(opChunks.size());
                for (OpChunk opChunk : opChunks) {
                    ParallelBootTransactionControl txControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
                    transactionControls.put(opChunk, txControl);
                    ParallelBootOperationContext pboc = opChunk.runtimeOps.size() == 0 ? null : ParallelBootOperationStepHandler.this.createOperationContext(primaryContext, bootSecurityDomain, txControl, null);
                    ParallelBootTask subsystemTask = new ParallelBootTask(opChunk.getSubsystemNames(), opChunk.runtimeOps, OperationContext.Stage.RUNTIME, txControl, pboc);
                    ParallelBootOperationStepHandler.this.executor.execute(subsystemTask);
                }
                try {
                    preparedLatch.await();
                    ParallelBootOperationStepHandler.this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.RUNTIME);
                }
                catch (InterruptedException e) {
                    context.getFailureDescription().set(new ModelNode().set(ControllerLogger.ROOT_LOGGER.subsystemBootInterrupted()));
                    Thread.currentThread().interrupt();
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem runtime operations in [%d] ms", elapsed);
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.MODEL);
                        try {
                            completeLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
        };
    }

    private static class EntryComparator
    implements Comparator<Map.Entry<String, List<ParsedBootOp>>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, List<ParsedBootOp>> e1, Map.Entry<String, List<ParsedBootOp>> e2) {
            if (e1 == e2) {
                return 0;
            }
            int diff = e2.getValue().size() - e1.getValue().size();
            return diff == 0 ? 1 : diff;
        }
    }

    private static class OpChunk
    implements Comparable<OpChunk> {
        private final Map<String, List<ParsedBootOp>> ops = new LinkedHashMap<String, List<ParsedBootOp>>();
        private final List<ParsedBootOp> runtimeOps = new ArrayList<ParsedBootOp>();
        private int opCount = 0;

        private OpChunk() {
        }

        Set<String> getSubsystemNames() {
            return this.ops.keySet();
        }

        void addModelPhaseOps(String subsystem, List<ParsedBootOp> opsList) {
            this.ops.put(subsystem, opsList);
            this.opCount += opsList.size();
        }

        List<ParsedBootOp> getModelPhaseOps() {
            ArrayList<ParsedBootOp> list = new ArrayList<ParsedBootOp>(this.opCount);
            for (List<ParsedBootOp> item : this.ops.values()) {
                list.addAll(item);
            }
            return list;
        }

        @Override
        public int compareTo(OpChunk opChunk) {
            if (this == opChunk) {
                return 0;
            }
            int diff = this.opCount - opChunk.opCount;
            return diff == 0 ? -1 : diff;
        }
    }

    private static class ParallelBootTransactionControl
    implements ProxyController.ProxyOperationControl {
        private final CountDownLatch preparedLatch;
        private final CountDownLatch committedLatch;
        private final CountDownLatch completeLatch;
        private OperationResponse response;
        private ModelController.OperationTransaction transaction;
        private boolean signalled;

        ParallelBootTransactionControl(CountDownLatch preparedLatch, CountDownLatch committedLatch, CountDownLatch completeLatch) {
            this.preparedLatch = preparedLatch;
            this.committedLatch = committedLatch;
            this.completeLatch = completeLatch;
        }

        @Override
        public void operationFailed(ModelNode response) {
            if (!this.signalled) {
                this.response = OperationResponse.Factory.createSimple((ModelNode)response);
                this.preparedLatch.countDown();
                this.completeLatch.countDown();
                this.signalled = true;
            }
        }

        @Override
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (!this.signalled) {
                this.transaction = transaction;
                this.preparedLatch.countDown();
                this.signalled = true;
                try {
                    this.committedLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.transactionInterrupted();
                }
            }
        }

        @Override
        public void operationCompleted(OperationResponse response) {
            this.response = response;
            this.completeLatch.countDown();
        }
    }

    private class ParallelBootTask
    implements Runnable {
        private final Set<String> subsystemNames;
        private final List<ParsedBootOp> bootOperations;
        private final OperationContext.Stage executionStage;
        private final ParallelBootTransactionControl transactionControl;
        private final ParallelBootOperationContext pboc;

        ParallelBootTask(Set<String> subsystemNames, List<ParsedBootOp> bootOperations, OperationContext.Stage executionStage, ParallelBootTransactionControl transactionControl, ParallelBootOperationContext pboc) {
            assert (bootOperations != null || pboc != null);
            this.subsystemNames = subsystemNames;
            this.bootOperations = bootOperations;
            this.executionStage = executionStage;
            this.transactionControl = transactionControl;
            this.pboc = pboc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                block30: {
                    if (this.pboc != null) break block30;
                    this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                        @Override
                        public void commit() {
                        }

                        @Override
                        public void rollback() {
                        }
                    }, new ModelNode());
                    if (!this.transactionControl.signalled) {
                        if (this.bootOperations != null) {
                            for (ParsedBootOp op : this.bootOperations) {
                                if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                this.transactionControl.operationFailed(op.response);
                                break;
                            }
                        }
                        if (!this.transactionControl.signalled) {
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemNames));
                            this.transactionControl.operationFailed(failure);
                        }
                    } else {
                        this.transactionControl.operationCompleted(this.transactionControl.response);
                    }
                    if (this.pboc != null) {
                        this.pboc.close();
                    }
                    return;
                }
                try {
                    this.pboc.setControllingThread();
                    for (ParsedBootOp op : this.bootOperations) {
                        OperationStepHandler osh = op.handler == null ? ParallelBootOperationStepHandler.this.rootRegistration.getOperationHandler(op.address, op.operationName) : op.handler;
                        this.pboc.addStep(op.response, op.operation, osh, this.executionStage);
                    }
                    this.pboc.executeOperation();
                }
                catch (Error | RuntimeException t) {
                    block31: {
                        try {
                            ControllerLogger.MGMT_OP_LOGGER.failedSubsystemBootOperations(t, this.subsystemNames);
                            if (this.transactionControl.signalled) break block31;
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(t.toString());
                            this.transactionControl.operationFailed(failure);
                        }
                        catch (Throwable throwable) {
                            if (!this.transactionControl.signalled) {
                                if (this.bootOperations != null) {
                                    for (ParsedBootOp op : this.bootOperations) {
                                        if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                        this.transactionControl.operationFailed(op.response);
                                        break;
                                    }
                                }
                                if (!this.transactionControl.signalled) {
                                    ModelNode failure = new ModelNode();
                                    failure.get("success").set(false);
                                    failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemNames));
                                    this.transactionControl.operationFailed(failure);
                                }
                            } else {
                                this.transactionControl.operationCompleted(this.transactionControl.response);
                            }
                            if (this.pboc != null) {
                                this.pboc.close();
                            }
                            throw throwable;
                        }
                    }
                    if (!this.transactionControl.signalled) {
                        if (this.bootOperations != null) {
                            for (ParsedBootOp op : this.bootOperations) {
                                if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                this.transactionControl.operationFailed(op.response);
                                break;
                            }
                        }
                        if (!this.transactionControl.signalled) {
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemNames));
                            this.transactionControl.operationFailed(failure);
                        }
                    } else {
                        this.transactionControl.operationCompleted(this.transactionControl.response);
                    }
                    if (this.pboc != null) {
                        this.pboc.close();
                    }
                    break block32;
                }
                if (!this.transactionControl.signalled) {
                    if (this.bootOperations != null) {
                        for (ParsedBootOp op : this.bootOperations) {
                            if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                            this.transactionControl.operationFailed(op.response);
                            break;
                        }
                    }
                    if (!this.transactionControl.signalled) {
                        ModelNode failure = new ModelNode();
                        failure.get("success").set(false);
                        failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemNames));
                        this.transactionControl.operationFailed(failure);
                    }
                } else {
                    this.transactionControl.operationCompleted(this.transactionControl.response);
                }
                if (this.pboc != null) {
                    this.pboc.close();
                }
            }
        }
    }
}

