/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;

public class RequirementRegistration {
    private final Map<PathAddress, List<RegistrationPoint>> registrationPoints = new LinkedHashMap<PathAddress, List<RegistrationPoint>>();
    private final String requiredName;
    private final CapabilityId dependentId;

    public RequirementRegistration(String requiredName, String dependentName, CapabilityScope dependentContext) {
        this(requiredName, new CapabilityId(dependentName, dependentContext));
    }

    protected RequirementRegistration(String requiredName, CapabilityId dependentId) {
        this.requiredName = requiredName;
        this.dependentId = dependentId;
    }

    protected RequirementRegistration(String requiredName, String dependentName, CapabilityScope dependentContext, RegistrationPoint registrationPoint) {
        this(requiredName, dependentName, dependentContext);
        this.putRegistrationPoint(registrationPoint);
    }

    public RequirementRegistration(RuntimeRequirementRegistration toCopy) {
        this(toCopy.getRequiredName(), toCopy.getDependentId());
        this.registrationPoints.putAll(toCopy.registrationPoints);
    }

    public String getRequiredName() {
        return this.requiredName;
    }

    public String getDependentName() {
        return this.dependentId.getName();
    }

    public CapabilityScope getDependentContext() {
        return this.dependentId.getScope();
    }

    public CapabilityId getDependentId() {
        return this.dependentId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        RequirementRegistration that = (RequirementRegistration)o;
        return this.dependentId.equals(that.dependentId) && this.requiredName.equals(that.requiredName);
    }

    public final int hashCode() {
        int result = this.requiredName.hashCode();
        result = 31 * result + this.dependentId.hashCode();
        return result;
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next().get(0);
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        HashSet<RegistrationPoint> result = new HashSet<RegistrationPoint>();
        for (List<RegistrationPoint> registrationPoints : this.registrationPoints.values()) {
            result.addAll(registrationPoints);
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        List<RegistrationPoint> registrationPoints;
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress) && (registrationPoints = this.registrationPoints.get(addedAddress)).contains(toAdd)) {
            return false;
        }
        this.putRegistrationPoint(toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toRemove) {
        PathAddress removedAddress = toRemove.getAddress();
        if (!this.registrationPoints.containsKey(removedAddress)) {
            return false;
        }
        List<RegistrationPoint> registrationPoints = this.registrationPoints.get(removedAddress);
        if (toRemove.getAttribute() == null) {
            registrationPoints.clear();
        } else {
            registrationPoints.remove(toRemove);
        }
        if (registrationPoints.isEmpty()) {
            this.registrationPoints.remove(removedAddress);
        }
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        int size = 0;
        for (List<RegistrationPoint> value : this.registrationPoints.values()) {
            size = value.size();
        }
        return size;
    }

    private void putRegistrationPoint(RegistrationPoint registrationPoint) {
        PathAddress address = registrationPoint.getAddress();
        if (this.registrationPoints.containsKey(address)) {
            this.registrationPoints.get(address).add(registrationPoint);
        } else {
            ArrayList<RegistrationPoint> registrationPoints = new ArrayList<RegistrationPoint>();
            registrationPoints.add(registrationPoint);
            this.registrationPoints.put(address, registrationPoints);
        }
    }
}

