/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

final class DefaultDeploymentOperations
implements DeploymentOperations {
    private final ModelControllerClient controllerClient;

    DefaultDeploymentOperations(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    @Override
    public Future<ModelNode> deploy(ModelNode operation, ExecutorService executorService) {
        return this.controllerClient.executeAsync(operation, OperationMessageHandler.DISCARD);
    }

    @Override
    public Map<String, Boolean> getDeploymentsStatus() {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.controllerClient.execute(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelNode result = response.get("result");
        HashMap<String, Boolean> deployments = new HashMap<String, Boolean>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                deployments.put(property.getName(), property.getValue().get("enabled").asBoolean(false));
            }
        }
        return deployments;
    }

    @Override
    public void close() throws IOException {
        this.controllerClient.close();
    }

    @Override
    public Set<String> getUnrelatedDeployments(ModelNode owner) {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.controllerClient.execute(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelNode result = response.get("result");
        HashSet<String> deployments = new HashSet<String>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                if (owner.equals(property.getValue().get("owner"))) continue;
                deployments.add(property.getName());
            }
        }
        return deployments;
    }
}

