/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ExtensibleFilter
implements DirectoryStream.Filter<Path> {
    private static final Comparator<String> reverseComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int idx1 = o1.length();
            int idx2 = o2.length();
            int comp = 0;
            while (comp == 0 && idx1 > 0 && idx2 > 0) {
                comp = o1.charAt(--idx1) - o2.charAt(--idx2);
            }
            return comp == 0 ? idx1 - idx2 : comp;
        }
    };
    private static final String[] DEFAULT_PREFIXES = new String[]{"#", "%", ",", ".", "_$"};
    private static final String[] DEFAULT_SUFFIXES = new String[]{"#", "$", "%", "~", ",v", ".BAK", ".bak", ".old", ".orig", ".tmp", ".rej", ".sh", ".txt"};
    private static final String[] DEFAULT_MATCHES = new String[]{".make.state", ".nse_depinfo", "CVS", "CVS.admin", "RCS", "RCSLOG", "SCCS", "TAGS", "core", "tags"};
    private final List<String> suffixes;
    private final List<String> prefixes;
    private final List<String> matches;

    public ExtensibleFilter() {
        this(DEFAULT_MATCHES, DEFAULT_PREFIXES, DEFAULT_SUFFIXES);
    }

    public ExtensibleFilter(String[] matches, String[] prefixes, String[] suffixes) {
        if (matches == null) {
            matches = DEFAULT_MATCHES;
        }
        Arrays.sort(matches);
        this.matches = new ArrayList<String>(Arrays.asList(matches));
        if (prefixes == null) {
            prefixes = DEFAULT_PREFIXES;
        }
        Arrays.sort(prefixes);
        this.prefixes = new ArrayList<String>(Arrays.asList(prefixes));
        if (suffixes == null) {
            suffixes = DEFAULT_SUFFIXES;
        }
        Arrays.sort(suffixes, reverseComparator);
        this.suffixes = new ArrayList<String>(Arrays.asList(suffixes));
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
        Collections.sort(this.prefixes);
    }

    public void addPrefixes(String[] prefixes) {
        this.prefixes.addAll(Arrays.asList(prefixes));
        Collections.sort(this.prefixes);
    }

    public void delPrefix(String prefix) {
        this.prefixes.remove(prefix);
    }

    public void delPrefixes(String[] prefixes) {
        this.prefixes.removeAll(Arrays.asList(prefixes));
        Collections.sort(this.prefixes);
    }

    public void addSuffix(String suffix) {
        this.suffixes.add(suffix);
        Collections.sort(this.suffixes, reverseComparator);
    }

    public void addSuffixes(String[] suffixes) {
        this.suffixes.addAll(Arrays.asList(suffixes));
        Collections.sort(this.suffixes, reverseComparator);
    }

    public void delSuffix(String suffix) {
        this.suffixes.remove(suffix);
    }

    public void delSuffixes(String[] suffixes) {
        this.suffixes.removeAll(Arrays.asList(suffixes));
        Collections.sort(this.suffixes, reverseComparator);
    }

    public String[] getSuffixes() {
        String[] tmp = new String[this.suffixes.size()];
        this.suffixes.toArray(tmp);
        return tmp;
    }

    public void setSuffixes(String[] suffixes) {
        Arrays.sort(suffixes, reverseComparator);
        this.suffixes.clear();
        this.suffixes.addAll(Arrays.asList(suffixes));
    }

    public String[] getPrefixes() {
        String[] tmp = new String[this.prefixes.size()];
        this.prefixes.toArray(tmp);
        return tmp;
    }

    public void setPrefixes(String[] prefixes) {
        Arrays.sort(prefixes);
        this.prefixes.clear();
        this.prefixes.addAll(Arrays.asList(prefixes));
    }

    public String[] getMatches() {
        String[] tmp = new String[this.matches.size()];
        this.matches.toArray(tmp);
        return tmp;
    }

    public void setMatches(String[] matches) {
        Arrays.sort(matches);
        this.matches.clear();
        this.matches.addAll(Arrays.asList(matches));
    }

    @Override
    public boolean accept(Path file) {
        String suffix;
        int firstLessIndex;
        String prefix;
        String name = file.getFileName().toString();
        int index = Collections.binarySearch(this.matches, name);
        if (index >= 0) {
            return false;
        }
        index = Collections.binarySearch(this.prefixes, name);
        if (index >= 0) {
            return false;
        }
        if (index < -1 && name.startsWith(prefix = this.prefixes.get(firstLessIndex = -2 - index))) {
            return false;
        }
        index = Collections.binarySearch(this.suffixes, name, reverseComparator);
        if (index >= 0) {
            return false;
        }
        return index >= -1 || !name.endsWith(suffix = this.suffixes.get(firstLessIndex = -2 - index));
    }
}

