/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;

public class WriteRelativeToAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    private final PathManager pathManager;

    public WriteRelativeToAttributeHandler(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    protected void validateUpdatedModel(OperationContext context, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        ModelNode relativeTo = DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        if (relativeTo.isDefined()) {
            try {
                this.pathManager.getPathEntry(relativeTo.asString());
            }
            catch (IllegalArgumentException e) {
                throw DeploymentScannerLogger.ROOT_LOGGER.pathEntryNotFound(relativeTo.asString());
            }
        }
    }
}

