/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.DiscoverySubsystemRegistrar;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceListAttributeDefinition;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class AggregateDiscoveryProviderRegistrar
extends DiscoveryProviderRegistrar {
    static final PathElement PATH = PathElement.pathElement((String)"aggregate-provider");
    private static final CapabilityReferenceListAttributeDefinition<DiscoveryProvider> PROVIDER_NAMES = new CapabilityReferenceListAttributeDefinition.Builder("providers", CapabilityReference.builder((RuntimeCapability)DISCOVERY_PROVIDER_CAPABILITY, (UnaryServiceDescriptor)DISCOVERY_PROVIDER_DESCRIPTOR).build()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(PROVIDER_NAMES);

    AggregateDiscoveryProviderRegistrar() {
        super(PATH, (ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)DiscoverySubsystemRegistrar.RESOLVER.createChildResolver(PATH)).addAttributes(ATTRIBUTES));
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ServiceDependency provider = PROVIDER_NAMES.resolve(context, model).map((Function)new Function<List<DiscoveryProvider>, DiscoveryProvider>(){

            @Override
            public DiscoveryProvider apply(List<DiscoveryProvider> providers) {
                return new AggregateDiscoveryProvider((DiscoveryProvider[])providers.toArray(DiscoveryProvider[]::new));
            }
        });
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder((RuntimeCapability)DISCOVERY_PROVIDER_CAPABILITY, (ServiceDependency)provider).build();
    }
}

