/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.MutableDiscoveryProvider;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.Messages;
import org.wildfly.extension.discovery.StaticProviderDefinition;

class StaticProviderAddHandler
extends AbstractAddStepHandler {
    private static final StaticProviderAddHandler INSTANCE = new StaticProviderAddHandler();

    static StaticProviderAddHandler getInstance() {
        return INSTANCE;
    }

    private StaticProviderAddHandler() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(new AttributeDefinition[]{StaticProviderDefinition.SERVICES}));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.registerCapability(RuntimeCapability.Builder.of((String)"org.wildfly.discovery.provider", (boolean)true, (Object)new MutableDiscoveryProvider()).build().fromBaseCapability(context.getCurrentAddressValue()));
        super.execute(context, operation);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
    }

    static void modifyRegistrationModel(OperationContext context, ModelNode op) throws OperationFailedException {
        WriteAttributeHandler.INSTANCE.execute(context, op);
        context.addStep(op, StaticProviderAddHandler::modifyRegistration, OperationContext.Stage.RUNTIME);
    }

    static void modifyRegistration(OperationContext context, ModelNode op) throws OperationFailedException {
        MutableDiscoveryProvider mutableDiscoveryProvider = (MutableDiscoveryProvider)context.getCapabilityRuntimeAPI("org.wildfly.discovery.provider", context.getCurrentAddressValue(), MutableDiscoveryProvider.class);
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        System.out.println("Model is: " + model);
        if (model.hasDefined("services")) {
            List list = StaticProviderDefinition.SERVICES.resolveModelAttribute(context, model).asList();
            ArrayList<ServiceURL> services = new ArrayList<ServiceURL>();
            for (ModelNode servicesNode : list) {
                List attributeNodeList;
                ModelNode attributesNode;
                ModelNode abstractTypeNode = StaticProviderDefinition.ABSTRACT_TYPE.resolveModelAttribute(context, servicesNode);
                ModelNode abstractTypeAuthorityNode = StaticProviderDefinition.ABSTRACT_TYPE_AUTHORITY.resolveModelAttribute(context, servicesNode);
                ModelNode uriNode = StaticProviderDefinition.URI.resolveModelAttribute(context, servicesNode);
                ModelNode uriSchemeAuthorityNode = StaticProviderDefinition.URI_SCHEME_AUTHORITY.resolveModelAttribute(context, servicesNode);
                ServiceURL.Builder builder = new ServiceURL.Builder();
                if (abstractTypeNode != null && abstractTypeNode.isDefined()) {
                    builder.setAbstractType(abstractTypeNode.asString());
                }
                if (abstractTypeAuthorityNode != null && abstractTypeAuthorityNode.isDefined()) {
                    builder.setAbstractTypeAuthority(abstractTypeAuthorityNode.asString());
                }
                builder.setUri(URI.create(uriNode.asString()));
                if (uriSchemeAuthorityNode != null && uriSchemeAuthorityNode.isDefined()) {
                    builder.setUriSchemeAuthority(uriSchemeAuthorityNode.asString());
                }
                if ((attributesNode = StaticProviderDefinition.ATTRIBUTES.resolveModelAttribute(context, servicesNode)) != null && attributesNode.isDefined() && !(attributeNodeList = attributesNode.asList()).isEmpty()) {
                    for (ModelNode node : attributeNodeList) {
                        String key = StaticProviderDefinition.NAME.resolveModelAttribute(context, node).asString();
                        ModelNode valueNode = StaticProviderDefinition.VALUE.resolveModelAttribute(context, node);
                        if (valueNode != null) {
                            builder.addAttribute(key, AttributeValue.fromString((String)valueNode.asString()));
                            continue;
                        }
                        builder.addAttribute(key);
                    }
                }
                ServiceURL serviceURL = builder.create();
                Messages.log.tracef("Adding service URL %s", serviceURL);
                services.add(serviceURL);
            }
            mutableDiscoveryProvider.setDiscoveryProvider((DiscoveryProvider)(services.isEmpty() ? DiscoveryProvider.EMPTY : new StaticDiscoveryProvider(services)));
        } else {
            mutableDiscoveryProvider.setDiscoveryProvider(DiscoveryProvider.EMPTY);
        }
    }
}

