/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.impl.MutableDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.AggregateProviderDefinition;

class AggregateProviderAddHandler
extends AbstractAddStepHandler {
    private static final AggregateProviderAddHandler INSTANCE = new AggregateProviderAddHandler();

    static AggregateProviderAddHandler getInstance() {
        return INSTANCE;
    }

    private AggregateProviderAddHandler() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(new AttributeDefinition[]{AggregateProviderDefinition.PROVIDER_NAMES}));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.registerCapability(RuntimeCapability.Builder.of((String)"org.wildfly.discovery.provider", (boolean)true, (Object)new MutableDiscoveryProvider()).build().fromBaseCapability(context.getCurrentAddressValue()));
        super.execute(context, operation);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        StringListAttributeDefinition ad = AggregateProviderDefinition.PROVIDER_NAMES;
        ad.addCapabilityRequirements(context, resource.getModel().get(ad.getName()));
    }

    static void modifyRegistrationModel(OperationContext context, ModelNode op) throws OperationFailedException {
        WriteAttributeHandler.INSTANCE.execute(context, op);
        context.addStep(op, AggregateProviderAddHandler::modifyRegistration, OperationContext.Stage.RUNTIME);
    }

    static void modifyRegistration(OperationContext context, ModelNode op) throws OperationFailedException {
        MutableDiscoveryProvider mutableDiscoveryProvider = (MutableDiscoveryProvider)context.getCapabilityRuntimeAPI("org.wildfly.discovery.provider", context.getCurrentAddressValue(), MutableDiscoveryProvider.class);
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (model.hasDefined("providers")) {
            List list = AggregateProviderDefinition.PROVIDER_NAMES.unwrap((ExpressionResolver)context, model);
            if (list.isEmpty()) {
                mutableDiscoveryProvider.setDiscoveryProvider(DiscoveryProvider.EMPTY);
            } else {
                DiscoveryProvider[] providers = new DiscoveryProvider[list.size()];
                int i = 0;
                for (String name : list) {
                    providers[i++] = (DiscoveryProvider)context.getCapabilityRuntimeAPI("org.wildfly.discovery.provider", name, DiscoveryProvider.class);
                }
                AggregateDiscoveryProvider discoveryProvider = new AggregateDiscoveryProvider(providers);
                mutableDiscoveryProvider.setDiscoveryProvider((DiscoveryProvider)discoveryProvider);
            }
        } else {
            mutableDiscoveryProvider.setDiscoveryProvider(DiscoveryProvider.EMPTY);
        }
    }
}

