/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.controller.CancelActiveOperationHandler;
import org.jboss.as.domain.management.controller.SecureOperationReadHandler;
import org.jboss.dmr.ModelType;

public class ActiveOperationResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"active-operation");
    static final ResourceDefinition INSTANCE = new ActiveOperationResourceDefinition();
    static final AttributeDefinition OPERATION_NAME = SimpleAttributeDefinitionBuilder.create((String)"operation", (ModelType)ModelType.STRING).build();
    static final AttributeDefinition ADDRESS = PrimitiveListAttributeDefinition.Builder.of((String)"address", (ModelType)ModelType.PROPERTY).build();
    private static final AttributeDefinition CALLER_THREAD = SimpleAttributeDefinitionBuilder.create((String)"caller-thread", (ModelType)ModelType.STRING).build();
    private static final AttributeDefinition ACCESS_MECHANISM = SimpleAttributeDefinitionBuilder.create((String)"access-mechanism", (ModelType)ModelType.STRING).setAllowNull(true).setValidator((ParameterValidator)EnumValidator.create(AccessMechanism.class, (boolean)true, (boolean)false)).build();
    private static final AttributeDefinition EXECUTION_STATUS = SimpleAttributeDefinitionBuilder.create((String)"execution-status", (ModelType)ModelType.STRING).setValidator((ParameterValidator)EnumValidator.create(OperationContext.ExecutionStatus.class, (boolean)false, (boolean)false)).build();
    private static final AttributeDefinition CANCELLED = SimpleAttributeDefinitionBuilder.create((String)"cancelled", (ModelType)ModelType.BOOLEAN).build();
    private static final AttributeDefinition RUNNING_TIME = SimpleAttributeDefinitionBuilder.create((String)"running-time", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.NANOSECONDS).build();
    private static final AttributeDefinition EXCLUSIVE_RUNNING_TIME = SimpleAttributeDefinitionBuilder.create((String)"exclusive-running-time", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.NANOSECONDS).build();

    private ActiveOperationResourceDefinition() {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core", "management-operations", "active-operation"));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(CancelActiveOperationHandler.DEFINITION, CancelActiveOperationHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(OPERATION_NAME, SecureOperationReadHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(ADDRESS, SecureOperationReadHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(CALLER_THREAD, null);
        resourceRegistration.registerReadOnlyAttribute(ACCESS_MECHANISM, null);
        resourceRegistration.registerReadOnlyAttribute(EXECUTION_STATUS, null);
        resourceRegistration.registerReadOnlyAttribute(RUNNING_TIME, null);
        resourceRegistration.registerReadOnlyAttribute(EXCLUSIVE_RUNNING_TIME, null);
        resourceRegistration.registerReadOnlyAttribute(CANCELLED, null);
        resourceRegistration.setRuntimeOnly(true);
    }
}

