/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class PrincipalAdd
implements OperationStepHandler {
    private final WritableAuthorizerConfiguration authorizerConfiguration;
    private final WritableAuthorizerConfiguration.MatchType matchType;

    private PrincipalAdd(WritableAuthorizerConfiguration authorizerConfiguration, WritableAuthorizerConfiguration.MatchType matchType) {
        this.authorizerConfiguration = authorizerConfiguration;
        this.matchType = matchType;
    }

    public static OperationStepHandler createForInclude(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new PrincipalAdd(authorizerConfiguration, WritableAuthorizerConfiguration.MatchType.INCLUDE);
    }

    public static OperationStepHandler createForExclude(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new PrincipalAdd(authorizerConfiguration, WritableAuthorizerConfiguration.MatchType.EXCLUDE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        PrincipalResourceDefinition.TYPE.validateAndSet(operation, model);
        PrincipalResourceDefinition.REALM.validateAndSet(operation, model);
        PrincipalResourceDefinition.NAME.validateAndSet(operation, model);
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        AuthorizerConfiguration.PrincipalType principalType = PrincipalResourceDefinition.getPrincipalType(context, model);
        String realm = PrincipalResourceDefinition.getRealm(context, model);
        String name = PrincipalResourceDefinition.getName(context, model);
        PathAddress completeAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress roleAddress = completeAddress.subAddress(0, completeAddress.size() - 1);
        this.validateUniqueness(context, roleName, roleAddress, principalType, realm, name);
        this.registerRuntimeAdd(context, roleName.toUpperCase(Locale.ENGLISH), principalType, name, realm);
        context.stepCompleted();
    }

    private void validateUniqueness(OperationContext context, String roleName, PathAddress roleAddress, AuthorizerConfiguration.PrincipalType principalType, String realm, String name) throws OperationFailedException {
        Resource roleResource = context.readResourceFromRoot(roleAddress);
        ModelNode model = Resource.Tools.readModel((Resource)roleResource);
        int matchesFound = 0;
        for (Property current : this.getIncludeExclude(model)) {
            if (!this.matches(context, current.getValue(), principalType, realm, name) || ++matchesFound <= 1) continue;
            throw DomainManagementLogger.ROOT_LOGGER.duplicateIncludeExclude(roleName, this.matchType.toString(), principalType.toString(), name, realm != null ? realm : "undefined");
        }
    }

    private boolean matches(OperationContext context, ModelNode value, AuthorizerConfiguration.PrincipalType principalType, String realm, String name) throws OperationFailedException {
        AuthorizerConfiguration.PrincipalType valuePrincipalType = PrincipalResourceDefinition.getPrincipalType(context, value);
        if (principalType != valuePrincipalType) {
            return false;
        }
        String valueName = PrincipalResourceDefinition.getName(context, value);
        if (!name.equals(valueName)) {
            return false;
        }
        String valueRealm = PrincipalResourceDefinition.getRealm(context, value);
        return (realm != null || valueRealm == null) && (realm == null || realm.equals(valueRealm));
    }

    private List<Property> getIncludeExclude(ModelNode model) {
        if (this.matchType == WritableAuthorizerConfiguration.MatchType.INCLUDE) {
            return model.get("include").asPropertyList();
        }
        return model.get("exclude").asPropertyList();
    }

    private void registerRuntimeAdd(OperationContext context, final String roleName, final AuthorizerConfiguration.PrincipalType principalType, final String name, final String realm) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!PrincipalAdd.this.authorizerConfiguration.addRoleMappingPrincipal(roleName, principalType, PrincipalAdd.this.matchType, name, realm, context.isBooting())) {
                    throw DomainManagementLogger.ROOT_LOGGER.inconsistentRbacRuntimeState();
                }
                PrincipalAdd.this.registerRollbackHandler(context, roleName, principalType, name, realm);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName, final AuthorizerConfiguration.PrincipalType principalType, final String name, final String realm) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!PrincipalAdd.this.authorizerConfiguration.removeRoleMappingPrincipal(roleName, principalType, PrincipalAdd.this.matchType, name, realm)) {
                    context.restartRequired();
                }
            }
        });
    }
}

