/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class AuthorizationValidatingHandler
implements OperationStepHandler {
    static final AuthorizationValidatingHandler INSTANCE = new AuthorizationValidatingHandler();

    static ModelNode createOperation(ModelNode operationToValidate) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
        PathAddress realmPA = null;
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"security-realm".equals(pe.getKey())) continue;
            realmPA = pa.subAddress(0, i + 1);
            break;
        }
        assert (realmPA != null) : "operationToValidate did not have an address that included a security-realm";
        return Util.getEmptyOperation((String)"validate-authorization", (ModelNode)realmPA.toModelNode());
    }

    private AuthorizationValidatingHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set children = resource.getChildrenNames("authorization");
        if (children.size() > 1) {
            String realmName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            HashSet<String> invalid = new HashSet<String>(children);
            throw DomainManagementLogger.ROOT_LOGGER.multipleAuthorizationConfigurationsDefined(realmName, invalid);
        }
        context.stepCompleted();
    }
}

