/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.FileAuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FileAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition FORMATTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("formatter", ModelType.STRING).setAllowNull(false)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING).setAllowNull(true)).setMinSize(1)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FORMATTER, PATH, RELATIVE_TO, MAX_FAILURE_COUNT};

    public FileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
        super(auditLogger, pathManager, PathElement.pathElement((String)"file-handler"), DomainManagementResolver.getResolver("core.management.file-handler"), (OperationStepHandler)new FileAuditLogHandlerAddHandler(auditLogger, pathManager, ATTRIBUTES), (OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger));
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        HandlerWriteAttributeHandler write = new HandlerWriteAttributeHandler(this.auditLogger, this.pathManager, ATTRIBUTES);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    private static FileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String relativeTo = model.hasDefined(RELATIVE_TO.getName()) ? RELATIVE_TO.resolveModelAttribute(context, model).asString() : null;
        String path = PATH.resolveModelAttribute(context, model).asString();
        String formatterName = FORMATTER.resolveModelAttribute(context, model).asString();
        int maxFailureCount = MAX_FAILURE_COUNT.resolveModelAttribute(context, model).asInt();
        return new FileAuditLogHandler(name, formatterName, maxFailureCount, pathManager, path, relativeTo);
    }

    private static class HandlerWriteAttributeHandler
    extends AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler {
        public HandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
            super(auditLogger, pathManager, attributeDefinitions);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if (!super.handleApplyAttributeRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder)) {
                this.auditLogger.getUpdater().updateHandler((AuditLogHandler)FileAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, operation));
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (!super.handlerRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handback)) {
                this.auditLogger.getUpdater().rollbackChanges();
            }
        }
    }

    private static class FileAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final PathManagerService pathManager;

        private FileAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes) {
            super(attributes);
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            HandlerUtil.checkNoOtherHandlerWithTheSameName(context, operation);
            String formatterName = operation.get(FORMATTER.getName()).asString();
            if (!HandlerUtil.lookForFormatter(context, PathAddress.pathAddress((ModelNode)operation.require("address")), formatterName)) {
                throw DomainManagementLogger.ROOT_LOGGER.noFormatterCalled(formatterName);
            }
            super.populateModel(context, operation, resource);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)FileAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, operation));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }
}

