/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.logging.DomainManagementLogger;

public class HandlerUtil {
    static void checkNoOtherHandlerWithTheSameName(OperationContext context) throws OperationFailedException {
        PathElement check;
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        Resource resource = context.readResourceFromRoot(parentAddress);
        PathElement element = address.getLastElement();
        PathElement pathElement = check = element.getKey().equals("syslog-handler") ? PathElement.pathElement((String)"file-handler", (String)element.getValue()) : PathElement.pathElement((String)"syslog-handler", (String)element.getValue());
        if (resource.hasChild(check)) {
            throw DomainManagementLogger.ROOT_LOGGER.handlerAlreadyExists(check.getValue(), parentAddress.append(new PathElement[]{check}));
        }
    }

    static boolean lookForFormatter(OperationContext context, PathAddress addr, String name) {
        PathAddress referenceAddress = addr.subAddress(0, addr.size() - 1).append("json-formatter", name);
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        return HandlerUtil.lookForResource(root, referenceAddress);
    }

    private static boolean lookForResource(Resource root, PathAddress pathAddress) {
        Resource current = root;
        for (PathElement element : pathAddress) {
            if ((current = current.getChild(element)) != null) continue;
            return false;
        }
        return true;
    }
}

